/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.std.str.CharSink;

public abstract class AbstractDataFrameCursorFactory
implements DataFrameCursorFactory {
    private final CairoEngine engine;
    private final String tableName;
    private final long tableVersion;

    public AbstractDataFrameCursorFactory(CairoEngine engine, String tableName, long tableVersion) {
        this.engine = engine;
        this.tableName = tableName;
        this.tableVersion = tableVersion;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("{\"name\":\"").put(this.getClass().getSimpleName()).put("\", \"table\":\"").put(this.tableName).put("\"}");
    }

    protected TableReader getReader(CairoSecurityContext sqlContext) {
        return this.engine.getReader(sqlContext, this.tableName, this.tableVersion);
    }

    @Override
    public void close() {
    }
}

