/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;

public abstract class AbstractFullDataFrameCursor
implements DataFrameCursor {
    protected final FullTableDataFrame frame = new FullTableDataFrame();
    protected TableReader reader;
    protected int partitionHi;
    protected int partitionIndex;

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public SymbolMapReader getSymbolTable(int columnIndex) {
        return this.reader.getSymbolMapReader(columnIndex);
    }

    @Override
    public TableReader getTableReader() {
        return this.reader;
    }

    @Override
    public boolean reload() {
        boolean moreData = this.reader.reload();
        this.partitionHi = this.reader.getPartitionCount();
        this.toTop();
        return moreData;
    }

    @Override
    public long size() {
        return this.reader.size();
    }

    public DataFrameCursor of(TableReader reader) {
        this.reader = reader;
        this.partitionHi = reader.getPartitionCount();
        this.toTop();
        return this;
    }

    protected class FullTableDataFrame
    implements DataFrame {
        private static final long rowLo = 0L;
        protected long rowHi;
        protected int partitionIndex;

        protected FullTableDataFrame() {
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int direction) {
            return AbstractFullDataFrameCursor.this.reader.getBitmapIndexReader(this.partitionIndex, AbstractFullDataFrameCursor.this.reader.getColumnBase(this.partitionIndex), columnIndex, direction);
        }

        @Override
        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public long getRowHi() {
            return this.rowHi;
        }

        @Override
        public long getRowLo() {
            return 0L;
        }
    }
}

