/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexBwdReader;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.util.concurrent.locks.LockSupport;

public abstract class AbstractIndexReader
implements BitmapIndexReader {
    public static final String INDEX_CORRUPT = "cursor could not consistently read index header [corrupt?]";
    protected static final Log LOG = LogFactory.getLog(BitmapIndexBwdReader.class);
    protected final MappedReadOnlyMemory keyMem = new SinglePageMappedReadOnlyPageMemory();
    protected final MappedReadOnlyMemory valueMem = new SinglePageMappedReadOnlyPageMemory();
    protected int blockValueCountMod;
    protected int blockCapacity;
    protected long spinLockTimeoutUs;
    protected MicrosecondClock clock;
    protected int keyCount;
    protected long unIndexedNullCount;
    private int keyCountIncludingNulls;

    @Override
    public void close() {
        if (this.isOpen()) {
            Misc.free(this.keyMem);
            Misc.free(this.valueMem);
        }
    }

    @Override
    public int getKeyCount() {
        return this.keyCountIncludingNulls;
    }

    @Override
    public boolean isOpen() {
        return this.keyMem.getFd() != -1L;
    }

    public void of(CairoConfiguration configuration, Path path, CharSequence name, long unIndexedNullCount, long partitionTxn) {
        this.unIndexedNullCount = unIndexedNullCount;
        TableUtils.txnPartitionConditionally(path, partitionTxn);
        int plen = path.length();
        long pageSize = configuration.getFilesFacade().getMapPageSize();
        this.spinLockTimeoutUs = configuration.getSpinLockTimeoutUs();
        try {
            int keyCount;
            int blockValueCountMod;
            this.keyMem.of(configuration.getFilesFacade(), BitmapIndexUtils.keyFileName(path, name), pageSize, 0L);
            this.keyMem.grow(configuration.getFilesFacade().length(this.keyMem.getFd()));
            this.clock = configuration.getMicrosecondClock();
            long keyMemSize = this.keyMem.size();
            if (keyMemSize < 64L) {
                LOG.error().$("file too short [corrupt] ").$(path).$();
                throw CairoException.instance(0).put("Index file too short: ").put(path);
            }
            if (this.keyMem.getByte(0L) != -6) {
                LOG.error().$("unknown format [corrupt] ").$(path).$();
                throw CairoException.instance(0).put("Unknown format: ").put(path);
            }
            long deadline = this.clock.getTicks() + this.spinLockTimeoutUs;
            while (true) {
                long seq = this.keyMem.getLong(1L);
                Unsafe.getUnsafe().loadFence();
                if (this.keyMem.getLong(29L) == seq) {
                    blockValueCountMod = this.keyMem.getInt(17L) - 1;
                    keyCount = this.keyMem.getInt(21L);
                    Unsafe.getUnsafe().loadFence();
                    if (this.keyMem.getLong(1L) == seq) break;
                }
                if (this.clock.getTicks() > deadline) {
                    LOG.error().$(INDEX_CORRUPT).$(" [timeout=").$(this.spinLockTimeoutUs).utf8("\u03bcs]").$();
                    throw CairoException.instance(0).put(INDEX_CORRUPT);
                }
                LockSupport.parkNanos(1L);
            }
            this.blockValueCountMod = blockValueCountMod;
            this.blockCapacity = (blockValueCountMod + 1) * 8 + 16;
            this.keyCountIncludingNulls = keyCount;
            this.keyCount = this.keyCountIncludingNulls++;
            if (unIndexedNullCount > 0L) {
                // empty if block
            }
            this.valueMem.of(configuration.getFilesFacade(), BitmapIndexUtils.valueFileName(path.trimTo(plen), name), pageSize, 0L);
            this.valueMem.grow(configuration.getFilesFacade().length(this.valueMem.getFd()));
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    protected void updateKeyCount() {
        int keyCount;
        block3: {
            long deadline = this.clock.getTicks() + this.spinLockTimeoutUs;
            do {
                long seq = this.keyMem.getLong(1L);
                Unsafe.getUnsafe().loadFence();
                if (this.keyMem.getLong(29L) != seq) continue;
                keyCount = this.keyMem.getInt(21L);
                Unsafe.getUnsafe().loadFence();
                if (seq == this.keyMem.getLong(1L)) break block3;
            } while (this.clock.getTicks() <= deadline);
            this.keyCount = 0;
            LOG.error().$(INDEX_CORRUPT).$(" [timeout=").$(this.spinLockTimeoutUs).utf8("\u03bcs]").$();
            throw CairoException.instance(0).put(INDEX_CORRUPT);
        }
        if (keyCount > this.keyCount) {
            this.keyCountIncludingNulls = keyCount;
            this.keyCount = this.keyCountIncludingNulls++;
            if (this.unIndexedNullCount > 0L) {
                // empty if block
            }
        }
    }
}

