/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.ObjList;

public abstract class BaseRecordMetadata
implements RecordMetadata {
    protected ObjList<TableColumnMetadata> columnMetadata;
    protected CharSequenceIntHashMap columnNameIndexMap;
    protected int timestampIndex;
    protected int columnCount;

    public static TableColumnMetadata copyOf(RecordMetadata metadata, int columnIndex) {
        if (metadata instanceof BaseRecordMetadata) {
            return ((BaseRecordMetadata)metadata).getColumnQuick(columnIndex);
        }
        return new TableColumnMetadata(metadata.getColumnName(columnIndex), metadata.getColumnType(columnIndex), metadata.isColumnIndexed(columnIndex), metadata.getIndexValueBlockCapacity(columnIndex), metadata.isSymbolTableStatic(columnIndex), metadata.getMetadata(columnIndex));
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnType(int columnIndex) {
        return this.getColumnQuick(columnIndex).getType();
    }

    @Override
    public int getColumnIndexQuiet(CharSequence columnName, int lo, int hi) {
        int index = this.columnNameIndexMap.keyIndex(columnName, lo, hi);
        if (index < 0) {
            return this.columnNameIndexMap.valueAt(index);
        }
        return -1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnQuick(columnIndex).getName();
    }

    @Override
    public int getIndexValueBlockCapacity(int columnIndex) {
        return this.getColumnQuick(columnIndex).getIndexValueBlockCapacity();
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    @Override
    public RecordMetadata getMetadata(int columnIndex) {
        return this.getColumnQuick(columnIndex).getMetadata();
    }

    @Override
    public boolean isColumnIndexed(int columnIndex) {
        return this.getColumnQuick(columnIndex).isIndexed();
    }

    @Override
    public boolean isSymbolTableStatic(int columnIndex) {
        return this.columnMetadata.getQuick(columnIndex).isSymbolTableStatic();
    }

    public TableColumnMetadata getColumnQuick(int index) {
        return this.columnMetadata.getQuick(index);
    }
}

