/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.vm.ReadOnlyVirtualMemory;
import io.questdb.std.str.Path;

public final class BitmapIndexUtils {
    static final long KEY_ENTRY_SIZE = 32L;
    static final int KEY_ENTRY_OFFSET_VALUE_COUNT = 0;
    static final int KEY_ENTRY_OFFSET_LAST_VALUE_BLOCK_OFFSET = 16;
    static final int KEY_ENTRY_OFFSET_FIRST_VALUE_BLOCK_OFFSET = 8;
    static final int KEY_ENTRY_OFFSET_COUNT_CHECK = 24;
    static final int KEY_FILE_RESERVED = 64;
    static final int KEY_RESERVED_OFFSET_SIGNATURE = 0;
    static final int KEY_RESERVED_OFFSET_SEQUENCE = 1;
    static final int KEY_RESERVED_OFFSET_VALUE_MEM_SIZE = 9;
    static final int KEY_RESERVED_OFFSET_BLOCK_VALUE_COUNT = 17;
    static final int KEY_RESERVED_OFFSET_KEY_COUNT = 21;
    static final int KEY_RESERVED_OFFSET_SEQUENCE_CHECK = 29;
    static final byte SIGNATURE = -6;
    static final int VALUE_BLOCK_FILE_RESERVED = 16;

    public static Path keyFileName(Path path, CharSequence name) {
        return path.concat(name).put(".k").$();
    }

    public static Path valueFileName(Path path, CharSequence name) {
        return path.concat(name).put(".v").$();
    }

    static void seekValueBlockRTL(long valueCount, long blockOffset, ReadOnlyVirtualMemory valueMem, long maxValue, long blockValueCountMod, ValueBlockSeeker seeker) {
        long valueBlockOffset = blockOffset;
        if (valueCount > 0L) {
            long hi;
            long cellCount;
            long prevBlockOffset = (blockValueCountMod + 1L) * 8L;
            while (true) {
                long lo = valueMem.getLong(valueBlockOffset);
                cellCount = (valueCount - 1L & blockValueCountMod) + 1L;
                if (lo <= maxValue || (valueCount -= cellCount) <= 0L) break;
                valueBlockOffset = valueMem.getLong(valueBlockOffset + prevBlockOffset);
            }
            if (valueCount > 0L && maxValue < (hi = valueMem.getLong(valueBlockOffset + (cellCount - 1L) * 8L))) {
                valueCount -= cellCount - BitmapIndexUtils.searchValueBlock(valueMem, valueBlockOffset, cellCount, maxValue);
            }
        }
        seeker.seek(valueCount, valueBlockOffset);
    }

    static void seekValueBlockLTR(long initialCount, long firstValueBlockOffset, ReadOnlyVirtualMemory valueMem, long minValue, long blockValueCountMod, ValueBlockSeeker seeker) {
        long valueCount = initialCount;
        long valueBlockOffset = firstValueBlockOffset;
        if (valueCount > 0L) {
            long lo;
            long cellCount;
            long hi;
            while ((hi = valueMem.getLong(valueBlockOffset + ((cellCount = valueCount > blockValueCountMod ? blockValueCountMod + 1L : valueCount) - 1L) * 8L)) < minValue && (valueCount -= cellCount) > 0L) {
                long nextBlockOffset = (blockValueCountMod + 1L) * 8L + 8L;
                valueBlockOffset = valueMem.getLong(valueBlockOffset + nextBlockOffset);
            }
            if (valueCount > 0L && minValue > (lo = valueMem.getLong(valueBlockOffset))) {
                valueCount -= BitmapIndexUtils.searchValueBlock(valueMem, valueBlockOffset, cellCount, minValue - 1L);
            }
        }
        seeker.seek(initialCount - valueCount, valueBlockOffset);
    }

    static long getKeyEntryOffset(int key) {
        return (long)key * 32L + 64L;
    }

    static long searchValueBlock(ReadOnlyVirtualMemory memory, long offset, long cellCount, long value) {
        long half;
        if (cellCount < 64L) {
            long i = offset;
            while (true) {
                if (memory.getLong(i) > value) {
                    return (i - offset) / 8L;
                }
                i += 8L;
            }
        }
        long low = 0L;
        long high = cellCount - 1L;
        while ((half = (high - low) / 2L) != 0L) {
            long pivot = memory.getLong(offset + (low + half) * 8L);
            if (pivot <= value) {
                low += half;
                continue;
            }
            high = low + half;
        }
        return low + 1L;
    }

    @FunctionalInterface
    static interface ValueBlockSeeker {
        public void seek(long var1, long var3);
    }
}

