/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EngineMigration;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.Sequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.tasks.TelemetryTask;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class CairoEngine
implements Closeable,
WriterSource {
    private static final Log LOG = LogFactory.getLog(CairoEngine.class);
    private final WriterPool writerPool;
    private final ReaderPool readerPool;
    private final CairoConfiguration configuration;
    private final WriterMaintenanceJob writerMaintenanceJob;
    private final MessageBus messageBus;
    private final RingQueue<TelemetryTask> telemetryQueue;
    private final MPSequence telemetryPubSeq;
    private final SCSequence telemetrySubSeq;
    private final long tableIdMemSize;
    private long tableIdFd = -1L;
    private long tableIdMem = 0L;

    public CairoEngine(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.messageBus = new MessageBusImpl(configuration);
        this.writerPool = new WriterPool(configuration, this.messageBus);
        this.readerPool = new ReaderPool(configuration);
        this.writerMaintenanceJob = new WriterMaintenanceJob(configuration);
        this.telemetryQueue = new RingQueue<TelemetryTask>(TelemetryTask::new, configuration.getTelemetryConfiguration().getQueueCapacity());
        this.telemetryPubSeq = new MPSequence(this.telemetryQueue.getCapacity());
        this.telemetrySubSeq = new SCSequence();
        this.telemetryPubSeq.then(this.telemetrySubSeq).then(this.telemetryPubSeq);
        this.tableIdMemSize = Files.PAGE_SIZE;
        this.openTableId();
        try {
            new EngineMigration(this, configuration).migrateEngineTo(419);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public void openTableId() {
        this.freeTableId();
        FilesFacade ff = this.configuration.getFilesFacade();
        Path path = Path.getThreadLocal(this.configuration.getRoot()).concat("_tab_index.d").$();
        this.tableIdFd = TableUtils.openFileRWOrFail(ff, path);
        long fileSize = ff.length(this.tableIdFd);
        if (fileSize < 8L && !ff.allocate(this.tableIdFd, Files.PAGE_SIZE)) {
            ff.close(this.tableIdFd);
            throw CairoException.instance(ff.errno()).put("Could not allocate [file=").put(path).put(", actual=").put(fileSize).put(", desired=").put(this.tableIdMemSize).put(']');
        }
        this.tableIdMem = ff.mmap(this.tableIdFd, this.tableIdMemSize, 0L, 2);
        if (this.tableIdMem == -1L) {
            ff.close(this.tableIdFd);
            throw CairoException.instance(ff.errno()).put("Could not mmap [file=").put(path).put(']');
        }
    }

    public boolean clear() {
        boolean b1 = this.readerPool.releaseAll();
        boolean b2 = this.writerPool.releaseAll();
        return b1 & b2;
    }

    @Override
    public void close() {
        Misc.free(this.writerPool);
        Misc.free(this.readerPool);
        this.freeTableId();
        Misc.free(this.messageBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(CairoSecurityContext securityContext, AppendOnlyVirtualMemory mem, Path path, TableStructure struct) {
        if (this.lock(securityContext, struct.getTableName())) {
            if (this.writerPool.exists(struct.getTableName())) {
                throw EntryUnavailableException.INSTANCE;
            }
            boolean newTable = false;
            try {
                this.createTableUnsafe(securityContext, mem, path, struct);
                newTable = true;
            }
            finally {
                this.unlock(securityContext, struct.getTableName(), null, newTable);
            }
        } else {
            throw EntryUnavailableException.INSTANCE;
        }
    }

    public void createTableUnsafe(CairoSecurityContext securityContext, AppendOnlyVirtualMemory mem, Path path, TableStructure struct) {
        securityContext.checkWritePermission();
        TableUtils.createTable(this.configuration.getFilesFacade(), mem, path, this.configuration.getRoot(), struct, this.configuration.getMkDirMode(), (int)this.getNextTableId());
    }

    public void freeTableId() {
        if (this.tableIdMem != 0L) {
            this.configuration.getFilesFacade().munmap(this.tableIdMem, this.tableIdMemSize);
            this.tableIdMem = 0L;
        }
        if (this.tableIdFd != -1L) {
            this.configuration.getFilesFacade().close(this.tableIdFd);
            this.tableIdFd = -1L;
        }
    }

    public TableWriter getBackupWriter(CairoSecurityContext securityContext, CharSequence tableName, CharSequence backupDirName) {
        securityContext.checkWritePermission();
        return new TableWriter(this.configuration, tableName, this.messageBus, true, DefaultLifecycleManager.INSTANCE, backupDirName);
    }

    public int getBusyReaderCount() {
        return this.readerPool.getBusyCount();
    }

    public int getBusyWriterCount() {
        return this.writerPool.getBusyCount();
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    public long getNextTableId() {
        long next;
        long x = Unsafe.getUnsafe().getLong(this.tableIdMem);
        while ((next = x) != (x = Os.compareAndSwap(this.tableIdMem, next, next + 1L))) {
        }
        return next + 1L;
    }

    public PoolListener getPoolListener() {
        return this.writerPool.getPoolListener();
    }

    public void setPoolListener(PoolListener poolListener) {
        this.writerPool.setPoolListener(poolListener);
        this.readerPool.setPoolListener(poolListener);
    }

    public TableReader getReader(CairoSecurityContext securityContext, CharSequence tableName) {
        return this.getReader(securityContext, tableName, -1L);
    }

    public TableReader getReader(CairoSecurityContext securityContext, CharSequence tableName, long version) {
        TableReader reader = this.readerPool.get(tableName);
        if (version > -1L && reader.getVersion() != version) {
            reader.close();
            throw ReaderOutOfDateException.INSTANCE;
        }
        return reader;
    }

    public int getStatus(CairoSecurityContext securityContext, Path path, CharSequence tableName, int lo, int hi) {
        if (this.writerPool.exists(tableName)) {
            return 0;
        }
        return TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableName, lo, hi);
    }

    public int getStatus(CairoSecurityContext securityContext, Path path, CharSequence tableName) {
        return this.getStatus(securityContext, path, tableName, 0, tableName.length());
    }

    public Sequence getTelemetryPubSequence() {
        return this.telemetryPubSeq;
    }

    public RingQueue<TelemetryTask> getTelemetryQueue() {
        return this.telemetryQueue;
    }

    public SCSequence getTelemetrySubSequence() {
        return this.telemetrySubSeq;
    }

    @Override
    public TableWriter getWriter(CairoSecurityContext securityContext, CharSequence tableName) {
        securityContext.checkWritePermission();
        return this.writerPool.get(tableName);
    }

    public Job getWriterMaintenanceJob() {
        return this.writerMaintenanceJob;
    }

    public boolean lock(CairoSecurityContext securityContext, CharSequence tableName) {
        securityContext.checkWritePermission();
        if (this.writerPool.lock(tableName)) {
            boolean locked = this.readerPool.lock(tableName);
            if (locked) {
                LOG.info().$("locked [table=`").$(tableName).$("`, thread=").$(Thread.currentThread().getId()).$(']').$();
                return true;
            }
            this.writerPool.unlock(tableName);
        }
        return false;
    }

    public boolean lockReaders(CharSequence tableName) {
        return this.readerPool.lock(tableName);
    }

    public boolean lockWriter(CharSequence tableName) {
        return this.writerPool.lock(tableName);
    }

    public boolean migrateNullFlag(CairoSecurityContext cairoSecurityContext, CharSequence tableName) {
        try (TableWriter writer = this.getWriter(cairoSecurityContext, tableName);
             TableReader reader = this.getReader(cairoSecurityContext, tableName);){
            TableReaderMetadata readerMetadata = reader.getMetadata();
            if (readerMetadata.getVersion() < 416) {
                LOG.info().$("migrating null flag for symbols [table=").utf8(tableName).$(']').$();
                int count = reader.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    if (readerMetadata.getColumnType(i) != 11) continue;
                    LOG.info().$("updating null flag [column=").utf8(readerMetadata.getColumnName(i)).$(']').$();
                    writer.getSymbolMapWriter(i).updateNullFlag(reader.hasNull(i));
                }
                writer.updateMetadataVersion();
                LOG.info().$("migrated null flag for symbols [table=").utf8(tableName).$(", tableVersion=").$(419).$(']').$();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean releaseAllReaders() {
        return this.readerPool.releaseAll();
    }

    public void releaseAllWriters() {
        this.writerPool.releaseAll();
    }

    public boolean releaseInactive() {
        boolean useful = this.writerPool.releaseInactive();
        return useful |= this.readerPool.releaseInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CairoSecurityContext securityContext, Path path, CharSequence tableName) {
        securityContext.checkWritePermission();
        if (this.lock(securityContext, tableName)) {
            try {
                path.of(this.configuration.getRoot()).concat(tableName).$();
                int errno = this.configuration.getFilesFacade().rmdir(path);
                if (errno != 0) {
                    LOG.error().$("remove failed [tableName='").utf8(tableName).$("', error=").$(errno).$(']').$();
                    throw CairoException.instance(errno).put("Table remove failed");
                }
                return;
            }
            finally {
                this.unlock(securityContext, tableName, null, false);
            }
        }
        throw CairoException.instance(this.configuration.getFilesFacade().errno()).put("Could not lock '").put(tableName).put('\'');
    }

    public int removeDirectory(Path path, CharSequence dir) {
        path.of(this.configuration.getRoot()).concat(dir);
        FilesFacade ff = this.configuration.getFilesFacade();
        return ff.rmdir(path.slash$());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(CairoSecurityContext securityContext, Path path, CharSequence tableName, Path otherPath, CharSequence newName) {
        securityContext.checkWritePermission();
        if (this.lock(securityContext, tableName)) {
            try {
                this.rename0(path, tableName, otherPath, newName);
            }
            finally {
                this.unlock(securityContext, tableName, null, false);
            }
        } else {
            LOG.error().$("cannot lock and rename [from='").$(tableName).$("', to='").$(newName).$("']").$();
            throw EntryUnavailableException.INSTANCE;
        }
    }

    public void resetTableId() {
        Unsafe.getUnsafe().putLong(this.tableIdMem, 0L);
    }

    public void unlock(CairoSecurityContext securityContext, CharSequence tableName, @Nullable TableWriter writer, boolean newTable) {
        this.readerPool.unlock(tableName);
        this.writerPool.unlock(tableName, writer, newTable);
        LOG.info().$("unlocked [table=`").$(tableName).$("`]").$();
    }

    public void unlockReaders(CharSequence tableName) {
        this.readerPool.unlock(tableName);
    }

    public void unlockWriter(CharSequence tableName) {
        this.writerPool.unlock(tableName);
    }

    private void rename0(Path path, CharSequence tableName, Path otherPath, CharSequence to) {
        CharSequence root;
        FilesFacade ff = this.configuration.getFilesFacade();
        if (TableUtils.exists(ff, path, root = this.configuration.getRoot(), tableName) != 0) {
            LOG.error().$('\'').utf8(tableName).$("' does not exist. Rename failed.").$();
            throw CairoException.instance(0).put("Rename failed. Table '").put(tableName).put("' does not exist");
        }
        path.of(root).concat(tableName).$();
        otherPath.of(root).concat(to).$();
        if (ff.exists(otherPath)) {
            LOG.error().$("rename target exists [from='").$(tableName).$("', to='").$(otherPath).$("']").$();
            throw CairoException.instance(0).put("Rename target exists");
        }
        if (!ff.rename(path, otherPath)) {
            int error = ff.errno();
            LOG.error().$("rename failed [from='").$(path).$("', to='").$(otherPath).$("', error=").$(error).$(']').$();
            throw CairoException.instance(error).put("Rename failed");
        }
    }

    private class WriterMaintenanceJob
    extends SynchronizedJob {
        private final MicrosecondClock clock;
        private final long checkInterval;
        private long last = 0L;

        public WriterMaintenanceJob(CairoConfiguration configuration) {
            this.clock = configuration.getMicrosecondClock();
            this.checkInterval = configuration.getIdleCheckInterval() * 1000L;
        }

        @Override
        protected boolean runSerially() {
            long t = this.clock.getTicks();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return CairoEngine.this.releaseInactive();
            }
            return false;
        }
    }
}

