/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class CairoException
extends RuntimeException
implements Sinkable,
FlyweightMessageContainer {
    private static final ThreadLocal<CairoException> tlException = new ThreadLocal<CairoException>(CairoException::new);
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    protected final StringSink message = new StringSink();
    private int errno;
    private boolean cacheable;
    private boolean interruption;

    public static CairoException instance(int errno) {
        CairoException ex = (CairoException)tlException.get();
        ex.message.clear();
        ex.errno = errno;
        ex.cacheable = false;
        ex.interruption = false;
        return ex;
    }

    public int getErrno() {
        return this.errno;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return "[" + this.errno + "] " + this.message;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return EMPTY_STACK_TRACE;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public CairoException setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public boolean isInterruption() {
        return this.interruption;
    }

    public CairoException setInterruption(boolean interruption) {
        this.interruption = interruption;
        return this;
    }

    public CairoException put(long value) {
        this.message.put(value);
        return this;
    }

    public CairoException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public CairoException put(char c) {
        this.message.put(c);
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[').put(this.errno).put("]: ").put(this.message);
    }
}

