/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.DefaultTelemetryConfiguration;
import io.questdb.TelemetryConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cutlass.text.DefaultTextConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.NanosecondClock;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;

public class DefaultCairoConfiguration
implements CairoConfiguration {
    private final CharSequence root;
    private final TextConfiguration textConfiguration = new DefaultTextConfiguration();
    private final DefaultTelemetryConfiguration telemetryConfiguration = new DefaultTelemetryConfiguration();
    private final BuildInformation buildInformation = new BuildInformationHolder();
    private final long databaseIdLo;
    private final long databaseIdHi;

    public DefaultCairoConfiguration(CharSequence root) {
        this.root = Chars.toString(root);
        Rnd rnd = new Rnd(NanosecondClockImpl.INSTANCE.getTicks(), MicrosecondClockImpl.INSTANCE.getTicks());
        this.databaseIdLo = rnd.nextLong();
        this.databaseIdHi = rnd.nextLong();
    }

    @Override
    public int getBindVariablePoolSize() {
        return 8;
    }

    @Override
    public int getSqlCopyBufferSize() {
        return 0x100000;
    }

    @Override
    public int getCopyPoolCapacity() {
        return 16;
    }

    @Override
    public int getCreateAsSelectRetryCount() {
        return 5;
    }

    @Override
    public CharSequence getDefaultMapType() {
        return "fast";
    }

    @Override
    public boolean getDefaultSymbolCacheFlag() {
        return true;
    }

    @Override
    public int getDefaultSymbolCapacity() {
        return 128;
    }

    @Override
    public int getFileOperationRetryCount() {
        return 30;
    }

    @Override
    public FilesFacade getFilesFacade() {
        return FilesFacadeImpl.INSTANCE;
    }

    @Override
    public long getIdleCheckInterval() {
        return 100L;
    }

    @Override
    public long getInactiveReaderTTL() {
        return -10000L;
    }

    @Override
    public long getInactiveWriterTTL() {
        return -10000L;
    }

    @Override
    public int getIndexValueBlockSize() {
        return 256;
    }

    @Override
    public int getDoubleToStrCastScale() {
        return 19;
    }

    @Override
    public int getFloatToStrCastScale() {
        return 4;
    }

    @Override
    public int getMaxSwapFileCount() {
        return 30;
    }

    @Override
    public MicrosecondClock getMicrosecondClock() {
        return MicrosecondClockImpl.INSTANCE;
    }

    @Override
    public MillisecondClock getMillisecondClock() {
        return MillisecondClockImpl.INSTANCE;
    }

    @Override
    public NanosecondClock getNanosecondClock() {
        return NanosecondClockImpl.INSTANCE;
    }

    @Override
    public int getMkDirMode() {
        return 509;
    }

    @Override
    public int getParallelIndexThreshold() {
        return 100000;
    }

    @Override
    public int getReaderPoolMaxSegments() {
        return 5;
    }

    @Override
    public CharSequence getRoot() {
        return this.root;
    }

    @Override
    public CharSequence getInputRoot() {
        return null;
    }

    @Override
    public CharSequence getBackupRoot() {
        return null;
    }

    @Override
    public DateFormat getBackupDirTimestampFormat() {
        return null;
    }

    @Override
    public CharSequence getBackupTempDirName() {
        return "tmp";
    }

    @Override
    public int getBackupMkDirMode() {
        return 509;
    }

    @Override
    public long getSpinLockTimeoutUs() {
        return 1000000L;
    }

    @Override
    public int getSqlCharacterStoreCapacity() {
        return 64;
    }

    @Override
    public boolean isO3QuickSortEnabled() {
        return false;
    }

    @Override
    public int getSqlCharacterStoreSequencePoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlColumnPoolCapacity() {
        return 4096;
    }

    @Override
    public double getSqlCompactMapLoadFactor() {
        return 0.8;
    }

    @Override
    public int getSqlExpressionPoolCapacity() {
        return 8192;
    }

    @Override
    public double getSqlFastMapLoadFactor() {
        return 0.5;
    }

    @Override
    public int getSqlJoinContextPoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlLexerPoolCapacity() {
        return 2048;
    }

    @Override
    public int getSqlMapKeyCapacity() {
        return 128;
    }

    @Override
    public int getSqlMapPageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlMapMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlMapMaxResizes() {
        return 64;
    }

    @Override
    public int getSqlModelPoolCapacity() {
        return 1024;
    }

    @Override
    public long getSqlSortKeyPageSize() {
        return 0x400000L;
    }

    @Override
    public int getSqlSortKeyMaxPages() {
        return 128;
    }

    @Override
    public long getSqlSortLightValuePageSize() {
        return 0x800000L;
    }

    @Override
    public int getSqlSortLightValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlHashJoinValuePageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlHashJoinValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlAnalyticStorePageSize() {
        return 4096;
    }

    @Override
    public int getSqlAnalyticStoreMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSqlAnalyticRowIdPageSize() {
        return 1024;
    }

    @Override
    public int getSqlAnalyticRowIdMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSqlAnalyticTreeKeyPageSize() {
        return 4096;
    }

    @Override
    public int getSqlAnalyticTreeKeyMaxPages() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getSqlLatestByRowCount() {
        return 1000L;
    }

    @Override
    public int getSqlHashJoinLightValuePageSize() {
        return 0x100000;
    }

    @Override
    public int getSqlHashJoinLightValueMaxPages() {
        return 1024;
    }

    @Override
    public int getSqlSortValuePageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlSortValueMaxPages() {
        return 1024;
    }

    @Override
    public TextConfiguration getTextConfiguration() {
        return this.textConfiguration;
    }

    @Override
    public long getWorkStealTimeoutNanos() {
        return 10000L;
    }

    @Override
    public boolean isParallelIndexingEnabled() {
        return true;
    }

    @Override
    public int getSqlJoinMetadataPageSize() {
        return 16384;
    }

    @Override
    public int getSqlJoinMetadataMaxResizes() {
        return 10;
    }

    @Override
    public int getAnalyticColumnPoolCapacity() {
        return 64;
    }

    @Override
    public int getCreateTableModelPoolCapacity() {
        return 32;
    }

    @Override
    public int getColumnCastModelPoolCapacity() {
        return 32;
    }

    @Override
    public int getRenameTableModelPoolCapacity() {
        return 8;
    }

    @Override
    public int getWithClauseModelPoolCapacity() {
        return 128;
    }

    @Override
    public int getInsertPoolCapacity() {
        return 8;
    }

    @Override
    public int getCommitMode() {
        return 2;
    }

    @Override
    public DateLocale getDefaultDateLocale() {
        return DateFormatUtils.enLocale;
    }

    @Override
    public int getGroupByPoolCapacity() {
        return 1024;
    }

    @Override
    public int getMaxSymbolNotEqualsCount() {
        return 100;
    }

    @Override
    public int getGroupByMapCapacity() {
        return 1024;
    }

    @Override
    public boolean enableTestFactories() {
        return true;
    }

    @Override
    public TelemetryConfiguration getTelemetryConfiguration() {
        return this.telemetryConfiguration;
    }

    @Override
    public long getAppendPageSize() {
        return this.getFilesFacade().getMapPageSize();
    }

    @Override
    public int getTableBlockWriterQueueCapacity() {
        return 4;
    }

    @Override
    public int getColumnIndexerQueueCapacity() {
        return 1024;
    }

    @Override
    public int getVectorAggregateQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3CallbackQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3PartitionQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3OpenColumnQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3CopyQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3PartitionUpdateQueueCapacity() {
        return 1024;
    }

    @Override
    public BuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    @Override
    public long getDatabaseIdHi() {
        return this.databaseIdHi;
    }

    @Override
    public long getDatabaseIdLo() {
        return this.databaseIdLo;
    }

    @Override
    public int getO3PurgeDiscoveryQueueCapacity() {
        return 1024;
    }

    @Override
    public int getO3PurgeQueueCapacity() {
        return 1024;
    }

    @Override
    public int getTxnScoreboardEntryCount() {
        return 8192;
    }

    @Override
    public int getO3MaxUncommittedRows() {
        return 1000;
    }

    @Override
    public long getO3CommitHysteresis() {
        return 0L;
    }
}

