/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MappedReadWriteMemory;
import io.questdb.cairo.vm.PagedMappedReadWriteMemory;
import io.questdb.cairo.vm.PagedVirtualMemory;
import io.questdb.cairo.vm.ReadWriteVirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;

public class EngineMigration {
    public static final int VERSION_TX_STRUCT_UPDATE_1 = 418;
    public static final int VERSION_TBL_META_HYSTERESIS = 419;
    public static final long TX_STRUCT_UPDATE_1_OFFSET_MAP_WRITER_COUNT = 72L;
    public static final long TX_STRUCT_UPDATE_1_META_OFFSET_PARTITION_BY = 4L;
    public static final String TX_STRUCT_UPDATE_1_ARCHIVE_FILE_NAME = "_archive";
    private static final Log LOG = LogFactory.getLog(EngineMigration.class);
    private static final ObjList<MigrationAction> MIGRATIONS = new ObjList();
    private static final IntList MIGRATIONS_CRITICALITY = new IntList();
    private static final int MIGRATIONS_LIST_OFFSET = 417;
    private final CairoEngine engine;
    private final CairoConfiguration configuration;
    private boolean updateSuccess;

    public EngineMigration(CairoEngine engine, CairoConfiguration configuration) {
        this.engine = engine;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateEngineTo(int latestVersion) {
        block45: {
            FilesFacade ff = this.configuration.getFilesFacade();
            int tempMemSize = 8;
            long mem = Unsafe.malloc(tempMemSize);
            try (PagedVirtualMemory virtualMem = new PagedVirtualMemory(ff.getPageSize(), 8);
                 Path path = new Path();
                 PagedMappedReadWriteMemory rwMemory = new PagedMappedReadWriteMemory();){
                long readLen;
                MigrationContext context = new MigrationContext(mem, tempMemSize, virtualMem, rwMemory);
                path.of(this.configuration.getRoot());
                path.concat("_upgrade.d").$();
                boolean existed = ff.exists(path);
                long upgradeFd = TableUtils.openFileRWOrFail(ff, path);
                LOG.debug().$("open [fd=").$(upgradeFd).$(", path=").$(path).$(']').$();
                if (existed && (readLen = ff.read(upgradeFd, mem, 4L, 0L)) == 4L && Unsafe.getUnsafe().getInt(mem) >= latestVersion) {
                    LOG.info().$("table structures are up to date").$();
                    ff.close(upgradeFd);
                    upgradeFd = -1L;
                }
                if (upgradeFd == -1L) break block45;
                try {
                    LOG.info().$("upgrading database [version=").$(latestVersion).I$();
                    if (this.upgradeTables(context, latestVersion)) {
                        Unsafe.getUnsafe().putInt(mem, latestVersion);
                        long writeLen = ff.write(upgradeFd, mem, 4L, 0L);
                        if (writeLen < 4L) {
                            LOG.error().$("could not write to ").$("_upgrade.d").$(" [fd=").$(upgradeFd).$(",errno=").$(ff.errno()).I$();
                        }
                    }
                }
                finally {
                    ff.close(upgradeFd);
                }
            }
            finally {
                Unsafe.free(mem, tempMemSize);
            }
        }
    }

    static MigrationAction getMigrationToVersion(int version) {
        return MIGRATIONS.getQuick(version - 417);
    }

    private static int getMigrationToVersionCriticality(int version) {
        return MIGRATIONS_CRITICALITY.getQuick(version - 417);
    }

    private static void setByVersion(int version, MigrationAction action, int criticality) {
        MIGRATIONS.setQuick(version - 417, action);
        MIGRATIONS_CRITICALITY.extendAndSet(version - 417, criticality);
    }

    private boolean upgradeTables(MigrationContext context, int latestVersion) {
        FilesFacade ff = this.configuration.getFilesFacade();
        long mem = context.getTempMemory(8);
        this.updateSuccess = true;
        try (Path path = new Path();
             Path copyPath = new Path();){
            path.of(this.configuration.getRoot());
            copyPath.of(this.configuration.getRoot());
            int rootLen = path.length();
            NativeLPSZ nativeLPSZ = new NativeLPSZ();
            ff.iterateDir(path.$(), (name, type) -> {
                if (type == 4) {
                    nativeLPSZ.of(name);
                    if (Chars.notDots(nativeLPSZ)) {
                        path.trimTo(rootLen);
                        path.concat(nativeLPSZ);
                        copyPath.trimTo(rootLen);
                        copyPath.concat(nativeLPSZ);
                        int plen = path.length();
                        path.concat("_meta");
                        if (ff.exists(path.$())) {
                            long fd = TableUtils.openFileRWOrFail(ff, path);
                            try {
                                if (ff.read(fd, mem, 4L, 12L) == 4L) {
                                    int currentTableVersion = Unsafe.getUnsafe().getInt(mem);
                                    if (currentTableVersion < latestVersion) {
                                        LOG.info().$("upgrading [path=").$(path).$(",fromVersion=").$(currentTableVersion).$(",toVersion=").$(latestVersion).I$();
                                        copyPath.trimTo(plen);
                                        EngineMigration.backupFile(ff, path, copyPath, "_meta", currentTableVersion);
                                        path.trimTo(plen);
                                        context.of(path, copyPath, fd);
                                        for (int i = currentTableVersion + 1; i <= latestVersion; ++i) {
                                            MigrationAction migration = EngineMigration.getMigrationToVersion(i);
                                            try {
                                                if (migration != null) {
                                                    LOG.info().$("upgrading table [path=").$(path).$(",toVersion=").$(i).I$();
                                                    migration.migrate(context);
                                                }
                                            }
                                            catch (Exception e) {
                                                LOG.error().$("failed to upgrade table path=").$(path.trimTo(plen)).$(", exception: ").$(e).$();
                                                if (EngineMigration.getMigrationToVersionCriticality(i) != 0) {
                                                    throw e;
                                                }
                                                this.updateSuccess = false;
                                                ff.close(fd);
                                                path.trimTo(plen);
                                                copyPath.trimTo(plen);
                                                return;
                                            }
                                            Unsafe.getUnsafe().putInt(mem, i);
                                            if (ff.write(fd, mem, 4L, 12L) == 4L) continue;
                                            throw CairoException.instance(ff.errno()).put("failed to write updated version to table Metadata file [path=").put(path.trimTo(plen)).put(",latestVersion=").put(i).put(']');
                                        }
                                    }
                                    return;
                                }
                                this.updateSuccess = false;
                                throw CairoException.instance(ff.errno()).put("Could not update table [path=").put(path).put(']');
                            }
                            finally {
                                ff.close(fd);
                                path.trimTo(plen);
                                copyPath.trimTo(plen);
                            }
                        }
                    }
                }
            });
            LOG.info().$("upgraded tables to ").$(latestVersion).$();
        }
        return this.updateSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backupFile(FilesFacade ff, Path src, Path toTemp, String backupName, int version) {
        int copyPathLen = toTemp.length();
        try {
            toTemp.concat(backupName).put(".v").put(version);
            int i = 1;
            while (ff.exists(toTemp.$())) {
                LOG.info().$("back up file exists, [path=").$(toTemp).I$();
                toTemp.trimTo(copyPathLen);
                toTemp.concat(backupName).put(".v").put(version).put(".").put(i);
                ++i;
            }
            LOG.info().$("back up coping file [from=").$(src).$(",to=").$(toTemp).I$();
            if (ff.copy(src.$(), toTemp.$()) < 0) {
                throw CairoException.instance(ff.errno()).put("Cannot backup transaction file [to=").put(toTemp).put(']');
            }
        }
        finally {
            toTemp.trimTo(copyPathLen);
        }
    }

    static int readIntAtOffset(FilesFacade ff, Path path, long tempMem4b, long fd) {
        if (ff.read(fd, tempMem4b, 4L, 4L) != 4L) {
            throw CairoException.instance(ff.errno()).put("Cannot read: ").put(path);
        }
        return Unsafe.getUnsafe().getInt(tempMem4b);
    }

    static {
        MIGRATIONS.extendAndSet(2, null);
        EngineMigration.setByVersion(417, x$0 -> MigrationActions.assignTableId(x$0), 1);
        EngineMigration.setByVersion(418, x$0 -> MigrationActions.rebuildTransactionFile(x$0), 0);
        EngineMigration.setByVersion(419, MigrationActions::addTblMetaHysteresis, 0);
    }

    class MigrationContext {
        private final long tempMemory;
        private final int tempMemoryLen;
        private final PagedVirtualMemory tempVirtualMem;
        private final MappedReadWriteMemory rwMemory;
        private Path tablePath;
        private long metadataFd;
        private Path tablePath2;

        public MigrationContext(long mem, int tempMemSize, PagedVirtualMemory tempVirtualMem, MappedReadWriteMemory rwMemory) {
            this.tempMemory = mem;
            this.tempMemoryLen = tempMemSize;
            this.tempVirtualMem = tempVirtualMem;
            this.rwMemory = rwMemory;
        }

        public CairoConfiguration getConfiguration() {
            return EngineMigration.this.configuration;
        }

        public FilesFacade getFf() {
            return EngineMigration.this.configuration.getFilesFacade();
        }

        public long getMetadataFd() {
            return this.metadataFd;
        }

        public int getNextTableId() {
            return (int)EngineMigration.this.engine.getNextTableId();
        }

        public MappedReadWriteMemory createRwMemoryOf(FilesFacade ff, Path path, long pageSize) {
            this.rwMemory.of(ff, path, pageSize);
            return this.rwMemory;
        }

        public Path getTablePath() {
            return this.tablePath;
        }

        public Path getTablePath2() {
            return this.tablePath2;
        }

        public long getTempMemory(int size) {
            if (size <= this.tempMemoryLen) {
                return this.tempMemory;
            }
            throw new UnsupportedOperationException("No temp memory of size " + size + " is allocate. Only " + this.tempMemoryLen + " is available");
        }

        public PagedVirtualMemory getTempVirtualMem() {
            return this.tempVirtualMem;
        }

        public MigrationContext of(Path path, Path pathCopy, long metadataFd) {
            this.tablePath = path;
            this.tablePath2 = pathCopy;
            this.metadataFd = metadataFd;
            return this;
        }
    }

    private static class MigrationActions {
        private MigrationActions() {
        }

        public static void addTblMetaHysteresis(MigrationContext migrationContext) {
            Path path = migrationContext.getTablePath();
            FilesFacade ff = migrationContext.getFf();
            path.concat("_meta").$();
            if (!ff.exists(path)) {
                LOG.error().$("meta file does not exist, nothing to migrate [path=").$(path).I$();
                return;
            }
            long tempMem = migrationContext.getTempMemory(8);
            Unsafe.getUnsafe().putInt(tempMem, migrationContext.getConfiguration().getO3MaxUncommittedRows());
            if (ff.write(migrationContext.metadataFd, tempMem, 4L, 20L) != 4L) {
                throw CairoException.instance(ff.errno()).put("Cannot update metadata [path=").put(path).put(']');
            }
            Unsafe.getUnsafe().putLong(tempMem, migrationContext.getConfiguration().getO3CommitHysteresis());
            if (ff.write(migrationContext.metadataFd, tempMem, 8L, 24L) != 8L) {
                throw CairoException.instance(ff.errno()).put("Cannot update metadata [path=").put(path).put(']');
            }
        }

        private static void assignTableId(MigrationContext migrationContext) {
            long mem = migrationContext.getTempMemory(8);
            FilesFacade ff = migrationContext.getFf();
            Path path = migrationContext.getTablePath();
            LOG.info().$("setting table id in [path=").$(path).I$();
            Unsafe.getUnsafe().putInt(mem, migrationContext.getNextTableId());
            if (ff.write(migrationContext.getMetadataFd(), mem, 4L, 16L) == 4L) {
                return;
            }
            throw CairoException.instance(ff.errno()).put("Could not update table id [path=").put(path).put(']');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void rebuildTransactionFile(MigrationContext migrationContext) {
            Path path = migrationContext.getTablePath();
            FilesFacade ff = migrationContext.getFf();
            int pathDirLen = path.length();
            path.concat("_txn").$();
            if (!ff.exists(path)) {
                LOG.error().$("tx file does not exist, nothing to migrate [path=").$(path).I$();
                return;
            }
            EngineMigration.backupFile(ff, path, migrationContext.getTablePath2(), "_txn", 417);
            LOG.debug().$("opening for rw [path=").$(path).I$();
            MappedReadWriteMemory txMem = migrationContext.createRwMemoryOf(ff, path.$(), ff.getPageSize());
            long tempMem8b = migrationContext.getTempMemory(8);
            PagedVirtualMemory txFileUpdate = migrationContext.getTempVirtualMem();
            txFileUpdate.clear();
            txFileUpdate.jumpTo(0L);
            try {
                long writeSize;
                int symbolsCount = txMem.getInt(72L);
                for (int i = 0; i < symbolsCount; ++i) {
                    long symbolCountOffset = 72L + ((long)i + 1L) * 4L;
                    int symDistinctCount = txMem.getInt(symbolCountOffset);
                    txFileUpdate.putInt(symDistinctCount);
                    txFileUpdate.putInt(symDistinctCount);
                }
                long partitionSegmentOffset = txFileUpdate.getAppendOffset();
                txFileUpdate.putInt(0);
                int partitionBy = EngineMigration.readIntAtOffset(ff, path, tempMem8b, migrationContext.getMetadataFd());
                if (partitionBy != 3) {
                    path.trimTo(pathDirLen);
                    MigrationActions.writeAttachedPartitions(ff, tempMem8b, path, txMem, partitionBy, symbolsCount, txFileUpdate);
                }
                long updateSize = txFileUpdate.getAppendOffset();
                long partitionSegmentSize = updateSize - partitionSegmentOffset - 4L;
                txFileUpdate.putInt(partitionSegmentOffset, (int)partitionSegmentSize);
                long writeOffset = 76L;
                txMem.jumpTo(writeOffset);
                int size = txFileUpdate.getPageCount();
                for (int i = 0; i < size && updateSize > 0L; updateSize -= writeSize, ++i) {
                    writeSize = Math.min(updateSize, txFileUpdate.getPageSize(i));
                    txMem.putBlockOfBytes(txFileUpdate.getPageAddress(i), writeSize);
                }
                assert (updateSize == 0L);
            }
            finally {
                txMem.close();
            }
        }

        private static void writeAttachedPartitions(FilesFacade ff, long tempMem8b, Path path, MappedReadWriteMemory txMem, int partitionBy, int symbolsCount, PagedVirtualMemory writeTo) {
            int rootLen = path.length();
            long minTimestamp = txMem.getLong(24L);
            long maxTimestamp = txMem.getLong(32L);
            long transientCount = txMem.getLong(8L);
            Timestamps.TimestampFloorMethod timestampFloorMethod = TableUtils.getPartitionFloor(partitionBy);
            Timestamps.TimestampAddMethod timestampAddMethod = TableUtils.getPartitionAdd(partitionBy);
            long tsLimit = timestampFloorMethod.floor(maxTimestamp);
            long ts = timestampFloorMethod.floor(minTimestamp);
            while (ts < tsLimit) {
                path.trimTo(rootLen);
                TableUtils.setPathForPartition(path, partitionBy, ts, false);
                if (ff.exists(path.concat(EngineMigration.TX_STRUCT_UPDATE_1_ARCHIVE_FILE_NAME).$()) && !MigrationActions.removedPartitionsIncludes(ts, txMem, symbolsCount)) {
                    long partitionSize = TableUtils.readLongAtOffset(ff, path, tempMem8b, 0L);
                    writeTo.putLong(ts);
                    writeTo.putLong(partitionSize);
                    writeTo.putLong(-1L);
                    writeTo.putLong(0L);
                }
                ts = timestampAddMethod.calculate(ts, 1);
            }
            writeTo.putLong(tsLimit);
            writeTo.putLong(transientCount);
            writeTo.putLong(-1L);
            writeTo.putLong(0L);
        }

        private static boolean removedPartitionsIncludes(long ts, ReadWriteVirtualMemory txMem, int symbolsCount) {
            long removedPartitionLo = 72L + ((long)symbolsCount + 1L) * 4L;
            long removedPartitionCount = txMem.getInt(removedPartitionLo);
            long removedPartitionsHi = removedPartitionLo + 8L * removedPartitionCount;
            for (long offset = removedPartitionLo + 4L; offset < removedPartitionsHi; offset += 8L) {
                long removedPartition = txMem.getLong(offset);
                if (removedPartition != ts) continue;
                return true;
            }
            return false;
        }
    }

    @FunctionalInterface
    static interface MigrationAction {
        public void migrate(MigrationContext var1);
    }
}

