/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.IntList;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;

public class MetadataMigration400 {
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int CHAR = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int STRING = 8;
    public static final int SYMBOL = 9;
    public static final int BINARY = 10;
    public static final int DATE = 11;
    public static final int TIMESTAMP = 12;
    public static final int LONG256 = 13;
    public static final int PARAMETER = 14;
    private static final IntList typeMapping = new IntList();
    private static final Log LOG = LogFactory.getLog(MetadataMigration400.class);

    public static void convert(FilesFacade ff, Path path1, Path path2, AppendOnlyVirtualMemory appendMem, MappedReadOnlyMemory roMem) {
        int i;
        int plen = path1.length();
        path1.concat("_meta").$();
        if (!ff.exists(path1)) {
            return;
        }
        roMem.of(ff, path1, ff.getPageSize(), ff.length(path1));
        if (roMem.getInt(12L) == 419) {
            LOG.error().$("already up to date ").$(path1).$();
            return;
        }
        path1.trimTo(plen);
        path1.concat("_meta.1").$();
        appendMem.of(ff, path1, ff.getPageSize());
        int columnCount = roMem.getInt(0L);
        appendMem.putInt(columnCount);
        appendMem.putInt(roMem.getInt(4L));
        appendMem.putInt(roMem.getInt(8L));
        appendMem.putInt(419);
        appendMem.jumpTo(128L);
        long offset = 128L;
        for (i = 0; i < columnCount; ++i) {
            appendMem.putByte((byte)typeMapping.getQuick(roMem.getByte(offset)));
            long flags = 0L;
            if (roMem.getBool(offset + 1L)) {
                flags |= 1L;
            }
            appendMem.putLong(flags);
            appendMem.putInt(roMem.getInt(offset + 2L));
            appendMem.skip(3L);
            offset += 16L;
        }
        for (i = 0; i < columnCount; ++i) {
            CharSequence s = roMem.getStr(offset);
            appendMem.putStr(s);
            offset += (long)s.length() * 2L + 4L;
        }
        roMem.close();
        appendMem.close();
        path1.trimTo(plen).concat("_meta").$();
        path2.trimTo(plen).concat("_meta.old").$();
        if (!ff.rename(path1, path2)) {
            LOG.error().$("could not rename ").$(path1).$(" -> ").$(path2).$();
            return;
        }
        path1.trimTo(plen).concat("_meta.1").$();
        path2.trimTo(plen).concat("_meta").$();
        if (!ff.rename(path1, path2)) {
            LOG.error().$("could not rename ").$(path1).$(" -> ").$(path2).$();
            return;
        }
        LOG.info().$("updated ").$(path2).$();
    }

    public static void main(String[] args) {
        try (SinglePageMappedReadOnlyPageMemory roMem = new SinglePageMappedReadOnlyPageMemory();
             AppendOnlyVirtualMemory appendMem = new AppendOnlyVirtualMemory();
             Path path1 = new Path();
             Path path2 = new Path();){
            if (args.length < 1) {
                LOG.info().$("usage: ").$(MetadataMigration400.class.getName()).$(" <db_path>").$();
                return;
            }
            FilesFacade ff = FilesFacadeImpl.INSTANCE;
            NativeLPSZ nativeLPSZ = new NativeLPSZ();
            path1.of(args[0]).$();
            ff.iterateDir(path1, (name, type) -> {
                if (type == 4) {
                    nativeLPSZ.of(name);
                    if (!Chars.equals((CharSequence)nativeLPSZ, '.') && !Chars.equals((CharSequence)nativeLPSZ, "..")) {
                        int plen = path1.length();
                        path1.chop$().concat(nativeLPSZ);
                        path2.of(path1);
                        MetadataMigration400.convert(ff, path1, path2, appendMem, roMem);
                        path1.trimTo(plen);
                    }
                }
            });
            MetadataMigration400.convert(FilesFacadeImpl.INSTANCE, path1, path2, appendMem, roMem);
        }
    }

    static {
        typeMapping.extendAndSet(0, 0);
        typeMapping.extendAndSet(1, 1);
        typeMapping.extendAndSet(2, 2);
        typeMapping.extendAndSet(4, 4);
        typeMapping.extendAndSet(5, 5);
        typeMapping.extendAndSet(6, 8);
        typeMapping.extendAndSet(7, 9);
        typeMapping.extendAndSet(8, 10);
        typeMapping.extendAndSet(9, 11);
        typeMapping.extendAndSet(10, 13);
        typeMapping.extendAndSet(11, 6);
        typeMapping.extendAndSet(14, 14);
        typeMapping.extendAndSet(12, 7);
        typeMapping.extendAndSet(3, 3);
        typeMapping.extendAndSet(13, 12);
    }
}

