/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3PartitionUpdateTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class O3CopyJob
extends AbstractQueueConsumerJob<O3CopyTask> {
    private static final Log LOG = LogFactory.getLog(O3CopyJob.class);

    public O3CopyJob(MessageBus messageBus) {
        super(messageBus.getO3CopyQueue(), messageBus.getO3CopySubSeq());
    }

    public static void copy(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        switch (blockType) {
            case 3: {
                O3CopyJob.mergeCopy(columnType, timestampMergeIndexAddr, srcDataFixAddr + srcDataFixOffset - srcDataTop, srcDataVarAddr + srcDataVarOffset, srcDataLo, srcDataHi, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, dstFixAddr + dstFixOffset, dstVarAddr, dstVarOffset);
                break;
            }
            case 1: {
                O3CopyJob.copyO3(columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, dstFixAddr + dstFixOffset, dstVarAddr, dstVarOffset, dstVarAdjust);
                break;
            }
            case 2: {
                O3CopyJob.copyData(columnType, srcDataFixAddr + srcDataFixOffset, srcDataFixSize - srcDataFixOffset, srcDataVarAddr + srcDataVarOffset, srcDataVarSize - srcDataVarOffset, srcDataLo, srcDataHi, dstFixAddr + dstFixOffset, dstVarAddr, dstVarOffset, dstVarAdjust);
                break;
            }
        }
        O3CopyJob.copyTail(columnCounter, partCounter, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcDataMax, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
    }

    public static void copy(O3CopyTask task, long cursor, Sequence subSeq) {
        AtomicInteger columnCounter = task.getColumnCounter();
        AtomicInteger partCounter = task.getPartCounter();
        int columnType = task.getColumnType();
        int blockType = task.getBlockType();
        long timestampMergeIndexAddr = task.getTimestampMergeIndexAddr();
        long srcDataFixFd = task.getSrcDataFixFd();
        long srcDataFixAddr = task.getSrcDataFixAddr();
        long srcDataFixOffset = task.getSrcDataFixOffset();
        long srcDataFixSize = task.getSrcDataFixSize();
        long srcDataVarFd = task.getSrcDataVarFd();
        long srcDataVarAddr = task.getSrcDataVarAddr();
        long srcDataVarOffset = task.getSrcDataVarOffset();
        long srcDataVarSize = task.getSrcDataVarSize();
        long srcDataTop = task.getSrcDataTop();
        long srcDataLo = task.getSrcDataLo();
        long srcDataMax = task.getSrcDataMax();
        long srcDataHi = task.getSrcDataHi();
        long srcOooFixAddr = task.getSrcOooFixAddr();
        long srcOooFixSize = task.getSrcOooFixSize();
        long srcOooVarAddr = task.getSrcOooVarAddr();
        long srcOooVarSize = task.getSrcOooVarSize();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long srcOooPartitionLo = task.getSrcOooPartitionLo();
        long srcOooPartitionHi = task.getSrcOooPartitionHi();
        long timestampMin = task.getTimestampMin();
        long timestampMax = task.getTimestampMax();
        long partitionTimestamp = task.getPartitionTimestamp();
        long dstFixFd = task.getDstFixFd();
        long dstFixAddr = task.getDstFixAddr();
        long dstFixOffset = task.getDstFixOffset();
        long dstFixSize = task.getDstFixSize();
        long dstVarFd = task.getDstVarFd();
        long dstVarAddr = task.getDstVarAddr();
        long dstVarOffset = task.getDstVarOffset();
        long dstVarAdjust = task.getDstVarAdjust();
        long dstVarSize = task.getDstVarSize();
        long dstKFd = task.getDstKFd();
        long dskVFd = task.getDstVFd();
        long dstIndexOffset = task.getDstIndexOffset();
        long dstIndexAdjust = task.getDstIndexAdjust();
        boolean isIndexed = task.isIndexed();
        long srcTimestampFd = task.getSrcTimestampFd();
        long srcTimestampAddr = task.getSrcTimestampAddr();
        long srcTimestampSize = task.getSrcTimestampSize();
        boolean partitionMutates = task.isPartitionMutates();
        TableWriter tableWriter = task.getTableWriter();
        BitmapIndexWriter indexWriter = task.getIndexWriter();
        subSeq.done(cursor);
        O3CopyJob.copy(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dskVFd, dstIndexOffset, dstIndexAdjust, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
    }

    private static void copyTail(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long srcDataMax, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        if (partCounter == null || partCounter.decrementAndGet() == 0) {
            FilesFacade ff = tableWriter.getFilesFacade();
            if (isIndexed) {
                O3CopyJob.updateIndex(columnCounter, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, dstFixFd, dstFixAddr, Math.abs(dstFixSize), dstVarFd, dstVarAddr, Math.abs(dstVarSize), dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter);
            }
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, srcDataVarFd, srcDataVarAddr, srcDataVarSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, dstVarFd, dstVarAddr, dstVarSize);
            int columnsRemaining = columnCounter.decrementAndGet();
            LOG.debug().$("organic [columnsRemaining=").$(columnsRemaining).I$();
            if (columnsRemaining == 0) {
                O3CopyJob.updatePartition(timestampMergeIndexAddr, srcDataMax, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePartition(long timestampMergeIndexAddr, long srcDataMax, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter) {
        FilesFacade ff = tableWriter.getFilesFacade();
        O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
        try {
            try {
                O3Utils.close(ff, srcTimestampFd);
            }
            finally {
                O3CopyJob.notifyWriter(srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, srcOooMax, srcDataMax, partitionMutates, tableWriter);
            }
        }
        finally {
            if (timestampMergeIndexAddr != 0L) {
                Vect.freeMergedIndex(timestampMergeIndexAddr);
            }
            tableWriter.o3CountDownDoneLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateIndex(AtomicInteger columnCounter, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        try {
            boolean closed;
            long row = dstIndexOffset / 4L;
            boolean bl = closed = !indexWriter.isOpen();
            if (closed) {
                indexWriter.of(tableWriter.getConfiguration(), dstKFd, dstVFd, row == 0L);
            }
            try {
                O3CopyJob.updateIndex(dstFixAddr, dstFixSize, indexWriter, dstIndexOffset / 4L, dstIndexAdjust);
            }
            finally {
                if (closed) {
                    Misc.free(indexWriter);
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("index error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, 0L, 0L, tableWriter);
            throw e;
        }
    }

    static void copyIdle(AtomicInteger columnCounter, AtomicInteger partCounter, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long dstKFd, long dstVFd, TableWriter tableWriter) {
        if (partCounter == null || partCounter.decrementAndGet() == 0) {
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, tableWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyIdleQuick(AtomicInteger columnCounter, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstKFd, long dstVFd, TableWriter tableWriter) {
        try {
            FilesFacade ff = tableWriter.getFilesFacade();
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, srcDataVarFd, srcDataVarAddr, srcDataVarSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, dstVarFd, dstVarAddr, dstVarSize);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
        }
        finally {
            O3CopyJob.closeColumnIdle(columnCounter, timestampMergeIndexAddr, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
        }
    }

    static void closeColumnIdle(AtomicInteger columnCounter, long timestampMergeIndexAddr, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter) {
        int columnsRemaining = columnCounter.decrementAndGet();
        LOG.debug().$("idle [table=").$(tableWriter.getTableName()).$(", columnsRemaining=").$(columnsRemaining).I$();
        if (columnsRemaining == 0) {
            O3CopyJob.closeColumnIdleQuick(timestampMergeIndexAddr, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeColumnIdleQuick(long timestampMergeIndexAddr, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter) {
        try {
            FilesFacade ff = tableWriter.getFilesFacade();
            O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
            O3Utils.close(ff, srcTimestampFd);
            if (timestampMergeIndexAddr != 0L) {
                Vect.freeMergedIndex(timestampMergeIndexAddr);
            }
        }
        finally {
            tableWriter.o3ClockDownPartitionUpdateCount();
            tableWriter.o3CountDownDoneLatch();
        }
    }

    static void notifyWriter(long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long srcOooMax, long srcDataMax, boolean partitionMutates, TableWriter tableWriter) {
        long cursor = tableWriter.getO3PartitionUpdatePubSeq().next();
        if (cursor > -1L) {
            O3CopyJob.publishUpdPartitionSizeTaskHarmonized(cursor, srcOooPartitionLo, srcOooPartitionHi, partitionTimestamp, srcDataMax, partitionMutates, tableWriter);
        } else {
            O3CopyJob.publishUpdPartitionSizeTaskContended(cursor, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, srcOooMax, srcDataMax, partitionMutates, tableWriter);
        }
    }

    private static void publishUpdPartitionSizeTaskContended(long cursor, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long srcOooMax, long srcDataMax, boolean partitionMutates, TableWriter tableWriter) {
        while (cursor == -2L) {
            cursor = tableWriter.getO3PartitionUpdatePubSeq().next();
        }
        if (cursor > -1L) {
            O3CopyJob.publishUpdPartitionSizeTaskHarmonized(cursor, srcOooPartitionLo, srcOooPartitionHi, partitionTimestamp, srcDataMax, partitionMutates, tableWriter);
        } else {
            tableWriter.o3PartitionUpdateSynchronized(timestampMin, timestampMax, partitionTimestamp, srcOooPartitionLo, srcOooPartitionHi, partitionMutates, srcOooMax, srcDataMax);
        }
    }

    private static void publishUpdPartitionSizeTaskHarmonized(long cursor, long srcOooPartitionLo, long srcOooPartitionHi, long partitionTimestamp, long srcDataMax, boolean partitionMutates, TableWriter tableWriter) {
        O3PartitionUpdateTask task = tableWriter.getO3PartitionUpdateQueue().get(cursor);
        task.of(partitionTimestamp, srcOooPartitionLo, srcOooPartitionHi, srcDataMax, partitionMutates);
        tableWriter.getO3PartitionUpdatePubSeq().done(cursor);
    }

    private static void copyData(int columnType, long srcFixAddr, long srcFixSize, long srcVarAddr, long srcVarSize, long srcLo, long srcHi, long dstFixAddr, long dstVarAddr, long dstVarOffset, long dstVarAdjust) {
        switch (columnType) {
            case 10: 
            case 13: {
                O3CopyJob.copyVarSizeCol(srcFixAddr, srcFixSize, srcVarAddr, srcVarSize, srcLo, srcHi, dstFixAddr, dstVarAddr, dstVarOffset, dstVarAdjust);
                break;
            }
            default: {
                O3CopyJob.copyFixedSizeCol(srcFixAddr, srcLo, srcHi, dstFixAddr, ColumnType.pow2SizeOf(Math.abs(columnType)));
            }
        }
    }

    private static void copyFixedSizeCol(long src, long srcLo, long srcHi, long dst, int shl) {
        Vect.memcpy(src + (srcLo << shl), dst, srcHi - srcLo + 1L << shl);
    }

    private static void copyO3(int columnType, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long dstFixAddr, long dstVarAddr, long dstVarOffset, long dstVarAdjust) {
        switch (columnType) {
            case 10: 
            case 13: {
                O3CopyJob.copyVarSizeCol(srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, dstFixAddr, dstVarAddr, dstVarOffset, dstVarAdjust);
                break;
            }
            case 0: 
            case 1: {
                O3CopyJob.copyFixedSizeCol(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, 0);
                break;
            }
            case 2: 
            case 3: {
                O3CopyJob.copyFixedSizeCol(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, 1);
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                O3CopyJob.copyFixedSizeCol(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, 2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                O3CopyJob.copyFixedSizeCol(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, 3);
                break;
            }
            case -7: {
                O3Utils.copyFromTimestampIndex(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr);
                break;
            }
            case 12: {
                O3CopyJob.copyFixedSizeCol(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, 5);
                break;
            }
        }
    }

    private static void copyVarSizeCol(long srcFixAddr, long srcFixSize, long srcVarAddr, long srcVarSize, long srcLo, long srcHi, long dstFixAddr, long dstVarAddr, long dstVarOffset, long dstVarAdjust) {
        long lo = O3Utils.findVarOffset(srcFixAddr, srcLo, srcHi, srcVarSize);
        long hi = srcHi + 1L == srcFixSize / 8L ? srcVarSize : O3Utils.findVarOffset(srcFixAddr, srcHi + 1L, srcFixSize / 8L, srcVarSize);
        long dest = dstVarAddr + dstVarOffset;
        long len = hi - lo;
        Vect.memcpy(srcVarAddr + lo, dest, len);
        long offset = dstVarOffset + dstVarAdjust;
        if (lo == offset) {
            O3CopyJob.copyFixedSizeCol(srcFixAddr, srcLo, srcHi, dstFixAddr, 3);
        } else {
            O3Utils.shiftCopyFixedSizeColumnData(lo - offset, srcFixAddr, srcLo, srcHi, dstFixAddr);
        }
    }

    private static void mergeCopy(int columnType, long mergeIndexAddr, long srcDataFixAddr, long srcDataVarAddr, long srcDataLo, long srcDataHi, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long dstFixAddr, long dstVarAddr, long dstVarOffset) {
        long rowCount = srcOooHi - srcOooLo + 1L + srcDataHi - srcDataLo + 1L;
        switch (columnType) {
            case 0: 
            case 1: {
                Vect.mergeShuffle8Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, mergeIndexAddr, rowCount);
                break;
            }
            case 2: 
            case 3: {
                Vect.mergeShuffle16Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, mergeIndexAddr, rowCount);
                break;
            }
            case 10: {
                Vect.oooMergeCopyStrColumn(mergeIndexAddr, rowCount, srcDataFixAddr, srcDataVarAddr, srcOooFixAddr, srcOooVarAddr, dstFixAddr, dstVarAddr, dstVarOffset);
                break;
            }
            case 13: {
                Vect.oooMergeCopyBinColumn(mergeIndexAddr, rowCount, srcDataFixAddr, srcDataVarAddr, srcOooFixAddr, srcOooVarAddr, dstFixAddr, dstVarAddr, dstVarOffset);
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                Vect.mergeShuffle32Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, mergeIndexAddr, rowCount);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                Vect.mergeShuffle64Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, mergeIndexAddr, rowCount);
                break;
            }
            case -7: {
                Vect.oooCopyIndex(mergeIndexAddr, rowCount, dstFixAddr);
                break;
            }
            case 12: {
                Vect.mergeShuffle256Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, mergeIndexAddr, rowCount);
                break;
            }
        }
    }

    private static void updateIndex(long dstFixAddr, long dstFixSize, BitmapIndexWriter w, long row, long rowAdjust) {
        w.rollbackConditionally(row + rowAdjust);
        long count = dstFixSize / 4L - rowAdjust;
        while (row < count) {
            w.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(dstFixAddr + row * 4L)), row + rowAdjust);
            ++row;
        }
        w.setMaxValue(count - 1L);
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        O3CopyJob.copy((O3CopyTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }
}

