/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class O3OpenColumnJob
extends AbstractQueueConsumerJob<O3OpenColumnTask> {
    public static final int OPEN_MID_PARTITION_FOR_APPEND = 1;
    public static final int OPEN_LAST_PARTITION_FOR_APPEND = 2;
    public static final int OPEN_MID_PARTITION_FOR_MERGE = 3;
    public static final int OPEN_LAST_PARTITION_FOR_MERGE = 4;
    public static final int OPEN_NEW_PARTITION_FOR_APPEND = 5;
    private static final Log LOG = LogFactory.getLog(O3OpenColumnJob.class);

    public O3OpenColumnJob(MessageBus messageBus) {
        super(messageBus.getO3OpenColumnQueue(), messageBus.getO3OpenColumnSubSeq());
    }

    public static void appendLastPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, boolean isIndexed, AppendOnlyVirtualMemory dstFixMem, AppendOnlyVirtualMemory dstVarMem, TableWriter tableWriter, BitmapIndexWriter indexWriter, long tmpBuf) {
        long dstLen = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        switch (columnType) {
            case 10: 
            case 13: {
                O3OpenColumnJob.appendVarColumn(columnCounter, columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, isIndexed, 0L, 0L, 0L, -dstFixMem.getFd(), -dstVarMem.getFd(), dstFixMem, dstVarMem, dstLen, tableWriter, tmpBuf);
                break;
            }
            case -7: {
                O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataMax, isIndexed, -dstFixMem.getFd(), 0L, 0L, dstFixMem, dstLen, tableWriter);
                break;
            }
            default: {
                O3OpenColumnJob.appendFixColumn(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, isIndexed, 0L, 0L, 0L, -dstFixMem.getFd(), dstFixMem, dstLen, tableWriter, indexWriter);
            }
        }
    }

    public static void openColumn(O3OpenColumnTask task, long cursor, Sequence subSeq, long tmpBuf) {
        int openColumnMode = task.getOpenColumnMode();
        CharSequence pathToTable = task.getPathToTable();
        int columnType = task.getColumnType();
        CharSequence columnName = task.getColumnName();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long timestampMin = task.getTimestampMin();
        long timestampMax = task.getTimestampMax();
        long oooTimestampLo = task.getOooTimestampLo();
        long partitionTimestamp = task.getPartitionTimestamp();
        long srcDataMax = task.getSrcDataMax();
        long srcDataTxn = task.getSrcDataTxn();
        long srcTimestampFd = task.getSrcTimestampFd();
        long srcTimestampAddr = task.getSrcTimestampAddr();
        long srcTimestampSize = task.getSrcTimestampSize();
        AtomicInteger columnCounter = task.getColumnCounter();
        AtomicInteger partCounter = task.getPartCounter();
        boolean isIndexed = task.isIndexed();
        long srcOooFixAddr = task.getSrcOooFixAddr();
        long srcOooFixSize = task.getSrcOooFixSize();
        long srcOooVarAddr = task.getSrcOooVarAddr();
        long srcOooVarSize = task.getSrcOooVarSize();
        long mergeOOOLo = task.getMergeOOOLo();
        long mergeOOOHi = task.getMergeOOOHi();
        long mergeDataLo = task.getMergeDataLo();
        long mergeDataHi = task.getMergeDataHi();
        long txn = task.getTxn();
        int prefixType = task.getPrefixType();
        long prefixLo = task.getPrefixLo();
        long prefixHi = task.getPrefixHi();
        int suffixType = task.getSuffixType();
        long suffixLo = task.getSuffixLo();
        long suffixHi = task.getSuffixHi();
        int mergeType = task.getMergeType();
        long timestampMergeIndexAddr = task.getTimestampMergeIndexAddr();
        long activeFixFd = task.getActiveFixFd();
        long activeVarFd = task.getActiveVarFd();
        long srcDataTop = task.getSrcDataTop();
        TableWriter tableWriter = task.getTableWriter();
        BitmapIndexWriter indexWriter = task.getIndexWriter();
        subSeq.done(cursor);
        O3OpenColumnJob.openColumn(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, isIndexed, activeFixFd, activeVarFd, tableWriter, indexWriter, tmpBuf);
    }

    public static void openColumn(int openColumnMode, CharSequence pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long oooTimestampLo, long partitionTimestamp, long srcDataTop, long srcDataMax, long srcDataTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, int suffixType, long suffixLo, long suffixHi, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean isIndexed, long activeFixFd, long activeVarFd, TableWriter tableWriter, BitmapIndexWriter indexWriter, long tmpBuf) {
        long mergeLen = mergeOOOHi - mergeOOOLo + 1L + mergeDataHi - mergeDataLo + 1L;
        Path pathToPartition = Path.getThreadLocal(pathToTable);
        TableUtils.setPathForPartition(pathToPartition, tableWriter.getPartitionBy(), oooTimestampLo, false);
        int pplen = pathToPartition.length();
        TableUtils.txnPartitionConditionally(pathToPartition, srcDataTxn);
        int plen = pathToPartition.length();
        switch (openColumnMode) {
            case 1: {
                O3OpenColumnJob.appendMidPartition(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, tmpBuf);
                break;
            }
            case 3: {
                O3OpenColumnJob.mergeMidPartition(pathToPartition, plen, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, tmpBuf);
                break;
            }
            case 4: {
                O3OpenColumnJob.mergeLastPartition(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, isIndexed, activeFixFd, activeVarFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, tmpBuf);
                break;
            }
            case 5: {
                O3OpenColumnJob.appendNewPartition(pathToPartition, plen, columnName, columnCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataMax, isIndexed, tableWriter, indexWriter);
                break;
            }
        }
    }

    private static long getVarColumnSize(FilesFacade ff, int columnType, long dataFd, long lastValueOffset, long tmpBuf) {
        long offset;
        if (columnType == 10) {
            if (ff.read(dataFd, tmpBuf, 4L, lastValueOffset) != 4L) {
                throw CairoException.instance(ff.errno()).put("could not read string length [fd=").put(dataFd).put(']');
            }
            int len = Unsafe.getUnsafe().getInt(tmpBuf);
            offset = len < 1 ? lastValueOffset + 4L : lastValueOffset + 4L + (long)len * 2L;
        } else {
            if (ff.read(dataFd, tmpBuf, 8L, lastValueOffset) != 8L) {
                throw CairoException.instance(ff.errno()).put("could not read blob length [fd=").put(dataFd).put(']');
            }
            long len = Unsafe.getUnsafe().getLong(tmpBuf);
            offset = len < 1L ? lastValueOffset + 8L : lastValueOffset + 8L + len;
        }
        return offset;
    }

    private static void appendMidPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long tmpBuf) {
        long dstFixFd = 0L;
        long dstVarFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = O3OpenColumnJob.getSrcDataTop(ff, pathToPartition, plen, columnName, srcDataMax, tmpBuf);
                if (srcDataTop == srcDataMax) {
                    TableUtils.writeColumnTop(ff, pathToPartition.trimTo(plen), columnName, srcDataMax, tmpBuf);
                }
            }
            catch (Throwable e) {
                LOG.error().$("append mid partition error 1 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                tableWriter.o3BumpErrorCount();
                O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, tableWriter);
                throw e;
            }
        }
        long dstLen = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop;
        switch (columnType) {
            case 10: 
            case 13: {
                try {
                    TableUtils.iFile(pathToPartition.trimTo(plen), columnName);
                    dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
                    TableUtils.dFile(pathToPartition.trimTo(plen), columnName);
                    dstVarFd = TableUtils.openRW(ff, pathToPartition, LOG);
                }
                catch (Throwable e) {
                    LOG.error().$("append mid partition error 2 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    tableWriter.o3BumpErrorCount();
                    O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, 0L, 0L, dstVarFd, 0L, 0L, 0L, 0L, tableWriter);
                    throw e;
                }
                O3OpenColumnJob.appendVarColumn(columnCounter, columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstVarFd, null, null, dstLen, tableWriter, tmpBuf);
                break;
            }
            case -7: {
                O3OpenColumnJob.appendTimestampColumn(columnCounter, columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataMax, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, null, dstLen, tableWriter);
                break;
            }
            default: {
                try {
                    TableUtils.dFile(pathToPartition.trimTo(plen), columnName);
                    dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
                }
                catch (Throwable e) {
                    LOG.error().$("append mid partition error 3 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    tableWriter.o3BumpErrorCount();
                    O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, 0L, 0L, dstVarFd, 0L, 0L, 0L, 0L, tableWriter);
                    throw e;
                }
                O3OpenColumnJob.appendFixColumn(pathToPartition, plen, columnName, columnCounter, columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, timestampMin, timestampMax, partitionTimestamp, srcDataTop, srcDataMax, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, null, dstLen, tableWriter, indexWriter);
            }
        }
    }

    private static void appendFixColumn(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long dstFixFd, AppendOnlyVirtualMemory dstFixMem, long dstLen, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        long dstIndexAdjust;
        long dstIndexOffset;
        long dstFixAddr;
        long dstFixOffset;
        long dstFixSize;
        long dstKFd = 0L;
        long dstVFd = 0L;
        int shl = ColumnType.pow2SizeOf(columnType);
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            dstFixSize = dstLen << shl;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixOffset = srcDataMax - srcDataTop << shl;
                dstFixAddr = O3Utils.mapRW(ff, Math.abs(dstFixFd), dstFixSize);
                dstIndexOffset = dstFixOffset;
                dstIndexAdjust = 0L;
            } else {
                dstFixAddr = dstFixMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixSize = -dstFixSize;
                dstIndexOffset = 0L;
                dstIndexAdjust = srcDataMax - srcDataTop;
            }
            if (isIndexed && !indexWriter.isOpen()) {
                BitmapIndexUtils.keyFileName(pathToPartition.trimTo(plen), columnName);
                dstKFd = TableUtils.openRW(ff, pathToPartition, LOG);
                BitmapIndexUtils.valueFileName(pathToPartition.trimTo(plen), columnName);
                dstVFd = TableUtils.openRW(ff, pathToPartition, LOG);
            }
        }
        catch (Throwable e) {
            LOG.error().$("append fix error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, 0L, 0L, 0L, 0L, 0L, dstKFd, dstVFd, tableWriter);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, 0L, 0L, 0L, 0L, 0L, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, tableWriter, indexWriter);
    }

    private static void appendTimestampColumn(AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataMax, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, AppendOnlyVirtualMemory dstFixMem, long dstLen, TableWriter tableWriter) {
        long dstFixAddr;
        long dstFixOffset;
        long dstFixSize;
        long dstFixFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            dstFixSize = dstLen * 8L;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize) {
                dstFixOffset = srcDataMax * 8L;
                dstFixFd = -Math.abs(srcTimestampFd);
                dstFixAddr = O3Utils.mapRW(ff, -dstFixFd, dstFixSize);
            } else {
                dstFixAddr = dstFixMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixSize = -dstFixSize;
            }
        }
        catch (Throwable e) {
            LOG.error().$("append ts error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, 0L, 0L, 0L, 0L, 0L, 0L, 0L, tableWriter);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, 0L, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, tableWriter, null);
    }

    private static void appendVarColumn(AtomicInteger columnCounter, int columnType, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataTop, long srcDataMax, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long activeFixFd, long activeVarFd, AppendOnlyVirtualMemory dstFixMem, AppendOnlyVirtualMemory dstVarMem, long dstLen, TableWriter tableWriter, long tmpBuf) {
        long dstVarAdjust;
        long dstVarOffset;
        long dstFixOffset;
        long dstFixAddr = 0L;
        long dstVarAddr = 0L;
        long dstVarSize = 0L;
        long dstFixSize = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            long l = O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr, srcOooFixSize, srcOooVarSize);
            dstFixSize = dstLen * 8L;
            if (dstFixMem == null || dstFixMem.getAppendAddressSize() < dstFixSize || dstVarMem.getAppendAddressSize() < l) {
                dstFixOffset = (srcDataMax - srcDataTop) * 8L;
                dstFixAddr = O3Utils.mapRW(ff, Math.abs(activeFixFd), dstFixSize);
                dstVarOffset = dstFixOffset > 0L ? O3OpenColumnJob.getVarColumnSize(ff, columnType, Math.abs(activeVarFd), Unsafe.getUnsafe().getLong(dstFixAddr + dstFixOffset - 8L), tmpBuf) : 0L;
                dstVarSize = l + dstVarOffset;
                dstVarAddr = O3Utils.mapRW(ff, Math.abs(activeVarFd), dstVarSize);
                dstVarAdjust = 0L;
            } else {
                dstFixAddr = dstFixMem.getAppendAddress();
                dstVarAddr = dstVarMem.getAppendAddress();
                dstFixOffset = 0L;
                dstFixSize = -dstFixSize;
                dstVarOffset = 0L;
                dstVarSize = -l;
                dstVarAdjust = dstVarMem.getAppendOffset();
            }
        }
        catch (Throwable e) {
            LOG.error().$("append var error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, activeFixFd, dstFixAddr, dstFixSize, activeVarFd, dstVarAddr, dstVarSize, 0L, 0L, tableWriter);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcOooLo, srcOooHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, activeFixFd, dstFixAddr, dstFixOffset, dstFixSize, activeVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, 0L, 0L, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, false, tableWriter, null);
    }

    private static void publishCopyTask(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        long cursor = tableWriter.getO3CopyPubSeq().next();
        if (cursor > -1L) {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, isIndexed, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        } else {
            O3OpenColumnJob.publishCopyTaskContended(cursor, columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataTop, srcDataLo, srcDataHi, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        }
    }

    private static void publishCopyTaskContended(long cursor, AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTop, long srcDataLo, long srcDataHi, long srcDataMax, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        while (cursor == -2L) {
            cursor = tableWriter.getO3CopyPubSeq().next();
        }
        if (cursor == -1L) {
            O3CopyJob.copy(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        } else {
            O3OpenColumnJob.publishCopyTaskHarmonized(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, isIndexed, cursor, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        }
    }

    private static void publishCopyTaskHarmonized(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, long dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarAdjust, long dstVarSize, long dstKFd, long dstVFd, long dstIndexOffset, long dstIndexAdjust, boolean isIndexed, long cursor, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        O3CopyTask task = tableWriter.getO3CopyQueue().get(cursor);
        task.of(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarAdjust, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
        tableWriter.getO3CopyPubSeq().done(cursor);
    }

    private static void mergeLastPartition(Path pathToPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataTop, long srcDataMax, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, boolean isIndexed, long activeFixFd, long activeVarFd, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long tmpBuf) {
        switch (columnType) {
            case 10: 
            case 13: {
                O3OpenColumnJob.mergeVarColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, -activeFixFd, -activeVarFd, tableWriter, tmpBuf);
                break;
            }
            default: {
                O3OpenColumnJob.mergeFixColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataMax, srcDataTop, -activeFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, isIndexed, tableWriter, indexWriter, tmpBuf);
            }
        }
    }

    private static void mergeMidPartition(Path pathToPartition, int plen, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataTop, long srcDataMax, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, long tmpBuf) {
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataTop == -1L) {
            try {
                srcDataTop = O3OpenColumnJob.getSrcDataTop(ff, pathToPartition, plen, columnName, srcDataMax, tmpBuf);
            }
            catch (Throwable e) {
                LOG.error().$("merge mid partition error 1 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                tableWriter.o3BumpErrorCount();
                O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, tableWriter);
                throw e;
            }
        }
        long srcDataFixFd = 0L;
        long srcDataVarFd = 0L;
        switch (columnType) {
            case 10: 
            case 13: {
                try {
                    TableUtils.iFile(pathToPartition.trimTo(plen), columnName);
                    srcDataFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
                    TableUtils.dFile(pathToPartition.trimTo(plen), columnName);
                    srcDataVarFd = TableUtils.openRW(ff, pathToPartition, LOG);
                }
                catch (Throwable e) {
                    LOG.error().$("merge mid partition error 2 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    tableWriter.o3BumpErrorCount();
                    O3CopyJob.copyIdleQuick(columnCounter, 0L, srcDataFixFd, 0L, 0L, srcDataVarFd, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, tableWriter);
                    throw e;
                }
                O3OpenColumnJob.mergeVarColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataTop, srcDataMax, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, srcDataFixFd, srcDataVarFd, tableWriter, tmpBuf);
                break;
            }
            default: {
                try {
                    if (columnType < 0 && srcTimestampFd > 0L) {
                        srcDataFixFd = -srcTimestampFd;
                    } else {
                        TableUtils.dFile(pathToPartition.trimTo(plen), columnName);
                        srcDataFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
                    }
                }
                catch (Throwable e) {
                    LOG.error().$("merge mid partition error 3 [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    tableWriter.o3BumpErrorCount();
                    O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, tableWriter);
                    throw e;
                }
                O3OpenColumnJob.mergeFixColumn(pathToPartition, pplen, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, srcDataMax, srcDataTop, srcDataFixFd, srcTimestampFd, srcTimestampAddr, srcTimestampSize, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, mergeLen, suffixType, suffixLo, suffixHi, isIndexed, tableWriter, indexWriter, tmpBuf);
            }
        }
    }

    private static long getSrcDataTop(FilesFacade ff, Path path, int plen, CharSequence columnName, long srcDataMax, long tmpBuf) {
        boolean dFileExists = ff.exists(TableUtils.dFile(path.trimTo(plen), columnName));
        TableUtils.topFile(path.trimTo(plen), columnName);
        if (dFileExists && ff.exists(path)) {
            long topFd = TableUtils.openRW(ff, path, LOG);
            try {
                if (ff.read(topFd, tmpBuf, 8L, 0L) == 8L) {
                    long l = Unsafe.getUnsafe().getLong(tmpBuf);
                    return l;
                }
                throw CairoException.instance(ff.errno()).put("could not read [file=").put(path).put(']');
            }
            finally {
                ff.close(topFd);
            }
        }
        if (dFileExists) {
            return 0L;
        }
        return srcDataMax;
    }

    private static void mergeFixColumn(Path pathToPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataMax, long srcDataTop, long srcDataFixFd, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, boolean isIndexed, TableWriter tableWriter, BitmapIndexWriter indexWriter, long tmpBuf) {
        long dstFixAppendOffset2;
        long dstFixAppendOffset1;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        long srcDataFixSize = 0L;
        long srcDataFixAddr = 0L;
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        long dstKFd = 0L;
        long dstVFd = 0L;
        long srcFixFd = Math.abs(srcDataFixFd);
        int shl = ColumnType.pow2SizeOf(Math.abs(columnType));
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            TableUtils.txnPartition(pathToPartition.trimTo(pplen), txn);
            int pDirNameLen = pathToPartition.length();
            if (srcDataTop > 0L) {
                long srcDataActualBytes = srcDataMax - srcDataTop << shl;
                long srcDataMaxBytes = srcDataMax << shl;
                if (srcDataTop > prefixHi || prefixType == 1) {
                    srcDataFixSize = srcDataActualBytes + srcDataMaxBytes;
                    srcDataFixAddr = O3Utils.mapRW(ff, srcFixFd, srcDataFixSize);
                    O3OpenColumnJob.setNull(columnType, srcDataFixAddr + srcDataActualBytes, srcDataTop);
                    Vect.memcpy(srcDataFixAddr, srcDataFixAddr + srcDataMaxBytes, srcDataActualBytes);
                    srcDataTop = 0L;
                    srcDataFixOffset = srcDataActualBytes;
                } else {
                    TableUtils.writeColumnTop(ff, pathToPartition.trimTo(pDirNameLen), columnName, srcDataTop, tmpBuf);
                    srcDataFixSize = srcDataActualBytes;
                    srcDataFixAddr = O3Utils.mapRW(ff, srcFixFd, srcDataFixSize);
                    srcDataFixOffset = 0L;
                }
            } else {
                srcDataFixSize = srcDataMax << shl;
                srcDataFixAddr = O3Utils.mapRW(ff, srcFixFd, srcDataFixSize);
                srcDataFixOffset = 0L;
            }
            srcDataTopOffset = srcDataTop << shl;
            pathToPartition.trimTo(pDirNameLen).concat(columnName).put(".d").$();
            dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
            dstFixSize = srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop << shl;
            dstFixAddr = O3Utils.mapRW(ff, dstFixFd, dstFixSize);
            if (prefixType == 2) {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L - srcDataTop << shl;
                prefixHi -= srcDataTop;
            } else {
                dstFixAppendOffset1 = prefixHi - prefixLo + 1L << shl;
            }
            dstFixAppendOffset2 = mergeDataLo > -1L && mergeOOOLo > -1L ? dstFixAppendOffset1 + (mergeLen << shl) : dstFixAppendOffset1;
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            if (isIndexed) {
                BitmapIndexUtils.keyFileName(pathToPartition.trimTo(pDirNameLen), columnName);
                dstKFd = TableUtils.openRW(ff, pathToPartition, LOG);
                BitmapIndexUtils.valueFileName(pathToPartition.trimTo(pDirNameLen), columnName);
                dstVFd = TableUtils.openRW(ff, pathToPartition, LOG);
            }
            if (prefixType != -1) {
                ++partCount;
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge fix error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixSize, 0L, 0L, 0L, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, 0L, 0L, 0L, dstKFd, dstVFd, tableWriter);
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.publishMultiCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, 0L, 0L, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstFixFd, dstFixAddr, dstFixSize, 0L, 0L, 0L, dstFixAppendOffset1, dstFixAppendOffset2, 0L, 0L, dstKFd, dstVFd, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter);
    }

    private static void mergeVarColumn(Path pathToPartition, int pplen, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long oooPartitionMin, long oooPartitionMax, long oooPartitionHi, long srcDataTop, long srcDataMax, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeOOOLo, long mergeOOOHi, long mergeDataLo, long mergeDataHi, long mergeLen, int suffixType, long suffixLo, long suffixHi, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long srcDataFixFd, long srcDataVarFd, TableWriter tableWriter, long tmpBuf) {
        long dstVarAppendOffset2;
        long dstFixAppendOffset2;
        long dstFixAppendOffset1;
        long srcDataTopOffset;
        long srcDataFixOffset;
        int partCount = 0;
        long dstVarFd = 0L;
        long dstVarAddr = 0L;
        long srcDataFixAddr = 0L;
        long dstVarSize = 0L;
        long dstFixSize = 0L;
        long srcDataFixSize = 0L;
        long srcDataVarSize = 0L;
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long srcDataVarAddr = 0L;
        long srcDataVarOffset = 0L;
        long dstVarAppendOffset1 = 0L;
        long srcFixFd = Math.abs(srcDataFixFd);
        long srcVarFd = Math.abs(srcDataVarFd);
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            TableUtils.txnPartition(pathToPartition.trimTo(pplen), txn);
            int pDirNameLen = pathToPartition.length();
            if (srcDataTop > 0L) {
                long srcDataActualBytes = (srcDataMax - srcDataTop) * 8L;
                long srcDataMaxBytes = srcDataMax * 8L;
                if (srcDataTop > prefixHi || prefixType == 1) {
                    srcDataFixSize = srcDataActualBytes + srcDataMaxBytes;
                    srcDataFixAddr = O3Utils.mapRW(ff, srcFixFd, srcDataFixSize);
                    if (srcDataActualBytes > 0L) {
                        srcDataVarSize = O3OpenColumnJob.getVarColumnSize(ff, columnType, srcVarFd, Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataActualBytes - 8L), tmpBuf);
                    }
                    if (columnType == 10) {
                        srcDataVarOffset = srcDataVarSize;
                        srcDataVarSize += srcDataTop * 4L + srcDataVarSize;
                        srcDataVarAddr = O3Utils.mapRW(ff, srcVarFd, srcDataVarSize);
                        Vect.setMemoryInt(srcDataVarAddr + srcDataVarOffset, -1, srcDataTop);
                        Vect.setVarColumnRefs32Bit(srcDataFixAddr + srcDataActualBytes, 0L, srcDataTop);
                        O3Utils.shiftCopyFixedSizeColumnData(-srcDataTop * 4L, srcDataFixAddr, 0L, srcDataMax - srcDataTop, srcDataFixAddr + srcDataMaxBytes);
                        Vect.memcpy(srcDataVarAddr, srcDataVarAddr + srcDataVarOffset + srcDataTop * 4L, srcDataVarOffset);
                    } else {
                        srcDataVarOffset = srcDataVarSize;
                        srcDataVarSize += srcDataTop * 8L + srcDataVarSize;
                        srcDataVarAddr = O3Utils.mapRW(ff, srcVarFd, srcDataVarSize);
                        Vect.setMemoryLong(srcDataVarAddr + srcDataVarOffset, -1L, srcDataTop);
                        Vect.setVarColumnRefs64Bit(srcDataFixAddr + srcDataActualBytes, 0L, srcDataTop);
                        O3Utils.shiftCopyFixedSizeColumnData(-srcDataTop * 8L, srcDataFixAddr, 0L, srcDataMax - srcDataTop, srcDataFixAddr + srcDataMaxBytes);
                        Vect.memcpy(srcDataVarAddr, srcDataVarAddr + srcDataVarOffset + srcDataTop * 8L, srcDataVarOffset);
                    }
                    srcDataTop = 0L;
                    srcDataFixOffset = srcDataActualBytes;
                } else {
                    TableUtils.writeColumnTop(ff, pathToPartition.trimTo(pDirNameLen), columnName, srcDataTop, tmpBuf);
                    srcDataFixSize = srcDataActualBytes;
                    srcDataFixAddr = O3Utils.mapRW(ff, srcFixFd, srcDataFixSize);
                    srcDataFixOffset = 0L;
                    srcDataVarSize = O3OpenColumnJob.getVarColumnSize(ff, columnType, srcVarFd, Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataFixSize - srcDataFixOffset - 8L), tmpBuf);
                    srcDataVarAddr = O3Utils.mapRO(ff, srcVarFd, srcDataVarSize);
                }
            } else {
                srcDataFixSize = srcDataMax * 8L;
                srcDataFixAddr = O3Utils.mapRW(ff, srcFixFd, srcDataFixSize);
                srcDataFixOffset = 0L;
                srcDataVarSize = O3OpenColumnJob.getVarColumnSize(ff, columnType, srcVarFd, Unsafe.getUnsafe().getLong(srcDataFixAddr + srcDataFixSize - 8L), tmpBuf);
                srcDataVarAddr = O3Utils.mapRO(ff, srcVarFd, srcDataVarSize);
            }
            srcDataTopOffset = srcDataTop * 8L;
            pathToPartition.trimTo(pDirNameLen).concat(columnName);
            int pColNameLen = pathToPartition.length();
            pathToPartition.put(".i").$();
            dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
            dstFixSize = (srcOooHi - srcOooLo + 1L + srcDataMax - srcDataTop) * 8L;
            dstFixAddr = O3Utils.mapRW(ff, dstFixFd, dstFixSize);
            pathToPartition.trimTo(pColNameLen);
            pathToPartition.put(".d").$();
            dstVarFd = TableUtils.openRW(ff, pathToPartition, LOG);
            dstVarSize = srcDataVarSize - srcDataVarOffset + O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr, srcOooFixSize, srcOooVarSize);
            dstVarAddr = O3Utils.mapRW(ff, dstVarFd, dstVarSize);
            if (prefixType == 2) {
                dstFixAppendOffset1 = (prefixHi - prefixLo + 1L - srcDataTop) * 8L;
                prefixHi -= srcDataTop;
            } else {
                dstFixAppendOffset1 = (prefixHi - prefixLo + 1L) * 8L;
            }
            if (suffixType == 2 && srcDataTop > 0L) {
                suffixHi -= srcDataTop;
                suffixLo -= srcDataTop;
            }
            switch (prefixType) {
                case 1: {
                    dstVarAppendOffset1 = O3Utils.getVarColumnLength(prefixLo, prefixHi, srcOooFixAddr, srcOooFixSize, srcOooVarSize);
                    ++partCount;
                    break;
                }
                case 2: {
                    dstVarAppendOffset1 = O3Utils.getVarColumnLength(prefixLo, prefixHi, srcDataFixAddr + srcDataFixOffset, srcDataFixSize, srcDataVarSize - srcDataVarOffset);
                    ++partCount;
                    break;
                }
            }
            if (mergeDataLo > -1L && mergeOOOLo > -1L) {
                long oooLen = O3Utils.getVarColumnLength(mergeOOOLo, mergeOOOHi, srcOooFixAddr, srcOooFixSize, srcOooVarSize);
                long dataLen = O3Utils.getVarColumnLength(mergeDataLo, mergeDataHi, srcDataFixAddr + srcDataFixOffset - srcDataTop * 8L, srcDataFixSize, srcDataVarSize - srcDataVarOffset);
                dstFixAppendOffset2 = dstFixAppendOffset1 + mergeLen * 8L;
                dstVarAppendOffset2 = dstVarAppendOffset1 + oooLen + dataLen;
            } else {
                dstFixAppendOffset2 = dstFixAppendOffset1;
                dstVarAppendOffset2 = dstVarAppendOffset1;
            }
            if (mergeType != -1) {
                ++partCount;
            }
            if (suffixType != -1) {
                ++partCount;
            }
        }
        catch (Throwable e) {
            LOG.error().$("merge var error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, 0L, 0L, tableWriter);
            throw e;
        }
        partCounter.set(partCount);
        O3OpenColumnJob.publishMultiCopyTasks(columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooPartitionMin, oooPartitionMax, oooPartitionHi, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstFixAppendOffset1, dstFixAppendOffset2, dstVarAppendOffset1, dstVarAppendOffset2, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, null);
    }

    private static void setNull(int columnType, long addr, long count) {
        switch (columnType) {
            case 0: 
            case 1: {
                Vect.memset(addr, count, 0);
                break;
            }
            case 2: 
            case 3: {
                Vect.setMemoryShort(addr, (short)0, count);
                break;
            }
            case 4: {
                Vect.setMemoryInt(addr, Integer.MIN_VALUE, count);
                break;
            }
            case 8: {
                Vect.setMemoryFloat(addr, Float.NaN, count);
                break;
            }
            case 11: {
                Vect.setMemoryInt(addr, -1, count);
                break;
            }
            case -7: 
            case 5: 
            case 6: 
            case 7: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count);
                break;
            }
            case 9: {
                Vect.setMemoryDouble(addr, Double.NaN, count);
                break;
            }
            case 12: {
                Vect.setMemoryLong(addr, Long.MIN_VALUE, count * 4L);
                break;
            }
        }
    }

    private static void appendNewPartition(Path pathToPartition, int plen, CharSequence columnName, AtomicInteger columnCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, long srcDataMax, boolean isIndexed, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        long dstFixFd = 0L;
        long dstFixAddr = 0L;
        long dstFixSize = 0L;
        long dstVarFd = 0L;
        long dstVarAddr = 0L;
        long dstVarSize = 0L;
        long dstKFd = 0L;
        long dstVFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        try {
            switch (columnType) {
                case 10: 
                case 13: {
                    O3OpenColumnJob.setPath(pathToPartition.trimTo(plen), columnName, ".i");
                    dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
                    dstFixSize = (srcOooHi - srcOooLo + 1L) * 8L;
                    dstFixAddr = O3Utils.mapRW(ff, dstFixFd, dstFixSize);
                    O3OpenColumnJob.setPath(pathToPartition.trimTo(plen), columnName, ".d");
                    dstVarFd = TableUtils.openRW(ff, pathToPartition, LOG);
                    dstVarSize = O3Utils.getVarColumnLength(srcOooLo, srcOooHi, srcOooFixAddr, srcOooFixSize, srcOooVarSize);
                    dstVarAddr = O3Utils.mapRW(ff, dstVarFd, dstVarSize);
                    break;
                }
                default: {
                    O3OpenColumnJob.setPath(pathToPartition.trimTo(plen), columnName, ".d");
                    dstFixFd = TableUtils.openRW(ff, pathToPartition, LOG);
                    dstFixSize = srcOooHi - srcOooLo + 1L << ColumnType.pow2SizeOf(Math.abs(columnType));
                    dstFixAddr = O3Utils.mapRW(ff, dstFixFd, dstFixSize);
                    if (isIndexed) {
                        BitmapIndexUtils.keyFileName(pathToPartition.trimTo(plen), columnName);
                        dstKFd = TableUtils.openRW(ff, pathToPartition, LOG);
                        BitmapIndexUtils.valueFileName(pathToPartition.trimTo(plen), columnName);
                        dstVFd = TableUtils.openRW(ff, pathToPartition, LOG);
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("append new partition error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, tableWriter);
            throw e;
        }
        O3OpenColumnJob.publishCopyTask(columnCounter, null, columnType, 1, timestampMergeIndexAddr, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, 0L, 0L, 0L, false, tableWriter, indexWriter);
    }

    private static void setPath(Path path, CharSequence columnName, CharSequence suffix) {
        path.concat(columnName).put(suffix).$();
    }

    private static void publishMultiCopyTasks(AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, long srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataTopOffset, long srcDataMax, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long timestampMin, long timestampMax, long partitionTimestamp, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long dstFixFd, long dstFixAddr, long dstFixSize, long dstVarFd, long dstVarAddr, long dstVarSize, long dstFixAppendOffset1, long dstFixAppendOffset2, long dstVarAppendOffset1, long dstVarAppendOffset2, long dstKFd, long dstVFd, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        boolean partitionMutates = true;
        switch (prefixType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, prefixType, 0L, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, prefixLo, prefixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, prefixType, 0L, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, prefixLo, prefixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, 0L, dstFixSize, dstVarFd, dstVarAddr, 0L, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
        }
        switch (mergeType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, 0L, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, 0L, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 3: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, mergeType, timestampMergeIndexAddr, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, mergeDataLo, mergeDataHi, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, mergeOOOLo, mergeOOOHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset1, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset1, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
        }
        switch (suffixType) {
            case 1: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, suffixType, 0L, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, 0L, 0L, srcDataTopOffset, srcDataMax, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, suffixLo, suffixHi, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
            case 2: {
                O3OpenColumnJob.publishCopyTask(columnCounter, partCounter, columnType, suffixType, 0L, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, suffixLo, suffixHi, srcDataTopOffset, srcDataMax, 0L, 0L, 0L, 0L, 0L, 0L, srcOooMax, srcOooLo, srcOooHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixAppendOffset2, dstFixSize, dstVarFd, dstVarAddr, dstVarAppendOffset2, 0L, dstVarSize, dstKFd, dstVFd, 0L, 0L, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, true, tableWriter, indexWriter);
                break;
            }
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        this.openColumn(workerId + 1, (O3OpenColumnTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }

    private void openColumn(int workerId, O3OpenColumnTask task, long cursor, Sequence subSeq) {
        O3OpenColumnJob.openColumn(task, cursor, subSeq, O3Utils.get8ByteBuf(workerId));
    }
}

