/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.O3Basket;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cairo.vm.ContiguousVirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import java.util.concurrent.atomic.AtomicInteger;

public class O3PartitionJob
extends AbstractQueueConsumerJob<O3PartitionTask> {
    private static final Log LOG = LogFactory.getLog(O3PartitionJob.class);

    public O3PartitionJob(MessageBus messageBus) {
        super(messageBus.getO3PartitionQueue(), messageBus.getO3PartitionSubSeq());
    }

    public static void processPartition(CharSequence pathToTable, int partitionBy, ObjList<AppendOnlyVirtualMemory> columns, ObjList<ContiguousVirtualMemory> oooColumns, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long partitionTimestamp, long maxTimestamp, long srcDataMax, long srcDataTxn, boolean last, long txn, long sortedTimestampsAddr, TableWriter tableWriter, AtomicInteger columnCounter, O3Basket o3Basket, long tmpBuf) {
        long oooTimestampLo = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooLo);
        TableWriterMetadata metadata = tableWriter.getMetadata();
        int timestampIndex = metadata.getTimestampIndex();
        Path path = Path.getThreadLocal(pathToTable);
        TableUtils.setPathForPartition(path, partitionBy, oooTimestampLo, false);
        int pplen = path.length();
        TableUtils.txnPartitionConditionally(path, srcDataTxn);
        int plen = path.length();
        long srcTimestampFd = 0L;
        FilesFacade ff = tableWriter.getFilesFacade();
        if (srcDataMax < 1L) {
            if (!last) {
                try {
                    LOG.debug().$("would create [path=").$(path.chop$().slash$()).$(']').$();
                    TableUtils.createDirsOrFail(ff, path, tableWriter.getConfiguration().getMkDirMode());
                }
                catch (Throwable e) {
                    LOG.error().$("process new partition error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    tableWriter.o3BumpErrorCount();
                    tableWriter.o3ClockDownPartitionUpdateCount();
                    tableWriter.o3CountDownDoneLatch();
                    throw e;
                }
            }
            O3PartitionJob.publishOpenColumnTasks(txn, columns, oooColumns, pathToTable, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, 0, 0L, 0L, 0, 0L, 0L, 0L, 0L, 0, 0L, 0L, 0L, srcDataTxn, 5, 0L, 0L, 0L, timestampIndex, sortedTimestampsAddr, tableWriter, columnCounter, o3Basket, tmpBuf);
        } else {
            int openColumnMode;
            long suffixHi;
            long suffixLo;
            int suffixType;
            long mergeOOOHi;
            long mergeOOOLo;
            long mergeDataHi;
            long mergeDataLo;
            int mergeType;
            long prefixHi;
            long prefixLo;
            int prefixType;
            long dataTimestampHi;
            long srcTimestampAddr = 0L;
            long srcTimestampSize = 0L;
            try {
                if (last) {
                    dataTimestampHi = maxTimestamp;
                    srcTimestampSize = srcDataMax * 8L;
                    srcTimestampFd = -columns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex)).getFd();
                    srcTimestampAddr = O3Utils.mapRW(ff, -srcTimestampFd, srcTimestampSize);
                } else {
                    srcTimestampSize = srcDataMax * 8L;
                    TableUtils.dFile(path.trimTo(plen), metadata.getColumnName(timestampIndex));
                    srcTimestampFd = TableUtils.openRW(ff, path, LOG);
                    srcTimestampAddr = O3Utils.mapRW(ff, srcTimestampFd, srcTimestampSize);
                    dataTimestampHi = Unsafe.getUnsafe().getLong(srcTimestampAddr + srcTimestampSize - 8L);
                }
                long dataTimestampLo = Unsafe.getUnsafe().getLong(srcTimestampAddr);
                prefixType = -1;
                prefixLo = -1L;
                prefixHi = -1L;
                mergeType = -1;
                mergeDataLo = -1L;
                mergeDataHi = -1L;
                mergeOOOLo = -1L;
                mergeOOOHi = -1L;
                suffixType = -1;
                suffixLo = -1L;
                suffixHi = -1L;
                assert (srcTimestampFd != -1L && srcTimestampFd != 1L);
                if (oooTimestampLo > dataTimestampLo) {
                    if (oooTimestampLo >= dataTimestampHi) {
                        suffixType = 1;
                        suffixLo = srcOooLo;
                        suffixHi = srcOooHi;
                    } else {
                        prefixType = 2;
                        prefixLo = 0L;
                        prefixHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, oooTimestampLo, 0L, srcDataMax - 1L, 1);
                        mergeDataLo = prefixHi + 1L;
                        mergeOOOLo = srcOooLo;
                        if (oooTimestampMax < dataTimestampHi) {
                            mergeOOOHi = srcOooHi;
                            mergeDataHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, oooTimestampMax - 1L, mergeDataLo, srcDataMax - 1L, 1);
                            mergeType = mergeDataLo > mergeDataHi ? 1 : 3;
                            suffixType = 2;
                            suffixLo = mergeDataHi + 1L;
                            suffixHi = srcDataMax - 1L;
                            assert (suffixLo <= suffixHi);
                        } else if (oooTimestampMax > dataTimestampHi) {
                            mergeOOOHi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampHi, srcOooLo, srcOooHi, -1);
                            mergeDataHi = srcDataMax - 1L;
                            mergeType = 3;
                            suffixType = 1;
                            suffixLo = mergeOOOHi + 1L;
                            suffixHi = srcOooHi;
                        } else {
                            mergeType = 3;
                            mergeOOOHi = srcOooHi;
                            mergeDataHi = srcDataMax - 1L;
                        }
                    }
                } else {
                    prefixType = 1;
                    prefixLo = srcOooLo;
                    if (dataTimestampLo < oooTimestampMax) {
                        mergeDataLo = 0L;
                        prefixHi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampLo, srcOooLo, srcOooHi, 1);
                        mergeOOOLo = prefixHi + 1L;
                        if (oooTimestampMax < dataTimestampHi) {
                            mergeType = 3;
                            mergeOOOHi = srcOooHi;
                            mergeDataHi = Vect.boundedBinarySearch64Bit(srcTimestampAddr, oooTimestampMax, 0L, srcDataMax - 1L, 1);
                            suffixLo = mergeDataHi + 1L;
                            suffixType = 2;
                            suffixHi = srcDataMax - 1L;
                        } else if (oooTimestampMax > dataTimestampHi) {
                            mergeDataHi = srcDataMax - 1L;
                            mergeOOOHi = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, dataTimestampHi - 1L, mergeOOOLo, srcOooHi, 1);
                            mergeType = mergeOOOLo > mergeOOOHi ? 2 : 3;
                            if (mergeOOOHi < srcOooHi) {
                                suffixLo = mergeOOOHi + 1L;
                                suffixType = 1;
                                suffixHi = Math.max(suffixLo, srcOooHi);
                            } else {
                                suffixType = -1;
                            }
                        } else {
                            mergeType = 3;
                            mergeOOOHi = srcOooHi;
                            mergeDataHi = srcDataMax - 1L;
                        }
                    } else {
                        prefixHi = srcOooHi;
                        suffixType = 2;
                        suffixLo = 0L;
                        suffixHi = srcDataMax - 1L;
                    }
                }
                if (prefixType == -1) {
                    openColumnMode = 1;
                } else {
                    TableUtils.txnPartition(path.trimTo(pplen), txn);
                    TableUtils.createDirsOrFail(ff, path.slash$(), tableWriter.getConfiguration().getMkDirMode());
                    openColumnMode = last ? 4 : 3;
                }
            }
            catch (Throwable e) {
                LOG.error().$("process existing partition error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
                O3Utils.close(ff, srcTimestampFd);
                tableWriter.o3BumpErrorCount();
                tableWriter.o3ClockDownPartitionUpdateCount();
                tableWriter.o3CountDownDoneLatch();
                throw e;
            }
            long timestampMax = Math.max(oooTimestampMax, dataTimestampHi);
            O3PartitionJob.publishOpenColumnTasks(txn, columns, oooColumns, pathToTable, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, timestampMax, oooTimestampLo, partitionTimestamp, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, srcDataMax, srcDataTxn, openColumnMode, srcTimestampFd, srcTimestampAddr, srcTimestampSize, timestampIndex, sortedTimestampsAddr, tableWriter, columnCounter, o3Basket, tmpBuf);
        }
    }

    public static void processPartition(long tmpBuf, O3PartitionTask task, long cursor, Sequence subSeq) {
        CharSequence pathToTable = task.getPathToTable();
        int partitionBy = task.getPartitionBy();
        ObjList<AppendOnlyVirtualMemory> columns = task.getColumns();
        ObjList<ContiguousVirtualMemory> oooColumns = task.getO3Columns();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long oooTimestampMin = task.getOooTimestampMin();
        long oooTimestampMax = task.getOooTimestampMax();
        long partitionTimestamp = task.getPartitionTimestamp();
        long maxTimestamp = task.getMaxTimestamp();
        long srcDataMax = task.getSrcDataMax();
        long srcDataTxn = task.getSrcNameTxn();
        boolean last = task.isLast();
        long txn = task.getTxn();
        long sortedTimestampsAddr = task.getSortedTimestampsAddr();
        TableWriter tableWriter = task.getTableWriter();
        AtomicInteger columnCounter = task.getColumnCounter();
        O3Basket o3Basket = task.getO3Basket();
        subSeq.done(cursor);
        O3PartitionJob.processPartition(pathToTable, partitionBy, columns, oooColumns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataMax, srcDataTxn, last, txn, sortedTimestampsAddr, tableWriter, columnCounter, o3Basket, tmpBuf);
    }

    private static long createMergeIndex(long srcDataTimestampAddr, long sortedTimestampsAddr, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi) {
        long indexSize = (mergeDataHi - mergeDataLo + 1L) * 16L;
        assert (indexSize > 0L);
        long index = Unsafe.malloc(indexSize);
        Vect.makeTimestampIndex(srcDataTimestampAddr, mergeDataLo, mergeDataHi, index);
        long result = Vect.mergeTwoLongIndexesAsc(index, mergeDataHi - mergeDataLo + 1L, sortedTimestampsAddr + mergeOOOLo * 16L, mergeOOOHi - mergeOOOLo + 1L);
        Unsafe.free(index, indexSize);
        return result;
    }

    private static void publishOpenColumnTaskHarmonized(long cursor, int openColumnMode, CharSequence pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long oooTimestampLo, long partitionTimestamp, long srcDataTop, long srcDataMax, long srcDataTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, boolean isIndexed, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, long activeFixFd, long activeVarFd, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        O3OpenColumnTask openColumnTask = tableWriter.getO3OpenColumnQueue().get(cursor);
        openColumnTask.of(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, isIndexed, activeFixFd, activeVarFd, tableWriter, indexWriter);
        tableWriter.getO3OpenColumnPubSeq().done(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishOpenColumnTasks(long txn, ObjList<AppendOnlyVirtualMemory> columns, ObjList<ContiguousVirtualMemory> oooColumns, CharSequence pathToTable, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long oooTimestampLo, long partitionTimestamp, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long srcDataMax, long srcDataTxn, int openColumnMode, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int timestampIndex, long sortedTimestampsAddr, TableWriter tableWriter, AtomicInteger columnCounter, O3Basket o3Basket, long tmpBuf) {
        LOG.debug().$("partition [ts=").$ts(oooTimestampLo).$(']').$();
        long timestampMergeIndexAddr = mergeType == 3 ? O3PartitionJob.createMergeIndex(srcTimestampAddr, sortedTimestampsAddr, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi) : 0L;
        TableWriterMetadata metadata = tableWriter.getMetadata();
        int columnCount = metadata.getColumnCount();
        columnCounter.set(columnCount);
        int columnsInFlight = columnCount;
        try {
            for (int i = 0; i < columnCount; ++i) {
                long srcOooVarSize;
                long srcOooVarAddr;
                long srcOooFixSize;
                long srcOooFixAddr;
                long activeVarFd;
                long activeFixFd;
                int colOffset = TableWriter.getPrimaryColumnIndex(i);
                boolean notTheTimestamp = i != timestampIndex;
                int columnType = metadata.getColumnType(i);
                ContiguousVirtualMemory oooMem1 = oooColumns.getQuick(colOffset);
                ContiguousVirtualMemory oooMem2 = oooColumns.getQuick(colOffset + 1);
                AppendOnlyVirtualMemory mem1 = columns.getQuick(colOffset);
                AppendOnlyVirtualMemory mem2 = columns.getQuick(colOffset + 1);
                if (columnType != 10 && columnType != 13) {
                    activeFixFd = mem1.getFd();
                    activeVarFd = 0L;
                    srcOooFixAddr = oooMem1.addressOf(0L);
                    srcOooFixSize = oooMem1.getAppendOffset();
                    srcOooVarAddr = 0L;
                    srcOooVarSize = 0L;
                } else {
                    activeFixFd = mem2.getFd();
                    activeVarFd = mem1.getFd();
                    srcOooFixAddr = oooMem2.addressOf(0L);
                    srcOooFixSize = oooMem2.getAppendOffset();
                    srcOooVarAddr = oooMem1.addressOf(0L);
                    srcOooVarSize = oooMem1.getAppendOffset();
                }
                String columnName = metadata.getColumnName(i);
                boolean isIndexed = metadata.isColumnIndexed(i);
                long srcDataTop = openColumnMode == 2 || openColumnMode == 4 ? tableWriter.getColumnTop(i) : -1L;
                BitmapIndexWriter indexWriter = isIndexed ? o3Basket.nextIndexer() : null;
                try {
                    long cursor = tableWriter.getO3OpenColumnPubSeq().next();
                    if (cursor > -1L) {
                        O3PartitionJob.publishOpenColumnTaskHarmonized(cursor, openColumnMode, pathToTable, columnName, columnCounter, o3Basket.nextPartCounter(), notTheTimestamp ? columnType : -columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, activeFixFd, activeVarFd, tableWriter, indexWriter);
                        continue;
                    }
                    O3PartitionJob.publishOpenColumnTaskContended(tmpBuf, cursor, openColumnMode, pathToTable, columnName, columnCounter, o3Basket.nextPartCounter(), notTheTimestamp ? columnType : -columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, isIndexed, activeFixFd, activeVarFd, tableWriter, indexWriter);
                    continue;
                }
                catch (Throwable e) {
                    tableWriter.o3BumpErrorCount();
                    LOG.error().$("open column error [table=").$(tableWriter.getTableName()).$(", e=").$(e).I$();
                    columnsInFlight = i + 1;
                    throw e;
                }
            }
        }
        finally {
            int delta = columnsInFlight - columnCount;
            LOG.debug().$("idle [delta=").$(delta).$(']').$();
            if (delta < 0 && columnCounter.addAndGet(delta) == 0) {
                O3CopyJob.closeColumnIdleQuick(timestampMergeIndexAddr, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
            }
        }
    }

    private static void publishOpenColumnTaskContended(long tmpBuf, long cursor, int openColumnMode, CharSequence pathToTable, CharSequence columnName, AtomicInteger columnCounter, AtomicInteger partCounter, int columnType, long timestampMergeIndexAddr, long srcOooFixAddr, long srcOooFixSize, long srcOooVarAddr, long srcOooVarSize, long srcOooLo, long srcOooHi, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long oooTimestampLo, long partitionTimestamp, long srcDataTop, long srcDataMax, long srcDataTxn, long txn, int prefixType, long prefixLo, long prefixHi, int mergeType, long mergeDataLo, long mergeDataHi, long mergeOOOLo, long mergeOOOHi, int suffixType, long suffixLo, long suffixHi, long srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean isIndexed, long activeFixFd, long activeVarFd, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        while (cursor == -2L) {
            cursor = tableWriter.getO3OpenColumnPubSeq().next();
        }
        if (cursor > -1L) {
            O3PartitionJob.publishOpenColumnTaskHarmonized(cursor, openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeDataLo, mergeDataHi, mergeOOOLo, mergeOOOHi, suffixType, suffixLo, suffixHi, isIndexed, srcTimestampFd, srcTimestampAddr, srcTimestampSize, activeFixFd, activeVarFd, tableWriter, indexWriter);
        } else {
            O3OpenColumnJob.openColumn(openColumnMode, pathToTable, columnName, columnCounter, partCounter, columnType, timestampMergeIndexAddr, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, oooTimestampLo, partitionTimestamp, srcDataTop, srcDataMax, srcDataTxn, txn, prefixType, prefixLo, prefixHi, mergeType, mergeOOOLo, mergeOOOHi, mergeDataLo, mergeDataHi, suffixType, suffixLo, suffixHi, srcTimestampFd, srcTimestampAddr, srcTimestampSize, isIndexed, activeFixFd, activeVarFd, tableWriter, indexWriter, tmpBuf);
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        this.processPartition(workerId + 1, (O3PartitionTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }

    private void processPartition(int workerId, O3PartitionTask task, long cursor, Sequence subSeq) {
        O3PartitionJob.processPartition(O3Utils.get8ByteBuf(workerId), task, cursor, subSeq);
    }
}

