/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.Path;
import io.questdb.tasks.O3PurgeTask;

public class O3PurgeJob
extends AbstractQueueConsumerJob<O3PurgeTask> {
    private static final Log LOG = LogFactory.getLog(O3PurgeJob.class);
    private final CairoConfiguration configuration;

    public O3PurgeJob(MessageBus messageBus) {
        super(messageBus.getO3PurgeQueue(), messageBus.getO3PurgeSubSeq());
        this.configuration = messageBus.getConfiguration();
    }

    public static int purgePartitionDir(FilesFacade ff, Path path, int partitionBy, long partitionTimestamp, TxnScoreboard txnScoreboard, long nameTxnToRemove, long minTxnToExpect) {
        long readerTxn = txnScoreboard.getMin();
        long readerTxnCount = txnScoreboard.getActiveReaderCount(readerTxn);
        int errno = -1;
        if (txnScoreboard.isTxnAvailable(minTxnToExpect)) {
            TableUtils.setPathForPartition(path, partitionBy, partitionTimestamp, false);
            TableUtils.txnPartitionConditionally(path, nameTxnToRemove);
            path.slash$();
            errno = ff.rmdir(path);
            if (errno == 0) {
                LOG.info().$("purged [path=").$(path).$(", readerTxn=").$(readerTxn).$(", readerTxnCount=").$(readerTxnCount).$(']').$();
                return 0;
            }
        }
        return errno;
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        O3PurgeTask task = (O3PurgeTask)this.queue.get(cursor);
        int errno = O3PurgeJob.purgePartitionDir(this.configuration.getFilesFacade(), Path.getThreadLocal(this.configuration.getRoot()).concat(task.getTableName()), task.getPartitionBy(), task.getTimestamp(), task.getTxnScoreboard(), task.getNameTxnToRemove(), task.getMinTxnToExpect());
        this.subSeq.done(cursor);
        if (errno == 0) {
            return true;
        }
        LOG.info().$("could not purge, re-queue? [table=").$(task.getTableName()).$(", ts=").$ts(task.getTimestamp()).$(", txn=").$(task.getNameTxnToRemove()).$(", errno=").$(errno).$(']').$();
        return false;
    }
}

