/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class O3Utils {
    private static final Log LOG = LogFactory.getLog(O3Utils.class);
    private static long[] temp8ByteBuf;

    public static void freeBuf() {
        if (temp8ByteBuf != null) {
            int n = temp8ByteBuf.length;
            for (int i = 0; i < n; ++i) {
                Unsafe.free(temp8ByteBuf[i], 8L);
            }
            temp8ByteBuf = null;
        }
    }

    public static void initBuf() {
        O3Utils.initBuf(1);
    }

    public static void initBuf(int workerCount) {
        temp8ByteBuf = new long[workerCount];
        for (int i = 0; i < workerCount; ++i) {
            O3Utils.temp8ByteBuf[i] = Unsafe.malloc(8L);
        }
    }

    static long get8ByteBuf(int worker) {
        return temp8ByteBuf[worker];
    }

    static long getVarColumnLength(long srcLo, long srcHi, long srcFixAddr, long srcFixSize, long srcVarSize) {
        long lo = O3Utils.findVarOffset(srcFixAddr, srcLo, srcHi, srcVarSize);
        long hi = srcHi + 1L == srcFixSize / 8L ? srcVarSize : O3Utils.findVarOffset(srcFixAddr, srcHi + 1L, srcFixSize / 8L, srcVarSize);
        return hi - lo;
    }

    static long findVarOffset(long srcFixAddr, long srcLo, long srcHi, long srcVarSize) {
        long lo = Unsafe.getUnsafe().getLong(srcFixAddr + srcLo * 8L);
        if (lo > -1L) {
            return lo;
        }
        while (++srcLo < srcHi) {
            lo = Unsafe.getUnsafe().getLong(srcFixAddr + srcLo * 8L);
            if (lo <= -1L) continue;
            return lo;
        }
        return srcVarSize;
    }

    static void shiftCopyFixedSizeColumnData(long shift, long src, long srcLo, long srcHi, long dstAddr) {
        Vect.shiftCopyFixedSizeColumnData(shift, src, srcLo, srcHi, dstAddr);
    }

    static void copyFromTimestampIndex(long src, long srcLo, long srcHi, long dstAddr) {
        Vect.copyFromTimestampIndex(src, srcLo, srcHi, dstAddr);
    }

    static void unmapAndClose(FilesFacade ff, long dstFixFd, long dstFixAddr, long dstFixSize) {
        O3Utils.unmap(ff, dstFixAddr, dstFixSize);
        O3Utils.close(ff, dstFixFd);
    }

    static void unmap(FilesFacade ff, long addr, long size) {
        if (addr != 0L && size > 0L) {
            ff.munmap(addr, size);
        }
    }

    static void close(FilesFacade ff, long fd) {
        if (fd > 0L) {
            LOG.debug().$("closed [fd=").$(fd).$(']').$();
            ff.close(fd);
        }
    }

    static long mapRO(FilesFacade ff, long fd, long size) {
        long address = ff.mmap(fd, size, 0L, 1);
        if (address == -1L) {
            throw CairoException.instance(ff.errno()).put("Could not mmap timestamp column ").put(" [size=").put(size).put(", fd=").put(fd).put(", memUsed=").put(Unsafe.getMemUsed()).put(", fileLen=").put(ff.length(fd)).put(']');
        }
        return address;
    }

    static long mapRW(FilesFacade ff, long fd, long size) {
        O3Utils.allocateDiskSpace(ff, fd, size);
        long addr = ff.mmap(fd, size, 0L, 2);
        if (addr > -1L) {
            return addr;
        }
        throw CairoException.instance(ff.errno()).put("could not mmap column [fd=").put(fd).put(", size=").put(size).put(']');
    }

    static void allocateDiskSpace(FilesFacade ff, long fd, long size) {
        if (!ff.allocate(fd, size)) {
            throw CairoException.instance(ff.errno()).put("No space left [size=").put(size).put(", fd=").put(fd).put(']');
        }
    }
}

