/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cairo.vm.PagedSlidingReadOnlyMemory;
import io.questdb.cairo.vm.ReadOnlyVirtualMemory;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.io.Closeable;

class SymbolColumnIndexer
implements ColumnIndexer,
Closeable {
    private static final long SEQUENCE_OFFSET = Unsafe.getFieldOffset(SymbolColumnIndexer.class, "sequence");
    private final BitmapIndexWriter writer = new BitmapIndexWriter();
    private final PagedSlidingReadOnlyMemory mem = new PagedSlidingReadOnlyMemory();
    private long columnTop;
    private volatile long sequence = 0L;
    private volatile boolean distressed = false;

    SymbolColumnIndexer() {
    }

    @Override
    public void close() {
        Misc.free(this.writer);
        Misc.free(this.mem);
    }

    @Override
    public void distress() {
        this.distressed = true;
    }

    @Override
    public BitmapIndexWriter getWriter() {
        return this.writer;
    }

    @Override
    public long getFd() {
        return this.mem.getFd();
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public void refreshSourceAndIndex(long loRow, long hiRow) {
        this.mem.updateSize();
        this.index(this.mem, loRow, hiRow);
    }

    @Override
    public void index(ReadOnlyVirtualMemory mem, long loRow, long hiRow) {
        this.writer.rollbackConditionally(loRow);
        long lim = hiRow + this.columnTop;
        for (long lo = loRow; lo < lim; ++lo) {
            this.writer.add(TableUtils.toIndexKey(mem.getInt((lo - this.columnTop) * 4L)), lo);
        }
        this.writer.setMaxValue(lim - 1L);
    }

    @Override
    public boolean isDistressed() {
        return this.distressed;
    }

    @Override
    public void configureFollowerAndWriter(CairoConfiguration configuration, Path path, CharSequence name, AppendOnlyVirtualMemory columnMem, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(configuration, path, name);
            this.mem.of(columnMem);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void configureWriter(CairoConfiguration configuration, Path path, CharSequence name, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(configuration, path, name);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void rollback(long maxRow) {
        this.writer.rollbackValues(maxRow);
    }

    @Override
    public boolean tryLock(long expectedSequence) {
        return Unsafe.cas((Object)this, SEQUENCE_OFFSET, expectedSequence, expectedSequence + 1L);
    }
}

