/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexBwdReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class SymbolMapReaderImpl
implements Closeable,
SymbolMapReader {
    private static final Log LOG = LogFactory.getLog(SymbolMapReaderImpl.class);
    private final BitmapIndexBwdReader indexReader = new BitmapIndexBwdReader();
    private final SinglePageMappedReadOnlyPageMemory charMem = new SinglePageMappedReadOnlyPageMemory();
    private final SinglePageMappedReadOnlyPageMemory offsetMem = new SinglePageMappedReadOnlyPageMemory();
    private final ObjList<String> cache = new ObjList();
    private int maxHash;
    private boolean cached;
    private int symbolCount;
    private long maxOffset;
    private int symbolCapacity;
    private boolean nullValue;

    public SymbolMapReaderImpl() {
    }

    public SymbolMapReaderImpl(CairoConfiguration configuration, Path path, CharSequence name, int symbolCount) {
        this.of(configuration, path, name, symbolCount);
    }

    @Override
    public void close() {
        Misc.free(this.indexReader);
        Misc.free(this.charMem);
        this.cache.clear();
        long fd = this.offsetMem.getFd();
        Misc.free(this.offsetMem);
        LOG.debug().$("closed [fd=").$(fd).$(']').$();
    }

    @Override
    public int getSymbolCapacity() {
        return this.symbolCapacity;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public boolean isDeleted() {
        return this.offsetMem.isDeleted();
    }

    @Override
    public void updateSymbolCount(int symbolCount) {
        if (symbolCount > this.symbolCount) {
            this.symbolCount = symbolCount;
            this.maxOffset = SymbolMapWriter.keyToOffset(symbolCount);
            this.offsetMem.grow(this.maxOffset);
            this.growCharMemToSymbolCount(symbolCount);
        } else if (symbolCount < this.symbolCount) {
            this.cache.remove(symbolCount + 1, this.symbolCount);
            this.symbolCount = symbolCount;
        }
    }

    public void of(CairoConfiguration configuration, Path path, CharSequence name, int symbolCount) {
        FilesFacade ff = configuration.getFilesFacade();
        this.symbolCount = symbolCount;
        this.maxOffset = SymbolMapWriter.keyToOffset(symbolCount - 1);
        int plen = path.length();
        try {
            long mapPageSize = configuration.getFilesFacade().getMapPageSize();
            SymbolMapWriter.offsetFileName(path.trimTo(plen), name);
            if (!ff.exists(path)) {
                LOG.error().$(path).$(" is not found").$();
                throw CairoException.instance(0).put("SymbolMap does not exist: ").put(path);
            }
            long len = ff.length(path);
            if (len < 64L) {
                LOG.error().$(path).$(" is too short [len=").$(len).$(']').$();
                throw CairoException.instance(0).put("SymbolMap is too short: ").put(path);
            }
            this.offsetMem.of(ff, path, mapPageSize, SymbolMapWriter.keyToOffset(symbolCount));
            this.symbolCapacity = this.offsetMem.getInt(0L);
            this.cached = this.offsetMem.getBool(4L);
            this.nullValue = this.offsetMem.getBool(8L);
            this.indexReader.of(configuration, path.trimTo(plen), name, 0L, -1L);
            this.charMem.of(ff, SymbolMapWriter.charFileName(path.trimTo(plen), name), mapPageSize, 0L);
            this.growCharMemToSymbolCount(symbolCount);
            this.maxHash = Numbers.ceilPow2(this.symbolCapacity / 2) - 1;
            if (this.cached) {
                this.cache.setPos(this.symbolCapacity);
            }
            this.cache.clear();
            LOG.debug().$("open [name=").$(path.trimTo(plen).concat(name).$()).$(", fd=").$(this.offsetMem.getFd()).$(", capacity=").$(this.symbolCapacity).$(']').$();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    @Override
    public int size() {
        return this.symbolCount;
    }

    @Override
    public int keyOf(CharSequence value) {
        if (value != null) {
            int hash = Hash.boundedHash(value, this.maxHash);
            RowCursor cursor = this.indexReader.getCursor(true, hash, 0L, this.maxOffset);
            while (cursor.hasNext()) {
                long offsetOffset = cursor.next();
                if (!Chars.equals(value, this.charMem.getStr(this.offsetMem.getLong(offsetOffset)))) continue;
                return SymbolMapWriter.offsetToKey(offsetOffset);
            }
            return -2;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean containsNullValue() {
        return this.nullValue;
    }

    @Override
    public CharSequence valueOf(int key) {
        if (key > -1 && key < this.symbolCount) {
            if (this.cached) {
                return this.cachedValue(key);
            }
            return this.uncachedValue(key);
        }
        return null;
    }

    @Override
    public CharSequence valueBOf(int key) {
        if (key > -1 && key < this.symbolCount) {
            if (this.cached) {
                return this.cachedValue(key);
            }
            return this.uncachedValue2(key);
        }
        return null;
    }

    private CharSequence cachedValue(int key) {
        String symbol = this.cache.getQuiet(key);
        return symbol != null ? symbol : this.fetchAndCache(key);
    }

    private CharSequence fetchAndCache(int key) {
        CharSequence cs = this.charMem.getStr(this.offsetMem.getLong(SymbolMapWriter.keyToOffset(key)));
        assert (cs != null);
        String symbol = Chars.toString(cs);
        this.cache.extendAndSet(key, symbol);
        return symbol;
    }

    private void growCharMemToSymbolCount(int symbolCount) {
        long charMemLength;
        if (symbolCount > 0) {
            long lastSymbolOffset = this.offsetMem.getLong(SymbolMapWriter.keyToOffset(symbolCount - 1));
            this.charMem.grow(lastSymbolOffset + 4L);
            charMemLength = lastSymbolOffset + VmUtils.getStorageLength(this.charMem.getStrLen(lastSymbolOffset));
        } else {
            charMemLength = 0L;
        }
        this.charMem.grow(charMemLength);
    }

    private CharSequence uncachedValue(int key) {
        return this.charMem.getStr(this.offsetMem.getLong(SymbolMapWriter.keyToOffset(key)));
    }

    private CharSequence uncachedValue2(int key) {
        return this.charMem.getStr2(this.offsetMem.getLong(SymbolMapWriter.keyToOffset(key)));
    }

    @Override
    public long symbolCharsAddressOf(int symbolIndex) {
        if (symbolIndex < this.symbolCount) {
            long offset = this.offsetMem.getLong(SymbolMapWriter.keyToOffset(symbolIndex));
            return this.charMem.addressOf(offset);
        }
        if (symbolIndex == this.symbolCount) {
            return this.charMem.addressOf(this.charMem.getGrownLength());
        }
        return -1L;
    }
}

