/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class TableBlockWriter
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableBlockWriter.class);
    private static final Timestamps.TimestampFloorMethod NO_PARTITIONING_FLOOR = ts -> 0L;
    private final CharSequence root;
    private final FilesFacade ff;
    private final int mkDirMode;
    private final RingQueue<TableBlockWriterTaskHolder> queue;
    private final Sequence pubSeq;
    private final LongList columnRowsAdded = new LongList();
    private final LongObjHashMap<PartitionBlockWriter> partitionBlockWriterByTimestamp = new LongObjHashMap();
    private final ObjList<PartitionBlockWriter> partitionBlockWriters = new ObjList();
    private final ObjList<TableBlockWriterTask> concurrentTasks = new ObjList();
    private final AtomicInteger nCompletedConcurrentTasks = new AtomicInteger();
    private TableWriter writer;
    private RecordMetadata metadata;
    private int columnCount;
    private int partitionBy;
    private Timestamps.TimestampFloorMethod timestampFloorMethod;
    private int timestampColumnIndex;
    private long firstTimestamp;
    private long lastTimestamp;
    private int nextPartitionBlockWriterIndex;
    private int nEnqueuedConcurrentTasks;
    private PartitionBlockWriter partWriter;

    TableBlockWriter(CairoConfiguration configuration, MessageBus messageBus) {
        this.root = configuration.getRoot();
        this.ff = configuration.getFilesFacade();
        this.mkDirMode = configuration.getMkDirMode();
        this.queue = messageBus.getTableBlockWriterQueue();
        this.pubSeq = messageBus.getTableBlockWriterPubSeq();
    }

    public void appendPageFrameColumn(int columnIndex, long pageFrameSize, long sourceAddress) {
        LOG.info().$("appending data").$(" [tableName=").$(this.writer.getTableName()).$(", columnIndex=").$(columnIndex).$(", pageFrameSize=").$(pageFrameSize).$(']').$();
        if (columnIndex == this.timestampColumnIndex) {
            long firstBlockTimestamp = Unsafe.getUnsafe().getLong(sourceAddress);
            if (firstBlockTimestamp < this.firstTimestamp) {
                this.firstTimestamp = firstBlockTimestamp;
            }
            long addr = sourceAddress + pageFrameSize - 8L;
            long lastBlockTimestamp = Unsafe.getUnsafe().getLong(addr);
            if (lastBlockTimestamp > this.lastTimestamp) {
                this.lastTimestamp = lastBlockTimestamp;
            }
        }
        this.partWriter.appendPageFrameColumn(columnIndex, pageFrameSize, sourceAddress);
    }

    public void cancel() {
        this.completePendingConcurrentTasks(true);
        this.writer.cancelRow();
        for (int n = 0; n < this.nextPartitionBlockWriterIndex; ++n) {
            this.partitionBlockWriters.getQuick(n).cancel();
        }
        this.writer.purgeUnusedPartitions();
        LOG.info().$("cancelled new block [table=").$(this.writer.getTableName()).$(']').$();
        this.clear();
    }

    @Override
    public void close() {
        this.clear();
        Misc.freeObjList(this.partitionBlockWriters);
        this.partitionBlockWriters.clear();
    }

    public void commit() {
        int n;
        LOG.info().$("committing block write").$(" [tableName=").$(this.writer.getTableName()).$(", firstTimestamp=").$ts(this.firstTimestamp).$(", lastTimestamp=").$ts(this.lastTimestamp).$(']').$();
        this.completePendingConcurrentTasks(false);
        for (n = 0; n < this.nextPartitionBlockWriterIndex; ++n) {
            this.partitionBlockWriters.getQuick(n).startCommitAppendedBlock();
        }
        this.completePendingConcurrentTasks(false);
        for (n = 0; n < this.nextPartitionBlockWriterIndex; ++n) {
            this.partitionBlockWriters.getQuick(n).completeCommitAppendedBlock();
        }
        this.writer.commitBlock(this.firstTimestamp);
        LOG.info().$("committed new block [table=").$(this.writer.getTableName()).$(']').$();
        this.clear();
    }

    public void startPageFrame(long timestampLo) {
        this.partWriter = this.getPartitionBlockWriter(timestampLo);
        this.partWriter.startPageFrame(timestampLo);
    }

    private static long mapFile(FilesFacade ff, long fd, long mapOffset, long mapSz) {
        long minFileSz;
        long alignedMapOffset = mapOffset / ff.getPageSize() * ff.getPageSize();
        long addressOffsetDueToAlignment = mapOffset - alignedMapOffset;
        long alignedMapSz = mapSz + addressOffsetDueToAlignment;
        long fileSz = ff.length(fd);
        if (fileSz < (minFileSz = mapOffset + alignedMapSz) && !ff.allocate(fd, minFileSz)) {
            throw CairoException.instance(ff.errno()).put("Could not allocate file for append fd=").put(fd).put(", offset=").put(mapOffset).put(", size=").put(mapSz);
        }
        long address = ff.mmap(fd, alignedMapSz, alignedMapOffset, 2);
        if (address == -1L) {
            int errno = ff.errno();
            throw CairoException.instance(ff.errno()).put("Could not mmap append fd=").put(fd).put(", offset=").put(mapOffset).put(", size=").put(mapSz).put(", errno=").put(errno);
        }
        assert (address / ff.getPageSize() * ff.getPageSize() == address);
        return address + addressOffsetDueToAlignment;
    }

    private static void unmapFile(FilesFacade ff, long address, long mapSz) {
        long alignedAddress = address / ff.getPageSize() * ff.getPageSize();
        long alignedMapSz = mapSz + address - alignedAddress;
        ff.munmap(alignedAddress, alignedMapSz);
    }

    void clear() {
        if (this.nCompletedConcurrentTasks.get() < this.nEnqueuedConcurrentTasks) {
            LOG.error().$("new block should have been either committed or cancelled [table=").$(this.writer.getTableName()).$(']').$();
            this.completePendingConcurrentTasks(true);
        }
        this.metadata = null;
        this.writer = null;
        this.partWriter = null;
        for (int i = 0; i < this.nextPartitionBlockWriterIndex; ++i) {
            this.partitionBlockWriters.getQuick(i).clear();
        }
        this.nextPartitionBlockWriterIndex = 0;
        this.partitionBlockWriterByTimestamp.clear();
    }

    private void completePendingConcurrentTasks(boolean cancel) {
        if (this.nCompletedConcurrentTasks.get() < this.nEnqueuedConcurrentTasks) {
            for (int n = 0; n < this.nEnqueuedConcurrentTasks; ++n) {
                TableBlockWriterTask task = this.concurrentTasks.getQuick(n);
                if (cancel) {
                    task.cancel();
                    continue;
                }
                task.run();
            }
        }
        while (this.nCompletedConcurrentTasks.get() < this.nEnqueuedConcurrentTasks) {
            LockSupport.parkNanos(0L);
        }
        this.nEnqueuedConcurrentTasks = 0;
        this.nCompletedConcurrentTasks.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueConcurrentTask(TableBlockWriterTask task) {
        long seq;
        assert (this.concurrentTasks.getQuick(this.nEnqueuedConcurrentTasks) == task);
        assert (!task.ready.get());
        task.ready.set(true);
        ++this.nEnqueuedConcurrentTasks;
        do {
            if ((seq = this.pubSeq.next()) < 0L) continue;
            try {
                this.queue.get(seq).task = task;
            }
            finally {
                this.pubSeq.done(seq);
            }
            return;
        } while (seq != -1L);
        task.run();
    }

    private TableBlockWriterTask getConcurrentTask() {
        if (this.concurrentTasks.size() <= this.nEnqueuedConcurrentTasks) {
            this.concurrentTasks.extendAndSet(this.nEnqueuedConcurrentTasks, new TableBlockWriterTask());
        }
        return this.concurrentTasks.getQuick(this.nEnqueuedConcurrentTasks);
    }

    private PartitionBlockWriter getPartitionBlockWriter(long timestamp) {
        long timestampLo = this.timestampFloorMethod.floor(timestamp);
        PartitionBlockWriter partWriter = this.partitionBlockWriterByTimestamp.get(timestampLo);
        if (null == partWriter) {
            assert (this.nextPartitionBlockWriterIndex <= this.partitionBlockWriters.size());
            if (this.nextPartitionBlockWriterIndex == this.partitionBlockWriters.size()) {
                partWriter = new PartitionBlockWriter();
                this.partitionBlockWriters.extendAndSet(this.nextPartitionBlockWriterIndex, partWriter);
            } else {
                partWriter = this.partitionBlockWriters.getQuick(this.nextPartitionBlockWriterIndex);
            }
            ++this.nextPartitionBlockWriterIndex;
            this.partitionBlockWriterByTimestamp.put(timestampLo, partWriter);
            partWriter.of(timestampLo);
        }
        return partWriter;
    }

    void open(TableWriter writer) {
        this.writer = writer;
        this.metadata = writer.getMetadata();
        this.columnCount = this.metadata.getColumnCount();
        this.partitionBy = writer.getPartitionBy();
        this.columnRowsAdded.ensureCapacity(this.columnCount);
        this.timestampColumnIndex = this.metadata.getTimestampIndex();
        this.firstTimestamp = this.timestampColumnIndex >= 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        this.lastTimestamp = this.timestampColumnIndex >= 0 ? Long.MIN_VALUE : 0L;
        this.nEnqueuedConcurrentTasks = 0;
        this.nCompletedConcurrentTasks.set(0);
        switch (this.partitionBy) {
            case 0: {
                this.timestampFloorMethod = Timestamps.FLOOR_DD;
                break;
            }
            case 1: {
                this.timestampFloorMethod = Timestamps.FLOOR_MM;
                break;
            }
            case 2: {
                this.timestampFloorMethod = Timestamps.FLOOR_YYYY;
                break;
            }
            default: {
                this.timestampFloorMethod = NO_PARTITIONING_FLOOR;
            }
        }
        LOG.info().$("started new block [table=").$(writer.getTableName()).$(']').$();
    }

    private class TableBlockWriterTask {
        private final AtomicBoolean ready = new AtomicBoolean(false);
        private TaskType taskType;
        private long sourceAddress;
        private long sourceSizeOrEnd;
        private long destAddress;
        private long sourceInitialOffset;
        private long indexFd;
        private long indexOffsetLo;
        private int columnIndex;
        private PartitionStruct partitionStruct;

        private TableBlockWriterTask() {
        }

        private void assignAppendPageFrameColumn(long destAddress, long pageFrameLength, long sourceAddress) {
            this.taskType = TaskType.AppendBlock;
            this.destAddress = destAddress;
            this.sourceSizeOrEnd = pageFrameLength;
            this.sourceAddress = sourceAddress;
        }

        private void assignUpdateBinaryIndex(long columnDataAddressLo, long columnDataAddressHi, long columnDataOffsetLo, long indexFd, long indexOffsetLo, int columnIndex, PartitionStruct partitionStruct) {
            this.taskType = TaskType.GenerateBinaryIndex;
            this.sourceAddress = columnDataAddressLo;
            this.sourceSizeOrEnd = columnDataAddressHi;
            this.sourceInitialOffset = columnDataOffsetLo;
            this.indexFd = indexFd;
            this.indexOffsetLo = indexOffsetLo;
            this.columnIndex = columnIndex;
            this.partitionStruct = partitionStruct;
        }

        private void assignUpdateStringIndex(long columnDataAddressLo, long columnDataAddressHi, long columnDataOffsetLo, long indexFd, long indexOffsetLo, int columnIndex, PartitionStruct partitionStruct) {
            this.taskType = TaskType.GenerateStringIndex;
            this.sourceAddress = columnDataAddressLo;
            this.sourceSizeOrEnd = columnDataAddressHi;
            this.sourceInitialOffset = columnDataOffsetLo;
            this.indexFd = indexFd;
            this.indexOffsetLo = indexOffsetLo;
            this.columnIndex = columnIndex;
            this.partitionStruct = partitionStruct;
        }

        private void cancel() {
            if (this.ready.compareAndSet(true, false)) {
                TableBlockWriter.this.nCompletedConcurrentTasks.incrementAndGet();
            }
        }

        private void completeUpdateBinaryIndex(long columnDataAddressLo, long columnDataAddressHi, long columnDataOffsetLo, long indexFd, long indexOffsetLo, int columnIndex, PartitionStruct partitionStruct) {
            long indexMappingSz = columnDataAddressHi - columnDataAddressLo;
            long indexMappingStart = TableBlockWriter.mapFile(TableBlockWriter.this.ff, indexFd, indexOffsetLo, indexMappingSz);
            long offset = columnDataOffsetLo;
            long columnDataAddress = columnDataAddressLo;
            long columnIndexAddress = indexMappingStart;
            long nRowsAdded = 0L;
            while (columnDataAddress < columnDataAddressHi) {
                assert (columnIndexAddress + 8L <= indexMappingStart + indexMappingSz);
                ++nRowsAdded;
                Unsafe.getUnsafe().putLong(columnIndexAddress, offset);
                columnIndexAddress += 8L;
                long binLen = Unsafe.getUnsafe().getLong(columnDataAddress);
                long sz = binLen == -1L ? 8L : 8L + binLen;
                columnDataAddress += sz;
                offset += sz;
            }
            partitionStruct.setColumnNRowsAdded(columnIndex, nRowsAdded);
            TableBlockWriter.unmapFile(TableBlockWriter.this.ff, indexMappingStart, indexMappingSz);
        }

        private void completeUpdateStringIndex(long columnDataAddressLo, long columnDataAddressHi, long columnDataOffsetLo, long indexFd, long indexOffsetLo, int columnIndex, PartitionStruct partitionStruct) {
            long indexMappingSz = (columnDataAddressHi - columnDataAddressLo) * 2L;
            long indexMappingStart = TableBlockWriter.mapFile(TableBlockWriter.this.ff, indexFd, indexOffsetLo, indexMappingSz);
            long offset = columnDataOffsetLo;
            long columnDataAddress = columnDataAddressLo;
            long columnIndexAddress = indexMappingStart;
            long nRowsAdded = 0L;
            while (columnDataAddress < columnDataAddressHi) {
                assert (columnIndexAddress + 8L <= indexMappingStart + indexMappingSz);
                ++nRowsAdded;
                Unsafe.getUnsafe().putLong(columnIndexAddress, offset);
                columnIndexAddress += 8L;
                int strLen = Unsafe.getUnsafe().getInt(columnDataAddress);
                long bit = strLen >>> 30 & 2 ^ 2;
                long sz = 4L + 2L * (long)(strLen + 1) - bit;
                columnDataAddress += sz;
                offset += sz;
            }
            partitionStruct.setColumnNRowsAdded(columnIndex, nRowsAdded);
            TableBlockWriter.unmapFile(TableBlockWriter.this.ff, indexMappingStart, indexMappingSz);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean run() {
            if (!this.ready.compareAndSet(true, false)) return false;
            try {
                switch (this.taskType) {
                    case AppendBlock: {
                        Vect.memcpy(this.sourceAddress, this.destAddress, this.sourceSizeOrEnd);
                        boolean bl = true;
                        return bl;
                    }
                    case GenerateStringIndex: {
                        this.completeUpdateStringIndex(this.sourceAddress, this.sourceSizeOrEnd, this.sourceInitialOffset, this.indexFd, this.indexOffsetLo, this.columnIndex, this.partitionStruct);
                        boolean bl = true;
                        return bl;
                    }
                    case GenerateBinaryIndex: {
                        this.completeUpdateBinaryIndex(this.sourceAddress, this.sourceSizeOrEnd, this.sourceInitialOffset, this.indexFd, this.indexOffsetLo, this.columnIndex, this.partitionStruct);
                        boolean bl = true;
                        return bl;
                    }
                }
                return false;
            }
            finally {
                TableBlockWriter.this.nCompletedConcurrentTasks.incrementAndGet();
            }
        }
    }

    private class PartitionBlockWriter
    implements Closeable {
        private final PartitionStruct partitionStruct = new PartitionStruct();
        private final LongList columnTops = new LongList();
        private final Path path = new Path();
        private long timestampLo;
        private long timestampHi;
        private boolean opened;

        private PartitionBlockWriter() {
        }

        @Override
        public void close() {
            this.clear();
            this.path.close();
        }

        private void openPartition() {
            assert (!this.opened);
            this.partitionStruct.of(TableBlockWriter.this.columnCount);
            this.path.of(TableBlockWriter.this.root).concat(TableBlockWriter.this.writer.getTableName());
            this.timestampHi = TableUtils.setPathForPartition(this.path, TableBlockWriter.this.partitionBy, this.timestampLo, true);
            int plen = this.path.length();
            try {
                if (TableBlockWriter.this.ff.mkdirs(this.path.slash$(), TableBlockWriter.this.mkDirMode) != 0) {
                    throw CairoException.instance(TableBlockWriter.this.ff.errno()).put("Could not create directory: ").put(this.path);
                }
                assert (TableBlockWriter.this.columnCount > 0);
                this.columnTops.setAll(TableBlockWriter.this.columnCount, -1L);
                block8: for (int columnIndex = 0; columnIndex < TableBlockWriter.this.columnCount; ++columnIndex) {
                    String name = TableBlockWriter.this.metadata.getColumnName(columnIndex);
                    long appendOffset = TableBlockWriter.this.writer.getPrimaryAppendOffset(this.timestampLo, columnIndex);
                    this.partitionStruct.setColumnStartOffset(columnIndex, appendOffset);
                    this.partitionStruct.setColumnAppendOffset(columnIndex, appendOffset);
                    this.partitionStruct.setColumnDataFd(columnIndex, TableUtils.openFileRWOrFail(TableBlockWriter.this.ff, TableUtils.dFile(this.path.trimTo(plen), name)));
                    int columnType = TableBlockWriter.this.metadata.getColumnType(columnIndex);
                    switch (columnType) {
                        case 10: 
                        case 13: {
                            this.partitionStruct.setColumnIndexFd(columnIndex, TableUtils.openFileRWOrFail(TableBlockWriter.this.ff, TableUtils.iFile(this.path.trimTo(plen), name)));
                            this.partitionStruct.setColumnFieldSizePow2(columnIndex, -1);
                            continue block8;
                        }
                        default: {
                            this.partitionStruct.setColumnIndexFd(columnIndex, -1L);
                            this.partitionStruct.setColumnFieldSizePow2(columnIndex, ColumnType.pow2SizeOf(columnType));
                        }
                    }
                }
                this.opened = true;
                LOG.info().$("opened partition to '").$(this.path).$('\'').$();
            }
            catch (Throwable ex) {
                this.closePartition();
                throw ex;
            }
            finally {
                this.path.trimTo(plen);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closePartition() {
            try {
                for (int columnIndex = 0; columnIndex < TableBlockWriter.this.columnCount; ++columnIndex) {
                    long address;
                    long fd = this.partitionStruct.getColumnDataFd(columnIndex);
                    if (fd > 0L) {
                        TableBlockWriter.this.ff.close(fd);
                    }
                    if ((fd = this.partitionStruct.getColumnIndexFd(columnIndex)) > 0L) {
                        TableBlockWriter.this.ff.close(fd);
                    }
                    if ((address = this.partitionStruct.getColumnMappingStart(columnIndex)) == 0L) continue;
                    long sz = this.partitionStruct.getColumnMappingSize(columnIndex);
                    TableBlockWriter.unmapFile(TableBlockWriter.this.ff, address, sz);
                    this.partitionStruct.setColumnMappingStart(columnIndex, 0L);
                }
                int nAdditionalMappings = this.partitionStruct.getnAdditionalMappings();
                for (int i = 0; i < nAdditionalMappings; ++i) {
                    long address = this.partitionStruct.getAdditionalMappingStart(i);
                    long sz = this.partitionStruct.getAdditionalMappingSize(i);
                    TableBlockWriter.unmapFile(TableBlockWriter.this.ff, address, sz);
                }
            }
            finally {
                this.partitionStruct.clear();
                this.opened = false;
            }
        }

        private void appendPageFrameColumn(int columnIndex, long pageFrameSize, long sourceAddress) {
            if (sourceAddress != 0L) {
                long destAddress;
                long appendOffset = this.partitionStruct.getColumnAppendOffset(columnIndex);
                long nextAppendOffset = appendOffset + pageFrameSize;
                this.partitionStruct.setColumnAppendOffset(columnIndex, nextAppendOffset);
                long columnStartAddress = this.partitionStruct.getColumnMappingStart(columnIndex);
                if (columnStartAddress == 0L) {
                    assert (appendOffset == this.partitionStruct.getColumnStartOffset(columnIndex));
                    long mapSz = Math.max(pageFrameSize, TableBlockWriter.this.ff.getMapPageSize());
                    long address = TableBlockWriter.mapFile(TableBlockWriter.this.ff, this.partitionStruct.getColumnDataFd(columnIndex), appendOffset, mapSz);
                    this.partitionStruct.setColumnMappingStart(columnIndex, address);
                    this.partitionStruct.setColumnMappingSize(columnIndex, mapSz);
                    destAddress = columnStartAddress = address;
                } else {
                    long initialOffset = this.partitionStruct.getColumnStartOffset(columnIndex);
                    assert (initialOffset < appendOffset);
                    long minMapSz = nextAppendOffset - initialOffset;
                    if (minMapSz > this.partitionStruct.getColumnMappingSize(columnIndex)) {
                        this.partitionStruct.addAdditionalMapping(this.partitionStruct.getColumnMappingStart(columnIndex), this.partitionStruct.getColumnMappingSize(columnIndex));
                        long address = TableBlockWriter.mapFile(TableBlockWriter.this.ff, this.partitionStruct.getColumnDataFd(columnIndex), this.partitionStruct.getColumnStartOffset(columnIndex), minMapSz);
                        this.partitionStruct.setColumnMappingStart(columnIndex, address);
                        this.partitionStruct.setColumnMappingSize(columnIndex, minMapSz);
                    }
                    destAddress = this.partitionStruct.getColumnMappingStart(columnIndex) + appendOffset - initialOffset;
                }
                TableBlockWriterTask task = TableBlockWriter.this.getConcurrentTask();
                task.assignAppendPageFrameColumn(destAddress, pageFrameSize, sourceAddress);
                TableBlockWriter.this.enqueueConcurrentTask(task);
            } else {
                TableBlockWriter.this.partWriter.setColumnTop(columnIndex, pageFrameSize);
            }
        }

        private void cancel() {
            this.clear();
        }

        private void clear() {
            if (this.opened) {
                this.closePartition();
            }
            this.columnTops.clear();
        }

        private void completeCommitAppendedBlock() {
            long nRowsAdded = 0L;
            for (int columnIndex = 0; columnIndex < TableBlockWriter.this.columnCount; ++columnIndex) {
                long nColRowsAdded = this.partitionStruct.getColumnNRowsAdded(columnIndex);
                assert (nColRowsAdded >= 0L);
                if (nColRowsAdded <= nRowsAdded) continue;
                nRowsAdded = nColRowsAdded;
            }
            long blockLastTimestamp = Math.min(this.timestampHi, TableBlockWriter.this.lastTimestamp);
            LOG.info().$("committing ").$(nRowsAdded).$(" rows to partition at ").$(this.path).$(" [firstTimestamp=").$ts(this.timestampLo).$(", lastTimestamp=").$ts(this.timestampHi).$(']').$();
            TableBlockWriter.this.writer.startAppendedBlock(this.timestampLo, blockLastTimestamp, nRowsAdded, this.columnTops);
        }

        private void completeUpdateSymbolCache(int columnIndex, long colNRowsAdded) {
            SymbolMapWriter symWriter;
            long address = this.partitionStruct.getColumnMappingStart(columnIndex);
            assert (address > 0L);
            int nSymbols = Vect.maxInt(address, colNRowsAdded) + 1;
            if (nSymbols > (symWriter = TableBlockWriter.this.writer.getSymbolMapWriter(columnIndex)).getSymbolCount()) {
                symWriter.commitAppendedBlock(nSymbols - symWriter.getSymbolCount());
            }
        }

        private void of(long timestampLo) {
            this.timestampLo = timestampLo;
            this.openPartition();
            this.columnTops.ensureCapacity(TableBlockWriter.this.columnCount);
        }

        private void setColumnTop(int columnIndex, long columnTop) {
            this.columnTops.set(columnIndex, columnTop);
        }

        private void startCommitAppendedBlock() {
            block4: for (int columnIndex = 0; columnIndex < TableBlockWriter.this.columnCount; ++columnIndex) {
                int columnType = TableBlockWriter.this.metadata.getColumnType(columnIndex);
                long offsetLo = this.partitionStruct.getColumnStartOffset(columnIndex);
                long offsetHi = this.partitionStruct.getColumnAppendOffset(columnIndex);
                switch (columnType) {
                    case 10: 
                    case 13: {
                        TableBlockWriterTask task = TableBlockWriter.this.getConcurrentTask();
                        if (offsetHi != offsetLo) {
                            long columnDataAddressLo = this.partitionStruct.getColumnMappingStart(columnIndex);
                            assert (offsetHi - offsetLo <= this.partitionStruct.getColumnMappingSize(columnIndex));
                            long columnDataAddressHi = columnDataAddressLo + offsetHi - offsetLo;
                            long indexFd = this.partitionStruct.getColumnIndexFd(columnIndex);
                            long indexOffsetLo = TableBlockWriter.this.writer.getSecondaryAppendOffset(this.timestampLo, columnIndex);
                            if (columnType == 10) {
                                task.assignUpdateStringIndex(columnDataAddressLo, columnDataAddressHi, offsetLo, indexFd, indexOffsetLo, columnIndex, this.partitionStruct);
                            } else {
                                task.assignUpdateBinaryIndex(columnDataAddressLo, columnDataAddressHi, offsetLo, indexFd, indexOffsetLo, columnIndex, this.partitionStruct);
                            }
                            this.partitionStruct.setColumnNRowsAdded(columnIndex, -1L);
                            TableBlockWriter.this.enqueueConcurrentTask(task);
                            continue block4;
                        }
                        this.partitionStruct.setColumnNRowsAdded(columnIndex, 0L);
                        continue block4;
                    }
                    case 11: {
                        long colNRowsAdded = offsetHi - offsetLo >> this.partitionStruct.getColumnFieldSizePow2(columnIndex);
                        this.partitionStruct.setColumnNRowsAdded(columnIndex, colNRowsAdded);
                        this.completeUpdateSymbolCache(columnIndex, colNRowsAdded);
                        continue block4;
                    }
                    default: {
                        long colNRowsAdded = offsetHi - offsetLo >> this.partitionStruct.getColumnFieldSizePow2(columnIndex);
                        this.partitionStruct.setColumnNRowsAdded(columnIndex, colNRowsAdded);
                        continue block4;
                    }
                }
            }
        }

        private void startPageFrame(long timestamp) {
            assert (this.opened);
            assert (timestamp == Long.MIN_VALUE || timestamp >= this.timestampLo);
            assert (timestamp <= this.timestampHi);
            this.timestampLo = timestamp;
        }
    }

    public static class TableBlockWriterJob
    extends AbstractQueueConsumerJob<TableBlockWriterTaskHolder> {
        public TableBlockWriterJob(MessageBus messageBus) {
            super(messageBus.getTableBlockWriterQueue(), messageBus.getTableBlockWriterSubSeq());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doRun(int workerId, long cursor) {
            try {
                TableBlockWriterTaskHolder holder = (TableBlockWriterTaskHolder)this.queue.get(cursor);
                boolean useful = holder.task.run();
                holder.task = null;
                boolean bl = useful;
                return bl;
            }
            finally {
                this.subSeq.done(cursor);
            }
        }
    }

    public static class TableBlockWriterTaskHolder {
        private TableBlockWriterTask task;
    }

    private static class PartitionStruct {
        private static final int MAPPING_STRUCT_ENTRY_P2 = 3;
        private static final int INITIAL_ADDITIONAL_MAPPINGS = 4;
        private long[] mappingData = null;
        private int columnCount;
        private int nAdditionalMappings;

        private PartitionStruct() {
        }

        private void addAdditionalMapping(long start, long size) {
            int i = this.getMappingDataIndex(this.columnCount, this.nAdditionalMappings << 1);
            ++this.nAdditionalMappings;
            int minSz = i + this.nAdditionalMappings << 1;
            if (this.mappingData.length < minSz) {
                long[] newMappingData = new long[minSz + 8];
                System.arraycopy(this.mappingData, 0, newMappingData, 0, this.mappingData.length);
                this.mappingData = newMappingData;
            }
            this.mappingData[i++] = start;
            this.mappingData[i] = size;
        }

        private void clear() {
            Arrays.fill(this.mappingData, 0L);
        }

        private long getAdditionalMappingSize(int nMapping) {
            int i = this.getMappingDataIndex(this.columnCount, (nMapping << 1) + 1);
            return this.mappingData[i];
        }

        private long getAdditionalMappingStart(int nMapping) {
            int i = this.getMappingDataIndex(this.columnCount, nMapping << 1);
            return this.mappingData[i];
        }

        private long getColumnAppendOffset(int columnIndex) {
            return this.mappingData[this.getMappingDataIndex(columnIndex, 5)];
        }

        private long getColumnDataFd(int columnIndex) {
            return this.mappingData[this.getMappingDataIndex(columnIndex, 0)];
        }

        private int getColumnFieldSizePow2(int columnIndex) {
            return (int)this.mappingData[this.getMappingDataIndex(columnIndex, 7)];
        }

        private long getColumnIndexFd(int columnIndex) {
            return this.mappingData[this.getMappingDataIndex(columnIndex, 1)];
        }

        private long getColumnMappingSize(int columnIndex) {
            return this.mappingData[this.getMappingDataIndex(columnIndex, 3)];
        }

        private long getColumnMappingStart(int columnIndex) {
            return this.mappingData[this.getMappingDataIndex(columnIndex, 2)];
        }

        private long getColumnNRowsAdded(int columnIndex) {
            return this.mappingData[this.getMappingDataIndex(columnIndex, 6)];
        }

        private long getColumnStartOffset(int columnIndex) {
            return this.mappingData[this.getMappingDataIndex(columnIndex, 4)];
        }

        private int getMappingDataIndex(int columnIndex, int fieldIndex) {
            return (columnIndex << 3) + fieldIndex;
        }

        private int getnAdditionalMappings() {
            return this.nAdditionalMappings;
        }

        private void of(int columnCount) {
            this.columnCount = columnCount;
            this.nAdditionalMappings = 0;
            int MAPPING_STRUCT_ENTRY_SIZE = 8;
            int sz = columnCount * MAPPING_STRUCT_ENTRY_SIZE;
            if (this.mappingData == null || this.mappingData.length < sz) {
                this.mappingData = new long[sz += 8];
            }
        }

        private void setColumnAppendOffset(int columnIndex, long offset) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)5)] = offset;
        }

        private void setColumnDataFd(int columnIndex, long fd) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)0)] = fd;
        }

        private void setColumnFieldSizePow2(int columnIndex, int fieldSizePow2) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)7)] = fieldSizePow2;
        }

        private void setColumnIndexFd(int columnIndex, long fd) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)1)] = fd;
        }

        private void setColumnMappingSize(int columnIndex, long size) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)3)] = size;
        }

        private void setColumnMappingStart(int columnIndex, long address) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)2)] = address;
        }

        private void setColumnNRowsAdded(int columnIndex, long nRowsAdded) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)6)] = nRowsAdded;
        }

        private void setColumnStartOffset(int columnIndex, long offset) {
            this.mappingData[this.getMappingDataIndex((int)columnIndex, (int)4)] = offset;
        }
    }

    private static enum TaskType {
        AppendBlock,
        GenerateStringIndex,
        GenerateBinaryIndex;

    }
}

