/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.vm.ReadOnlyVirtualMemory;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.Nullable;

public class TablePageFrameCursor
implements PageFrameCursor {
    private final LongList columnFrameAddresses = new LongList();
    private final LongList columnFrameLengths = new LongList();
    private final LongList columnTops = new LongList();
    private final ReplicationPageFrame frame = new ReplicationPageFrame();
    private TableReader reader;
    private long maxRowsPerFrame;
    private IntList columnIndexes;
    private IntList columnSizes;
    private int columnCount;
    private boolean moveToNextPartition;
    private int partitionIndex;
    private int partitionCount;
    private int timestampColumnIndex;
    private long frameFirstRow;
    private long nPartitionRows;
    private long firstTimestamp = Long.MIN_VALUE;
    private int columnBase;
    private boolean checkNFrameRowsForColumnTops;

    @Override
    public void close() {
        if (null != this.reader) {
            this.reader = Misc.free(this.reader);
            this.reader = null;
            this.columnIndexes = null;
            this.columnSizes = null;
        }
    }

    @Override
    @Nullable
    public ReplicationPageFrame next() {
        while (!this.moveToNextPartition || ++this.partitionIndex < this.partitionCount) {
            long nFrameRows;
            if (this.moveToNextPartition) {
                this.nPartitionRows = this.reader.openPartition(this.partitionIndex);
                if (this.nPartitionRows <= this.frameFirstRow) {
                    this.frameFirstRow = 0L;
                    continue;
                }
                this.columnBase = this.reader.getColumnBase(this.partitionIndex);
                this.checkNFrameRowsForColumnTops = false;
                for (int i = 0; i < this.columnCount; ++i) {
                    int columnIndex = this.columnIndexes.get(i);
                    long columnTop = this.reader.getColumnTop(this.columnBase, columnIndex);
                    this.columnTops.setQuick(i, columnTop);
                    if (columnTop <= 0L) continue;
                    this.checkNFrameRowsForColumnTops = true;
                }
            }
            if ((nFrameRows = this.nPartitionRows - this.frameFirstRow) > this.maxRowsPerFrame) {
                nFrameRows = this.maxRowsPerFrame;
            }
            if (this.checkNFrameRowsForColumnTops) {
                this.checkNFrameRowsForColumnTops = false;
                long frameLastRow = this.frameFirstRow + nFrameRows - 1L;
                for (int i = 0; i < this.columnCount; ++i) {
                    long columnTop = this.columnTops.getQuick(i);
                    if (columnTop <= this.frameFirstRow) continue;
                    this.checkNFrameRowsForColumnTops = true;
                    if (columnTop > frameLastRow) continue;
                    nFrameRows = columnTop - this.frameFirstRow;
                    frameLastRow = this.frameFirstRow + nFrameRows - 1L;
                }
            }
            for (int i = 0; i < this.columnCount; ++i) {
                int columnIndex = this.columnIndexes.get(i);
                long columnTop = this.columnTops.getQuick(i);
                ReadOnlyVirtualMemory col = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.columnBase, columnIndex));
                if (columnTop <= this.frameFirstRow && col.getPageCount() > 0) {
                    long columnPageLength;
                    assert (col.getPageCount() == 1);
                    long colFrameFirstRow = this.frameFirstRow - columnTop;
                    long colFrameLastRow = colFrameFirstRow + nFrameRows;
                    long colMaxRow = this.nPartitionRows - columnTop;
                    long columnPageAddress = col.getPageAddress(0);
                    int columnType = this.reader.getMetadata().getColumnType(columnIndex);
                    switch (columnType) {
                        case 10: {
                            ReadOnlyVirtualMemory strLenCol = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.columnBase, columnIndex) + 1);
                            columnPageLength = this.calculateStringPagePosition(col, strLenCol, colFrameLastRow, colMaxRow);
                            if (colFrameFirstRow <= 0L) break;
                            long columnPageBegin = this.calculateStringPagePosition(col, strLenCol, colFrameFirstRow, colMaxRow);
                            columnPageAddress += columnPageBegin;
                            columnPageLength -= columnPageBegin;
                            break;
                        }
                        case 13: {
                            ReadOnlyVirtualMemory binLenCol = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.columnBase, columnIndex) + 1);
                            columnPageLength = this.calculateBinaryPagePosition(col, binLenCol, colFrameLastRow, colMaxRow);
                            if (colFrameFirstRow <= 0L) break;
                            long columnPageBegin = this.calculateBinaryPagePosition(col, binLenCol, colFrameFirstRow, colMaxRow);
                            columnPageAddress += columnPageBegin;
                            columnPageLength -= columnPageBegin;
                            break;
                        }
                        default: {
                            int columnSizeBinaryPower = this.columnSizes.getQuick(i);
                            columnPageLength = colFrameLastRow << columnSizeBinaryPower;
                            if (colFrameFirstRow <= 0L) break;
                            long columnPageBegin = colFrameFirstRow << columnSizeBinaryPower;
                            columnPageAddress += columnPageBegin;
                            columnPageLength -= columnPageBegin;
                        }
                    }
                    this.columnFrameAddresses.setQuick(i, columnPageAddress);
                    this.columnFrameLengths.setQuick(i, columnPageLength);
                    if (this.timestampColumnIndex != columnIndex) continue;
                    this.firstTimestamp = Unsafe.getUnsafe().getLong(columnPageAddress);
                    continue;
                }
                this.columnFrameAddresses.setQuick(i, 0L);
                this.columnFrameLengths.setQuick(i, nFrameRows);
            }
            this.frameFirstRow += nFrameRows;
            assert (this.frameFirstRow <= this.nPartitionRows);
            if (this.frameFirstRow == this.nPartitionRows) {
                this.moveToNextPartition = true;
                this.frameFirstRow = 0L;
            } else {
                this.moveToNextPartition = false;
            }
            return this.frame;
        }
        return null;
    }

    @Override
    public void toTop() {
        this.partitionIndex = -1;
        this.moveToNextPartition = true;
        this.partitionCount = this.reader.getPartitionCount();
        this.firstTimestamp = Long.MIN_VALUE;
    }

    @Override
    public long size() {
        return this.reader.size();
    }

    @Override
    public SymbolMapReader getSymbolMapReader(int i) {
        return this.reader.getSymbolMapReader(this.columnIndexes.getQuick(i));
    }

    public TablePageFrameCursor of(TableReader reader, long maxRowsPerFrame, int timestampColumnIndex, IntList columnIndexes, IntList columnSizes) {
        this.reader = reader;
        this.maxRowsPerFrame = maxRowsPerFrame;
        this.columnIndexes = columnIndexes;
        this.columnSizes = columnSizes;
        this.columnCount = columnIndexes.size();
        this.timestampColumnIndex = timestampColumnIndex;
        this.columnFrameAddresses.seed(this.columnCount, 0L);
        this.columnFrameLengths.seed(this.columnCount, 0L);
        this.columnTops.seed(this.columnCount, 0L);
        this.toTop();
        return this;
    }

    private long calculateBinaryPagePosition(ReadOnlyVirtualMemory col, ReadOnlyVirtualMemory binLenCol, long row, long maxRows) {
        assert (row > 0L && row <= maxRows);
        if (row < maxRows) {
            long binLenOffset = row << 3;
            return binLenCol.getLong(binLenOffset);
        }
        long binLenOffset = row - 1L << 3;
        long prevBinOffset = binLenCol.getLong(binLenOffset);
        long binLen = col.getInt(prevBinOffset);
        long sz = binLen == -1L ? 8L : 8L + binLen;
        return prevBinOffset + sz;
    }

    private long calculateStringPagePosition(ReadOnlyVirtualMemory col, ReadOnlyVirtualMemory strLenCol, long row, long maxRows) {
        assert (row > 0L && row <= maxRows);
        if (row < maxRows) {
            long strLenOffset = row << 3;
            return strLenCol.getLong(strLenOffset);
        }
        long strLenOffset = row - 1L << 3;
        long prevStrOffset = strLenCol.getLong(strLenOffset);
        long strLen = col.getInt(prevStrOffset);
        long sz = strLen == -1L ? 4L : 4L + 2L * strLen;
        return prevStrOffset + sz;
    }

    TablePageFrameCursor of(TableReader reader, long maxRowsPerFrame, int timestampColumnIndex, IntList columnIndexes, IntList columnSizes, int partitionIndex, long partitionRowCount) {
        this.of(reader, maxRowsPerFrame, timestampColumnIndex, columnIndexes, columnSizes);
        this.partitionIndex = partitionIndex - 1;
        this.frameFirstRow = partitionRowCount;
        return this;
    }

    public class ReplicationPageFrame
    implements PageFrame {
        @Override
        public long getFirstTimestamp() {
            return TablePageFrameCursor.this.firstTimestamp;
        }

        @Override
        public long getPageAddress(int i) {
            return TablePageFrameCursor.this.columnFrameAddresses.getQuick(i);
        }

        @Override
        public long getPageSize(int i) {
            return TablePageFrameCursor.this.columnFrameLengths.getQuick(i);
        }

        public int getPartitionIndex() {
            return TablePageFrameCursor.this.partitionIndex;
        }
    }
}

