/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexBwdNullReader;
import io.questdb.cairo.BitmapIndexBwdReader;
import io.questdb.cairo.BitmapIndexFwdNullReader;
import io.questdb.cairo.BitmapIndexFwdReader;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.EmptySymbolMapReader;
import io.questdb.cairo.NullColumn;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.ReadOnlyVirtualMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;

public class TableReader
implements Closeable,
SymbolTableSource {
    private static final Log LOG = LogFactory.getLog(TableReader.class);
    private static final int PARTITIONS_SLOT_SIZE = 4;
    private static final int PARTITIONS_SLOT_OFFSET_SIZE = 1;
    private static final int PARTITIONS_SLOT_OFFSET_NAME_TXN = 2;
    private static final int PARTITIONS_SLOT_OFFSET_DATA_TXN = 3;
    private static final int PARTITIONS_SLOT_SIZE_MSB = Numbers.msb(4);
    private final ColumnCopyStruct tempCopyStruct = new ColumnCopyStruct();
    private final FilesFacade ff;
    private final Path path;
    private final int rootLen;
    private final TableReaderMetadata metadata;
    private final DateFormat partitionFormat;
    private final LongList openPartitionInfo;
    private final TableReaderRecordCursor recordCursor = new TableReaderRecordCursor();
    private final Timestamps.TimestampFloorMethod timestampFloorMethod;
    private final String tableName;
    private final ObjList<SymbolMapReader> symbolMapReaders = new ObjList();
    private final CairoConfiguration configuration;
    private final IntList symbolCountSnapshot = new IntList();
    private final TxReader txFile;
    private final MappedReadOnlyMemory todoMem = new SinglePageMappedReadOnlyPageMemory();
    private final TxnScoreboard txnScoreboard;
    private int partitionCount;
    private LongList columnTops;
    private ObjList<MappedReadOnlyMemory> columns;
    private ObjList<BitmapIndexReader> bitmapIndexes;
    private int columnCount;
    private int columnCountBits;
    private long rowCount;
    private long txn = 0L;
    private long tempMem8b = Unsafe.malloc(8L);
    private boolean active;

    public TableReader(CairoConfiguration configuration, CharSequence tableName) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.tableName = Chars.toString(tableName);
        this.path = new Path();
        this.path.of(configuration.getRoot()).concat(tableName);
        this.rootLen = this.path.length();
        try {
            this.failOnPendingTodo();
            this.metadata = this.openMetaFile();
            this.columnCount = this.metadata.getColumnCount();
            this.columnCountBits = TableReader.getColumnBits(this.columnCount);
            int partitionBy = this.metadata.getPartitionBy();
            this.txnScoreboard = new TxnScoreboard(this.ff, this.path.trimTo(this.rootLen), configuration.getTxnScoreboardEntryCount());
            this.path.trimTo(this.rootLen);
            LOG.debug().$("open [id=").$(this.metadata.getId()).$(", table=").utf8(tableName).I$();
            this.txFile = new TxReader(this.ff, this.path, partitionBy);
            this.readTxnSlow();
            this.openSymbolMaps();
            this.partitionCount = this.txFile.getPartitionCount();
            this.partitionFormat = TableUtils.getPartitionDateFmt(partitionBy);
            this.timestampFloorMethod = partitionBy == 3 ? null : TableUtils.getPartitionFloor(partitionBy);
            int capacity = this.getColumnBase(this.partitionCount);
            this.columns = new ObjList(capacity);
            this.columns.setPos(capacity + 2);
            this.columns.setQuick(0, NullColumn.INSTANCE);
            this.columns.setQuick(1, NullColumn.INSTANCE);
            this.bitmapIndexes = new ObjList(capacity);
            this.bitmapIndexes.setPos(capacity + 2);
            this.openPartitionInfo = new LongList(this.partitionCount * 4);
            this.openPartitionInfo.setPos(this.partitionCount * 4);
            for (int i = 0; i < this.partitionCount; ++i) {
                this.openPartitionInfo.setQuick(i * 4, this.txFile.getPartitionTimestamp(i));
                this.openPartitionInfo.setQuick(i * 4 + 1, -1L);
                this.openPartitionInfo.setQuick(i * 4 + 2, this.txFile.getPartitionNameTxn(i));
                this.openPartitionInfo.setQuick(i * 4 + 3, this.txFile.getPartitionDataTxn(i));
            }
            this.columnTops = new LongList(capacity / 2);
            this.columnTops.setPos(capacity / 2);
            this.recordCursor.of(this);
            this.active = true;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public static int getPrimaryColumnIndex(int base, int index) {
        return 2 + base + index * 2;
    }

    public double avgDouble(int columnIndex) {
        double result = 0.0;
        long countTotal = 0L;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyVirtualMemory column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long a = column.getPageAddress(pageIndex);
                long count = column.getPageSize(pageIndex) / 8L;
                result += Vect.avgDouble(a, count);
                ++countTotal;
            }
        }
        if (countTotal == 0L) {
            return 0.0;
        }
        return result / (double)countTotal;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.freeSymbolMapReaders();
            this.freeBitmapIndexCache();
            Misc.free(this.metadata);
            this.goPassive();
            Misc.free(this.txFile);
            Misc.free(this.todoMem);
            this.freeColumns();
            this.freeTempMem();
            Misc.free(this.txnScoreboard);
            Misc.free(this.path);
            LOG.debug().$("closed '").utf8(this.tableName).$('\'').$();
        }
    }

    public void closeColumnForRemove(int columnIndex) {
        assert (columnIndex > -1 && columnIndex < this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            this.closeColumn(this.getColumnBase(partitionIndex), columnIndex);
        }
        if (this.metadata.getColumnType(columnIndex) == 11) {
            Misc.free(this.symbolMapReaders.getAndSetQuick(columnIndex, EmptySymbolMapReader.INSTANCE));
        }
    }

    public void closeColumnForRemove(CharSequence columnName) {
        this.closeColumnForRemove(this.metadata.getColumnIndex(columnName));
    }

    public long floorToPartitionTimestamp(long timestamp) {
        return this.timestampFloorMethod.floor(timestamp);
    }

    public BitmapIndexReader getBitmapIndexReader(int partitionIndex, int columnBase, int columnIndex, int direction) {
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        BitmapIndexReader reader = this.bitmapIndexes.getQuick(direction == 2 ? index : index + 1);
        return reader == null ? this.createBitmapIndexReaderAt(index, columnBase, columnIndex, direction, this.txFile.getPartitionNameTxn(partitionIndex)) : reader;
    }

    public ReadOnlyVirtualMemory getColumn(int absoluteIndex) {
        return this.columns.getQuick(absoluteIndex);
    }

    public int getColumnBase(int partitionIndex) {
        return partitionIndex << this.columnCountBits;
    }

    public long getColumnTop(int base, int columnIndex) {
        return this.columnTops.getQuick(base / 2 + columnIndex);
    }

    public TableReaderRecordCursor getCursor() {
        this.recordCursor.toTop();
        return this.recordCursor;
    }

    public long getDataVersion() {
        return this.txFile.getDataVersion();
    }

    public long getMaxTimestamp() {
        return this.txFile.getMaxTimestamp();
    }

    public TableReaderMetadata getMetadata() {
        return this.metadata;
    }

    public long getMinTimestamp() {
        return this.txFile.getMinTimestamp();
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getPartitionIndexByTimestamp(long timestamp) {
        int end = this.openPartitionInfo.binarySearchBlock(0, this.openPartitionInfo.size(), PARTITIONS_SLOT_SIZE_MSB, timestamp);
        if (end < 0) {
            return (-end - 2) / 4;
        }
        return end / 4;
    }

    public int getPartitionedBy() {
        return this.metadata.getPartitionBy();
    }

    public SymbolMapReader getSymbolMapReader(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex);
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.getSymbolMapReader(columnIndex);
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getVersion() {
        return this.txFile.getStructureVersion();
    }

    public void goActive() {
        if (this.active) {
            return;
        }
        this.reload(true);
        this.active = true;
    }

    public void goPassive() {
        if (this.active) {
            this.active = false;
            this.txnScoreboard.releaseTxn(this.txn);
        }
    }

    public boolean isOpen() {
        return this.tempMem8b != 0L;
    }

    public double maxDouble(int columnIndex) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyVirtualMemory column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long count;
                long a = column.getPageAddress(pageIndex);
                double x = Vect.maxDouble(a, count = column.getPageSize(pageIndex) / 8L);
                if (!(x > max)) continue;
                max = x;
            }
        }
        return max;
    }

    public double minDouble(int columnIndex) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyVirtualMemory column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long count;
                long a = column.getPageAddress(pageIndex);
                double x = Vect.minDouble(a, count = column.getPageSize(pageIndex) / 8L);
                if (!(x < min)) continue;
                min = x;
            }
        }
        return min;
    }

    public long openPartition(int partitionIndex) {
        long size = this.getPartitionRowCount(partitionIndex);
        if (size != -1L) {
            return size;
        }
        return this.openPartition0(partitionIndex);
    }

    public void reconcileOpenPartitionsFrom(int partitionIndex) {
        int txPartitionCount = this.txFile.getPartitionCount();
        int txPartitionIndex = partitionIndex;
        boolean changed = false;
        while (partitionIndex < this.partitionCount && txPartitionIndex < txPartitionCount) {
            int offset = partitionIndex * 4;
            long openPartitionTimestamp = this.openPartitionInfo.getQuick(offset);
            long openPartitionSize = this.openPartitionInfo.getQuick(offset + 1);
            long openPartitionDataTxn = this.openPartitionInfo.getQuick(offset + 3);
            long openPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
            long txPartTs = this.txFile.getPartitionTimestamp(txPartitionIndex);
            if (openPartitionTimestamp < txPartTs) {
                this.deletePartition(partitionIndex);
                continue;
            }
            if (openPartitionTimestamp > txPartTs) {
                this.insertPartition(partitionIndex, txPartTs);
                changed = true;
                ++txPartitionIndex;
                ++partitionIndex;
                continue;
            }
            long newPartitionSize = this.txFile.getPartitionSize(txPartitionIndex);
            long txPartitionDataTxn = this.txFile.getPartitionDataTxn(partitionIndex);
            long txPartitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
            if (openPartitionNameTxn == txPartitionNameTxn && openPartitionDataTxn == txPartitionDataTxn) {
                if (openPartitionSize != newPartitionSize) {
                    if (openPartitionSize > -1L) {
                        this.reloadPartition(partitionIndex, newPartitionSize, txPartitionNameTxn, partitionIndex == txPartitionCount - 1);
                        this.openPartitionInfo.setQuick(partitionIndex * 4 + 1, newPartitionSize);
                        LOG.debug().$("updated partition size [partition=").$(openPartitionTimestamp).I$();
                    }
                    changed = true;
                }
            } else {
                this.openPartitionInfo.setQuick(offset + 1, -1L);
                this.openPartition0(partitionIndex);
                this.openPartitionInfo.setQuick(offset + 2, txPartitionNameTxn);
                changed = true;
            }
            ++txPartitionIndex;
            ++partitionIndex;
        }
        while (partitionIndex < this.partitionCount) {
            this.deletePartition(partitionIndex);
            changed = true;
        }
        while (partitionIndex < txPartitionCount) {
            this.insertPartition(partitionIndex, this.txFile.getPartitionTimestamp(partitionIndex));
            changed = true;
            ++partitionIndex;
        }
        if (changed) {
            this.reloadSymbolMapCounts();
        }
    }

    public boolean reload() {
        return this.reload(false);
    }

    public void reshuffleSymbolMapReaders(long pTransitionIndex) {
        int i;
        int columnCount = Unsafe.getUnsafe().getInt(pTransitionIndex + 4L);
        long index = pTransitionIndex + 8L;
        long stateAddress = index + (long)columnCount * 8L;
        if (columnCount > this.columnCount) {
            this.symbolMapReaders.setPos(columnCount);
        }
        Vect.memset(stateAddress, columnCount, 0);
        for (i = 0; i < columnCount; ++i) {
            if (Unsafe.getUnsafe().getByte(stateAddress + (long)i) == -1) continue;
            Unsafe.getUnsafe().putByte(stateAddress + (long)i, (byte)-1);
            int copyFrom = Unsafe.getUnsafe().getInt(index + (long)i * 8L);
            if (copyFrom == i + 1 && copyFrom < columnCount) {
                SymbolMapReader reader = this.symbolMapReaders.getQuick(copyFrom);
                if (reader == null || !reader.isDeleted()) continue;
                this.symbolMapReaders.setQuick(copyFrom, this.reloadSymbolMapReader(copyFrom, reader));
                continue;
            }
            if (copyFrom > 0) {
                SymbolMapReader tmp = this.copyOrRenewSymbolMapReader(this.symbolMapReaders.getAndSetQuick(copyFrom - 1, null), i);
                int copyTo = Unsafe.getUnsafe().getInt(index + (long)i * 8L + 4L);
                while (copyTo > 0 && Unsafe.getUnsafe().getByte(stateAddress + (long)copyTo - 1L) != -1) {
                    Unsafe.getUnsafe().putByte(stateAddress + (long)copyTo - 1L, (byte)-1);
                    tmp = this.copyOrRenewSymbolMapReader(tmp, copyTo - 1);
                    copyTo = Unsafe.getUnsafe().getInt(index + (long)(copyTo - 1) * 8L + 4L);
                }
                Misc.free(tmp);
                continue;
            }
            Misc.free(this.symbolMapReaders.getAndSetQuick(i, this.reloadSymbolMapReader(i, null)));
        }
        if (columnCount < this.columnCount) {
            for (i = columnCount; i < this.columnCount; ++i) {
                Misc.free(this.symbolMapReaders.getQuick(i));
            }
            this.symbolMapReaders.setPos(columnCount);
        }
    }

    public long size() {
        return this.rowCount;
    }

    public double sumDouble(int columnIndex) {
        double result = 0.0;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyVirtualMemory column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long a = column.getPageAddress(pageIndex);
                long count = column.getPageSize(pageIndex) / 8L;
                result += Vect.sumDouble(a, count);
            }
        }
        return result;
    }

    private static int getColumnBits(int columnCount) {
        return Numbers.msb(Numbers.ceilPow2(columnCount) * 2);
    }

    private static boolean isEntryToBeProcessed(long address, int index) {
        if (Unsafe.getUnsafe().getByte(address + (long)index) == -1) {
            return false;
        }
        Unsafe.getUnsafe().putByte(address + (long)index, (byte)-1);
        return true;
    }

    private static void growColumn(ReadOnlyVirtualMemory mem1, ReadOnlyVirtualMemory mem2, int type, long rowCount) {
        if (rowCount > 0L) {
            switch (type) {
                default: {
                    mem1.grow(rowCount << ColumnType.pow2SizeOf(type));
                    break;
                }
                case 13: {
                    TableReader.growBin(mem1, mem2, rowCount);
                    break;
                }
                case 10: {
                    TableReader.growStr(mem1, mem2, rowCount);
                }
            }
        }
    }

    private static void growStr(ReadOnlyVirtualMemory mem1, ReadOnlyVirtualMemory mem2, long rowCount) {
        assert (mem2 != null);
        mem2.grow(rowCount * 8L);
        long offset = mem2.getLong((rowCount - 1L) * 8L);
        mem1.grow(offset + 4L);
        int len = mem1.getInt(offset);
        if (len > 0) {
            mem1.grow(offset + VmUtils.getStorageLength(len));
        }
    }

    private static void growBin(ReadOnlyVirtualMemory mem1, ReadOnlyVirtualMemory mem2, long rowCount) {
        assert (mem2 != null);
        mem2.grow(rowCount * 8L);
        long offset = mem2.getLong((rowCount - 1L) * 8L);
        mem1.grow(offset + 8L);
        long len = mem1.getLong(offset);
        if (len > 0L) {
            mem1.grow(offset + len + 8L);
        }
    }

    private void closeColumn(int columnBase, int columnIndex) {
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        Misc.free(this.columns.getAndSetQuick(index, NullColumn.INSTANCE));
        Misc.free(this.columns.getAndSetQuick(index + 1, NullColumn.INSTANCE));
        Misc.free(this.bitmapIndexes.getAndSetQuick(index, null));
        Misc.free(this.bitmapIndexes.getAndSetQuick(index + 1, null));
    }

    private void copyColumnsTo(ObjList<MappedReadOnlyMemory> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex, long partitionRowCount, boolean lastPartition) {
        MappedReadOnlyMemory mem1 = this.tempCopyStruct.mem1;
        boolean reload = (mem1 instanceof SinglePageMappedReadOnlyPageMemory || mem1 instanceof NullColumn) && mem1.isDeleted();
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        this.tempCopyStruct.mem1 = columns.getAndSetQuick(index, mem1);
        this.tempCopyStruct.mem2 = columns.getAndSetQuick(index + 1, this.tempCopyStruct.mem2);
        this.tempCopyStruct.top = columnTops.getAndSetQuick(columnBase / 2 + columnIndex, this.tempCopyStruct.top);
        this.tempCopyStruct.backwardReader = indexReaders.getAndSetQuick(index, this.tempCopyStruct.backwardReader);
        this.tempCopyStruct.forwardReader = indexReaders.getAndSetQuick(index + 1, this.tempCopyStruct.forwardReader);
        if (reload) {
            this.reloadColumnAt(this.path, columns, columnTops, indexReaders, columnBase, columnIndex, partitionRowCount, lastPartition);
        }
    }

    private SymbolMapReader copyOrRenewSymbolMapReader(SymbolMapReader reader, int columnIndex) {
        if (reader != null && reader.isDeleted()) {
            reader = this.reloadSymbolMapReader(columnIndex, reader);
        }
        return this.symbolMapReaders.getAndSetQuick(columnIndex, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitmapIndexReader createBitmapIndexReaderAt(int globalIndex, int columnBase, int columnIndex, int direction, long txn) {
        BitmapIndexReader reader;
        if (!this.metadata.isColumnIndexed(columnIndex)) {
            throw CairoException.instance(0).put("Not indexed: ").put(this.metadata.getColumnName(columnIndex));
        }
        ReadOnlyVirtualMemory col = this.columns.getQuick(globalIndex);
        if (col instanceof NullColumn) {
            if (direction == 2) {
                reader = new BitmapIndexBwdNullReader();
                this.bitmapIndexes.setQuick(globalIndex, reader);
            } else {
                reader = new BitmapIndexFwdNullReader();
                this.bitmapIndexes.setQuick(globalIndex + 1, reader);
            }
        } else {
            Path path = this.pathGenPartitioned(this.getPartitionIndex(columnBase));
            try {
                if (direction == 2) {
                    reader = new BitmapIndexBwdReader(this.configuration, path, this.metadata.getColumnName(columnIndex), this.getColumnTop(columnBase, columnIndex), txn);
                    this.bitmapIndexes.setQuick(globalIndex, reader);
                } else {
                    reader = new BitmapIndexFwdReader(this.configuration, path, this.metadata.getColumnName(columnIndex), this.getColumnTop(columnBase, columnIndex), txn);
                    this.bitmapIndexes.setQuick(globalIndex + 1, reader);
                }
            }
            finally {
                path.trimTo(this.rootLen);
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewColumnList(int columnCount, long pTransitionIndex, int columnBits) {
        int capacity = this.partitionCount << columnBits;
        ObjList<MappedReadOnlyMemory> columns = new ObjList<MappedReadOnlyMemory>(capacity);
        LongList columnTops = new LongList(capacity / 2);
        ObjList<BitmapIndexReader> indexReaders = new ObjList<BitmapIndexReader>(capacity);
        columns.setPos(capacity + 2);
        columns.setQuick(0, NullColumn.INSTANCE);
        columns.setQuick(1, NullColumn.INSTANCE);
        columnTops.setPos(capacity / 2);
        indexReaders.setPos(capacity + 2);
        long pIndexBase = pTransitionIndex + 8L;
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = partitionIndex << columnBits;
            int oldBase = partitionIndex << this.columnCountBits;
            try {
                int i;
                Path path = this.pathGenPartitioned(partitionIndex).$();
                long partitionRowCount = this.openPartitionInfo.getQuick(partitionIndex * 4 + 1);
                boolean lastPartition = partitionIndex == this.partitionCount - 1;
                for (i = 0; i < columnCount; ++i) {
                    int copyFrom = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L) - 1;
                    if (copyFrom > -1) {
                        this.fetchColumnsFrom(this.columns, this.columnTops, this.bitmapIndexes, oldBase, copyFrom);
                        this.copyColumnsTo(columns, columnTops, indexReaders, base, i, partitionRowCount, lastPartition);
                        continue;
                    }
                    this.reloadColumnAt(path, columns, columnTops, indexReaders, base, i, partitionRowCount, lastPartition);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    int index = TableReader.getPrimaryColumnIndex(oldBase, i);
                    Misc.free(this.columns.getQuick(index));
                    Misc.free(this.columns.getQuick(index + 1));
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        this.columns = columns;
        this.columnTops = columnTops;
        this.columnCountBits = columnBits;
        this.bitmapIndexes = indexReaders;
    }

    private void deletePartition(int partitionIndex) {
        int offset = partitionIndex * 4;
        long partitionTimestamp = this.openPartitionInfo.getQuick(offset);
        long partitionSize = this.openPartitionInfo.getQuick(offset + 1);
        int columnBase = this.getColumnBase(partitionIndex);
        if (partitionSize > -1L) {
            for (int k = 0; k < this.columnCount; ++k) {
                this.closeColumn(columnBase, k);
            }
        }
        int baseIndex = TableReader.getPrimaryColumnIndex(columnBase, 0);
        int newBaseIndex = TableReader.getPrimaryColumnIndex(this.getColumnBase(partitionIndex + 1), 0);
        this.columns.remove(baseIndex, newBaseIndex - 1);
        this.openPartitionInfo.removeIndexBlock(offset, 4);
        LOG.info().$("deleted partition [path=").$(this.path).$(",timestamp=").$ts(partitionTimestamp).I$();
        --this.partitionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failOnPendingTodo() {
        try {
            this.path.concat("_todo_").$();
            if (this.ff.exists(this.path)) {
                long instanceHashHi;
                long instanceHashLo;
                long todoTxn;
                this.todoMem.of(this.ff, this.path, this.ff.getPageSize());
                long attemptsLeft = 10L;
                do {
                    todoTxn = this.todoMem.getLong(24L);
                    Unsafe.getUnsafe().loadFence();
                    instanceHashLo = this.todoMem.getLong(8L);
                    instanceHashHi = this.todoMem.getLong(16L);
                    Unsafe.getUnsafe().loadFence();
                } while (todoTxn != this.todoMem.getLong(0L) && --attemptsLeft > 0L);
                if (instanceHashHi != 0L && instanceHashHi != this.configuration.getDatabaseIdHi() || instanceHashLo != 0L && instanceHashLo != this.configuration.getDatabaseIdLo()) {
                    throw CairoException.instance(0).put("Table ").put(this.path.$()).put(" is pending recovery.");
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void fetchColumnsFrom(ObjList<MappedReadOnlyMemory> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex) {
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        this.tempCopyStruct.mem1 = columns.getAndSetQuick(index, null);
        this.tempCopyStruct.mem2 = columns.getAndSetQuick(index + 1, null);
        this.tempCopyStruct.top = columnTops.getQuick(columnBase / 2 + columnIndex);
        this.tempCopyStruct.backwardReader = indexReaders.getAndSetQuick(index, null);
        this.tempCopyStruct.forwardReader = indexReaders.getAndSetQuick(index + 1, null);
    }

    private void formatPartitionDirName(int partitionIndex, CharSink sink) {
        this.partitionFormat.format(this.openPartitionInfo.getQuick(partitionIndex * 4), null, null, sink);
    }

    private void freeBitmapIndexCache() {
        Misc.freeObjList(this.bitmapIndexes);
    }

    private void freeColumns() {
        Misc.freeObjList(this.columns);
    }

    private void freeSymbolMapReaders() {
        int n = this.symbolMapReaders.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.symbolMapReaders.getQuick(i));
        }
        this.symbolMapReaders.clear();
    }

    private void freeTempMem() {
        if (this.tempMem8b != 0L) {
            Unsafe.free(this.tempMem8b, 8L);
            this.tempMem8b = 0L;
        }
    }

    int getColumnCount() {
        return this.columnCount;
    }

    int getPartitionIndex(int columnBase) {
        return columnBase >>> this.columnCountBits;
    }

    long getPartitionRowCount(int partitionIndex) {
        return this.openPartitionInfo.getQuick(partitionIndex * 4 + 1);
    }

    long getTransientRowCount() {
        return this.txFile.getTransientRowCount();
    }

    long getTxn() {
        return this.txn;
    }

    TxnScoreboard getTxnScoreboard() {
        return this.txnScoreboard;
    }

    boolean hasNull(int columnIndex) {
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyVirtualMemory column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long count;
                long a = column.getPageAddress(pageIndex);
                if (!Vect.hasNull(a, count = column.getPageSize(pageIndex) / 4L)) continue;
                return true;
            }
        }
        return false;
    }

    private void insertPartition(int partitionIndex, long timestamp) {
        int columnBase = this.getColumnBase(partitionIndex);
        int columnSlotSize = this.getColumnBase(1);
        int topBase = columnBase / 2;
        int topSlotSize = columnSlotSize / 2;
        int idx = TableReader.getPrimaryColumnIndex(columnBase, 0);
        this.columns.insert(idx, columnSlotSize);
        this.columns.set(idx, columnBase + columnSlotSize, NullColumn.INSTANCE);
        this.bitmapIndexes.insert(idx, columnSlotSize);
        this.bitmapIndexes.set(idx, columnBase + columnSlotSize, null);
        this.columnTops.insert(topBase, topSlotSize);
        this.columnTops.seed(topBase, topSlotSize, 0L);
        int offset = partitionIndex * 4;
        this.openPartitionInfo.insert(offset, 4);
        this.openPartitionInfo.setQuick(offset, timestamp);
        this.openPartitionInfo.setQuick(offset + 1, -1L);
        this.openPartitionInfo.setQuick(offset + 2, -1L);
        this.openPartitionInfo.setQuick(offset + 3, -1L);
        ++this.partitionCount;
        LOG.debug().$("inserted partition [path=").$(this.path).$(",timestamp=").$ts(timestamp).I$();
    }

    boolean isColumnCached(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex).isCached();
    }

    private TableReaderMetadata openMetaFile() {
        try {
            TableReaderMetadata tableReaderMetadata = new TableReaderMetadata(this.ff, this.path.concat("_meta").$());
            return tableReaderMetadata;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    @NotNull
    private MappedReadOnlyMemory openOrCreateMemory(Path path, ObjList<MappedReadOnlyMemory> columns, boolean lastPartition, int primaryIndex, MappedReadOnlyMemory mem) {
        if (mem != null && mem != NullColumn.INSTANCE) {
            mem.of(this.ff, path, this.ff.getMapPageSize(), this.ff.length(path));
        } else {
            mem = lastPartition ? new SinglePageMappedReadOnlyPageMemory(this.ff, path, this.ff.getMapPageSize()) : new SinglePageMappedReadOnlyPageMemory(this.ff, path, this.ff.length(path));
            columns.setQuick(primaryIndex, mem);
        }
        return mem;
    }

    private long openPartition0(int partitionIndex) {
        if (this.txFile.getPartitionCount() < 2 && this.txFile.getTransientRowCount() == 0L) {
            return -1L;
        }
        try {
            long partitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
            Path path = this.pathGenPartitioned(partitionIndex);
            TableUtils.txnPartitionConditionally(path, partitionNameTxn);
            if (this.ff.exists(path.$())) {
                path.chop$();
                boolean lastPartition = partitionIndex == this.partitionCount - 1;
                long partitionSize = this.txFile.getPartitionSize(partitionIndex);
                LOG.info().$("open partition ").utf8(path.$()).$(" [rowCount=").$(partitionSize).$(", partitionNameTxn=").$(partitionNameTxn).$(", transientRowCount=").$(this.txFile.getTransientRowCount()).$(", partitionIndex=").$(partitionIndex).$(", partitionCount=").$(this.partitionCount).$(']').$();
                if (partitionSize > 0L) {
                    this.openPartitionColumns(path, this.getColumnBase(partitionIndex), partitionSize, lastPartition);
                    int offset = partitionIndex * 4;
                    this.openPartitionInfo.setQuick(offset + 1, partitionSize);
                }
                long l = partitionSize;
                return l;
            }
            LOG.error().$("open partition failed, partition does not exist on the disk. [path=").utf8(path.$()).I$();
            if (this.getPartitionedBy() != 3) {
                CairoException exception = CairoException.instance(0).put("Partition '");
                this.formatPartitionDirName(partitionIndex, exception.message);
                TableUtils.txnPartitionConditionally(exception.message, partitionNameTxn);
                exception.put("' does not exist in table '").put(this.tableName).put("' directory. Run [ALTER TABLE ").put(this.tableName).put(" DROP PARTITION LIST '");
                this.formatPartitionDirName(partitionIndex, exception.message);
                TableUtils.txnPartitionConditionally(exception.message, partitionNameTxn);
                exception.put("'] to repair the table or restore the partition directory.");
                throw exception;
            }
            throw CairoException.instance(0).put("Table '").put(this.tableName).put("' data directory does not exist on the disk at ").put(path).put(". Restore data on disk or drop the table.");
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openPartitionColumns(Path path, int columnBase, long partitionRowCount, boolean lastPartition) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.reloadColumnAt(path, this.columns, this.columnTops, this.bitmapIndexes, columnBase, i, partitionRowCount, lastPartition);
        }
    }

    private void openSymbolMaps() {
        int symbolColumnIndex = 0;
        int columnCount = this.metadata.getColumnCount();
        this.symbolMapReaders.setPos(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            if (this.metadata.getColumnType(i) != 11) continue;
            SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl(this.configuration, this.path, this.metadata.getColumnName(i), this.symbolCountSnapshot.getQuick(symbolColumnIndex++));
            this.symbolMapReaders.extendAndSet(i, symbolMapReader);
        }
    }

    private Path pathGenPartitioned(int partitionIndex) {
        this.formatPartitionDirName(partitionIndex, this.path.slash());
        return this.path;
    }

    private boolean readTxnSlow() {
        int count = 0;
        long deadline = this.configuration.getMicrosecondClock().getTicks() + this.configuration.getSpinLockTimeoutUs();
        while (true) {
            long txn;
            if ((txn = this.txFile.readTxn()) == this.txn) {
                this.txnScoreboard.acquireTxn(txn);
                if (txn == 0L) {
                    this.txFile.readSymbolCounts(this.symbolCountSnapshot);
                }
                return false;
            }
            Unsafe.getUnsafe().loadFence();
            if (txn == this.txFile.readTxnCheck()) {
                Unsafe.getUnsafe().loadFence();
                this.txFile.readUnchecked();
                this.symbolCountSnapshot.clear();
                this.txFile.readSymbolCounts(this.symbolCountSnapshot);
                Unsafe.getUnsafe().loadFence();
                if (txn == this.txFile.getTxn()) {
                    if (this.active) {
                        this.txnScoreboard.releaseTxn(this.txn);
                    }
                    this.txn = txn;
                    this.txnScoreboard.acquireTxn(txn);
                    this.rowCount = this.txFile.getFixedRowCount() + this.txFile.getTransientRowCount();
                    LOG.debug().$("new transaction [txn=").$(txn).$(", transientRowCount=").$(this.txFile.getTransientRowCount()).$(", fixedRowCount=").$(this.txFile.getFixedRowCount()).$(", maxTimestamp=").$ts(this.txFile.getMaxTimestamp()).$(", attempts=").$(count).$(", thread=").$(Thread.currentThread().getName()).$(']').$();
                    return true;
                }
            }
            ++count;
            if (this.configuration.getMicrosecondClock().getTicks() > deadline) {
                LOG.error().$("tx read timeout [timeout=").$(this.configuration.getSpinLockTimeoutUs()).utf8("\u03bcs]").$();
                throw CairoException.instance(0).put("Transaction read timeout");
            }
            LockSupport.parkNanos(1L);
        }
    }

    private void reconcileOpenPartitions(long prevPartitionVersion) {
        if (this.txFile.getPartitionTableVersion() == prevPartitionVersion) {
            int txPartitionCount;
            int partitionIndex = Math.max(0, this.partitionCount - 1);
            if (partitionIndex < (txPartitionCount = this.txFile.getPartitionCount())) {
                if (partitionIndex < this.partitionCount) {
                    int offset = partitionIndex * 4;
                    long openPartitionSize = this.openPartitionInfo.getQuick(offset + 1);
                    if (openPartitionSize > -1L) {
                        long openPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
                        long openPartitionDataTxn = this.openPartitionInfo.getQuick(offset + 3);
                        long txPartitionSize = this.txFile.getPartitionSize(partitionIndex);
                        long txPartitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
                        long txPartitionDataTxn = this.txFile.getPartitionDataTxn(partitionIndex);
                        if (openPartitionNameTxn == txPartitionNameTxn && openPartitionDataTxn == txPartitionDataTxn) {
                            if (openPartitionSize != txPartitionSize) {
                                this.reloadPartition(partitionIndex, txPartitionSize, txPartitionNameTxn, partitionIndex == txPartitionCount - 1);
                                this.openPartitionInfo.setQuick(partitionIndex * 4 + 1, txPartitionSize);
                                LOG.debug().$("updated partition size [partition=").$(this.openPartitionInfo.getQuick(offset)).I$();
                            }
                        } else {
                            this.openPartition0(partitionIndex);
                            this.openPartitionInfo.setQuick(offset + 2, txPartitionNameTxn);
                        }
                    }
                    ++partitionIndex;
                }
                while (partitionIndex < txPartitionCount) {
                    this.insertPartition(partitionIndex, this.txFile.getPartitionTimestamp(partitionIndex));
                    ++partitionIndex;
                }
                this.reloadSymbolMapCounts();
            }
            return;
        }
        this.reconcileOpenPartitionsFrom(0);
    }

    private boolean reload(boolean activation) {
        if (this.txn == this.txFile.readTxn()) {
            if (activation) {
                this.txnScoreboard.acquireTxn(this.txn);
            }
            return false;
        }
        return this.reloadSlow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadColumnAt(Path path, ObjList<MappedReadOnlyMemory> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex, long partitionRowCount, boolean lastPartition) {
        int plen = path.length();
        try {
            String name = this.metadata.getColumnName(columnIndex);
            int primaryIndex = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
            int secondaryIndex = primaryIndex + 1;
            MappedReadOnlyMemory mem1 = columns.getQuick(primaryIndex);
            MappedReadOnlyMemory mem2 = columns.getQuick(secondaryIndex);
            if (this.ff.exists(TableUtils.dFile(path.trimTo(plen), name))) {
                mem1 = this.openOrCreateMemory(path, columns, lastPartition, primaryIndex, mem1);
                long columnTop = TableUtils.readColumnTop(this.ff, path.trimTo(plen), name, plen, this.tempMem8b);
                int type = this.metadata.getColumnType(columnIndex);
                switch (type) {
                    case 10: 
                    case 13: {
                        TableUtils.iFile(path.trimTo(plen), name);
                        mem2 = this.openOrCreateMemory(path, columns, lastPartition, secondaryIndex, mem2);
                        TableReader.growColumn(mem1, mem2, type, partitionRowCount - columnTop);
                        break;
                    }
                    default: {
                        Misc.free(columns.getAndSetQuick(secondaryIndex, null));
                        TableReader.growColumn(mem1, null, type, partitionRowCount - columnTop);
                    }
                }
                columnTops.setQuick(columnBase / 2 + columnIndex, columnTop);
                if (this.metadata.isColumnIndexed(columnIndex)) {
                    BitmapIndexReader indexReader = indexReaders.getQuick(primaryIndex);
                    if (indexReader instanceof BitmapIndexBwdReader) {
                        ((BitmapIndexBwdReader)indexReader).of(this.configuration, path.trimTo(plen), name, columnTop, -1L);
                    }
                    if ((indexReader = indexReaders.getQuick(secondaryIndex)) instanceof BitmapIndexFwdReader) {
                        ((BitmapIndexFwdReader)indexReader).of(this.configuration, path.trimTo(plen), name, columnTop, -1L);
                    }
                } else {
                    Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                    Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
                }
            } else {
                Misc.free(columns.getAndSetQuick(primaryIndex, NullColumn.INSTANCE));
                Misc.free(columns.getAndSetQuick(secondaryIndex, NullColumn.INSTANCE));
                Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
            }
        }
        finally {
            path.trimTo(plen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadColumnChanges() {
        long pTransitionIndex = this.metadata.createTransitionIndex();
        try {
            this.metadata.applyTransitionIndex(pTransitionIndex);
            int columnCount = Unsafe.getUnsafe().getInt(pTransitionIndex + 4L);
            int columnCountBits = TableReader.getColumnBits(columnCount);
            if (columnCountBits > this.columnCountBits) {
                this.createNewColumnList(columnCount, pTransitionIndex, columnCountBits);
            } else {
                this.reshuffleColumns(columnCount, pTransitionIndex);
            }
            this.reshuffleSymbolMapReaders(pTransitionIndex);
            this.columnCount = columnCount;
        }
        finally {
            TableReaderMetadata.freeTransitionIndex(pTransitionIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadPartition(int partitionIndex, long rowCount, long openPartitionNameTxn, boolean lastPartition) {
        Path path = this.pathGenPartitioned(partitionIndex);
        TableUtils.txnPartitionConditionally(path, openPartitionNameTxn);
        try {
            int symbolMapIndex = 0;
            int columnBase = this.getColumnBase(partitionIndex);
            for (int i = 0; i < this.columnCount; ++i) {
                int index = TableReader.getPrimaryColumnIndex(columnBase, i);
                MappedReadOnlyMemory mem1 = this.columns.getQuick(index);
                if (mem1 instanceof NullColumn) {
                    this.reloadColumnAt(path, this.columns, this.columnTops, this.bitmapIndexes, columnBase, i, rowCount, lastPartition);
                } else {
                    TableReader.growColumn(mem1, this.columns.getQuick(index + 1), this.metadata.getColumnType(i), rowCount - this.getColumnTop(columnBase, i));
                }
                SymbolMapReader reader = this.symbolMapReaders.getQuick(i);
                if (reader == null) continue;
                reader.updateSymbolCount(this.symbolCountSnapshot.getQuick(symbolMapIndex++));
            }
        }
        finally {
            path.trimTo(this.rootLen);
        }
    }

    private boolean reloadSlow() {
        long prevStructVersion = this.txFile.getStructureVersion();
        long prevPartitionVersion = this.txFile.getPartitionTableVersion();
        if (this.readTxnSlow()) {
            this.reloadStruct(prevStructVersion);
            this.reconcileOpenPartitions(prevPartitionVersion);
            return true;
        }
        return false;
    }

    private void reloadStruct(long prevStructVersion) {
        if (prevStructVersion == this.txFile.getStructureVersion()) {
            return;
        }
        this.reloadStructSlow();
    }

    private void reloadStructSlow() {
        this.reloadColumnChanges();
        this.reloadSymbolMapCounts();
    }

    private void reloadSymbolMapCounts() {
        int symbolMapIndex = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) != 11) continue;
            this.symbolMapReaders.getQuick(i).updateSymbolCount(this.symbolCountSnapshot.getQuick(symbolMapIndex++));
        }
    }

    private SymbolMapReader reloadSymbolMapReader(int columnIndex, SymbolMapReader reader) {
        if (this.metadata.getColumnType(columnIndex) == 11) {
            if (reader instanceof SymbolMapReaderImpl) {
                ((SymbolMapReaderImpl)reader).of(this.configuration, this.path, this.metadata.getColumnName(columnIndex), 0);
                return reader;
            }
            return new SymbolMapReaderImpl(this.configuration, this.path, this.metadata.getColumnName(columnIndex), 0);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshuffleColumns(int columnCount, long pTransitionIndex) {
        long pIndexBase = pTransitionIndex + 8L;
        long pState = pIndexBase + (long)columnCount * 8L;
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = this.getColumnBase(partitionIndex);
            try {
                int i;
                Path path = this.pathGenPartitioned(partitionIndex).$();
                long partitionRowCount = this.openPartitionInfo.getQuick(partitionIndex * 4 + 1);
                boolean lastPartition = partitionIndex == this.partitionCount - 1;
                Vect.memset(pState, columnCount, 0);
                for (i = 0; i < columnCount; ++i) {
                    if (!TableReader.isEntryToBeProcessed(pState, i)) continue;
                    int copyFrom = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L) - 1;
                    if (copyFrom == i) {
                        MappedReadOnlyMemory col = this.columns.getQuick(TableReader.getPrimaryColumnIndex(base, i));
                        if ((!(col instanceof SinglePageMappedReadOnlyPageMemory) || !col.isDeleted()) && !(col instanceof NullColumn)) continue;
                        this.reloadColumnAt(path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount, lastPartition);
                        continue;
                    }
                    if (copyFrom > -1) {
                        this.fetchColumnsFrom(this.columns, this.columnTops, this.bitmapIndexes, base, copyFrom);
                        this.copyColumnsTo(this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount, lastPartition);
                        int copyTo = Unsafe.getUnsafe().getInt(pIndexBase + (long)i * 8L + 4L) - 1;
                        while (copyTo > -1 && TableReader.isEntryToBeProcessed(pState, copyTo)) {
                            this.copyColumnsTo(this.columns, this.columnTops, this.bitmapIndexes, base, copyTo, partitionRowCount, lastPartition);
                            copyTo = Unsafe.getUnsafe().getInt(pIndexBase + (long)(copyTo - 1) * 8L + 4L);
                        }
                        Misc.free(this.tempCopyStruct.mem1);
                        Misc.free(this.tempCopyStruct.mem2);
                        Misc.free(this.tempCopyStruct.backwardReader);
                        Misc.free(this.tempCopyStruct.forwardReader);
                        continue;
                    }
                    this.reloadColumnAt(path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount, lastPartition);
                }
                for (i = columnCount; i < this.columnCount; ++i) {
                    int index = TableReader.getPrimaryColumnIndex(base, i);
                    Misc.free(this.columns.getQuick(index));
                    Misc.free(this.columns.getQuick(index + 1));
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private static class ColumnCopyStruct {
        MappedReadOnlyMemory mem1;
        MappedReadOnlyMemory mem2;
        BitmapIndexReader backwardReader;
        BitmapIndexReader forwardReader;
        long top;

        private ColumnCopyStruct() {
        }
    }
}

