/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TableReaderMetadata
extends BaseRecordMetadata
implements Closeable {
    private final MappedReadOnlyMemory metaMem;
    private final Path path;
    private final FilesFacade ff;
    private final CharSequenceIntHashMap tmpValidationMap = new CharSequenceIntHashMap();
    private int id;
    private MappedReadOnlyMemory transitionMeta;

    public TableReaderMetadata(FilesFacade ff) {
        this.path = new Path();
        this.ff = ff;
        this.metaMem = new SinglePageMappedReadOnlyPageMemory();
        this.columnMetadata = new ObjList(this.columnCount);
        this.columnNameIndexMap = new CharSequenceIntHashMap();
    }

    public TableReaderMetadata(FilesFacade ff, Path path) {
        this(ff);
        this.of(path);
    }

    public TableReaderMetadata of(Path path) {
        this.path.of(path).$();
        try {
            this.metaMem.of(this.ff, path, this.ff.length(path));
            this.columnCount = this.metaMem.getInt(0L);
            this.columnNameIndexMap.clear();
            TableUtils.validate(this.ff, this.metaMem, this.columnNameIndexMap);
            this.timestampIndex = this.metaMem.getInt(8L);
            this.id = this.metaMem.getInt(16L);
            this.columnMetadata.clear();
            long offset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence name = this.metaMem.getStr(offset);
                assert (name != null);
                this.columnMetadata.add(new TableColumnMetadata(Chars.toString(name), TableUtils.getColumnType(this.metaMem, i), TableUtils.isColumnIndexed(this.metaMem, i), TableUtils.getIndexBlockCapacity(this.metaMem, i), true, null));
                offset += (long)VmUtils.getStorageLength(name);
            }
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        return this;
    }

    public static void freeTransitionIndex(long address) {
        if (address == 0L) {
            return;
        }
        Unsafe.free(address, Unsafe.getUnsafe().getInt(address));
    }

    public void applyTransitionIndex(long pTransitionIndex) {
        this.metaMem.of(this.ff, this.path, this.ff.getPageSize(), this.ff.length(this.path));
        this.columnNameIndexMap.clear();
        int columnCount = Unsafe.getUnsafe().getInt(pTransitionIndex + 4L);
        long index = pTransitionIndex + 8L;
        long stateAddress = index + (long)columnCount * 8L;
        if (columnCount > this.columnCount) {
            this.columnMetadata.setPos(columnCount);
            this.columnCount = columnCount;
        }
        Vect.memset(stateAddress, columnCount, 0);
        for (int i = 0; i < columnCount; ++i) {
            if (Unsafe.getUnsafe().getByte(stateAddress + (long)i) == -1) continue;
            Unsafe.getUnsafe().putByte(stateAddress + (long)i, (byte)-1);
            int copyFrom = Unsafe.getUnsafe().getInt(index + (long)i * 8L);
            if (copyFrom == i + 1) {
                this.columnNameIndexMap.put(((TableColumnMetadata)this.columnMetadata.getQuick(i)).getName(), i);
                continue;
            }
            if (copyFrom > 0) {
                TableColumnMetadata tmp = this.moveMetadata(copyFrom - 1, null);
                this.columnNameIndexMap.put(tmp.getName(), i);
                tmp = this.moveMetadata(i, tmp);
                int copyTo = Unsafe.getUnsafe().getInt(index + (long)i * 8L + 4L);
                while (copyTo > 0 && Unsafe.getUnsafe().getByte(stateAddress + (long)copyTo - 1L) != -1) {
                    Unsafe.getUnsafe().putByte(stateAddress + (long)copyTo - 1L, (byte)-1);
                    this.columnNameIndexMap.put(tmp.getName(), copyTo - 1);
                    tmp = this.moveMetadata(copyTo - 1, tmp);
                    copyTo = Unsafe.getUnsafe().getInt(index + (long)(copyTo - 1) * 8L + 4L);
                }
                continue;
            }
            TableColumnMetadata m = this.newInstance(i, columnCount);
            this.moveMetadata(i, m);
            this.columnNameIndexMap.put(m.getName(), i);
        }
        if (columnCount < this.columnCount) {
            this.columnMetadata.set(columnCount, this.columnCount, null);
            this.columnMetadata.setPos(columnCount);
            this.columnCount = columnCount;
        }
        this.timestampIndex = this.metaMem.getInt(8L);
    }

    public void cloneTo(AppendOnlyVirtualMemory mem) {
        long len = this.ff.length(this.metaMem.getFd());
        for (long p = 0L; p < len; ++p) {
            mem.putByte(this.metaMem.getByte(p));
        }
    }

    @Override
    public void close() {
        Misc.free(this.metaMem);
        Misc.free(this.path);
    }

    public long createTransitionIndex() {
        if (this.transitionMeta == null) {
            this.transitionMeta = new SinglePageMappedReadOnlyPageMemory();
        }
        this.transitionMeta.of(this.ff, this.path, this.ff.getPageSize(), this.ff.length(this.path));
        try (MappedReadOnlyMemory metaMem = this.transitionMeta;){
            long pTransitionIndex;
            this.tmpValidationMap.clear();
            TableUtils.validate(this.ff, metaMem, this.tmpValidationMap);
            int columnCount = metaMem.getInt(0L);
            int n = Math.max(this.columnCount, columnCount);
            int size = n * 16;
            long index = pTransitionIndex = Unsafe.calloc(size);
            Unsafe.getUnsafe().putInt(index, size);
            Unsafe.getUnsafe().putInt(index + 4L, columnCount);
            index += 8L;
            long offset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence name = metaMem.getStr(offset);
                offset += (long)VmUtils.getStorageLength(name);
                int oldPosition = this.columnNameIndexMap.get(name);
                if (oldPosition > -1 && TableUtils.getColumnType(metaMem, i) == TableUtils.getColumnType(this.metaMem, oldPosition) && TableUtils.isColumnIndexed(metaMem, i) == TableUtils.isColumnIndexed(this.metaMem, oldPosition)) {
                    Unsafe.getUnsafe().putInt(index + (long)i * 8L, oldPosition + 1);
                    Unsafe.getUnsafe().putInt(index + (long)oldPosition * 8L + 4L, i + 1);
                    continue;
                }
                Unsafe.getUnsafe().putLong(index + (long)i * 8L, 0L);
            }
            long l = pTransitionIndex;
            return l;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public int getId() {
        return this.id;
    }

    public int getPartitionBy() {
        return this.metaMem.getInt(4L);
    }

    public int getVersion() {
        return this.metaMem.getInt(12L);
    }

    public int getMaxUncommittedRows() {
        return this.metaMem.getInt(20L);
    }

    public long getO3CommitHysteresisMicros() {
        return this.metaMem.getLong(24L);
    }

    private TableColumnMetadata moveMetadata(int index, TableColumnMetadata metadata) {
        return this.columnMetadata.getAndSetQuick(index, metadata);
    }

    private TableColumnMetadata newInstance(int index, int columnCount) {
        long offset = TableUtils.getColumnNameOffset(columnCount);
        CharSequence name = null;
        for (int i = 0; i <= index; ++i) {
            name = this.metaMem.getStr(offset);
            offset += (long)VmUtils.getStorageLength(name);
        }
        assert (name != null);
        return new TableColumnMetadata(Chars.toString(name), TableUtils.getColumnType(this.metaMem, index), TableUtils.isColumnIndexed(this.metaMem, index), TableUtils.getIndexBlockCapacity(this.metaMem, index), true, null);
    }
}

