/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Rows;
import io.questdb.std.str.CharSink;

public class TableReaderRecord
implements Record {
    private int columnBase;
    private long recordIndex = 0L;
    private TableReader reader;

    @Override
    public BinarySequence getBin(int col) {
        long recordIndex = this.getAdjustedRecordIndex(col) * 8L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(recordIndex, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getBin(this.reader.getColumn(absoluteColumnIndex + 1).getLong(recordIndex));
    }

    @Override
    public long getBinLen(int col) {
        long recordIndex = this.getAdjustedRecordIndex(col) * 8L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(recordIndex, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getBinLen(this.reader.getColumn(absoluteColumnIndex + 1).getLong(recordIndex));
    }

    @Override
    public boolean getBool(int col) {
        long offset = this.getAdjustedRecordIndex(col);
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getBool(offset);
    }

    @Override
    public byte getByte(int col) {
        long offset = this.getAdjustedRecordIndex(col);
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getByte(offset);
    }

    @Override
    public double getDouble(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 8L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getDouble(offset);
    }

    @Override
    public float getFloat(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 4L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getFloat(offset);
    }

    @Override
    public int getInt(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 4L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getInt(offset);
    }

    @Override
    public long getLong(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 8L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getLong(offset);
    }

    @Override
    public long getRowId() {
        return Rows.toRowID(this.reader.getPartitionIndex(this.columnBase), this.recordIndex);
    }

    @Override
    public short getShort(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 2L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getShort(offset);
    }

    @Override
    public char getChar(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 2L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getChar(offset);
    }

    @Override
    public CharSequence getStr(int col) {
        long recordIndex = this.getAdjustedRecordIndex(col) * 8L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(recordIndex, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getColumn(absoluteColumnIndex).getStr(this.reader.getColumn(absoluteColumnIndex + 1).getLong(recordIndex));
    }

    @Override
    public void getLong256(int col, CharSink sink) {
        int index = TableReader.getPrimaryColumnIndex(this.columnBase, col);
        long offset = this.getAdjustedRecordIndex(col) * 32L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, index);
        this.reader.getColumn(absoluteColumnIndex).getLong256(offset, sink);
    }

    @Override
    public Long256 getLong256A(int col) {
        int index = TableReader.getPrimaryColumnIndex(this.columnBase, col);
        long offset = this.getAdjustedRecordIndex(col) * 32L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, index);
        return this.reader.getColumn(absoluteColumnIndex).getLong256A(offset);
    }

    @Override
    public Long256 getLong256B(int col) {
        int index = TableReader.getPrimaryColumnIndex(this.columnBase, col);
        long offset = this.getAdjustedRecordIndex(col) * 32L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, index);
        return this.reader.getColumn(absoluteColumnIndex).getLong256B(offset);
    }

    @Override
    public CharSequence getStrB(int col) {
        int index = TableReader.getPrimaryColumnIndex(this.columnBase, col);
        long recordIndex = this.getAdjustedRecordIndex(col) * 8L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(recordIndex, index);
        return this.reader.getColumn(absoluteColumnIndex).getStr2(this.reader.getColumn(absoluteColumnIndex + 1).getLong(recordIndex));
    }

    @Override
    public int getStrLen(int col) {
        int index = TableReader.getPrimaryColumnIndex(this.columnBase, col);
        long recordIndex = this.getAdjustedRecordIndex(col) * 8L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(recordIndex, index);
        return this.reader.getColumn(absoluteColumnIndex).getStrLen(this.reader.getColumn(absoluteColumnIndex + 1).getLong(recordIndex));
    }

    @Override
    public CharSequence getSym(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 4L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getSymbolMapReader(col).valueOf(this.reader.getColumn(absoluteColumnIndex).getInt(offset));
    }

    @Override
    public CharSequence getSymB(int col) {
        long offset = this.getAdjustedRecordIndex(col) * 4L;
        int absoluteColumnIndex = TableReaderRecord.ifOffsetNegThen0ElseValue(offset, TableReader.getPrimaryColumnIndex(this.columnBase, col));
        return this.reader.getSymbolMapReader(col).valueBOf(this.reader.getColumn(absoluteColumnIndex).getInt(offset));
    }

    public long getRecordIndex() {
        return this.recordIndex;
    }

    public void setRecordIndex(long recordIndex) {
        this.recordIndex = recordIndex;
    }

    public void incrementRecordIndex() {
        ++this.recordIndex;
    }

    public void jumpTo(int partitionIndex, long recordIndex) {
        this.columnBase = this.reader.getColumnBase(partitionIndex);
        this.recordIndex = recordIndex;
    }

    public void of(TableReader reader) {
        this.reader = reader;
    }

    public static int ifOffsetNegThen0ElseValue(long offset, int value) {
        int sign = (int)((offset >>> 63 ^ 0xFFFFFFFFFFFFFFFFL) & 1L);
        return value >>> 31 + sign;
    }

    private long getAdjustedRecordIndex(int col) {
        assert (col > -1 && col < this.reader.getColumnCount()) : "Column index out of bounds: " + col + " >= " + this.reader.getColumnCount();
        return this.recordIndex - this.reader.getColumnTop(this.columnBase, col);
    }
}

