/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TablePageFrameCursor;
import io.questdb.cairo.TableReaderSelectedColumnRecordCursor;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class TableReaderRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final TableReaderSelectedColumnRecordCursor cursor;
    private final CairoEngine engine;
    private final String tableName;
    private final long tableVersion;
    private final IntList columnIndexes;
    private final IntList columnSizes;
    private TablePageFrameCursor pageFrameCursor = null;
    private final boolean framingSupported;

    public TableReaderRecordCursorFactory(RecordMetadata metadata, CairoEngine engine, String tableName, long tableVersion, @NotNull IntList columnIndexes, @NotNull IntList columnSizes, boolean framingSupported) {
        super(metadata);
        this.cursor = new TableReaderSelectedColumnRecordCursor(columnIndexes);
        this.engine = engine;
        this.tableName = tableName;
        this.tableVersion = tableVersion;
        this.columnIndexes = columnIndexes;
        this.columnSizes = columnSizes;
        this.framingSupported = framingSupported;
    }

    @Override
    public void close() {
        Misc.free(this.cursor);
        Misc.free(this.pageFrameCursor);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName, this.tableVersion));
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext) {
        if (this.pageFrameCursor != null) {
            return this.pageFrameCursor.of(this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName), Long.MAX_VALUE, -1, this.columnIndexes, this.columnSizes);
        }
        if (this.framingSupported) {
            this.pageFrameCursor = new TablePageFrameCursor();
            return this.pageFrameCursor.of(this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName), Long.MAX_VALUE, -1, this.columnIndexes, this.columnSizes);
        }
        return null;
    }

    @Override
    public boolean supportPageFrameCursor() {
        return this.framingSupported;
    }
}

