/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableReaderRecordCursor;
import io.questdb.std.Rows;

public class TableReaderTailRecordCursor
extends TableReaderRecordCursor {
    private long txn = 0L;
    private long lastRowId = -1L;
    private long dataVersion = -1L;

    public void bookmark() {
        this.lastRowId = this.recordA.getRowId();
        this.txn = this.reader.getTxn();
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        this.bookmark();
        return false;
    }

    public boolean reload() {
        if (this.reader.reload()) {
            if (this.reader.getDataVersion() != this.dataVersion) {
                this.lastRowId = -1L;
                this.dataVersion = this.reader.getDataVersion();
                this.toTop();
            } else {
                this.seekToLastSeenRow();
            }
            this.txn = this.reader.getTxn();
            return true;
        }
        long txn = this.reader.getTxn();
        if (txn > this.txn) {
            this.txn = txn;
            this.seekToLastSeenRow();
            return true;
        }
        return false;
    }

    public void toBottom() {
        this.lastRowId = Rows.toRowID(this.reader.getPartitionCount() - 1, this.reader.getTransientRowCount() - 1L);
        this.startFrom(this.lastRowId);
        this.txn = this.reader.getTxn();
        this.dataVersion = this.reader.getDataVersion();
    }

    private void seekToLastSeenRow() {
        if (this.lastRowId > -1L) {
            this.startFrom(this.lastRowId);
        } else {
            this.toTop();
            this.dataVersion = this.reader.getDataVersion();
        }
    }
}

