/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TablePageFrameCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;

public class TableReplicationRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final TablePageFrameCursor cursor;
    private final CairoEngine engine;
    private final CharSequence tableName;
    private final long maxRowsPerFrame;
    private final IntList columnIndexes;
    private final IntList columnSizes;

    public TableReplicationRecordCursorFactory(CairoEngine engine, CharSequence tableName, long maxRowsPerFrame) {
        super(TableReplicationRecordCursorFactory.createMetadata(engine, tableName));
        this.maxRowsPerFrame = maxRowsPerFrame;
        this.cursor = new TablePageFrameCursor();
        this.engine = engine;
        this.tableName = tableName;
        int nCols = this.getMetadata().getColumnCount();
        this.columnIndexes = new IntList(nCols);
        this.columnSizes = new IntList(nCols);
        for (int columnIndex = 0; columnIndex < nCols; ++columnIndex) {
            int type = this.getMetadata().getColumnType(columnIndex);
            int typeSize = ColumnType.sizeOf(type);
            this.columnIndexes.add(columnIndex);
            this.columnSizes.add(Numbers.msb(typeSize));
        }
    }

    @Override
    public void close() {
        Misc.free(this.cursor);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TablePageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext) {
        return this.cursor.of(this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName), this.maxRowsPerFrame, -1, this.columnIndexes, this.columnSizes);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    public TablePageFrameCursor getPageFrameCursorFrom(SqlExecutionContext executionContext, int timestampColumnIndex, long nFirstRow) {
        long partitionRowCount;
        int partitionIndex;
        TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName);
        int partitionCount = reader.getPartitionCount();
        for (partitionIndex = 0; partitionIndex < partitionCount && nFirstRow >= (partitionRowCount = reader.openPartition(partitionIndex)); ++partitionIndex, nFirstRow -= partitionRowCount) {
        }
        return this.cursor.of(reader, this.maxRowsPerFrame, timestampColumnIndex, this.columnIndexes, this.columnSizes, partitionIndex, nFirstRow);
    }

    private static RecordMetadata createMetadata(CairoEngine engine, CharSequence tableName) {
        try (TableReader reader = engine.getReader(AllowAllCairoSecurityContext.INSTANCE, tableName, -1L);){
            GenericRecordMetadata genericRecordMetadata = GenericRecordMetadata.copyOf(reader.getMetadata());
            return genericRecordMetadata;
        }
    }
}

