/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.MappedReadWriteMemory;
import io.questdb.cairo.vm.PagedVirtualMemory;
import io.questdb.cairo.vm.ReadOnlyVirtualMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.griffin.SqlException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public final class TableUtils {
    public static final int TABLE_EXISTS = 0;
    public static final int TABLE_DOES_NOT_EXIST = 1;
    public static final int TABLE_RESERVED = 2;
    public static final String META_FILE_NAME = "_meta";
    public static final String TXN_FILE_NAME = "_txn";
    public static final String TXN_SCOREBOARD_FILE_NAME = "_txn_scoreboard";
    public static final String UPGRADE_FILE_NAME = "_upgrade.d";
    public static final String DETACHED_DIR_MARKER = ".detached";
    public static final String TAB_INDEX_FILE_NAME = "_tab_index.d";
    public static final int INITIAL_TXN = 0;
    public static final int NULL_LEN = -1;
    public static final int ANY_TABLE_VERSION = -1;
    public static final long TX_OFFSET_TRANSIENT_ROW_COUNT = 8L;
    public static final long TX_OFFSET_FIXED_ROW_COUNT = 16L;
    public static final long TX_OFFSET_STRUCT_VERSION = 40L;
    public static final long TX_OFFSET_TXN_CHECK = 64L;
    public static final long META_OFFSET_COUNT = 0L;
    public static final long META_OFFSET_TIMESTAMP_INDEX = 8L;
    public static final long META_OFFSET_VERSION = 12L;
    public static final long META_OFFSET_TABLE_ID = 16L;
    public static final long META_OFFSET_O3_MAX_UNCOMMITTED_ROWS = 20L;
    public static final long META_OFFSET_O3_COMMIT_HYSTERESIS_IN_MICROS = 24L;
    public static final String FILE_SUFFIX_I = ".i";
    public static final String FILE_SUFFIX_D = ".d";
    public static final int LONGS_PER_TX_ATTACHED_PARTITION = 4;
    public static final int LONGS_PER_TX_ATTACHED_PARTITION_MSB = Numbers.msb(4);
    static final int MIN_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(4);
    static final byte TODO_RESTORE_META = 2;
    static final byte TODO_TRUNCATE = 1;
    static final DateFormat fmtDay;
    static final DateFormat fmtMonth;
    static final DateFormat fmtYear;
    static final String DEFAULT_PARTITION_NAME = "default";
    static final long TX_OFFSET_TXN = 0L;
    static final long TX_OFFSET_MIN_TIMESTAMP = 24L;
    static final long TX_OFFSET_MAX_TIMESTAMP = 32L;
    static final long TX_OFFSET_DATA_VERSION = 48L;
    static final long TX_OFFSET_PARTITION_TABLE_VERSION = 56L;
    static final long TX_OFFSET_MAP_WRITER_COUNT = 72L;
    static final String META_SWAP_FILE_NAME = "_meta.swp";
    static final String META_PREV_FILE_NAME = "_meta.prev";
    static final long META_OFFSET_PARTITION_BY = 4L;
    static final long META_COLUMN_DATA_SIZE = 16L;
    static final long META_COLUMN_DATA_RESERVED = 3L;
    static final long META_OFFSET_COLUMN_TYPES = 128L;
    static final int META_FLAG_BIT_INDEXED = 1;
    static final int META_FLAG_BIT_SEQUENTIAL = 2;
    static final String TODO_FILE_NAME = "_todo_";
    private static final int MIN_SYMBOL_CAPACITY = 2;
    private static final int MAX_SYMBOL_CAPACITY;
    private static final int MAX_SYMBOL_CAPACITY_CACHED;
    private static final int MAX_INDEX_VALUE_BLOCK_SIZE;
    private static final Log LOG;
    private static final DateFormat fmtDefault;

    private TableUtils() {
    }

    public static void createTable(FilesFacade ff, AppendOnlyVirtualMemory memory, Path path, CharSequence root, TableStructure structure, int mkDirMode, int tableId) {
        TableUtils.createTable(ff, memory, path, root, structure, mkDirMode, 419, tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(FilesFacade ff, AppendOnlyVirtualMemory memory, Path path, CharSequence root, TableStructure structure, int mkDirMode, int tableVersion, int tableId) {
        LOG.debug().$("create table [name=").$(structure.getTableName()).$(']').$();
        path.of(root).concat(structure.getTableName());
        if (ff.mkdirs(path.slash$(), mkDirMode) != 0) {
            throw CairoException.instance(ff.errno()).put("could not create [dir=").put(path).put(']');
        }
        int rootLen = path.length();
        long dirFd = !ff.isRestrictedFileSystem() ? TableUtils.openRO(ff, path.$(), LOG) : 0L;
        try (AppendOnlyVirtualMemory mem = memory;){
            int i;
            mem.of(ff, path.trimTo(rootLen).concat(META_FILE_NAME).$(), ff.getPageSize());
            int count = structure.getColumnCount();
            path.trimTo(rootLen);
            mem.putInt(count);
            mem.putInt(structure.getPartitionBy());
            mem.putInt(structure.getTimestampIndex());
            mem.putInt(tableVersion);
            mem.putInt(tableId);
            mem.putInt(structure.getO3MaxUncommittedRows());
            mem.putLong(structure.getO3CommitHysteresisInMicros());
            mem.jumpTo(128L);
            for (i = 0; i < count; ++i) {
                mem.putByte((byte)structure.getColumnType(i));
                long flags = 0L;
                if (structure.isIndexed(i)) {
                    flags |= 1L;
                }
                if (structure.isSequential(i)) {
                    flags |= 2L;
                }
                mem.putLong(flags);
                mem.putInt(structure.getIndexBlockCapacity(i));
                mem.skip(3L);
            }
            for (i = 0; i < count; ++i) {
                mem.putStr(structure.getColumnName(i));
            }
            int symbolMapCount = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                if (structure.getColumnType(i2) != 11) continue;
                SymbolMapWriter.createSymbolMapFiles(ff, mem, path.trimTo(rootLen), structure.getColumnName(i2), structure.getSymbolCapacity(i2), structure.getSymbolCacheFlag(i2));
                ++symbolMapCount;
            }
            mem.of(ff, path.trimTo(rootLen).concat(TXN_FILE_NAME).$(), ff.getPageSize());
            TableUtils.resetTxn(mem, symbolMapCount, 0L, 0L, 0L);
            TableUtils.resetTodoLog(ff, path, rootLen, mem);
            path.trimTo(rootLen).concat(TXN_SCOREBOARD_FILE_NAME).$();
        }
        finally {
            if (dirFd > 0L) {
                if (ff.fsync(dirFd) != 0) {
                    LOG.error().$("could not fsync [fd=").$(dirFd).$(", errno=").$(ff.errno()).$(']').$();
                }
                ff.close(dirFd);
            }
        }
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name) {
        return TableUtils.exists(ff, path, root, name, 0, name.length());
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name, int lo, int hi) {
        path.of(root).concat(name, lo, hi).$();
        if (ff.exists(path)) {
            if (ff.exists(path.chop$().concat(TXN_FILE_NAME).$())) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public static long getColumnNameOffset(int columnCount) {
        return 128L + (long)columnCount * 16L;
    }

    public static int getColumnType(ReadOnlyVirtualMemory metaMem, int columnIndex) {
        return metaMem.getByte(128L + (long)columnIndex * 16L);
    }

    public static Timestamps.TimestampAddMethod getPartitionAdd(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return Timestamps.ADD_DD;
            }
            case 1: {
                return Timestamps.ADD_MM;
            }
            case 2: {
                return Timestamps.ADD_YYYY;
            }
        }
        throw new UnsupportedOperationException("partition by " + partitionBy + " does not have add method");
    }

    public static long getPartitionTableIndexOffset(int symbolWriterCount, int index) {
        return TableUtils.getPartitionTableIndexOffset(TableUtils.getPartitionTableSizeOffset(symbolWriterCount), index);
    }

    public static long getPartitionTableIndexOffset(long partitionTableOffset, int index) {
        return partitionTableOffset + 4L + (long)index * 8L;
    }

    public static long getPartitionTableSizeOffset(int symbolWriterCount) {
        return TableUtils.getSymbolWriterIndexOffset(symbolWriterCount);
    }

    public static long getSymbolWriterIndexOffset(int index) {
        return 76L + (long)index * 8L;
    }

    public static long getSymbolWriterTransientIndexOffset(int index) {
        return TableUtils.getSymbolWriterIndexOffset(index) + 4L;
    }

    public static long getTxMemSize(int symbolWriterCount, int attachedPartitionsSize) {
        return TableUtils.getPartitionTableIndexOffset(symbolWriterCount, attachedPartitionsSize);
    }

    public static boolean isValidColumnName(CharSequence seq) {
        int l = seq.length();
        for (int i = 0; i < l; ++i) {
            char c = seq.charAt(i);
            switch (c) {
                case '\u0000': 
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': 
                case '\ufeff': {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isValidInfluxColumnName(CharSequence seq) {
        int l = seq.length();
        block5: for (int i = 0; i < l; ++i) {
            switch (seq.charAt(i)) {
                default: {
                    continue block5;
                }
                case '\u0000': 
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '.': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': 
                case '~': 
                case '\ufeff': {
                    return false;
                }
                case '_': {
                    if (i >= 1) continue block5;
                    return false;
                }
                case '-': {
                    if (i != 0 && i != l - 1) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    public static long lock(FilesFacade ff, Path path) {
        long fd = ff.openRW(path);
        if (fd == -1L) {
            LOG.error().$("cannot open '").$(path).$("' to lock [errno=").$(ff.errno()).$(']').$();
            return -1L;
        }
        if (ff.lock(fd) != 0) {
            LOG.error().$("cannot lock '").$(path).$("' [errno=").$(ff.errno()).$(", fd=").$(fd).$(']').$();
            ff.close(fd);
            return -1L;
        }
        return fd;
    }

    public static void lockName(Path path) {
        path.put(".lock").$();
    }

    public static long mapRWOrClose(FilesFacade ff, LPSZ path, long fd, long size) {
        long mem = ff.mmap(fd, size, 0L, 2);
        if (mem == -1L) {
            ff.close(fd);
            throw CairoException.instance(ff.errno()).put("Could not mmap [file=").put(path).put(']');
        }
        return mem;
    }

    public static void oldPartitionName(Path path, long txn) {
        path.put("-x-").put(txn);
    }

    public static long openFileRWOrFail(FilesFacade ff, LPSZ path) {
        return TableUtils.openRW(ff, path, LOG);
    }

    public static long openRO(FilesFacade ff, LPSZ path, Log log) {
        long fd = ff.openRO(path);
        if (fd > -1L) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).$(']').$();
            return fd;
        }
        throw CairoException.instance(ff.errno()).put("could not open read-only [file=").put(path).put(']');
    }

    public static void renameOrFail(FilesFacade ff, Path src, Path dst) {
        if (!ff.rename(src, dst)) {
            throw CairoException.instance(ff.errno()).put("could not rename ").put(src).put(" -> ").put(dst);
        }
    }

    public static void resetTodoLog(FilesFacade ff, Path path, int rootLen, MappedReadWriteMemory mem) {
        mem.of(ff, path.trimTo(rootLen).concat(TODO_FILE_NAME).$(), ff.getPageSize());
        mem.putLong(24L, 0L);
        Unsafe.getUnsafe().storeFence();
        mem.putLong(8L, 0L);
        mem.putLong(16L, 0L);
        Unsafe.getUnsafe().storeFence();
        mem.putLong(0L, 0L);
        mem.putLong(32L, 0L);
        mem.setSize(40L);
    }

    public static void resetTxn(PagedVirtualMemory txMem, int symbolMapCount, long txn, long dataVersion, long partitionTableVersion) {
        txMem.putLong(0L, txn);
        Unsafe.getUnsafe().storeFence();
        txMem.putLong(8L, 0L);
        txMem.putLong(16L, 0L);
        txMem.putLong(24L, Long.MAX_VALUE);
        txMem.putLong(32L, Long.MIN_VALUE);
        txMem.putLong(40L, 0L);
        txMem.putLong(48L, dataVersion);
        txMem.putLong(56L, partitionTableVersion);
        txMem.putInt(72L, symbolMapCount);
        for (int i = 0; i < symbolMapCount; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            txMem.putInt(offset, 0);
            txMem.putInt(offset += 4L, 0);
        }
        Unsafe.getUnsafe().storeFence();
        txMem.putLong(64L, txn);
        txMem.putInt(TableUtils.getPartitionTableSizeOffset(symbolMapCount), 0);
        txMem.jumpTo(TableUtils.getPartitionTableIndexOffset(symbolMapCount, 0));
    }

    public static long setPathForPartition(Path path, int partitionBy, long timestamp, boolean calculatePartitionMax) {
        return TableUtils.setSinkForPartition(path.slash(), partitionBy, timestamp, calculatePartitionMax);
    }

    public static long setSinkForPartition(CharSink path, int partitionBy, long timestamp, boolean calculatePartitionMax) {
        switch (partitionBy) {
            case 0: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                int m = Timestamps.getMonthOfYear(timestamp, y, leap);
                int d = Timestamps.getDayOfMonth(timestamp, y, m, leap);
                TimestampFormatUtils.append000(path, y);
                path.put('-');
                TimestampFormatUtils.append0(path, m);
                path.put('-');
                TimestampFormatUtils.append0(path, d);
                if (calculatePartitionMax) {
                    return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)(d - 1) * 86400000000L + 86400000000L - 1L;
                }
                return 0L;
            }
            case 1: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                int m = Timestamps.getMonthOfYear(timestamp, y, leap);
                TimestampFormatUtils.append000(path, y);
                path.put('-');
                TimestampFormatUtils.append0(path, m);
                if (calculatePartitionMax) {
                    return Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)Timestamps.getDaysPerMonth(m, leap) * 24L * 3600000000L - 1L;
                }
                return 0L;
            }
            case 2: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                TimestampFormatUtils.append000(path, y);
                if (calculatePartitionMax) {
                    return Timestamps.addYear(Timestamps.yearMicros(y, leap), 1) - 1L;
                }
                return 0L;
            }
        }
        path.put(DEFAULT_PARTITION_NAME);
        return Long.MAX_VALUE;
    }

    public static int toIndexKey(int symbolKey) {
        return symbolKey == Integer.MIN_VALUE ? 0 : symbolKey + 1;
    }

    public static void txnPartition(CharSink path, long txn) {
        path.put('.').put(txn);
    }

    public static void txnPartitionConditionally(CharSink path, long txn) {
        if (txn > -1L) {
            TableUtils.txnPartition(path, txn);
        }
    }

    public static void validate(FilesFacade ff, MappedReadOnlyMemory metaMem, CharSequenceIntHashMap nameIndex) {
        try {
            int i;
            int timestampType;
            int metaVersion = metaMem.getInt(12L);
            if (419 != metaVersion && metaVersion != 404) {
                throw TableUtils.validationException(metaMem).put("Metadata version does not match runtime version");
            }
            int columnCount = metaMem.getInt(0L);
            long offset = TableUtils.getColumnNameOffset(columnCount);
            if (offset < (long)columnCount || columnCount > 0 && (offset < 0L || offset >= ff.length(metaMem.getFd()))) {
                throw TableUtils.validationException(metaMem).put("Incorrect columnCount: ").put(columnCount);
            }
            int timestampIndex = metaMem.getInt(8L);
            if (timestampIndex < -1 || timestampIndex >= columnCount) {
                throw TableUtils.validationException(metaMem).put("Timestamp index is outside of columnCount");
            }
            if (timestampIndex != -1 && (timestampType = TableUtils.getColumnType(metaMem, timestampIndex)) != 7) {
                throw TableUtils.validationException(metaMem).put("Timestamp column must be TIMESTAMP, but found ").put(ColumnType.nameOf(timestampType));
            }
            for (i = 0; i < columnCount; ++i) {
                int type = TableUtils.getColumnType(metaMem, i);
                if (ColumnType.sizeOf(type) == -1) {
                    throw TableUtils.validationException(metaMem).put("Invalid column type ").put(type).put(" at [").put(i).put(']');
                }
                if (!TableUtils.isColumnIndexed(metaMem, i)) continue;
                if (type != 11) {
                    throw TableUtils.validationException(metaMem).put("Index flag is only supported for SYMBOL").put(" at [").put(i).put(']');
                }
                if (TableUtils.getIndexBlockCapacity(metaMem, i) >= 2) continue;
                throw TableUtils.validationException(metaMem).put("Invalid index value block capacity ").put(TableUtils.getIndexBlockCapacity(metaMem, i)).put(" at [").put(i).put(']');
            }
            for (i = 0; i < columnCount; ++i) {
                CharSequence name = metaMem.getStr(offset);
                if (name == null || name.length() < 1) {
                    throw TableUtils.validationException(metaMem).put("NULL column name at [").put(i).put(']');
                }
                if (nameIndex.put(name, i)) {
                    offset += (long)VmUtils.getStorageLength(name);
                    continue;
                }
                throw TableUtils.validationException(metaMem).put("Duplicate column: ").put(name).put(" at [").put(i).put(']');
            }
        }
        catch (Throwable e) {
            nameIndex.clear();
            throw e;
        }
    }

    public static void validateIndexValueBlockSize(int position, int indexValueBlockSize) throws SqlException {
        if (indexValueBlockSize < MIN_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "min index block capacity is ").put(MIN_INDEX_VALUE_BLOCK_SIZE);
        }
        if (indexValueBlockSize > MAX_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "max index block capacity is ").put(MAX_INDEX_VALUE_BLOCK_SIZE);
        }
    }

    public static void validateSymbolCapacity(int position, int symbolCapacity) throws SqlException {
        if (symbolCapacity < 2) {
            throw SqlException.$(position, "min symbol capacity is ").put(2);
        }
        if (symbolCapacity > MAX_SYMBOL_CAPACITY) {
            throw SqlException.$(position, "max symbol capacity is ").put(MAX_SYMBOL_CAPACITY);
        }
    }

    public static void validateSymbolCapacityCached(boolean cache, int symbolCapacity, int cacheKeywordPosition) throws SqlException {
        if (cache && symbolCapacity > MAX_SYMBOL_CAPACITY_CACHED) {
            throw SqlException.$(cacheKeywordPosition, "max cached symbol capacity is ").put(MAX_SYMBOL_CAPACITY_CACHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeColumnTop(FilesFacade ff, Path path, CharSequence columnName, long columnTop, long tempBuf) {
        TableUtils.topFile(path, columnName);
        long fd = TableUtils.openRW(ff, path, LOG);
        try {
            Unsafe.getUnsafe().putLong(tempBuf, columnTop);
            O3Utils.allocateDiskSpace(ff, fd, 8L);
            if (ff.write(fd, tempBuf, 8L, 0L) != 8L) {
                throw CairoException.instance(ff.errno()).put("could not write top file [path=").put(path).put(']');
            }
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readLongAtOffset(FilesFacade ff, Path path, long tempMem8b, long offset) {
        long fd = TableUtils.openRO(ff, path, LOG);
        try {
            if (ff.read(fd, tempMem8b, 8L, offset) != 8L) {
                throw CairoException.instance(ff.errno()).put("Cannot read: ").put(path);
            }
            long l = Unsafe.getUnsafe().getLong(tempMem8b);
            return l;
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readColumnTop(FilesFacade ff, Path path, CharSequence name, int plen, long buf) {
        try {
            if (ff.exists(TableUtils.topFile(path.chop$(), name))) {
                long fd = TableUtils.openRO(ff, path, LOG);
                try {
                    if (ff.read(fd, buf, 8L, 0L) != 8L) {
                        throw CairoException.instance(Os.errno()).put("Cannot read top of column ").put(path);
                    }
                    long l = Unsafe.getUnsafe().getLong(buf);
                    return l;
                }
                finally {
                    ff.close(fd);
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            path.trimTo(plen);
        }
    }

    static LPSZ dFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(FILE_SUFFIX_D).$();
    }

    static LPSZ topFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".top").$();
    }

    static LPSZ iFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(FILE_SUFFIX_I).$();
    }

    static long getColumnFlags(ReadOnlyVirtualMemory metaMem, int columnIndex) {
        return metaMem.getLong(128L + (long)columnIndex * 16L + 1L);
    }

    static boolean isColumnIndexed(ReadOnlyVirtualMemory metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 1L) != 0L;
    }

    static boolean isSequential(ReadOnlyVirtualMemory metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 2L) != 0L;
    }

    static int getIndexBlockCapacity(ReadOnlyVirtualMemory metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 16L + 9L);
    }

    static int openMetaSwapFile(FilesFacade ff, AppendOnlyVirtualMemory mem, Path path, int rootLen, int retryCount) {
        try {
            path.concat(META_SWAP_FILE_NAME).$();
            int l = path.length();
            int index = 0;
            while (true) {
                if (index > 0) {
                    path.trimTo(l).put('.').put(index);
                    path.$();
                }
                if (!ff.exists(path) || ff.remove(path)) {
                    try {
                        mem.of(ff, path, ff.getPageSize());
                        int n = index;
                        return n;
                    }
                    catch (CairoException e) {
                        LOG.error().$("could not open swap [file=").$(path).$(", errno=").$(e.getErrno()).$(']').$();
                        continue;
                    }
                }
                LOG.error().$("could not remove swap [file=").$(path).$(", errno=").$(ff.errno()).$(']').$();
                {
                    if (++index < retryCount) continue;
                    throw CairoException.instance(0).put("Cannot open indexed file. Max number of attempts reached [").put(index).put("]. Last file tried: ").put(path);
                }
                break;
            }
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void openMetaSwapFileByIndex(FilesFacade ff, AppendOnlyVirtualMemory mem, Path path, int rootLen, int swapIndex) {
        try {
            path.concat(META_SWAP_FILE_NAME);
            if (swapIndex > 0) {
                path.put('.').put(swapIndex);
            }
            path.$();
            mem.of(ff, path, ff.getPageSize());
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    static String getTodoText(long code) {
        switch ((int)(code & 0xFFL)) {
            case 1: {
                return "truncate";
            }
            case 2: {
                return "restore meta";
            }
        }
        return "unknown";
    }

    private static CairoException validationException(MappedReadOnlyMemory mem) {
        return CairoException.instance(0).put("Invalid metadata at fd=").put(mem.getFd()).put(". ");
    }

    static boolean isSamePartition(long timestampA, long timestampB, int partitionBy) {
        switch (partitionBy) {
            case 3: {
                return true;
            }
            case 0: {
                return Timestamps.floorDD(timestampA) == Timestamps.floorDD(timestampB);
            }
            case 1: {
                return Timestamps.floorMM(timestampA) == Timestamps.floorMM(timestampB);
            }
            case 2: {
                return Timestamps.floorYYYY(timestampA) == Timestamps.floorYYYY(timestampB);
            }
        }
        throw CairoException.instance(0).put("Cannot compare timestamps for unsupported partition type: [").put(partitionBy).put(']');
    }

    static DateFormat getPartitionDateFmt(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return fmtDay;
            }
            case 1: {
                return fmtMonth;
            }
            case 2: {
                return fmtYear;
            }
            case 3: {
                return fmtDefault;
            }
        }
        throw new UnsupportedOperationException("partition by " + partitionBy + " does not have date format");
    }

    static Timestamps.TimestampFloorMethod getPartitionFloor(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return Timestamps.FLOOR_DD;
            }
            case 1: {
                return Timestamps.FLOOR_MM;
            }
            case 2: {
                return Timestamps.FLOOR_YYYY;
            }
        }
        throw new UnsupportedOperationException("partition by " + partitionBy + " does not have floor method");
    }

    static Timestamps.TimestampCeilMethod getPartitionCeil(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return Timestamps.CEIL_DD;
            }
            case 1: {
                return Timestamps.CEIL_MM;
            }
            case 2: {
                return Timestamps.CEIL_YYYY;
            }
        }
        throw new UnsupportedOperationException("partition by " + partitionBy + " does not have ceil method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readPartitionSizeMinMax(FilesFacade ff, Path path, CharSequence columnName, long tempMem16b, long timestamp) {
        int plen = path.chop$().length();
        try {
            if (ff.exists(path.concat(columnName).put(FILE_SUFFIX_D).$())) {
                long fd = TableUtils.openRO(ff, path, LOG);
                try {
                    long fileSize = ff.length(fd);
                    long mappedMem = ff.mmap(fd, fileSize, 0L, 1);
                    if (mappedMem < 0L) {
                        throw CairoException.instance(ff.errno()).put("Cannot map: ").put(path);
                    }
                    try {
                        long ts;
                        long maxTimestamp = timestamp;
                        long size = 0L;
                        long hi = mappedMem + fileSize;
                        for (long ptr = mappedMem; ptr < hi && (ts = Unsafe.getUnsafe().getLong(ptr)) >= maxTimestamp; ptr += 8L) {
                            maxTimestamp = ts;
                            ++size;
                        }
                        if (size > 0L) {
                            long minTimestamp = Unsafe.getUnsafe().getLong(mappedMem);
                            Unsafe.getUnsafe().putLong(tempMem16b, minTimestamp);
                            Unsafe.getUnsafe().putLong(tempMem16b + 8L, maxTimestamp);
                        }
                        long l = size;
                        ff.munmap(mappedMem, fileSize);
                        return l;
                    }
                    catch (Throwable throwable) {
                        ff.munmap(mappedMem, fileSize);
                        throw throwable;
                    }
                }
                finally {
                    ff.close(fd);
                }
            }
            throw CairoException.instance(0).put("Doesn't exist: ").put(path);
        }
        finally {
            path.trimTo(plen);
        }
    }

    static void createDirsOrFail(FilesFacade ff, Path path, int mkDirMode) {
        if (ff.mkdirs(path, mkDirMode) != 0) {
            throw CairoException.instance(ff.errno()).put("could not create directories [file=").put(path).put(']');
        }
    }

    static long openRW(FilesFacade ff, LPSZ path, Log log) {
        long fd = ff.openRW(path);
        if (fd > -1L) {
            log.debug().$("open [file=").$(path).$(", fd=").$(fd).$(']').$();
            return fd;
        }
        throw CairoException.instance(ff.errno()).put("could not open read-write [file=").put(path).put(']');
    }

    static {
        MAX_SYMBOL_CAPACITY = Numbers.ceilPow2(Integer.MAX_VALUE);
        MAX_SYMBOL_CAPACITY_CACHED = Numbers.ceilPow2(1000000);
        MAX_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(0x800000);
        LOG = LogFactory.getLog(TableUtils.class);
        TimestampFormatCompiler compiler = new TimestampFormatCompiler();
        fmtDay = compiler.compile("yyyy-MM-dd");
        fmtMonth = compiler.compile("yyyy-MM");
        fmtYear = compiler.compile("yyyy");
        fmtDefault = new DateFormat(){

            @Override
            public void format(long datetime, DateLocale locale, CharSequence timeZoneName, CharSink sink) {
                sink.put(TableUtils.DEFAULT_PARTITION_NAME);
            }

            @Override
            public long parse(CharSequence in, DateLocale locale) {
                return 0L;
            }

            @Override
            public long parse(CharSequence in, int lo, int hi, DateLocale locale) {
                return 0L;
            }
        };
    }
}

