/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.O3Basket;
import io.questdb.cairo.O3CallbackJob;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3MutableAtomicInteger;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3PartitionJob;
import io.questdb.cairo.O3PurgeDiscoveryJob;
import io.questdb.cairo.O3PurgeJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.RowFunction;
import io.questdb.cairo.SymbolColumnIndexer;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableBlockWriter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.TxWriter;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cairo.vm.ContiguousVirtualMemory;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.MappedReadWriteMemory;
import io.questdb.cairo.vm.PagedMappedReadWriteMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.cairo.vm.WriteOnlyVirtualMemory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.BinarySequence;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.Long256;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.O3CallbackTask;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import io.questdb.tasks.O3PartitionUpdateTask;
import io.questdb.tasks.O3PurgeDiscoveryTask;
import io.questdb.tasks.O3PurgeTask;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;

public class TableWriter
implements Closeable {
    public static final int TIMESTAMP_MERGE_ENTRY_BYTES = 16;
    public static final int O3_BLOCK_NONE = -1;
    public static final int O3_BLOCK_O3 = 1;
    public static final int O3_BLOCK_DATA = 2;
    public static final int O3_BLOCK_MERGE = 3;
    private static final int MEM_PAGE_SIZE = 0x1000000;
    private static final Log LOG = LogFactory.getLog(TableWriter.class);
    private static final CharSequenceHashSet IGNORED_FILES = new CharSequenceHashSet();
    private static final Runnable NOOP = () -> {};
    private static final RemoveFileLambda REMOVE_OR_LOG = TableWriter::removeFileAndOrLog;
    private static final RemoveFileLambda REMOVE_OR_EXCEPTION = TableWriter::removeOrException;
    final ObjList<AppendOnlyVirtualMemory> columns;
    private final ObjList<SymbolMapWriter> symbolMapWriters;
    private final ObjList<SymbolMapWriter> denseSymbolMapWriters;
    private final ObjList<WriterTransientSymbolCountChangeHandler> denseSymbolTransientCountHandlers;
    private final ObjList<ColumnIndexer> indexers;
    private final ObjList<ColumnIndexer> denseIndexers = new ObjList();
    private final Path path;
    private final Path other;
    private final LongList refs = new LongList();
    private final Row row = new Row();
    private final int rootLen;
    private final MappedReadOnlyMemory metaMem;
    private final int partitionBy;
    private final RowFunction switchPartitionFunction = new SwitchPartitionRowFunction();
    private final RowFunction openPartitionFunction = new OpenPartitionRowFunction();
    private final RowFunction noPartitionFunction = new NoPartitionFunction();
    private final RowFunction noTimestampFunction = new NoTimestampFunction();
    private final RowFunction o3RowFunction = new O3PartitionFunction();
    private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
    private final LongList columnTops;
    private final FilesFacade ff;
    private final DateFormat partitionDirFmt;
    private final AppendOnlyVirtualMemory ddlMem;
    private final int mkDirMode;
    private final int fileOperationRetryCount;
    private final CharSequence tableName;
    private final TableWriterMetadata metadata;
    private final CairoConfiguration configuration;
    private final CharSequenceIntHashMap validationMap = new CharSequenceIntHashMap();
    private final FragileCode RECOVER_FROM_META_RENAME_FAILURE = this::recoverFromMetaRenameFailure;
    private final SOCountDownLatch indexLatch = new SOCountDownLatch();
    private final LongList indexSequences = new LongList();
    private final MessageBus messageBus;
    private final boolean parallelIndexerEnabled;
    private final Timestamps.TimestampFloorMethod timestampFloorMethod;
    private final Timestamps.TimestampCeilMethod timestampCeilMethod;
    private final Timestamps.TimestampAddMethod timestampAddMethod;
    private final int defaultCommitMode;
    private final FindVisitor removePartitionDirectories = this::removePartitionDirectories0;
    private final ObjList<Runnable> nullSetters;
    private final ObjList<Runnable> o3NullSetters;
    private final ObjList<ContiguousVirtualMemory> o3Columns;
    private final ObjList<ContiguousVirtualMemory> o3Columns2;
    private final TableBlockWriter blockWriter;
    private final TimestampValueRecord dropPartitionFunctionRec = new TimestampValueRecord();
    private final ObjList<O3CallbackTask> o3PendingCallbackTasks = new ObjList();
    private final O3ColumnUpdateMethod oooSortVarColumnRef = this::o3SortVarColumn;
    private final O3ColumnUpdateMethod oooSortFixColumnRef = this::o3SortFixColumn;
    private final SOUnboundedCountDownLatch o3DoneLatch = new SOUnboundedCountDownLatch();
    private final AtomicLong o3PartitionUpdRemaining = new AtomicLong();
    private final AtomicInteger o3ErrorCount = new AtomicInteger();
    private final MappedReadWriteMemory todoMem = new PagedMappedReadWriteMemory();
    private final TxWriter txFile;
    private final FindVisitor removePartitionDirsNotAttached = this::removePartitionDirsNotAttached;
    private final LongList o3PartitionRemoveCandidates = new LongList();
    private final ObjectPool<O3MutableAtomicInteger> o3ColumnCounters = new ObjectPool<O3MutableAtomicInteger>(O3MutableAtomicInteger::new, 64);
    private final ObjectPool<O3Basket> o3BasketPool = new ObjectPool<O3Basket>(O3Basket::new, 64);
    private final TxnScoreboard txnScoreboard;
    private final StringSink o3Sink = new StringSink();
    private final NativeLPSZ o3NativeLPSZ = new NativeLPSZ();
    private final RingQueue<O3PartitionUpdateTask> o3PartitionUpdateQueue;
    private final MPSequence o3PartitionUpdatePubSeq;
    private final SCSequence o3PartitionUpdateSubSeq;
    private LongConsumer appendTimestampSetter;
    private long todoTxn;
    private ContiguousVirtualMemory o3TimestampMem;
    private ContiguousVirtualMemory o3TimestampMemCpy;
    private final O3ColumnUpdateMethod o3MoveHysteresisRef = this::o3MoveHysteresis0;
    private long lockFd = -1L;
    private LongConsumer timestampSetter;
    private int columnCount;
    private RowFunction rowFunction = this.openPartitionFunction;
    private boolean avoidIndexOnCommit = false;
    private long partitionTimestampHi;
    private long masterRef = 0L;
    private long o3MasterRef = -1L;
    private boolean removeDirOnCancelRow = true;
    private long tempMem16b = Unsafe.malloc(16L);
    private int metaSwapIndex;
    private int metaPrevIndex;
    private final FragileCode RECOVER_FROM_TODO_WRITE_FAILURE = this::recoverFromTodoWriteFailure;
    private final FragileCode RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE = this::recoverFromSymbolMapWriterFailure;
    private final FragileCode RECOVER_FROM_SWAP_RENAME_FAILURE = this::recoverFromSwapRenameFailure;
    private final FragileCode RECOVER_FROM_COLUMN_OPEN_FAILURE = this::recoverOpenColumnFailure;
    private int indexCount;
    private boolean performRecovery;
    private boolean distressed = false;
    private LifecycleManager lifecycleManager;
    private String designatedTimestampColumnName;
    private long o3RowCount;
    private final O3ColumnUpdateMethod o3MoveUncommittedRef = this::o3MoveUncommitted0;
    private long lastPartitionTimestamp;
    private boolean o3InError = false;
    private final boolean o3QuickSortEnabled;

    public TableWriter(CairoConfiguration configuration, CharSequence tableName) {
        this(configuration, tableName, new MessageBusImpl(configuration));
    }

    public TableWriter(CairoConfiguration configuration, CharSequence tableName, @NotNull MessageBus messageBus) {
        this(configuration, tableName, messageBus, true, DefaultLifecycleManager.INSTANCE);
    }

    public TableWriter(CairoConfiguration configuration, CharSequence tableName, @NotNull MessageBus messageBus, boolean lock, LifecycleManager lifecycleManager) {
        this(configuration, tableName, messageBus, lock, lifecycleManager, configuration.getRoot());
    }

    public TableWriter(CairoConfiguration configuration, CharSequence tableName, @NotNull MessageBus messageBus, boolean lock, LifecycleManager lifecycleManager, CharSequence root) {
        LOG.info().$("open '").utf8(tableName).$('\'').$();
        this.configuration = configuration;
        this.messageBus = messageBus;
        this.defaultCommitMode = configuration.getCommitMode();
        this.lifecycleManager = lifecycleManager;
        this.parallelIndexerEnabled = configuration.isParallelIndexingEnabled();
        this.ff = configuration.getFilesFacade();
        this.mkDirMode = configuration.getMkDirMode();
        this.fileOperationRetryCount = configuration.getFileOperationRetryCount();
        this.tableName = Chars.toString(tableName);
        this.o3QuickSortEnabled = configuration.isO3QuickSortEnabled();
        this.o3PartitionUpdateQueue = new RingQueue<O3PartitionUpdateTask>(O3PartitionUpdateTask.CONSTRUCTOR, configuration.getO3PartitionUpdateQueueCapacity());
        this.o3PartitionUpdatePubSeq = new MPSequence(this.o3PartitionUpdateQueue.getCapacity());
        this.o3PartitionUpdateSubSeq = new SCSequence();
        this.o3PartitionUpdatePubSeq.then(this.o3PartitionUpdateSubSeq).then(this.o3PartitionUpdatePubSeq);
        this.path = new Path();
        this.path.of(root).concat(tableName);
        this.other = new Path().of(root).concat(tableName);
        this.rootLen = this.path.length();
        this.blockWriter = new TableBlockWriter(configuration, messageBus);
        try {
            if (lock) {
                this.lock();
            } else {
                this.lockFd = -1L;
            }
            long todoCount = this.openTodoMem();
            int todo = todoCount > 0L ? (int)this.todoMem.getLong(40L) : -1;
            if (todo == 2) {
                this.repairMetaRename((int)this.todoMem.getLong(48L));
            }
            this.ddlMem = new AppendOnlyVirtualMemory();
            this.metaMem = new SinglePageMappedReadOnlyPageMemory();
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.metadata = new TableWriterMetadata(this.ff, this.metaMem);
            this.partitionBy = this.metaMem.getInt(4L);
            this.txFile = new TxWriter(this.ff, this.path, this.partitionBy);
            this.txnScoreboard = new TxnScoreboard(this.ff, this.path.trimTo(this.rootLen), configuration.getTxnScoreboardEntryCount());
            this.path.trimTo(this.rootLen);
            switch (todo) {
                case 1: {
                    this.repairTruncate();
                    break;
                }
                case -1: 
                case 2: {
                    break;
                }
                default: {
                    LOG.error().$("ignoring unknown *todo* [code=").$(todo).$(']').$();
                }
            }
            this.columnCount = this.metadata.getColumnCount();
            if (this.metadata.getTimestampIndex() > -1) {
                this.designatedTimestampColumnName = this.metadata.getColumnName(this.metadata.getTimestampIndex());
            }
            this.refs.extendAndSet(this.columnCount, 0L);
            this.columns = new ObjList(this.columnCount * 2);
            this.o3Columns = new ObjList(this.columnCount * 2);
            this.o3Columns2 = new ObjList(this.columnCount * 2);
            this.row.activeColumns = this.columns;
            this.symbolMapWriters = new ObjList(this.columnCount);
            this.indexers = new ObjList(this.columnCount);
            this.denseSymbolMapWriters = new ObjList(this.metadata.getSymbolMapCount());
            this.denseSymbolTransientCountHandlers = new ObjList(this.metadata.getSymbolMapCount());
            this.nullSetters = new ObjList(this.columnCount);
            this.o3NullSetters = new ObjList(this.columnCount);
            this.row.activeNullSetters = this.nullSetters;
            this.columnTops = new LongList(this.columnCount);
            if (this.partitionBy != 3) {
                this.timestampFloorMethod = TableUtils.getPartitionFloor(this.partitionBy);
                this.timestampCeilMethod = TableUtils.getPartitionCeil(this.partitionBy);
                this.timestampAddMethod = TableUtils.getPartitionAdd(this.partitionBy);
                this.partitionDirFmt = TableUtils.getPartitionDateFmt(this.partitionBy);
            } else {
                this.timestampFloorMethod = null;
                this.timestampCeilMethod = null;
                this.timestampAddMethod = null;
                this.partitionDirFmt = null;
            }
            this.executeDeferred();
        }
        catch (Throwable e) {
            this.doClose(false);
            throw e;
        }
    }

    public static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    public static int getSecondaryColumnIndex(int index) {
        return TableWriter.getPrimaryColumnIndex(index) + 1;
    }

    public static long getTimestampIndexValue(long timestampIndex, long indexRow) {
        return Unsafe.getUnsafe().getLong(timestampIndex + indexRow * 16L);
    }

    public static DateFormat selectPartitionDirFmt(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return TableUtils.fmtDay;
            }
            case 1: {
                return TableUtils.fmtMonth;
            }
            case 2: {
                return TableUtils.fmtYear;
            }
        }
        return null;
    }

    public void addColumn(CharSequence name, int type) {
        this.addColumn(name, type, this.configuration.getDefaultSymbolCapacity(), this.configuration.getDefaultSymbolCacheFlag(), false, 0, false);
    }

    public void addColumn(CharSequence name, int type, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential) {
        assert (indexValueBlockCapacity == Numbers.ceilPow2(indexValueBlockCapacity)) : "power of 2 expected";
        assert (symbolCapacity == Numbers.ceilPow2(symbolCapacity)) : "power of 2 expected";
        assert (TableUtils.isValidColumnName(name)) : "invalid column name";
        this.checkDistressed();
        if (TableWriter.getColumnIndexQuiet(this.metaMem, name, this.columnCount) != -1) {
            throw CairoException.instance(0).put("Duplicate column name: ").put(name);
        }
        LOG.info().$("adding column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("]' to ").$(this.path).$();
        this.commit();
        this.removeColumnFiles(name, type, REMOVE_OR_EXCEPTION);
        this.metaSwapIndex = this.addColumnToMeta(name, type, isIndexed, indexValueBlockCapacity, isSequential);
        this.metaMem.close();
        this.validateSwapMeta(name);
        this.renameMetaToMetaPrev(name);
        this.writeRestoreMetaTodo(name);
        this.renameSwapMetaToMeta(name);
        if (type == 11) {
            try {
                this.createSymbolMapWriter(name, symbolCapacity, symbolCacheFlag);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE, name, e);
            }
        } else {
            this.symbolMapWriters.extendAndSet(this.columnCount, null);
        }
        this.configureColumn(type, isIndexed);
        ++this.columnCount;
        this.columnTops.extendAndSet(this.columnCount - 1, this.txFile.getTransientRowCount());
        if (this.txFile.getTransientRowCount() > 0L || this.partitionBy == 3) {
            try {
                this.openNewColumnFiles(name, isIndexed, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_COLUMN_OPEN_FAILURE, name, e);
            }
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.txFile.bumpStructureVersion(this.denseSymbolMapWriters);
        this.metadata.addColumn(name, type, isIndexed, indexValueBlockCapacity);
        LOG.info().$("ADDED column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("]' to ").$(this.path).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(CharSequence columnName, int indexValueBlockSize) {
        assert (indexValueBlockSize == Numbers.ceilPow2(indexValueBlockSize)) : "power of 2 expected";
        this.checkDistressed();
        int columnIndex = TableWriter.getColumnIndexQuiet(this.metaMem, columnName, this.columnCount);
        if (columnIndex == -1) {
            throw CairoException.instance(0).put("Invalid column name: ").put(columnName);
        }
        this.commit();
        if (TableUtils.isColumnIndexed(this.metaMem, columnIndex)) {
            throw CairoException.instance(0).put("already indexed [column=").put(columnName).put(']');
        }
        int existingType = TableUtils.getColumnType(this.metaMem, columnIndex);
        LOG.info().$("adding index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).$(']').$();
        if (existingType != 11) {
            LOG.error().$("cannot create index for [column='").utf8(columnName).$(", type=").$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).$(']').$();
            throw CairoException.instance(0).put("cannot create index for [column='").put(columnName).put(", type=").put(ColumnType.nameOf(existingType)).put(", path=").put(this.path).put(']');
        }
        SymbolColumnIndexer indexer = new SymbolColumnIndexer();
        try {
            try {
                if (this.partitionBy != 3) {
                    long timestamp = this.indexHistoricPartitions(indexer, columnName, indexValueBlockSize);
                    if (timestamp == Long.MIN_VALUE) {
                        return;
                    }
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, timestamp, true);
                } else {
                    this.setStateForTimestamp(this.path, 0L, false);
                }
                this.indexLastPartition(indexer, columnName, columnIndex, indexValueBlockSize);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        catch (Throwable e) {
            LOG.error().$("rolling back index created so far [path=").$(this.path).$(']').$();
            this.removeIndexFiles(columnName);
            throw e;
        }
        this.metaSwapIndex = this.copyMetadataAndSetIndexed(columnIndex, indexValueBlockSize);
        this.metaMem.close();
        this.validateSwapMeta(columnName);
        this.renameMetaToMetaPrev(columnName);
        this.writeRestoreMetaTodo(columnName);
        this.renameSwapMetaToMeta(columnName);
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.txFile.bumpStructureVersion(this.denseSymbolMapWriters);
        this.indexers.extendAndSet(columnIndex / 2, indexer);
        this.populateDenseIndexerList();
        TableColumnMetadata columnMetadata = this.metadata.getColumnQuick(columnIndex);
        columnMetadata.setIndexed(true);
        columnMetadata.setIndexValueBlockCapacity(indexValueBlockSize);
        LOG.info().$("ADDED index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$("]' to ").$(this.path).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int attachPartition(long timestamp) {
        block20: {
            assert (this.metadata.getTimestampIndex() > -1);
            String timestampCol = this.metadata.getColumnQuick(this.metadata.getTimestampIndex()).getName();
            if (this.txFile.attachedPartitionsContains(timestamp)) {
                LOG.info().$("partition is already attached [path=").$(this.path).$(']').$();
                return 5;
            }
            if (this.metadata.getSymbolMapCount() > 0) {
                LOG.error().$("attaching partitions on table with symbols not yet supported [table=").$(this.tableName).$(",partition=").$ts(timestamp).I$();
                return 2;
            }
            boolean rollbackRename = false;
            try {
                TableUtils.setPathForPartition(this.path, this.partitionBy, timestamp, false);
                if (!this.ff.exists(this.path.$())) {
                    TableUtils.setPathForPartition(this.other, this.partitionBy, timestamp, false);
                    this.other.put(".detached");
                    if (this.ff.exists(this.other.$())) {
                        if (this.ff.rename(this.other, this.path)) {
                            rollbackRename = true;
                            LOG.info().$("moved partition dir: ").$(this.other).$(" to ").$(this.path).$();
                        } else {
                            throw CairoException.instance(this.ff.errno()).put("File system error on trying to rename [from=").put(this.other).put(",to=").put(this.path).put(']');
                        }
                    }
                }
                if (this.ff.exists(this.path.$())) {
                    long partitionSize = TableUtils.readPartitionSizeMinMax(this.ff, this.path, timestampCol, this.tempMem16b, timestamp);
                    if (partitionSize > 0L) {
                        if (this.inTransaction()) {
                            LOG.info().$("committing open transaction before applying attach partition command [table=").$(this.tableName).$(",partition=").$ts(timestamp).I$();
                            this.commit();
                        }
                        TableWriter.attachPartitionCheckFilesMatchMetadata(this.ff, this.path, this.getMetadata(), partitionSize);
                        long minPartitionTimestamp = Unsafe.getUnsafe().getLong(this.tempMem16b);
                        long maxPartitionTimestamp = Unsafe.getUnsafe().getLong(this.tempMem16b + 8L);
                        assert (timestamp <= minPartitionTimestamp && minPartitionTimestamp <= maxPartitionTimestamp);
                        long nextMinTimestamp = Math.min(minPartitionTimestamp, this.txFile.getMinTimestamp());
                        long nextMaxTimestamp = Math.max(maxPartitionTimestamp, this.txFile.getMaxTimestamp());
                        boolean appendPartitionAttached = this.size() == 0L || this.getPartitionLo(nextMaxTimestamp) > this.getPartitionLo(this.txFile.getMaxTimestamp());
                        this.txFile.beginPartitionSizeUpdate();
                        this.txFile.updatePartitionSizeByTimestamp(timestamp, partitionSize);
                        this.txFile.finishPartitionSizeUpdate(nextMinTimestamp, nextMaxTimestamp);
                        this.txFile.commit(this.defaultCommitMode, this.denseSymbolMapWriters);
                        if (appendPartitionAttached) {
                            this.freeColumns(true);
                            this.configureAppendPosition();
                        }
                    } else {
                        LOG.error().$("cannot detect partition size [path=").$(this.path).$(",timestampColumn=").$(timestampCol).$(']').$();
                        int n = 1;
                        return n;
                    }
                    LOG.info().$("partition attached [path=").$(this.path).$(']').$();
                    rollbackRename = false;
                    break block20;
                }
                LOG.error().$("cannot attach missing partition [path=").$(this.path).$(']').$();
                int n = 4;
                return n;
            }
            finally {
                if (rollbackRename) {
                    if (this.ff.rename(this.path.$(), this.other.$())) {
                        LOG.info().$("moved partition dir after failed attach attempt: ").$(this.path).$(" to ").$(this.other).$();
                    } else {
                        LOG.info().$("file system error on trying to rename partition folder [errno=").$(this.ff.errno()).$(",from=").$(this.path).$(",to=").$(this.other).I$();
                    }
                }
                this.path.trimTo(this.rootLen);
                this.other.trimTo(this.rootLen);
            }
        }
        return 0;
    }

    public void changeCacheFlag(int columnIndex, boolean cache) {
        this.checkDistressed();
        this.commit();
        SymbolMapWriter symbolMapWriter = this.getSymbolMapWriter(columnIndex);
        if (symbolMapWriter.isCached() == cache) {
            return;
        }
        symbolMapWriter.updateCacheFlag(cache);
        this.txFile.bumpStructureVersion(this.denseSymbolMapWriters);
    }

    @Override
    public void close() {
        if (null != this.blockWriter) {
            this.blockWriter.clear();
        }
        if (this.isOpen() && this.lifecycleManager.close()) {
            this.doClose(true);
        }
    }

    public void commit() {
        this.commit(this.defaultCommitMode);
    }

    public void commit(int commitMode) {
        this.commit(commitMode, 0L);
    }

    public boolean checkMaxAndCommitHysteresis() {
        if (this.getO3RowCount() < (long)this.metadata.getO3MaxUncommittedRows()) {
            return false;
        }
        this.commitHysteresis();
        return true;
    }

    public void commitHysteresis() {
        this.commit(this.defaultCommitMode, this.metadata.getO3CommitHysteresisInMicros());
    }

    public void commitHysteresis(long lastTimestampHysteresisInMicros) {
        this.commit(this.defaultCommitMode, lastTimestampHysteresisInMicros);
    }

    public int getColumnIndex(CharSequence name) {
        int index = this.metadata.getColumnIndexQuiet(name);
        if (index > -1) {
            return index;
        }
        throw CairoException.instance(0).put("Invalid column name: ").put(name);
    }

    public String getDesignatedTimestampColumnName() {
        return this.designatedTimestampColumnName;
    }

    public FilesFacade getFilesFacade() {
        return this.ff;
    }

    public long getMaxTimestamp() {
        return this.txFile.getMaxTimestamp();
    }

    public TableWriterMetadata getMetadata() {
        return this.metadata;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public int getPartitionCount() {
        return this.txFile.getPartitionCount();
    }

    public long getStructureVersion() {
        return this.txFile.getStructureVersion();
    }

    public int getSymbolIndex(int columnIndex, CharSequence symValue) {
        return this.symbolMapWriters.getQuick(columnIndex).put(symValue);
    }

    public CharSequence getTableName() {
        return this.tableName;
    }

    public long getTxn() {
        return this.txFile.getTxn();
    }

    public TxnScoreboard getTxnScoreboard() {
        return this.txnScoreboard;
    }

    public boolean inTransaction() {
        return this.txFile != null && (this.txFile.inTransaction() || this.hasO3());
    }

    public boolean isOpen() {
        return this.tempMem16b != 0L;
    }

    public TableBlockWriter newBlock() {
        this.bumpMasterRef();
        this.txFile.newBlock();
        this.blockWriter.open(this);
        return this.blockWriter;
    }

    public Row newRow(long timestamp) {
        return this.rowFunction.newRow(timestamp);
    }

    public Row newRow() {
        return this.newRow(0L);
    }

    public void o3BumpErrorCount() {
        this.o3ErrorCount.incrementAndGet();
    }

    public long partitionNameToTimestamp(CharSequence partitionName) {
        if (this.partitionDirFmt == null) {
            throw CairoException.instance(0).put("table is not partitioned");
        }
        try {
            return this.partitionDirFmt.parse(partitionName, null);
        }
        catch (NumericException e) {
            CairoException ee = CairoException.instance(0);
            switch (this.partitionBy) {
                case 0: {
                    ee.put("'YYYY-MM-DD'");
                    break;
                }
                case 1: {
                    ee.put("'YYYY-MM'");
                    break;
                }
                default: {
                    ee.put("'YYYY'");
                }
            }
            ee.put(" expected");
            throw ee;
        }
    }

    public void removeColumn(CharSequence name) {
        boolean timestamp;
        this.checkDistressed();
        int index = this.getColumnIndex(name);
        int type = this.metadata.getColumnType(index);
        LOG.info().$("removing column '").utf8(name).$("' from ").$(this.path).$();
        int timestampIndex = this.metaMem.getInt(8L);
        boolean bl = timestamp = index == timestampIndex;
        if (timestamp && this.partitionBy != 3) {
            throw CairoException.instance(0).put("Cannot remove timestamp from partitioned table");
        }
        this.commit();
        String timestampColumnName = timestampIndex != -1 ? this.metadata.getColumnName(timestampIndex) : null;
        this.metaSwapIndex = this.removeColumnFromMeta(index);
        this.metaMem.close();
        this.renameMetaToMetaPrev(name);
        this.writeRestoreMetaTodo(name);
        this.renameSwapMetaToMeta(name);
        this.removeColumn(index);
        this.removeSymbolMapWriter(index);
        --this.columnCount;
        if (timestamp) {
            this.txFile.resetTimestamp();
            this.timestampSetter = value -> {};
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
            this.removeColumnFiles(name, type, REMOVE_OR_LOG);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.txFile.bumpStructureVersion(this.denseSymbolMapWriters);
        this.metadata.removeColumn(name);
        if (timestamp) {
            this.metadata.setTimestampIndex(-1);
        } else if (timestampColumnName != null) {
            int timestampIndex2 = this.metadata.getColumnIndex(timestampColumnName);
            this.metadata.setTimestampIndex(timestampIndex2);
            this.o3TimestampMem = this.o3Columns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex2));
        }
        LOG.info().$("REMOVED column '").utf8(name).$("' from ").$(this.path).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePartition(long timestamp) {
        long minTimestamp = this.txFile.getMinTimestamp();
        long maxTimestamp = this.txFile.getMaxTimestamp();
        if (this.partitionBy == 3) {
            return false;
        }
        if ((timestamp = this.getPartitionLo(timestamp)) < this.getPartitionLo(minTimestamp) || timestamp > maxTimestamp) {
            return false;
        }
        if (timestamp == this.getPartitionLo(maxTimestamp)) {
            LOG.error().$("cannot remove active partition [path=").$(this.path).$(", maxTimestamp=").$ts(maxTimestamp).$(']').$();
            return false;
        }
        if (!this.txFile.attachedPartitionsContains(timestamp)) {
            LOG.error().$("partition is already detached [path=").$(this.path).$(']').$();
            return false;
        }
        try {
            this.setStateForTimestamp(this.path, timestamp, false);
            long nextMinTimestamp = minTimestamp;
            if (timestamp == this.txFile.getPartitionTimestamp(0)) {
                nextMinTimestamp = this.readMinTimestamp(this.txFile.getPartitionTimestamp(1));
            }
            this.txFile.beginPartitionSizeUpdate();
            this.txFile.removeAttachedPartitions(timestamp);
            this.txFile.setMinTimestamp(nextMinTimestamp);
            this.txFile.finishPartitionSizeUpdate(nextMinTimestamp, this.txFile.getMaxTimestamp());
            this.txFile.commit(this.defaultCommitMode, this.denseSymbolMapWriters);
            if (this.ff.exists(this.path.$())) {
                int errno = this.ff.rmdir(this.path.chop$().slash$());
                if (errno != 0) {
                    LOG.info().$("partition directory delete is postponed [path=").$(this.path).$(", errno=").$(errno).$(']').$();
                } else {
                    LOG.info().$("partition marked for delete [path=").$(this.path).$(']').$();
                }
            } else {
                LOG.info().$("partition absent on disk now detached from table [path=").$(this.path).$(']').$();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    public void removePartition(Function function, int posForError) throws SqlException {
        if (this.partitionBy == 3) {
            throw SqlException.$(posForError, "table is not partitioned");
        }
        if (this.txFile.getPartitionCount() == 0) {
            throw SqlException.$(posForError, "table is empty");
        }
        for (int i = this.txFile.getPartitionCount() - 1; i > -1; --i) {
            long partitionTimestamp = this.txFile.getPartitionTimestamp(i);
            this.dropPartitionFunctionRec.setTimestamp(partitionTimestamp);
            if (!function.getBool(this.dropPartitionFunctionRec)) continue;
            this.removePartition(partitionTimestamp);
        }
    }

    public void renameColumn(CharSequence currentName, CharSequence newName) {
        this.checkDistressed();
        int index = this.getColumnIndex(currentName);
        int type = this.metadata.getColumnType(index);
        LOG.info().$("renaming column '").utf8(currentName).$("' to '").utf8(newName).$("' from ").$(this.path).$();
        this.commit();
        this.metaSwapIndex = this.renameColumnFromMeta(index, newName);
        this.metaMem.close();
        this.renameMetaToMetaPrev(currentName);
        this.writeRestoreMetaTodo(currentName);
        this.renameSwapMetaToMeta(currentName);
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
            this.clearTodoLog();
            this.renameColumnFiles(currentName, newName, type);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.txFile.bumpStructureVersion(this.denseSymbolMapWriters);
        this.metadata.renameColumn(currentName, newName);
        if (index == this.metadata.getTimestampIndex()) {
            this.designatedTimestampColumnName = Chars.toString(newName);
        }
        LOG.info().$("RENAMED column '").utf8(currentName).$("' to '").utf8(newName).$("' from ").$(this.path).$();
    }

    public void rollback() {
        this.checkDistressed();
        if (this.o3InError || this.inTransaction()) {
            try {
                LOG.info().$("tx rollback [name=").$(this.tableName).$(']').$();
                if ((this.masterRef & 1L) != 0L) {
                    ++this.masterRef;
                }
                this.freeColumns(false);
                this.txFile.readUnchecked();
                this.rollbackIndexes();
                this.rollbackSymbolTables();
                this.purgeUnusedPartitions();
                this.configureAppendPosition();
                this.o3InError = false;
                LOG.info().$("tx rollback complete [name=").$(this.tableName).$(']').$();
            }
            catch (Throwable e) {
                LOG.error().$("could not perform rollback [name=").$(this.tableName).$(", msg=").$(e.getMessage()).$(']').$();
                this.distressed = true;
            }
        }
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaO3CommitHysteresis(long o3CommitHysteresisInMicros) {
        try {
            this.commit();
            long metaSize = this.copyMetadataAndUpdateVersion();
            TableUtils.openMetaSwapFileByIndex(this.ff, this.ddlMem, this.path, this.rootLen, this.metaSwapIndex);
            try {
                this.ddlMem.jumpTo(24L);
                this.ddlMem.putLong(o3CommitHysteresisInMicros);
                this.ddlMem.jumpTo(metaSize);
            }
            finally {
                this.ddlMem.close();
            }
            this.finishMetaSwapUpdate();
            this.metadata.setO3CommitHysteresisInMicros(o3CommitHysteresisInMicros);
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaO3MaxUncommittedRows(int maxUncommittedRows) {
        try {
            this.commit();
            long metaSize = this.copyMetadataAndUpdateVersion();
            TableUtils.openMetaSwapFileByIndex(this.ff, this.ddlMem, this.path, this.rootLen, this.metaSwapIndex);
            try {
                this.ddlMem.jumpTo(20L);
                this.ddlMem.putInt(maxUncommittedRows);
                this.ddlMem.jumpTo(metaSize);
            }
            finally {
                this.ddlMem.close();
            }
            this.finishMetaSwapUpdate();
            this.metadata.setO3MaxUncommittedRows(maxUncommittedRows);
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void finishMetaSwapUpdate() {
        this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        this.writeRestoreMetaTodo();
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException ex) {
            try {
                this.recoverFromTodoWriteFailure(null);
            }
            catch (CairoException ex2) {
                this.throwDistressException(ex2);
            }
            throw ex;
        }
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.txFile.bumpStructureVersion(this.denseSymbolMapWriters);
        this.metadata.setTableVersion();
    }

    public long size() {
        return this.txFile.getRowCount();
    }

    public String toString() {
        return "TableWriter{name=" + this.tableName + '}';
    }

    public void transferLock(long lockFd) {
        assert (lockFd != -1L);
        this.lockFd = lockFd;
    }

    public final void truncate() {
        int i;
        int n = this.denseSymbolMapWriters.size();
        for (i = 0; i < n; ++i) {
            this.denseSymbolMapWriters.getQuick(i).truncate();
        }
        if (this.size() == 0L) {
            return;
        }
        this.todoMem.putLong(0L, ++this.todoTxn);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
        this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(24L, this.todoTxn);
        this.todoMem.putLong(32L, 1L);
        this.todoMem.putLong(40L, 1L);
        this.todoMem.setSize(48L);
        for (i = 0; i < this.columnCount; ++i) {
            this.getPrimaryColumn(i).truncate();
            AppendOnlyVirtualMemory mem = this.getSecondaryColumn(i);
            if (mem == null) continue;
            mem.truncate();
        }
        if (this.partitionBy != 3) {
            this.freeColumns(false);
            if (this.indexers != null) {
                n = this.indexers.size();
                for (i = 0; i < n; ++i) {
                    Misc.free(this.indexers.getQuick(i));
                }
            }
            this.removePartitionDirectories();
            this.rowFunction = this.openPartitionFunction;
        }
        this.txFile.resetTimestamp();
        this.txFile.truncate();
        try {
            this.clearTodoLog();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        LOG.info().$("truncated [name=").$(this.tableName).$(']').$();
    }

    public void updateMetadataVersion() {
        this.checkDistressed();
        this.commit();
        this.copyMetadataAndUpdateVersion();
        this.metaMem.close();
        this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        try {
            TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.txFile.bumpStructureVersion(this.denseSymbolMapWriters);
        this.metadata.setTableVersion();
    }

    public void updateSymbols(int columnIndex, SymbolMapReader symReader) {
        SymbolMapWriter symWriter;
        int nDestinationSymbols;
        int nSourceSymbols = symReader.size();
        if (nSourceSymbols > (nDestinationSymbols = (symWriter = this.getSymbolMapWriter(columnIndex)).getSymbolCount())) {
            long address = symReader.symbolCharsAddressOf(nDestinationSymbols);
            long addressHi = symReader.symbolCharsAddressOf(nSourceSymbols);
            symWriter.appendSymbolCharsBlock(addressHi - address, address);
        }
    }

    public void warmUp() {
        Row r = this.newRow(Math.max(-62135596800000000L, this.txFile.getMaxTimestamp()));
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                r.putByte(i, (byte)0);
            }
        }
        finally {
            r.cancel();
        }
    }

    private static void removeFileAndOrLog(FilesFacade ff, LPSZ name) {
        if (ff.exists(name)) {
            if (ff.remove(name)) {
                LOG.info().$("removed: ").$(name).$();
            } else {
                LOG.error().$("cannot remove: ").utf8(name).$(" [errno=").$(ff.errno()).$(']').$();
            }
        }
    }

    private static void renameFileOrLog(FilesFacade ff, LPSZ name, LPSZ to) {
        if (ff.exists(name)) {
            if (ff.rename(name, to)) {
                LOG.info().$("renamed: ").$(name).$();
            } else {
                LOG.error().$("cannot rename: ").utf8(name).$(" [errno=").$(ff.errno()).$(']').$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indexAndCountDown(ColumnIndexer indexer, long lo, long hi, SOCountDownLatch latch) {
        try {
            indexer.refreshSourceAndIndex(lo, hi);
        }
        catch (CairoException e) {
            indexer.distress();
            LOG.error().$("index error [fd=").$(indexer.getFd()).$(']').$('{').$(e).$('}').$();
        }
        finally {
            latch.countDown();
        }
    }

    private static void removeOrException(FilesFacade ff, LPSZ path) {
        if (ff.exists(path) && !ff.remove(path)) {
            throw CairoException.instance(ff.errno()).put("Cannot remove ").put(path);
        }
    }

    private static void setColumnSize(FilesFacade ff, AppendOnlyVirtualMemory mem1, AppendOnlyVirtualMemory mem2, int type, long actualPosition, long buf, boolean ensureFileSize) {
        if (actualPosition > 0L) {
            switch (type) {
                case 13: {
                    long mem1Size;
                    assert (mem2 != null);
                    TableWriter.readOffsetBytes(ff, mem2, actualPosition, buf);
                    long offset = Unsafe.getUnsafe().getLong(buf);
                    TableWriter.readBytes(ff, mem1, buf, 8, offset, "Cannot read length, fd=");
                    long len = Unsafe.getUnsafe().getLong(buf);
                    long l = mem1Size = len == -1L ? offset + 8L : offset + len + 8L;
                    if (ensureFileSize) {
                        mem1.ensureFileSize(mem1.pageIndex(mem1Size));
                        mem2.ensureFileSize(mem2.pageIndex(actualPosition * 8L));
                    }
                    mem1.setSize(mem1Size);
                    mem2.setSize(actualPosition * 8L);
                    break;
                }
                case 10: {
                    long mem1Size;
                    assert (mem2 != null);
                    TableWriter.readOffsetBytes(ff, mem2, actualPosition, buf);
                    long offset = Unsafe.getUnsafe().getLong(buf);
                    TableWriter.readBytes(ff, mem1, buf, 4, offset, "Cannot read length, fd=");
                    long len = Unsafe.getUnsafe().getInt(buf);
                    long l = mem1Size = len == -1L ? offset + 4L : offset + len * 2L + 4L;
                    if (ensureFileSize) {
                        mem1.ensureFileSize(mem1.pageIndex(mem1Size));
                        mem2.ensureFileSize(mem2.pageIndex(actualPosition * 8L));
                    }
                    mem1.setSize(mem1Size);
                    mem2.setSize(actualPosition * 8L);
                    break;
                }
                default: {
                    long mem1Size = actualPosition << ColumnType.pow2SizeOf(type);
                    if (ensureFileSize) {
                        mem1.ensureFileSize(mem1.pageIndex(mem1Size));
                    }
                    mem1.setSize(mem1Size);
                    break;
                }
            }
        } else {
            mem1.setSize(0L);
            if (mem2 != null) {
                mem2.setSize(0L);
            }
        }
    }

    private static int getColumnIndexQuiet(MappedReadOnlyMemory metaMem, CharSequence name, int columnCount) {
        long nameOffset = TableUtils.getColumnNameOffset(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            CharSequence col = metaMem.getStr(nameOffset);
            if (Chars.equalsIgnoreCase(col, name)) {
                return i;
            }
            nameOffset += (long)VmUtils.getStorageLength(col);
        }
        return -1;
    }

    private static void readOffsetBytes(FilesFacade ff, AppendOnlyVirtualMemory mem, long position, long buf) {
        TableWriter.readBytes(ff, mem, buf, 8, (position - 1L) * 8L, "could not read offset, fd=");
    }

    private static void readBytes(FilesFacade ff, AppendOnlyVirtualMemory mem, long buf, int byteCount, long offset, CharSequence errorMsg) {
        if (ff.read(mem.getFd(), buf, byteCount, offset) != (long)byteCount) {
            throw CairoException.instance(ff.errno()).put(errorMsg).put(mem.getFd()).put(", offset=").put(offset);
        }
    }

    private static void configureNullSetters(ObjList<Runnable> nullers, int type, WriteOnlyVirtualMemory mem1, WriteOnlyVirtualMemory mem2) {
        switch (type) {
            case 0: 
            case 1: {
                nullers.add(() -> mem1.putByte((byte)0));
                break;
            }
            case 9: {
                nullers.add(() -> mem1.putDouble(Double.NaN));
                break;
            }
            case 8: {
                nullers.add(() -> mem1.putFloat(Float.NaN));
                break;
            }
            case 4: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                nullers.add(() -> mem1.putLong(Long.MIN_VALUE));
                break;
            }
            case 12: {
                nullers.add(() -> mem1.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 2: {
                nullers.add(() -> mem1.putShort((short)0));
                break;
            }
            case 3: {
                nullers.add(() -> mem1.putChar('\u0000'));
                break;
            }
            case 10: {
                nullers.add(() -> mem2.putLong(mem1.putNullStr()));
                break;
            }
            case 11: {
                nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 13: {
                nullers.add(() -> mem2.putLong(mem1.putNullBin()));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openMetaFile(FilesFacade ff, Path path, int rootLen, MappedReadOnlyMemory metaMem) {
        path.concat("_meta").$();
        try {
            metaMem.of(ff, path, ff.getPageSize(), ff.length(path));
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void attachPartitionCheckFilesMatchMetadata(FilesFacade ff, Path path, RecordMetadata metadata, long partitionSize) throws CairoException {
        rootLen = path.length();
        size = metadata.getColumnCount();
        block7: for (columnIndex = 0; columnIndex < size; ++columnIndex) {
            try {
                columnType = metadata.getColumnType(columnIndex);
                columnName = metadata.getColumnName(columnIndex);
                path.concat(columnName);
                switch (columnType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: {
                        TableWriter.attachPartitionCheckFilesMatchFixedColumn(ff, path, columnType, partitionSize);
                        ** break;
lbl13:
                        // 1 sources

                        continue block7;
                    }
                    case 10: 
                    case 13: {
                        TableWriter.attachPartitionCheckFilesMatchVarLenColumn(ff, path, partitionSize);
                        continue block7;
                    }
                    ** default:
lbl18:
                    // 1 sources

                    continue block7;
                }
            }
            finally {
                path.trimTo(rootLen);
            }
        }
    }

    private static void attachPartitionCheckFilesMatchVarLenColumn(FilesFacade ff, Path path, long partitionSize) {
        int pathLen = path.length();
        path.put(".i").$();
        if (ff.exists(path)) {
            int typeSize = 4;
            long fileSize = ff.length(path);
            if (fileSize < partitionSize * (long)typeSize) {
                throw CairoException.instance(0).put("Column file row count does not match timestamp file row count. Partition files inconsistent [file=").put(path).put(",expectedSize=").put(partitionSize * (long)typeSize).put(",actual=").put(fileSize).put(']');
            }
            path.trimTo(pathLen);
            path.put(".d").$();
            if (ff.exists(path)) {
                return;
            }
        }
        throw CairoException.instance(0).put("Column file does not exist [path=").put(path).put(']');
    }

    private static void attachPartitionCheckFilesMatchFixedColumn(FilesFacade ff, Path path, int columnType, long partitionSize) {
        path.put(".d").$();
        if (ff.exists(path)) {
            long fileSize = ff.length(path);
            if (fileSize < partitionSize << ColumnType.pow2SizeOf(columnType)) {
                throw CairoException.instance(0).put("Column file row count does not match timestamp file row count. Partition files inconsistent [file=").put(path).put(",expectedSize=").put(partitionSize << ColumnType.pow2SizeOf(columnType)).put(",actual=").put(fileSize).put(']');
            }
            return;
        }
        throw CairoException.instance(0).put("Column file does not exist [path=").put(path).put(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addColumnToMeta(CharSequence name, int type, boolean indexFlag, int indexValueBlockCapacity, boolean sequentialFlag) {
        int index;
        try {
            index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount + 1);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndHysteresis();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i);
            }
            this.ddlMem.putByte((byte)type);
            long flags = 0L;
            if (indexFlag) {
                flags |= 1L;
            }
            if (sequentialFlag) {
                flags |= 2L;
            }
            this.ddlMem.putLong(flags);
            this.ddlMem.putInt(indexValueBlockCapacity);
            this.ddlMem.skip(3L);
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)VmUtils.getStorageLength(columnName);
            }
            this.ddlMem.putStr(name);
        }
        finally {
            this.ddlMem.close();
        }
        return index;
    }

    private void copyVersionAndHysteresis() {
        this.ddlMem.putInt(419);
        this.ddlMem.putInt(this.metaMem.getInt(16L));
        this.ddlMem.putInt(this.metaMem.getInt(20L));
        this.ddlMem.putInt(this.metaMem.getInt(24L));
    }

    private void bumpMasterRef() {
        if ((this.masterRef & 1L) == 0L) {
            ++this.masterRef;
        } else {
            this.cancelRowAndBump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRow() {
        if ((this.masterRef & 1L) == 0L) {
            return;
        }
        long dirtyMaxTimestamp = this.txFile.getMaxTimestamp();
        long dirtyTransientRowCount = this.txFile.getTransientRowCount();
        long rollbackToMaxTimestamp = this.txFile.cancelToMaxTimestamp();
        long rollbackToTransientRowCount = this.txFile.cancelToTransientRowCount();
        if (dirtyTransientRowCount == 1L) {
            if (this.partitionBy != 3) {
                this.freeColumns(false);
                if (this.removeDirOnCancelRow) {
                    try {
                        this.setStateForTimestamp(this.path, dirtyMaxTimestamp, false);
                        int errno = this.ff.rmdir(this.path.$());
                        if (errno != 0) {
                            throw CairoException.instance(errno).put("Cannot remove directory: ").put(this.path);
                        }
                        this.removeDirOnCancelRow = false;
                    }
                    finally {
                        this.path.trimTo(this.rootLen);
                    }
                }
                if (rollbackToMaxTimestamp > Long.MIN_VALUE) {
                    try {
                        this.openPartition(rollbackToMaxTimestamp);
                        this.setAppendPosition(rollbackToTransientRowCount, false);
                    }
                    catch (Throwable e) {
                        this.freeColumns(false);
                        throw e;
                    }
                } else {
                    this.rowFunction = this.openPartitionFunction;
                }
                this.removeDirOnCancelRow = true;
                this.txFile.cancelRow();
            } else {
                this.txFile.cancelRow();
                for (int i = 0; i < this.columnCount; ++i) {
                    this.getPrimaryColumn(i).setSize(0L);
                    AppendOnlyVirtualMemory mem = this.getSecondaryColumn(i);
                    if (mem == null) continue;
                    mem.setSize(0L);
                }
            }
        } else {
            this.txFile.cancelRow();
            boolean rowChanged = false;
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.refs.getQuick(i) != this.masterRef) continue;
                rowChanged = true;
                break;
            }
            if (rowChanged) {
                this.setAppendPosition(dirtyTransientRowCount - 1L, false);
            }
        }
        this.refs.fill(0, this.columnCount, --this.masterRef);
        --this.txFile.transientRowCount;
    }

    private void cancelRowAndBump() {
        this.cancelRow();
        ++this.masterRef;
    }

    private void checkDistressed() {
        if (!this.distressed) {
            return;
        }
        throw new CairoError("Table '" + this.tableName.toString() + "' is distressed");
    }

    private void clearTodoLog() {
        try {
            this.todoMem.putLong(0L, ++this.todoTxn);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(8L, 0L);
            this.todoMem.putLong(16L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(32L, 0L);
            Unsafe.getUnsafe().storeFence();
            this.todoMem.putLong(24L, this.todoTxn);
            this.todoMem.setSize(40L);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    void closeActivePartition() {
        LOG.info().$("closing last partition [table=").$(this.tableName).I$();
        this.closeAppendMemoryNoTruncate(true);
        Misc.freeObjList(this.denseIndexers);
        this.denseIndexers.clear();
    }

    void closeActivePartition(long size) {
        for (int i = 0; i < this.columnCount; ++i) {
            AppendOnlyVirtualMemory mem1 = this.getPrimaryColumn(i);
            AppendOnlyVirtualMemory mem2 = this.getSecondaryColumn(i);
            TableWriter.setColumnSize(this.ff, mem1, mem2, TableUtils.getColumnType(this.metaMem, i), size - this.columnTops.getQuick(i), this.tempMem16b, false);
            Misc.free(mem1);
            Misc.free(mem2);
        }
        Misc.freeObjList(this.denseIndexers);
        this.denseIndexers.clear();
    }

    private void closeAppendMemoryNoTruncate(boolean truncate) {
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            AppendOnlyVirtualMemory m = this.columns.getQuick(i);
            if (m == null) continue;
            m.close(truncate);
        }
    }

    private void commit(int commitMode, long lastTimestampHysteresisInMicros) {
        this.checkDistressed();
        if (this.o3InError) {
            this.rollback();
            return;
        }
        if ((this.masterRef & 1L) != 0L) {
            this.cancelRow();
        }
        if (this.inTransaction()) {
            if (this.hasO3() && this.o3Commit(lastTimestampHysteresisInMicros)) {
                return;
            }
            if (commitMode != 2) {
                this.syncColumns(commitMode);
            }
            this.updateIndexes();
            this.txFile.commit(commitMode, this.denseSymbolMapWriters);
            this.o3ProcessPartitionRemoveCandidates();
        }
    }

    void commitBlock(long firstTimestamp) {
        if (this.txFile.getMinTimestamp() == Long.MAX_VALUE) {
            this.txFile.setMinTimestamp(firstTimestamp);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            this.refs.setQuick(i, this.masterRef);
        }
        ++this.masterRef;
        this.commit();
        this.setAppendPosition(this.txFile.getTransientRowCount(), true);
    }

    private void configureAppendPosition() {
        if (this.txFile.getMaxTimestamp() > Long.MIN_VALUE || this.partitionBy == 3) {
            this.openFirstPartition(this.txFile.getMaxTimestamp());
            if (this.partitionBy == 3) {
                if (this.metadata.getTimestampIndex() < 0) {
                    this.rowFunction = this.noTimestampFunction;
                } else {
                    this.rowFunction = this.noPartitionFunction;
                    this.timestampSetter = this.appendTimestampSetter;
                }
            } else {
                this.rowFunction = this.switchPartitionFunction;
                this.timestampSetter = this.appendTimestampSetter;
            }
        } else {
            this.rowFunction = this.openPartitionFunction;
            this.timestampSetter = this.appendTimestampSetter;
        }
        this.row.activeColumns = this.columns;
    }

    private void configureColumn(int type, boolean indexFlag) {
        ContiguousVirtualMemory oooSecondary2;
        ContiguousVirtualMemory oooSecondary;
        AppendOnlyVirtualMemory secondary;
        AppendOnlyVirtualMemory primary = new AppendOnlyVirtualMemory();
        ContiguousVirtualMemory oooPrimary = new ContiguousVirtualMemory(0x1000000L, Integer.MAX_VALUE);
        ContiguousVirtualMemory oooPrimary2 = new ContiguousVirtualMemory(0x1000000L, Integer.MAX_VALUE);
        switch (type) {
            case 10: 
            case 13: {
                secondary = new AppendOnlyVirtualMemory();
                oooSecondary = new ContiguousVirtualMemory(0x1000000L, Integer.MAX_VALUE);
                oooSecondary2 = new ContiguousVirtualMemory(0x1000000L, Integer.MAX_VALUE);
                break;
            }
            default: {
                secondary = null;
                oooSecondary = null;
                oooSecondary2 = null;
            }
        }
        this.columns.add(primary);
        this.columns.add(secondary);
        this.o3Columns.add(oooPrimary);
        this.o3Columns.add(oooSecondary);
        this.o3Columns2.add(oooPrimary2);
        this.o3Columns2.add(oooSecondary2);
        TableWriter.configureNullSetters(this.nullSetters, type, primary, secondary);
        TableWriter.configureNullSetters(this.o3NullSetters, type, oooPrimary, oooSecondary);
        if (indexFlag) {
            this.indexers.extendAndSet((this.columns.size() - 1) / 2, new SymbolColumnIndexer());
            this.populateDenseIndexerList();
        }
        this.refs.add(0L);
    }

    private void configureColumnMemory() {
        this.symbolMapWriters.setPos(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            this.configureColumn(type, this.metadata.isColumnIndexed(i));
            if (type == 11) {
                int symbolIndex = this.denseSymbolMapWriters.size();
                WriterTransientSymbolCountChangeHandler transientSymbolCountChangeHandler = new WriterTransientSymbolCountChangeHandler(symbolIndex);
                this.denseSymbolTransientCountHandlers.add(transientSymbolCountChangeHandler);
                SymbolMapWriter symbolMapWriter = new SymbolMapWriter(this.configuration, this.path.trimTo(this.rootLen), this.metadata.getColumnName(i), this.txFile.readSymbolCount(symbolIndex), transientSymbolCountChangeHandler);
                this.symbolMapWriters.extendAndSet(i, symbolMapWriter);
                this.denseSymbolMapWriters.add(symbolMapWriter);
            }
            if (!this.metadata.isColumnIndexed(i)) continue;
            this.indexers.extendAndSet(i, new SymbolColumnIndexer());
        }
        int timestampIndex = this.metadata.getTimestampIndex();
        if (timestampIndex != -1) {
            this.o3TimestampMem = this.o3Columns.getQuick(TableWriter.getPrimaryColumnIndex(timestampIndex));
            this.o3TimestampMemCpy = new ContiguousVirtualMemory(0x1000000L, Integer.MAX_VALUE);
        }
        this.populateDenseIndexerList();
    }

    private LongConsumer configureTimestampSetter() {
        int index = this.metadata.getTimestampIndex();
        if (index == -1) {
            return value -> {};
        }
        this.nullSetters.setQuick(index, NOOP);
        this.o3NullSetters.setQuick(index, NOOP);
        return this.getPrimaryColumn(index)::putLong;
    }

    private void consumeO3PartitionRemoveTasks() {
        block5: {
            Object task;
            long cursor;
            RingQueue<O3PurgeDiscoveryTask> discoveryQueue = this.messageBus.getO3PurgeDiscoveryQueue();
            MCSequence discoverySubSeq = this.messageBus.getO3PurgeDiscoverySubSeq();
            RingQueue<O3PurgeTask> purgeQueue = this.messageBus.getO3PurgeQueue();
            MPSequence purgePubSeq = this.messageBus.getO3PurgePubSeq();
            MCSequence purgeSubSeq = this.messageBus.getO3PurgeSubSeq();
            if (discoverySubSeq != null) {
                while (true) {
                    if ((cursor = discoverySubSeq.next()) > -1L) {
                        task = discoveryQueue.get(cursor);
                        O3PurgeDiscoveryJob.discoverPartitions(this.ff, this.o3Sink, this.o3NativeLPSZ, this.refs, purgeQueue, purgePubSeq, this.path, this.tableName, ((O3PurgeDiscoveryTask)task).getPartitionBy(), ((O3PurgeDiscoveryTask)task).getTimestamp(), this.txnScoreboard);
                        continue;
                    }
                    if (cursor == -1L) break;
                }
            }
            if (purgeSubSeq == null) break block5;
            while (true) {
                if ((cursor = purgeSubSeq.next()) > -1L) {
                    task = purgeQueue.get(cursor);
                    O3PurgeJob.purgePartitionDir(this.ff, this.other, ((O3PurgeTask)task).getPartitionBy(), ((O3PurgeTask)task).getTimestamp(), this.txnScoreboard, ((O3PurgeTask)task).getNameTxnToRemove(), ((O3PurgeTask)task).getMinTxnToExpect());
                    continue;
                }
                if (cursor == -1L) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyMetadataAndSetIndexed(int columnIndex, int indexValueBlockSize) {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndHysteresis();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                if (i != columnIndex) {
                    this.writeColumnEntry(i);
                    continue;
                }
                this.ddlMem.putByte((byte)TableUtils.getColumnType(this.metaMem, i));
                long flags = 1L;
                if (TableUtils.isSequential(this.metaMem, i)) {
                    flags |= 2L;
                }
                this.ddlMem.putLong(flags);
                this.ddlMem.putInt(indexValueBlockSize);
                this.ddlMem.skip(3L);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)VmUtils.getStorageLength(columnName);
            }
            int n = index;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyMetadataAndUpdateVersion() {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.copyVersionAndHysteresis();
            this.ddlMem.putInt(this.metaMem.getInt(20L));
            this.ddlMem.putLong(this.metaMem.getInt(24L));
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)VmUtils.getStorageLength(columnName);
            }
            this.metaSwapIndex = index;
            long l = nameOffset;
            return l;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFiles(CharSequence columnName, int indexValueBlockCapacity, int plen, boolean force) {
        try {
            BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName);
            if (!force && this.ff.exists(this.path)) {
                return;
            }
            try {
                this.ddlMem.of(this.ff, this.path, this.ff.getPageSize());
                BitmapIndexWriter.initKeyMemory(this.ddlMem, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                LOG.error().$("could not create index [name=").utf8(this.path).$(", errno=").$(e.getErrno()).$(']').$();
                if (!this.ff.remove(this.path)) {
                    LOG.error().$("could not remove '").utf8(this.path).$("'. Please remove MANUALLY.").$("[errno=").$(this.ff.errno()).$(']').$();
                }
                throw e;
            }
            finally {
                this.ddlMem.close();
            }
            if (!this.ff.touch(BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName))) {
                LOG.error().$("could not create index [name=").$(this.path).$(']').$();
                throw CairoException.instance(this.ff.errno()).put("could not create index [name=").put(this.path).put(']');
            }
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void createSymbolMapWriter(CharSequence name, int symbolCapacity, boolean symbolCacheFlag) {
        SymbolMapWriter.createSymbolMapFiles(this.ff, this.ddlMem, this.path, name, symbolCapacity, symbolCacheFlag);
        WriterTransientSymbolCountChangeHandler transientSymbolCountChangeHandler = new WriterTransientSymbolCountChangeHandler(this.denseSymbolMapWriters.size());
        this.denseSymbolTransientCountHandlers.add(transientSymbolCountChangeHandler);
        SymbolMapWriter w = new SymbolMapWriter(this.configuration, this.path, name, 0, transientSymbolCountChangeHandler);
        this.denseSymbolMapWriters.add(w);
        this.symbolMapWriters.extendAndSet(this.columnCount, w);
    }

    private void doClose(boolean truncate) {
        this.consumeO3PartitionRemoveTasks();
        boolean tx = this.inTransaction();
        this.freeColumns(truncate & !this.distressed);
        this.freeSymbolMapWriters();
        this.freeIndexers();
        Misc.free(this.txFile);
        Misc.free(this.blockWriter);
        Misc.free(this.metaMem);
        Misc.free(this.ddlMem);
        Misc.free(this.other);
        Misc.free(this.todoMem);
        try {
            this.releaseLock(!truncate | tx | this.performRecovery | this.distressed);
        }
        finally {
            Misc.free(this.txnScoreboard);
            Misc.free(this.path);
            Misc.free(this.o3TimestampMemCpy);
            this.freeTempMem();
            LOG.info().$("closed '").utf8(this.tableName).$('\'').$();
        }
    }

    private void executeDeferred() {
        this.configureColumnMemory();
        this.appendTimestampSetter = this.timestampSetter = this.configureTimestampSetter();
        this.txFile.readRowCounts();
        this.configureAppendPosition();
        this.purgeUnusedPartitions();
        this.clearTodoLog();
    }

    private void freeAndRemoveColumnPair(ObjList<?> columns, int pi, int si) {
        Misc.free(columns.getQuick(pi));
        Misc.free(columns.getQuick(si));
        columns.remove(pi);
        columns.remove(pi);
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            this.closeAppendMemoryNoTruncate(truncate);
        }
        Misc.freeObjListAndKeepObjects(this.o3Columns);
        Misc.freeObjListAndKeepObjects(this.o3Columns2);
    }

    private void freeIndexers() {
        if (this.indexers != null) {
            Misc.freeObjList(this.indexers);
            this.indexers.clear();
            this.denseIndexers.clear();
        }
    }

    private void freeSymbolMapWriters() {
        if (this.denseSymbolMapWriters != null) {
            int n = this.denseSymbolMapWriters.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.denseSymbolMapWriters.getQuick(i));
            }
            this.symbolMapWriters.clear();
        }
        if (this.symbolMapWriters != null) {
            this.symbolMapWriters.clear();
        }
    }

    private void freeTempMem() {
        if (this.tempMem16b != 0L) {
            Unsafe.free(this.tempMem16b, 16L);
            this.tempMem16b = 0L;
        }
    }

    BitmapIndexWriter getBitmapIndexWriter(int columnIndex) {
        return this.indexers.getQuick(columnIndex).getWriter();
    }

    long getColumnTop(int columnIndex) {
        return this.columnTops.getQuick(columnIndex);
    }

    CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    Sequence getO3CopyPubSeq() {
        return this.messageBus.getO3CopyPubSeq();
    }

    RingQueue<O3CopyTask> getO3CopyQueue() {
        return this.messageBus.getO3CopyQueue();
    }

    Sequence getO3OpenColumnPubSeq() {
        return this.messageBus.getO3OpenColumnPubSeq();
    }

    RingQueue<O3OpenColumnTask> getO3OpenColumnQueue() {
        return this.messageBus.getO3OpenColumnQueue();
    }

    Sequence getO3PartitionUpdatePubSeq() {
        return this.o3PartitionUpdatePubSeq;
    }

    RingQueue<O3PartitionUpdateTask> getO3PartitionUpdateQueue() {
        return this.o3PartitionUpdateQueue;
    }

    public long getO3RowCount() {
        return (this.masterRef - this.o3MasterRef + 1L) / 2L;
    }

    private long getPartitionLo(long timestamp) {
        return this.timestampFloorMethod.floor(timestamp);
    }

    long getPartitionNameTxnByIndex(int index) {
        return this.txFile.getPartitionNameTxnByIndex(index);
    }

    long getPartitionSizeByIndex(int index) {
        return this.txFile.getPartitionSizeByIndex(index);
    }

    long getPrimaryAppendOffset(long timestamp, int columnIndex) {
        if (this.txFile.getAppendedPartitionCount() == 0) {
            this.openFirstPartition(timestamp);
        }
        if (timestamp > this.partitionTimestampHi) {
            return 0L;
        }
        return this.columns.get(TableWriter.getPrimaryColumnIndex(columnIndex)).getAppendOffset();
    }

    private AppendOnlyVirtualMemory getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getPrimaryColumnIndex(column));
    }

    long getSecondaryAppendOffset(long timestamp, int columnIndex) {
        if (this.txFile.getAppendedPartitionCount() == 0) {
            this.openFirstPartition(timestamp);
        }
        if (timestamp > this.partitionTimestampHi) {
            return 0L;
        }
        return this.columns.get(TableWriter.getSecondaryColumnIndex(columnIndex)).getAppendOffset();
    }

    private AppendOnlyVirtualMemory getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getSecondaryColumnIndex(column));
    }

    SymbolMapWriter getSymbolMapWriter(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex);
    }

    int getTxPartitionCount() {
        return this.txFile.getAppendedPartitionCount();
    }

    private boolean hasO3() {
        return this.o3MasterRef > -1L && this.getO3RowCount() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long indexHistoricPartitions(SymbolColumnIndexer indexer, CharSequence columnName, int indexValueBlockSize) {
        long ts = this.txFile.getMaxTimestamp();
        if (ts > Long.MIN_VALUE) {
            long maxTimestamp = this.timestampFloorMethod.floor(ts);
            long timestamp = this.txFile.getMinTimestamp();
            try (SinglePageMappedReadOnlyPageMemory roMem = new SinglePageMappedReadOnlyPageMemory();){
                while (timestamp < maxTimestamp) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, timestamp, true);
                    if (this.txFile.attachedPartitionsContains(timestamp) && this.ff.exists(this.path.$())) {
                        int plen = this.path.length();
                        TableUtils.dFile(this.path.trimTo(plen), columnName);
                        if (this.ff.exists(this.path)) {
                            this.path.trimTo(plen);
                            LOG.info().$("indexing [path=").$(this.path).$(']').$();
                            this.createIndexFiles(columnName, indexValueBlockSize, plen, true);
                            long partitionSize = this.txFile.getPartitionSizeByPartitionTimestamp(timestamp);
                            long columnTop = TableUtils.readColumnTop(this.ff, this.path.trimTo(plen), columnName, plen, this.tempMem16b);
                            if (partitionSize > columnTop) {
                                TableUtils.dFile(this.path.trimTo(plen), columnName);
                                roMem.of(this.ff, this.path, this.ff.getPageSize(), 0L);
                                roMem.grow(partitionSize - columnTop << ColumnType.pow2SizeOf(4));
                                indexer.configureWriter(this.configuration, this.path.trimTo(plen), columnName, columnTop);
                                indexer.index(roMem, columnTop, partitionSize);
                            }
                        }
                    }
                    timestamp = this.timestampAddMethod.calculate(timestamp, 1);
                }
            }
            finally {
                indexer.close();
            }
            return timestamp;
        }
        return ts;
    }

    private void indexLastPartition(SymbolColumnIndexer indexer, CharSequence columnName, int columnIndex, int indexValueBlockSize) {
        int plen = this.path.length();
        this.createIndexFiles(columnName, indexValueBlockSize, plen, true);
        long columnTop = TableUtils.readColumnTop(this.ff, this.path.trimTo(plen), columnName, plen, this.tempMem16b);
        indexer.configureFollowerAndWriter(this.configuration, this.path.trimTo(plen), columnName, this.getPrimaryColumn(columnIndex), columnTop);
        indexer.refreshSourceAndIndex(0L, this.txFile.getTransientRowCount());
    }

    boolean isSymbolMapWriterCached(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex).isCached();
    }

    private void lock() {
        try {
            this.path.trimTo(this.rootLen);
            TableUtils.lockName(this.path);
            this.performRecovery = this.ff.exists(this.path);
            this.lockFd = TableUtils.lock(this.ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.lockFd == -1L) {
            throw CairoException.instance(this.ff.errno()).put("Cannot lock table: ").put(this.path.$());
        }
    }

    private long o3CalculatedMoveUncommittedSize(long transientRowsAdded, long committedTransientRowCount) {
        for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
            long varLenMappedBytes;
            long varFileAppendOffset;
            long varFileMappedOffset;
            int columnType = this.metadata.getColumnType(colIndex);
            AppendOnlyVirtualMemory primaryColumn = this.getPrimaryColumn(colIndex);
            AppendOnlyVirtualMemory secondaryColumn = this.getSecondaryColumn(colIndex);
            int shl = ColumnType.pow2SizeOf(columnType);
            if (secondaryColumn == null) {
                long srcMappedRows = primaryColumn.offsetInPage(committedTransientRowCount + transientRowsAdded << shl) >> shl;
                if (srcMappedRows < transientRowsAdded) {
                    long delta = transientRowsAdded - srcMappedRows;
                    committedTransientRowCount += delta;
                    transientRowsAdded -= delta;
                }
                assert (primaryColumn.addressOf(committedTransientRowCount << shl) > 0L);
                continue;
            }
            shl = 3;
            long fixLenMappedRows = secondaryColumn.offsetInPage(secondaryColumn.getAppendOffset()) >> shl;
            if (fixLenMappedRows < transientRowsAdded) {
                committedTransientRowCount += transientRowsAdded - fixLenMappedRows;
                transientRowsAdded = fixLenMappedRows;
            }
            assert (secondaryColumn.addressOf(committedTransientRowCount << shl) > 0L);
            long varFileCommittedOffset = secondaryColumn.getLong(committedTransientRowCount << shl);
            if (varFileCommittedOffset >= (varFileMappedOffset = (varFileAppendOffset = primaryColumn.getAppendOffset()) - (varLenMappedBytes = primaryColumn.offsetInPage(primaryColumn.getAppendOffset())))) continue;
            long firstMappedVarColRowOffset = Vect.binarySearch64Bit(secondaryColumn.addressOf(committedTransientRowCount << shl), varFileMappedOffset, 0L, fixLenMappedRows - 1L, 1);
            if (firstMappedVarColRowOffset < 0L) {
                firstMappedVarColRowOffset = -firstMappedVarColRowOffset - 1L;
            }
            assert ((transientRowsAdded -= firstMappedVarColRowOffset) >= 0L);
            assert (primaryColumn.addressOf(secondaryColumn.getLong((committedTransientRowCount += firstMappedVarColRowOffset) << shl)) > 0L);
        }
        return transientRowsAdded;
    }

    void o3ClockDownPartitionUpdateCount() {
        this.o3PartitionUpdRemaining.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean o3Commit(long hysteresis) {
        this.o3RowCount = this.getO3RowCount();
        this.o3PartitionRemoveCandidates.clear();
        this.o3ErrorCount.set(0);
        this.o3ColumnCounters.clear();
        this.o3BasketPool.clear();
        o3HysteresisRowCount = 0L;
        o3MaxUncommittedRows = this.metadata.getO3MaxUncommittedRows();
        timestampIndex = this.metadata.getTimestampIndex();
        this.lastPartitionTimestamp = this.timestampFloorMethod.floor(this.partitionTimestampHi);
        try {
            this.o3RowCount += this.o3MoveUncommitted(timestampIndex);
            TableWriter.LOG.info().$("sorting o3 [table=").$(this.tableName).$(']').$();
            sortedTimestampsAddr = this.o3TimestampMem.addressOf(0L);
            if (this.o3RowCount > 600L || !this.o3QuickSortEnabled) {
                this.o3TimestampMemCpy.jumpTo(this.o3TimestampMem.getAppendOffset());
                Vect.radixSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount, this.o3TimestampMemCpy.addressOf(0L));
            } else {
                Vect.quickSortLongIndexAscInPlace(sortedTimestampsAddr, this.o3RowCount);
            }
            o3TimestampMin = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, 0L);
            if (o3TimestampMin < -62135596800000000L) {
                throw CairoException.instance(0).put("timestamps before 0001-01-01 are not allowed for O3");
            }
            if (hysteresis > 0L) {
                o3max = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, this.o3RowCount - 1L);
                hysteresisThresholdTimestamp = o3max - hysteresis;
                if (hysteresisThresholdTimestamp >= o3TimestampMin) {
                    hysteresisThresholdRow = Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, hysteresisThresholdTimestamp, 0L, this.o3RowCount - 1L, 1);
                    o3HysteresisRowCount = this.o3RowCount - hysteresisThresholdRow - 1L;
                    if (o3HysteresisRowCount > o3MaxUncommittedRows) {
                        o3HysteresisRowCount = o3MaxUncommittedRows;
                        srcOooMax = this.o3RowCount - o3MaxUncommittedRows;
                    } else {
                        srcOooMax = hysteresisThresholdRow + 1L;
                    }
                } else {
                    o3HysteresisRowCount = this.o3RowCount;
                    srcOooMax = 0L;
                }
                TableWriter.LOG.debug().$("o3 commit hysteresis [table=").$(this.tableName).$(", hysteresis=").$(hysteresis).$(", o3MaxUncommittedRows=").$(o3MaxUncommittedRows).$(", o3max=").$ts(o3max).$(", hysteresisThresholdTimestamp=").$ts(hysteresisThresholdTimestamp).$(", o3HysteresisRowCount=").$(o3HysteresisRowCount).$(", srcOooMax=").$(srcOooMax).$(", o3RowCount=").$(this.o3RowCount).I$();
            } else {
                TableWriter.LOG.debug().$("o3 commit no hysteresis [table=").$(this.tableName).$(", o3RowCount=").$(this.o3RowCount).I$();
                srcOooMax = this.o3RowCount;
            }
            if (srcOooMax == 0L) {
                o3max = true;
                if (this.denseIndexers.size() == 0) {
                    this.populateDenseIndexerList();
                }
                this.path.trimTo(this.rootLen);
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var69_51) {
            if (this.denseIndexers.size() == 0) {
                this.populateDenseIndexerList();
            }
            this.path.trimTo(this.rootLen);
            v0 = this.avoidIndexOnCommit = this.o3ErrorCount.get() == 0;
            if (o3HysteresisRowCount == 0L) {
                this.o3MasterRef = -1L;
                this.rowFunction = this.switchPartitionFunction;
                Row.access$502(this.row, this.columns);
                Row.access$602(this.row, this.nullSetters);
            } else {
                this.o3MasterRef = this.masterRef - o3HysteresisRowCount * 2L + 1L;
            }
            TableWriter.LOG.debug().$("adjusted [o3RowCount=").$(this.getO3RowCount()).I$();
            throw var69_51;
        }
        v1 = this.avoidIndexOnCommit = this.o3ErrorCount.get() == 0;
        if (o3HysteresisRowCount == 0L) {
            this.o3MasterRef = -1L;
            this.rowFunction = this.switchPartitionFunction;
            Row.access$502(this.row, this.columns);
            Row.access$602(this.row, this.nullSetters);
        } else {
            this.o3MasterRef = this.masterRef - o3HysteresisRowCount * 2L + 1L;
        }
        TableWriter.LOG.debug().$("adjusted [o3RowCount=").$(this.getO3RowCount()).I$();
        return o3max;
lbl-1000:
        // 1 sources

        {
            o3TimestampMax = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOooMax - 1L);
            maxTimestamp = this.txFile.getMaxTimestamp();
            this.o3Sort(sortedTimestampsAddr, timestampIndex, this.o3RowCount);
            TableWriter.LOG.info().$("sorted [table=").utf8(this.tableName).I$();
            this.o3DoneLatch.reset();
            this.o3PartitionUpdRemaining.set(0L);
            success = true;
            latchCount = 0;
            srcOoo = 0L;
            flattenTimestamp = true;
            pCount = 0;
lbl88:
            // 2 sources

            try {
                while (srcOoo < srcOooMax) {
                    try {
                        block38: {
                            srcOooLo = srcOoo;
                            o3Timestamp = TableWriter.getTimestampIndexValue(sortedTimestampsAddr, srcOoo);
                            srcOooTimestampCeil = this.timestampCeilMethod.ceil(o3Timestamp);
                            srcOooHi = srcOooTimestampCeil < o3TimestampMax ? Vect.boundedBinarySearchIndexT(sortedTimestampsAddr, srcOooTimestampCeil, srcOoo, srcOooMax - 1L, 1) : srcOooMax - 1L;
                            partitionTimestamp = this.timestampFloorMethod.floor(o3Timestamp);
                            last = partitionTimestamp == this.lastPartitionTimestamp;
                            srcOoo = srcOooHi + 1L;
                            partitionIndex = this.txFile.findAttachedPartitionIndexByLoTimestamp(partitionTimestamp);
                            if (partitionIndex > -1) {
                                srcDataSize = last != false ? this.txFile.transientRowCount : this.getPartitionSizeByIndex(partitionIndex);
                                srcNameTxn = this.getPartitionNameTxnByIndex(partitionIndex);
                            } else {
                                srcDataSize = -1L;
                                srcNameTxn = -1L;
                            }
                            append = last != false && (srcDataSize < 0L || o3Timestamp >= maxTimestamp);
                            TableWriter.LOG.debug().$("o3 partition task [table=").$(this.tableName).$(", srcOooLo=").$(srcOooLo).$(", srcOooHi=").$(srcOooHi).$(", srcOooMax=").$(srcOooMax).$(", o3TimestampMin=").$ts(o3TimestampMin).$(", o3Timestamp=").$ts(o3Timestamp).$(", o3TimestampMax=").$ts(o3TimestampMax).$(", partitionTimestamp=").$ts(partitionTimestamp).$(", partitionIndex=").$(partitionIndex).$(", srcDataSize=").$(srcDataSize).$(", maxTimestamp=").$ts(maxTimestamp).$(", last=").$(last).$(", append=").$(append).$(", memUsed=").$(Unsafe.getMemUsed()).I$();
                            ++pCount;
                            this.o3PartitionUpdRemaining.incrementAndGet();
                            o3Basket = this.o3BasketPool.next();
                            o3Basket.ensureCapacity(this.columnCount, this.indexCount);
                            columnCounter = this.o3ColumnCounters.next();
                            columnCounter.set(this.columnCount);
                            ++latchCount;
                            if (!append) break block38;
                            pathToPartition = Path.getThreadLocal(this.path);
                            TableUtils.setPathForPartition(pathToPartition, this.partitionBy, o3TimestampMin, false);
                            TableUtils.txnPartitionConditionally(pathToPartition, srcNameTxn);
                            plen = pathToPartition.length();
                            for (i = 0; i < this.columnCount; ++i) {
                                colOffset = TableWriter.getPrimaryColumnIndex(i);
                                notTheTimestamp = i != timestampIndex;
                                columnType = this.metadata.getColumnType(i);
                                columnName = this.metadata.getColumnName(i);
                                isIndexed = this.metadata.isColumnIndexed(i);
                                indexWriter = isIndexed != false ? this.getBitmapIndexWriter(i) : null;
                                oooMem1 = this.o3Columns.getQuick(colOffset);
                                oooMem2 = this.o3Columns.getQuick(colOffset + 1);
                                mem1 = this.columns.getQuick(colOffset);
                                mem2 = this.columns.getQuick(colOffset + 1);
                                srcDataTop = this.getColumnTop(i);
                                if (columnType != 10 && columnType != 13) {
                                    srcOooFixAddr = oooMem1.addressOf(0L);
                                    srcOooFixSize = oooMem1.getAppendOffset();
                                    srcOooVarAddr = 0L;
                                    srcOooVarSize = 0L;
                                    dstFixMem = mem1;
                                    dstVarMem = null;
                                } else {
                                    srcOooFixAddr = oooMem2.addressOf(0L);
                                    srcOooFixSize = oooMem2.getAppendOffset();
                                    srcOooVarAddr = oooMem1.addressOf(0L);
                                    srcOooVarSize = oooMem1.getAppendOffset();
                                    dstFixMem = mem2;
                                    dstVarMem = mem1;
                                }
                                O3OpenColumnJob.appendLastPartition(pathToPartition, plen, columnName, columnCounter, notTheTimestamp != false ? columnType : -columnType, srcOooFixAddr, srcOooFixSize, srcOooVarAddr, srcOooVarSize, srcOooLo, srcOooHi, srcOooMax, o3TimestampMin, o3TimestampMax, partitionTimestamp, srcDataTop, Math.max(0L, srcDataSize), isIndexed, dstFixMem, dstVarMem, this, indexWriter, this.tempMem16b);
                            }
                            ** GOTO lbl88
                        }
                        if (flattenTimestamp) {
                            Vect.flattenIndex(sortedTimestampsAddr, this.o3RowCount);
                            flattenTimestamp = false;
                        }
                        this.o3CommitPartitionAsync(columnCounter, maxTimestamp, sortedTimestampsAddr, srcOooMax, o3TimestampMin, o3TimestampMax, srcOooLo, srcOooHi, partitionTimestamp, last, srcDataSize, srcNameTxn, o3Basket);
                    }
                    catch (CairoError | CairoException e) {
                        TableWriter.LOG.error().$((Sinkable)e).$();
                        success = false;
                        throw e;
                    }
                }
                TableWriter.LOG.debug().$("o3 expecting updates [table=").$(this.tableName).$(", partitionsPublished=").$(pCount).I$();
                this.o3ConsumePartitionUpdates(srcOooMax, o3TimestampMin, o3TimestampMax);
                this.o3DoneLatch.await(latchCount);
                v2 = this.o3InError = success == false || this.o3ErrorCount.get() > 0;
            }
            catch (Throwable var68_50) {
                TableWriter.LOG.debug().$("o3 expecting updates [table=").$(this.tableName).$(", partitionsPublished=").$(pCount).I$();
                this.o3ConsumePartitionUpdates(srcOooMax, o3TimestampMin, o3TimestampMax);
                this.o3DoneLatch.await(latchCount);
                v3 = this.o3InError = success == false || this.o3ErrorCount.get() > 0;
                if (success && this.o3ErrorCount.get() > 0) {
                    throw CairoException.instance(0).put("bulk update failed and will be rolled back");
                }
                throw var68_50;
            }
            if (success && this.o3ErrorCount.get() > 0) {
                throw CairoException.instance(0).put("bulk update failed and will be rolled back");
            }
            if (o3HysteresisRowCount > 0L) {
                this.o3ShiftHysteresisUp(timestampIndex, o3HysteresisRowCount, srcOooMax);
            }
            if (this.denseIndexers.size() == 0) {
                this.populateDenseIndexerList();
            }
            this.path.trimTo(this.rootLen);
        }
        v4 = this.avoidIndexOnCommit = this.o3ErrorCount.get() == 0;
        if (o3HysteresisRowCount == 0L) {
            this.o3MasterRef = -1L;
            this.rowFunction = this.switchPartitionFunction;
            Row.access$502(this.row, this.columns);
            Row.access$602(this.row, this.nullSetters);
        } else {
            this.o3MasterRef = this.masterRef - o3HysteresisRowCount * 2L + 1L;
        }
        TableWriter.LOG.debug().$("adjusted [o3RowCount=").$(this.getO3RowCount()).I$();
        if (this.columns.getQuick(0).isClosed() || this.partitionTimestampHi < this.txFile.getMaxTimestamp()) {
            this.openPartition(this.txFile.getMaxTimestamp());
        }
        this.setAppendPosition(this.txFile.getTransientRowCount(), true);
        return false;
    }

    private void o3CommitPartitionAsync(AtomicInteger columnCounter, long maxTimestamp, long sortedTimestampsAddr, long srcOooMax, long oooTimestampMin, long oooTimestampMax, long srcOooLo, long srcOooHi, long partitionTimestamp, boolean last, long srcDataSize, long srcNameTxn, O3Basket o3Basket) {
        long cursor = this.messageBus.getO3PartitionPubSeq().next();
        if (cursor > -1L) {
            O3PartitionTask task = this.messageBus.getO3PartitionQueue().get(cursor);
            task.of(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataSize, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket);
            this.messageBus.getO3PartitionPubSeq().done(cursor);
        } else {
            O3PartitionJob.processPartition(this.path, this.partitionBy, this.columns, this.o3Columns, srcOooLo, srcOooHi, srcOooMax, oooTimestampMin, oooTimestampMax, partitionTimestamp, maxTimestamp, srcDataSize, srcNameTxn, last, this.getTxn(), sortedTimestampsAddr, this, columnCounter, o3Basket, this.tempMem16b);
        }
    }

    private void o3ConsumePartitionUpdates(long srcOooMax, long timestampMin, long timestampMax) {
        MCSequence partitionSubSeq = this.messageBus.getO3PartitionSubSeq();
        RingQueue<O3PartitionTask> partitionQueue = this.messageBus.getO3PartitionQueue();
        MCSequence openColumnSubSeq = this.messageBus.getO3OpenColumnSubSeq();
        RingQueue<O3OpenColumnTask> openColumnQueue = this.messageBus.getO3OpenColumnQueue();
        MCSequence copySubSeq = this.messageBus.getO3CopySubSeq();
        RingQueue<O3CopyTask> copyQueue = this.messageBus.getO3CopyQueue();
        do {
            long cursor;
            if ((cursor = this.o3PartitionUpdateSubSeq.next()) > -1L) {
                O3PartitionUpdateTask task = this.o3PartitionUpdateQueue.get(cursor);
                long partitionTimestamp = task.getPartitionTimestamp();
                long srcOooPartitionLo = task.getSrcOooPartitionLo();
                long srcOooPartitionHi = task.getSrcOooPartitionHi();
                long srcDataMax = task.getSrcDataMax();
                boolean partitionMutates = task.isPartitionMutates();
                this.o3ClockDownPartitionUpdateCount();
                this.o3PartitionUpdateSubSeq.done(cursor);
                if (this.o3ErrorCount.get() != 0) continue;
                this.o3PartitionUpdate(timestampMin, timestampMax, partitionTimestamp, srcOooPartitionLo, srcOooPartitionHi, srcOooMax, srcDataMax, partitionMutates);
                continue;
            }
            cursor = partitionSubSeq.next();
            if (cursor > -1L) {
                O3PartitionTask partitionTask = partitionQueue.get(cursor);
                if (partitionTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    partitionSubSeq.done(cursor);
                    this.o3ClockDownPartitionUpdateCount();
                    this.o3CountDownDoneLatch();
                    continue;
                }
                this.o3ProcessPartitionSafe(partitionSubSeq, cursor, partitionTask);
                continue;
            }
            cursor = openColumnSubSeq.next();
            if (cursor > -1L) {
                O3OpenColumnTask openColumnTask = openColumnQueue.get(cursor);
                if (openColumnTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                    O3CopyJob.closeColumnIdle(openColumnTask.getColumnCounter(), openColumnTask.getTimestampMergeIndexAddr(), openColumnTask.getSrcTimestampFd(), openColumnTask.getSrcTimestampAddr(), openColumnTask.getSrcTimestampSize(), this);
                    openColumnSubSeq.done(cursor);
                    continue;
                }
                this.o3OpenColumnSafe(openColumnSubSeq, cursor, openColumnTask);
                continue;
            }
            cursor = copySubSeq.next();
            if (cursor <= -1L) continue;
            O3CopyTask copyTask = copyQueue.get(cursor);
            if (copyTask.getTableWriter() == this && this.o3ErrorCount.get() > 0) {
                O3CopyJob.copyIdle(copyTask.getColumnCounter(), copyTask.getPartCounter(), copyTask.getTimestampMergeIndexAddr(), copyTask.getSrcDataFixFd(), copyTask.getSrcDataFixAddr(), copyTask.getSrcDataFixSize(), copyTask.getSrcDataVarFd(), copyTask.getSrcDataVarAddr(), copyTask.getSrcDataVarSize(), copyTask.getDstFixFd(), copyTask.getDstFixAddr(), copyTask.getDstFixSize(), copyTask.getDstVarFd(), copyTask.getDstVarAddr(), copyTask.getDstVarSize(), copyTask.getSrcTimestampFd(), copyTask.getSrcTimestampAddr(), copyTask.getSrcTimestampSize(), copyTask.getDstKFd(), copyTask.getDstVFd(), this);
                copySubSeq.done(cursor);
                continue;
            }
            this.o3CopySafe(cursor);
        } while (this.o3PartitionUpdRemaining.get() > 0L);
    }

    private void o3CopySafe(long cursor) {
        O3CopyTask task = this.messageBus.getO3CopyQueue().get(cursor);
        try {
            O3CopyJob.copy(task, cursor, this.messageBus.getO3CopySubSeq());
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    void o3CountDownDoneLatch() {
        this.o3DoneLatch.countDown();
    }

    private void o3MoveHysteresis0(int columnIndex, int columnType, long o3HysteresisRowCount, long o3RowCount) {
        if (columnIndex > -1) {
            long size;
            long sourceOffset;
            ContiguousVirtualMemory o3DataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(columnIndex));
            ContiguousVirtualMemory o3IndexMem = this.o3Columns.get(TableWriter.getSecondaryColumnIndex(columnIndex));
            int shl = ColumnType.pow2SizeOf(columnType);
            if (null == o3IndexMem) {
                sourceOffset = o3RowCount << shl;
                size = o3HysteresisRowCount << shl;
            } else {
                sourceOffset = o3IndexMem.getLong(o3RowCount * 8L);
                size = o3DataMem.getAppendOffset() - sourceOffset;
                O3Utils.shiftCopyFixedSizeColumnData(sourceOffset, o3IndexMem.addressOf(o3RowCount * 8L), 0L, o3HysteresisRowCount * 8L, o3IndexMem.addressOf(0L));
                o3IndexMem.jumpTo(o3HysteresisRowCount * 8L);
            }
            o3DataMem.jumpTo(size);
            Vect.memmove(o3DataMem.addressOf(0L), o3DataMem.addressOf(sourceOffset), size);
        } else {
            long sourceOffset = o3RowCount * 16L;
            long mergeMemAddr = this.o3TimestampMem.addressOf(0L);
            Vect.shiftTimestampIndex(mergeMemAddr + sourceOffset, o3HysteresisRowCount, mergeMemAddr);
            this.o3TimestampMem.jumpTo(o3HysteresisRowCount * 16L);
        }
    }

    private long o3MoveUncommitted(int timestampIndex) {
        long committedRowCount = this.txFile.getCommittedFixedRowCount() + this.txFile.getCommittedTransientRowCount();
        long rowsAdded = this.txFile.getRowCount() - committedRowCount;
        long committedTransientRowCount = this.txFile.getTransientRowCount() - Math.min(this.txFile.getTransientRowCount(), rowsAdded);
        if (Math.min(this.txFile.getTransientRowCount(), rowsAdded) > 0L) {
            LOG.debug().$("o3 move uncommitted [table=").$(this.tableName).$(", transientRowsAdded=").$(Math.min(this.txFile.getTransientRowCount(), rowsAdded)).I$();
            return this.o3ScheduleMoveUncommitted0(timestampIndex, Math.min(this.txFile.getTransientRowCount(), rowsAdded), committedTransientRowCount);
        }
        return 0L;
    }

    private void o3MoveUncommitted0(int colIndex, int columnType, long committedTransientRowCount, long transientRowsAdded) {
        if (colIndex > -1) {
            long srcFixOffset;
            long extendedSize;
            AppendOnlyVirtualMemory srcDataMem = this.getPrimaryColumn(colIndex);
            int shl = ColumnType.pow2SizeOf(columnType);
            ContiguousVirtualMemory o3DataMem = this.o3Columns.get(TableWriter.getPrimaryColumnIndex(colIndex));
            ContiguousVirtualMemory o3IndexMem = this.o3Columns.get(TableWriter.getSecondaryColumnIndex(colIndex));
            long dstVarOffset = o3DataMem.getAppendOffset();
            if (null == o3IndexMem) {
                extendedSize = transientRowsAdded << shl;
                srcFixOffset = committedTransientRowCount << shl;
            } else {
                AppendOnlyVirtualMemory srcFixMem = this.getSecondaryColumn(colIndex);
                long srcVarOffset = srcFixMem.getLong(committedTransientRowCount * 8L);
                long dstAppendOffset = o3IndexMem.getAppendOffset();
                o3IndexMem.jumpTo(o3IndexMem.getAppendOffset() + transientRowsAdded * 8L);
                O3Utils.shiftCopyFixedSizeColumnData(srcVarOffset - dstVarOffset, srcFixMem.addressOf(committedTransientRowCount * 8L), 0L, transientRowsAdded, o3IndexMem.addressOf(dstAppendOffset));
                long sourceEndOffset = srcDataMem.getAppendOffset();
                extendedSize = sourceEndOffset - srcVarOffset;
                srcFixOffset = srcVarOffset;
                srcFixMem.jumpTo(committedTransientRowCount * 8L);
            }
            o3DataMem.jumpTo(dstVarOffset + extendedSize);
            long appendAddress = o3DataMem.addressOf(dstVarOffset);
            long sourceAddress = srcDataMem.addressOf(srcFixOffset);
            Vect.memcpy(sourceAddress, appendAddress, extendedSize);
            srcDataMem.jumpTo(srcFixOffset);
        } else {
            colIndex = -colIndex - 1;
            int shl = ColumnType.pow2SizeOf(7);
            AppendOnlyVirtualMemory srcDataMem = this.getPrimaryColumn(colIndex);
            long srcFixOffset = committedTransientRowCount << shl;
            for (long n = 0L; n < transientRowsAdded; ++n) {
                long ts = srcDataMem.getLong(srcFixOffset + (n << shl));
                this.o3TimestampMem.putLong128(ts, this.o3RowCount + n);
            }
            srcDataMem.jumpTo(srcFixOffset);
        }
    }

    private void o3OpenColumnSafe(Sequence openColumnSubSeq, long cursor, O3OpenColumnTask openColumnTask) {
        try {
            O3OpenColumnJob.openColumn(openColumnTask, cursor, openColumnSubSeq, this.tempMem16b);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    private void o3OpenColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            ContiguousVirtualMemory mem1 = this.o3Columns.getQuick(TableWriter.getPrimaryColumnIndex(i));
            mem1.jumpTo(0L);
            ContiguousVirtualMemory mem2 = this.o3Columns.getQuick(TableWriter.getSecondaryColumnIndex(i));
            if (mem2 == null) continue;
            mem2.jumpTo(0L);
        }
        this.row.activeColumns = this.o3Columns;
        this.row.activeNullSetters = this.o3NullSetters;
        LOG.debug().$("switched partition to memory").$();
    }

    private void o3PartitionUpdate(long timestampMin, long timestampMax, long partitionTimestamp, long srcOooPartitionLo, long srcOooPartitionHi, long srcOooMax, long srcDataMax, boolean partitionMutates) {
        this.txFile.minTimestamp = Math.min(timestampMin, this.txFile.minTimestamp);
        long partitionSize = srcDataMax + srcOooPartitionHi - srcOooPartitionLo + 1L;
        long rowDelta = srcOooPartitionHi - srcOooMax;
        if (partitionTimestamp < this.lastPartitionTimestamp) {
            this.txFile.fixedRowCount += partitionSize - srcDataMax;
        } else if (rowDelta < -1L) {
            this.txFile.fixedRowCount += partitionSize;
        } else {
            this.txFile.transientRowCount = partitionSize;
            this.txFile.maxTimestamp = Math.max(this.txFile.maxTimestamp, timestampMax);
        }
        int partitionIndex = this.txFile.findAttachedPartitionIndexByLoTimestamp(partitionTimestamp);
        if (partitionTimestamp == this.lastPartitionTimestamp) {
            if (partitionMutates) {
                this.closeActivePartition();
            } else if (rowDelta < -1L) {
                this.closeActivePartition(partitionSize);
            } else {
                this.setAppendPosition(partitionSize, false);
            }
        }
        if (partitionMutates) {
            long srcDataTxn = this.txFile.getPartitionNameTxnByIndex(partitionIndex);
            LOG.info().$("merged partition [table=`").utf8(this.tableName).$("`, ts=").$ts(partitionTimestamp).$(", txn=").$(this.txFile.txn).$(']').$();
            this.txFile.updatePartitionSizeByIndexAndTxn(partitionIndex, partitionSize);
            this.o3PartitionRemoveCandidates.add(partitionTimestamp);
            this.o3PartitionRemoveCandidates.add(srcDataTxn);
            this.txFile.bumpPartitionTableVersion();
        } else {
            if (partitionTimestamp != this.lastPartitionTimestamp) {
                this.txFile.bumpPartitionTableVersion();
            }
            this.txFile.updatePartitionSizeByIndex(partitionIndex, partitionTimestamp, partitionSize);
        }
    }

    synchronized void o3PartitionUpdateSynchronized(long timestampMin, long timestampMax, long partitionTimestamp, long srcOooPartitionLo, long srcOooPartitionHi, boolean partitionMutates, long srcOooMax, long srcDataMax) {
        this.o3ClockDownPartitionUpdateCount();
        this.o3PartitionUpdate(timestampMin, timestampMax, partitionTimestamp, srcOooPartitionLo, srcOooPartitionHi, srcOooMax, srcDataMax, partitionMutates);
    }

    private void o3ProcessPartitionRemoveCandidates() {
        try {
            int n = this.o3PartitionRemoveCandidates.size();
            if (n > 0) {
                this.o3ProcessPartitionRemoveCandidates0(n);
            }
        }
        finally {
            this.o3PartitionRemoveCandidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ProcessPartitionRemoveCandidates0(int n) {
        long readerTxn = this.txnScoreboard.getMin();
        long readerTxnCount = this.txnScoreboard.getActiveReaderCount(readerTxn);
        if (this.txnScoreboard.isTxnAvailable(this.txFile.getTxn() - 1L)) {
            for (int i = 0; i < n; i += 2) {
                long timestamp = this.o3PartitionRemoveCandidates.getQuick(i);
                long txn = this.o3PartitionRemoveCandidates.getQuick(i + 1);
                try {
                    TableUtils.setPathForPartition(this.other, this.partitionBy, timestamp, false);
                    TableUtils.txnPartitionConditionally(this.other, txn);
                    this.other.slash$();
                    int errno = this.ff.rmdir(this.other);
                    if (errno == 0) {
                        LOG.info().$("purged [path=").$(this.other).$(", readerTxn=").$(readerTxn).$(", readerTxnCount=").$(readerTxnCount).$(']').$();
                        continue;
                    }
                    LOG.info().$("queued to purge [errno=").$(errno).$(", table=").$(this.tableName).$(", ts=").$ts(timestamp).$(", txn=").$(txn).$(']').$();
                    this.o3QueuePartitionForPurge(timestamp, txn);
                    continue;
                }
                finally {
                    this.other.trimTo(this.rootLen);
                }
            }
        } else {
            for (int i = 0; i < n; i += 2) {
                this.o3QueuePartitionForPurge(this.o3PartitionRemoveCandidates.getQuick(i), this.o3PartitionRemoveCandidates.getQuick(i + 1));
            }
        }
    }

    private void o3ProcessPartitionSafe(Sequence partitionSubSeq, long cursor, O3PartitionTask partitionTask) {
        try {
            O3PartitionJob.processPartition(this.tempMem16b, partitionTask, cursor, partitionSubSeq);
        }
        catch (CairoError | CairoException e) {
            LOG.error().$((Sinkable)((Object)e)).$();
        }
        catch (Throwable e) {
            LOG.error().$(e).$();
        }
    }

    private void o3QueuePartitionForPurge(long timestamp, long txn) {
        MPSequence seq = this.messageBus.getO3PurgeDiscoveryPubSeq();
        long cursor = seq.next();
        if (cursor > -1L) {
            O3PurgeDiscoveryTask task = this.messageBus.getO3PurgeDiscoveryQueue().get(cursor);
            task.of(this.tableName, this.partitionBy, this.txnScoreboard, timestamp, txn);
            seq.done(cursor);
        } else {
            LOG.error().$("could not purge [errno=").$(this.ff.errno()).$(", table=").$(this.tableName).$(", ts=").$ts(timestamp).$(", txn=").$(txn).$(']').$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long o3ScheduleMoveUncommitted0(int timestampIndex, long transientRowsAdded, long committedTransientRowCount) {
        long transientRowsAddedNew = this.o3CalculatedMoveUncommittedSize(transientRowsAdded, committedTransientRowCount);
        long delta = transientRowsAdded - transientRowsAddedNew;
        assert (delta >= 0L);
        if (delta > 0L) {
            transientRowsAdded -= delta;
            committedTransientRowCount += delta;
        }
        if (transientRowsAdded > 0L) {
            long maxCommittedTimestamp = 0L;
            if (delta > 0L) {
                AppendOnlyVirtualMemory timestampColumn = this.getPrimaryColumn(timestampIndex);
                if (!timestampColumn.isMapped(committedTransientRowCount - 1L << 3, 8L)) {
                    --transientRowsAdded;
                    ++committedTransientRowCount;
                }
                maxCommittedTimestamp = timestampColumn.getLong(committedTransientRowCount - 1L << 3);
            }
            MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
            RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
            this.o3PendingCallbackTasks.clear();
            this.o3DoneLatch.reset();
            int queuedCount = 0;
            for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
                int columnType = this.metadata.getColumnType(colIndex);
                int columnIndex = colIndex != timestampIndex ? colIndex : -colIndex - 1;
                long cursor = pubSeq.next();
                if (cursor > -1L) {
                    try {
                        O3CallbackTask task = queue.get(cursor);
                        task.of(this.o3DoneLatch, columnIndex, columnType, committedTransientRowCount, transientRowsAdded, this.o3MoveUncommittedRef);
                        this.o3PendingCallbackTasks.add(task);
                        continue;
                    }
                    finally {
                        ++queuedCount;
                        pubSeq.done(cursor);
                    }
                }
                this.o3MoveUncommitted0(columnIndex, columnType, committedTransientRowCount, transientRowsAdded);
            }
            for (int n = this.o3PendingCallbackTasks.size() - 1; n > -1; --n) {
                O3CallbackTask task = this.o3PendingCallbackTasks.getQuick(n);
                if (!task.tryLock()) continue;
                O3CallbackJob.runCallbackWithCol(task, -1L, null);
            }
            this.o3DoneLatch.await(queuedCount);
            if (delta == 0L) {
                this.txFile.resetToLastPartition(committedTransientRowCount);
            } else {
                this.txFile.resetToLastPartition(committedTransientRowCount, maxCommittedTimestamp);
            }
        }
        return transientRowsAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3ShiftHysteresisUp(int timestampIndex, long o3HysteresisRowCount, long o3RowCount) {
        this.o3PendingCallbackTasks.clear();
        MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
        RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
        this.o3DoneLatch.reset();
        int queuedCount = 0;
        for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
            int columnIndex;
            int columnType = this.metadata.getColumnType(colIndex);
            long cursor = pubSeq.next();
            int n = columnIndex = colIndex != timestampIndex ? colIndex : -colIndex - 1;
            if (cursor > -1L) {
                try {
                    O3CallbackTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, columnIndex, columnType, o3HysteresisRowCount, o3RowCount, this.o3MoveHysteresisRef);
                    this.o3PendingCallbackTasks.add(task);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            this.o3MoveHysteresis0(columnIndex, columnType, o3HysteresisRowCount, o3RowCount);
        }
        for (int n = this.o3PendingCallbackTasks.size() - 1; n > -1; --n) {
            O3CallbackTask task = this.o3PendingCallbackTasks.getQuick(n);
            if (!task.tryLock()) continue;
            O3CallbackJob.runCallbackWithCol(task, -1L, null);
        }
        this.o3DoneLatch.await(queuedCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o3Sort(long mergedTimestamps, int timestampIndex, long rowCount) {
        this.o3PendingCallbackTasks.clear();
        MPSequence pubSeq = this.messageBus.getO3CallbackPubSeq();
        RingQueue<O3CallbackTask> queue = this.messageBus.getO3CallbackQueue();
        this.o3DoneLatch.reset();
        int queuedCount = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (timestampIndex == i) continue;
            int type = this.metadata.getColumnType(i);
            long cursor = pubSeq.next();
            if (cursor > -1L) {
                try {
                    O3CallbackTask task = queue.get(cursor);
                    task.of(this.o3DoneLatch, i, type, mergedTimestamps, rowCount, type == 10 || type == 13 ? this.oooSortVarColumnRef : this.oooSortFixColumnRef);
                    this.o3PendingCallbackTasks.add(task);
                    continue;
                }
                finally {
                    ++queuedCount;
                    pubSeq.done(cursor);
                }
            }
            this.o3SortColumn(mergedTimestamps, i, type, rowCount);
        }
        for (int n = this.o3PendingCallbackTasks.size() - 1; n > -1; --n) {
            O3CallbackTask task = this.o3PendingCallbackTasks.getQuick(n);
            if (!task.tryLock()) continue;
            O3CallbackJob.runCallbackWithCol(task, -1L, null);
        }
        this.o3DoneLatch.await(queuedCount);
    }

    private void o3SortColumn(long mergedTimestamps, int i, int type, long rowCount) {
        switch (type) {
            case 10: 
            case 13: {
                this.o3SortVarColumn(i, type, mergedTimestamps, rowCount);
                break;
            }
            default: {
                this.o3SortFixColumn(i, type, mergedTimestamps, rowCount);
            }
        }
    }

    private void o3SortFixColumn(int columnIndex, int columnType, long mergedTimestampsAddr, long valueCount) {
        int columnOffset = TableWriter.getPrimaryColumnIndex(columnIndex);
        ContiguousVirtualMemory mem = this.o3Columns.getQuick(columnOffset);
        ContiguousVirtualMemory mem2 = this.o3Columns2.getQuick(columnOffset);
        long src = mem.addressOf(0L);
        long srcSize = mem.size();
        int shl = ColumnType.pow2SizeOf(columnType);
        mem2.jumpTo(valueCount << shl);
        long tgtDataAddr = mem2.addressOf(0L);
        long tgtDataSize = mem2.size();
        switch (shl) {
            case 0: {
                Vect.indexReshuffle8Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 1: {
                Vect.indexReshuffle16Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 2: {
                Vect.indexReshuffle32Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 3: {
                Vect.indexReshuffle64Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            case 5: {
                Vect.indexReshuffle256Bit(src, tgtDataAddr, mergedTimestampsAddr, valueCount);
                break;
            }
            default: {
                assert (false) : "col type is unsupported";
                break;
            }
        }
        mem.replacePage(tgtDataAddr, tgtDataSize);
        mem2.replacePage(src, srcSize);
    }

    private void o3SortVarColumn(int columnIndex, int columnType, long mergedTimestampsAddr, long valueCount) {
        int primaryIndex = TableWriter.getPrimaryColumnIndex(columnIndex);
        int secondaryIndex = primaryIndex + 1;
        ContiguousVirtualMemory dataMem = this.o3Columns.getQuick(primaryIndex);
        ContiguousVirtualMemory indexMem = this.o3Columns.getQuick(secondaryIndex);
        ContiguousVirtualMemory dataMem2 = this.o3Columns2.getQuick(primaryIndex);
        ContiguousVirtualMemory indexMem2 = this.o3Columns2.getQuick(secondaryIndex);
        long dataSize = dataMem.getAppendOffset();
        long srcDataAddr = dataMem.addressOf(0L);
        long srcDataSize = dataMem.size();
        long srcIndxAddr = indexMem.addressOf(0L);
        long srcIndxSize = indexMem.size();
        long tgtDataAddr = dataMem2.resize(dataSize);
        long tgtDataSize = dataMem2.size();
        long tgtIndxAddr = indexMem2.resize(valueCount * 8L);
        long tgtIndxSize = indexMem2.size();
        indexMem.putLong(valueCount * 8L, dataSize);
        long offset = Vect.sortVarColumn(mergedTimestampsAddr, valueCount, srcDataAddr, srcIndxAddr, tgtDataAddr, tgtIndxAddr);
        dataMem.replacePage(tgtDataAddr, tgtDataSize);
        indexMem.replacePage(tgtIndxAddr, tgtIndxSize);
        dataMem2.replacePage(srcDataAddr, srcDataSize);
        indexMem2.replacePage(srcIndxAddr, srcIndxSize);
        dataMem.jumpTo(offset);
        indexMem.jumpTo(valueCount * 8L);
    }

    private void o3TimestampSetter(long timestamp) {
        this.o3TimestampMem.putLong128(timestamp, this.getO3RowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumnFiles(CharSequence name, int i, int plen) {
        AppendOnlyVirtualMemory mem1 = this.getPrimaryColumn(i);
        AppendOnlyVirtualMemory mem2 = this.getSecondaryColumn(i);
        try {
            mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(plen), name), this.configuration.getAppendPageSize());
            if (mem2 != null) {
                mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(plen), name), this.configuration.getAppendPageSize());
            }
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void openFirstPartition(long timestamp) {
        this.openPartition(this.repairDataGaps(timestamp));
        this.setAppendPosition(this.txFile.getTransientRowCount(), true);
        if (this.performRecovery) {
            this.performRecovery();
        }
        this.txFile.openFirstPartition(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewColumnFiles(CharSequence name, boolean indexFlag, int indexValueBlockCapacity) {
        try {
            this.setStateForTimestamp(this.path, this.txFile.getMaxTimestamp(), false);
            int plen = this.path.length();
            int columnIndex = this.columnCount - 1;
            if (indexFlag) {
                this.createIndexFiles(name, indexValueBlockCapacity, plen, true);
            }
            this.openColumnFiles(name, columnIndex, plen);
            if (this.txFile.getTransientRowCount() > 0L) {
                this.writeColumnTop(name);
            }
            if (indexFlag) {
                ColumnIndexer indexer = this.indexers.getQuick(columnIndex);
                assert (indexer != null);
                this.indexers.getQuick(columnIndex).configureFollowerAndWriter(this.configuration, this.path.trimTo(plen), name, this.getPrimaryColumn(columnIndex), this.txFile.getTransientRowCount());
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPartition(long timestamp) {
        try {
            this.setStateForTimestamp(this.path, timestamp, true);
            int plen = this.path.length();
            if (this.ff.mkdirs(this.path.slash$(), this.mkDirMode) != 0) {
                throw CairoException.instance(this.ff.errno()).put("Cannot create directory: ").put(this.path);
            }
            assert (this.columnCount > 0);
            for (int i = 0; i < this.columnCount; ++i) {
                String name = this.metadata.getColumnName(i);
                boolean indexed = this.metadata.isColumnIndexed(i);
                if (indexed) {
                    this.createIndexFiles(name, this.metadata.getIndexValueBlockCapacity(i), plen, this.txFile.getTransientRowCount() < 1L);
                }
                this.openColumnFiles(name, i, plen);
                long columnTop = TableUtils.readColumnTop(this.ff, this.path, name, plen, this.tempMem16b);
                this.columnTops.extendAndSet(i, columnTop);
                if (!indexed) continue;
                ColumnIndexer indexer = this.indexers.getQuick(i);
                assert (indexer != null);
                indexer.configureFollowerAndWriter(this.configuration, this.path, name, this.getPrimaryColumn(i), columnTop);
            }
            LOG.info().$("switched partition [path='").$(this.path).$("']").$();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long openTodoMem() {
        this.path.concat("_todo_").$();
        try {
            if (this.ff.exists(this.path)) {
                long fileLen = this.ff.length(this.path);
                if (fileLen < 32L) {
                    throw CairoException.instance(0).put("corrupt ").put(this.path);
                }
                this.todoMem.of(this.ff, this.path, this.ff.getPageSize(), fileLen);
                this.todoTxn = this.todoMem.getLong(0L);
                if (this.todoMem.getLong(24L) != this.todoTxn) {
                    this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
                    this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
                    Unsafe.getUnsafe().storeFence();
                    this.todoMem.putLong(24L, this.todoTxn);
                    long l = 0L;
                    return l;
                }
                long l = this.todoMem.getLong(32L);
                return l;
            }
            TableUtils.resetTodoLog(this.ff, this.path, this.rootLen, this.todoMem);
            this.todoTxn = 0L;
            long l = 0L;
            return l;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void performRecovery() {
        this.rollbackIndexes();
        this.rollbackSymbolTables();
        this.performRecovery = false;
    }

    private void populateDenseIndexerList() {
        this.denseIndexers.clear();
        int n = this.indexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.indexers.getQuick(i);
            if (indexer == null) continue;
            this.denseIndexers.add(indexer);
        }
        this.indexCount = this.denseIndexers.size();
    }

    void purgeUnusedPartitions() {
        if (this.partitionBy != 3) {
            this.removeNonAttachedPartitions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMinTimestamp(long partitionTimestamp) {
        this.setStateForTimestamp(this.other, partitionTimestamp, false);
        try {
            TableUtils.dFile(this.other, this.metadata.getColumnName(this.metadata.getTimestampIndex()));
            if (this.ff.exists(this.other)) {
                long fd = TableUtils.openRO(this.ff, this.other, LOG);
                try {
                    long n = this.ff.read(fd, this.tempMem16b, 8L, 0L);
                    if (n != 8L) {
                        throw CairoException.instance(Os.errno()).put("could not read timestamp value");
                    }
                    long l = Unsafe.getUnsafe().getLong(this.tempMem16b);
                    return l;
                }
                finally {
                    this.ff.close(fd);
                }
            }
            throw CairoException.instance(0).put("Partition does not exist [path=").put(this.other).put(']');
        }
        finally {
            this.other.trimTo(this.rootLen);
        }
    }

    private void recoverFromMetaRenameFailure(CharSequence columnName) {
        TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
    }

    private void recoverFromSwapRenameFailure(CharSequence columnName) {
        this.recoverFromTodoWriteFailure(columnName);
        this.clearTodoLog();
    }

    private void recoverFromSymbolMapWriterFailure(CharSequence columnName) {
        this.removeSymbolMapFilesQuiet(columnName);
        this.removeMetaFile();
        this.recoverFromSwapRenameFailure(columnName);
    }

    private void recoverFromTodoWriteFailure(CharSequence columnName) {
        this.restoreMetaFrom("_meta.prev", this.metaPrevIndex);
        TableWriter.openMetaFile(this.ff, this.path, this.rootLen, this.metaMem);
    }

    private void recoverOpenColumnFailure(CharSequence columnName) {
        int index = this.columnCount - 1;
        this.removeMetaFile();
        this.removeLastColumn();
        this.recoverFromSwapRenameFailure(columnName);
        this.removeSymbolMapWriter(index);
    }

    private void releaseLock(boolean distressed) {
        if (this.lockFd != -1L) {
            this.ff.close(this.lockFd);
            if (distressed) {
                return;
            }
            try {
                TableUtils.lockName(this.path);
                TableWriter.removeOrException(this.ff, this.path);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void removeColumn(int columnIndex) {
        int pi = TableWriter.getPrimaryColumnIndex(columnIndex);
        int si = TableWriter.getSecondaryColumnIndex(columnIndex);
        this.freeAndRemoveColumnPair(this.columns, pi, si);
        this.freeAndRemoveColumnPair(this.o3Columns, pi, si);
        this.freeAndRemoveColumnPair(this.o3Columns2, pi, si);
        this.columnTops.removeIndex(columnIndex);
        this.nullSetters.remove(columnIndex);
        this.o3NullSetters.remove(columnIndex);
        if (columnIndex < this.indexers.size()) {
            Misc.free(this.indexers.getQuick(columnIndex));
            this.indexers.remove(columnIndex);
            this.populateDenseIndexerList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColumnFiles(CharSequence columnName, int columnType, RemoveFileLambda removeLambda) {
        try {
            this.ff.iterateDir(this.path.$(), (file, type) -> {
                this.nativeLPSZ.of(file);
                if (type == 4 && IGNORED_FILES.excludes(this.nativeLPSZ)) {
                    this.path.trimTo(this.rootLen);
                    this.path.concat(this.nativeLPSZ);
                    int plen = this.path.length();
                    removeLambda.remove(this.ff, TableUtils.dFile(this.path, columnName));
                    removeLambda.remove(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName));
                    removeLambda.remove(this.ff, TableUtils.topFile(this.path.trimTo(plen), columnName));
                    removeLambda.remove(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName));
                    removeLambda.remove(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName));
                }
            });
            if (columnType == 11) {
                removeLambda.remove(this.ff, SymbolMapWriter.offsetFileName(this.path.trimTo(this.rootLen), columnName));
                removeLambda.remove(this.ff, SymbolMapWriter.charFileName(this.path.trimTo(this.rootLen), columnName));
                removeLambda.remove(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), columnName));
                removeLambda.remove(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), columnName));
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeColumnFromMeta(int index) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount - 1);
            this.ddlMem.putInt(this.partitionBy);
            if (timestampIndex == index) {
                this.ddlMem.putInt(-1);
            } else if (index < timestampIndex) {
                this.ddlMem.putInt(timestampIndex - 1);
            } else {
                this.ddlMem.putInt(timestampIndex);
            }
            this.copyVersionAndHysteresis();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < this.columnCount; ++i) {
                if (i == index) continue;
                this.writeColumnEntry(i);
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                if (i != index) {
                    this.ddlMem.putStr(columnName);
                }
                nameOffset += (long)VmUtils.getStorageLength(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void removeIndexFiles(CharSequence columnName) {
        try {
            this.ff.iterateDir(this.path.$(), (file, type) -> {
                this.nativeLPSZ.of(file);
                if (type == 4 && IGNORED_FILES.excludes(this.nativeLPSZ)) {
                    this.path.trimTo(this.rootLen);
                    this.path.concat(this.nativeLPSZ);
                    int plen = this.path.length();
                    TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName));
                    TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName));
                }
            });
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeLastColumn() {
        this.removeColumn(this.columnCount - 1);
        --this.columnCount;
    }

    private void removeMetaFile() {
        try {
            this.path.concat("_meta").$();
            if (this.ff.exists(this.path) && !this.ff.remove(this.path)) {
                throw CairoException.instance(this.ff.errno()).put("Recovery failed. Cannot remove: ").put(this.path);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeNonAttachedPartitions() {
        LOG.info().$("purging non attached partitions [path=").$(this.path.$()).$(']').$();
        try {
            this.ff.iterateDir(this.path.$(), this.removePartitionDirsNotAttached);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirectories() {
        try {
            this.ff.iterateDir(this.path.$(), this.removePartitionDirectories);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirectories0(long name, int type) {
        int errno;
        this.path.trimTo(this.rootLen);
        this.path.concat(name).$();
        this.nativeLPSZ.of(name);
        if (IGNORED_FILES.excludes(this.nativeLPSZ) && type == 4 && (errno = this.ff.rmdir(this.path)) != 0) {
            LOG.info().$("could not remove [path=").$(this.path).$(", errno=").$(errno).$(']').$();
        }
    }

    private void removePartitionDirsNotAttached(long pName, int type) {
        this.nativeLPSZ.of(pName);
        if (!Files.isDots(this.nativeLPSZ) && type == 4) {
            if (Chars.endsWith((CharSequence)this.nativeLPSZ, ".detached")) {
                return;
            }
            try {
                long txn = 0L;
                int txnSep = Chars.indexOf(this.nativeLPSZ, '.');
                if (txnSep < 0) {
                    txnSep = this.nativeLPSZ.length();
                } else {
                    txn = Numbers.parseLong(this.nativeLPSZ, txnSep + 1, this.nativeLPSZ.length());
                }
                long dirTimestamp = this.partitionDirFmt.parse(this.nativeLPSZ, 0, txnSep, null);
                if (txn <= this.txFile.txn && (this.txFile.attachedPartitionsContains(dirTimestamp) || this.txFile.isActivePartition(dirTimestamp))) {
                    return;
                }
            }
            catch (NumericException txn) {
                // empty catch block
            }
            this.path.trimTo(this.rootLen);
            this.path.concat(pName).$();
            int errno = this.ff.rmdir(this.path);
            if (errno == 0) {
                LOG.info().$("removed partition dir: ").$(this.path).$();
            } else {
                LOG.error().$("cannot remove: ").$(this.path).$(" [errno=").$(errno).$(']').$();
            }
        }
    }

    private void removeSymbolMapFilesQuiet(CharSequence name) {
        try {
            TableWriter.removeFileAndOrLog(this.ff, SymbolMapWriter.offsetFileName(this.path.trimTo(this.rootLen), name));
            TableWriter.removeFileAndOrLog(this.ff, SymbolMapWriter.charFileName(this.path.trimTo(this.rootLen), name));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), name));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), name));
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeSymbolMapWriter(int index) {
        SymbolMapWriter writer = this.symbolMapWriters.getQuick(index);
        this.symbolMapWriters.remove(index);
        if (writer != null) {
            int symColIndex;
            this.denseSymbolTransientCountHandlers.remove(symColIndex);
            for (symColIndex = this.denseSymbolMapWriters.remove(writer); symColIndex < this.denseSymbolTransientCountHandlers.size(); ++symColIndex) {
                WriterTransientSymbolCountChangeHandler transientCountHandler = this.denseSymbolTransientCountHandlers.getQuick(symColIndex);
                assert (transientCountHandler.symColIndex - 1 == symColIndex);
                transientCountHandler.symColIndex = symColIndex;
            }
            Misc.free(writer);
        }
    }

    private int rename(int retries) {
        try {
            int index = 0;
            this.other.concat("_meta.prev").$();
            this.path.concat("_meta").$();
            int l = this.other.length();
            do {
                if (index > 0) {
                    this.other.trimTo(l);
                    this.other.put('.').put(index);
                    this.other.$();
                }
                if (this.ff.exists(this.other) && !this.ff.remove(this.other)) {
                    LOG.info().$("cannot remove target of rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).$(']').$();
                    ++index;
                    continue;
                }
                if (!this.ff.rename(this.path, this.other)) {
                    LOG.info().$("cannot rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).$(']').$();
                    ++index;
                    continue;
                }
                int n = index;
                return n;
            } while (index < retries);
            throw CairoException.instance(0).put("Cannot rename ").put(this.path).put(". Max number of attempts reached [").put(index).put("]. Last target was: ").put(this.other);
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameColumnFiles(CharSequence columnName, CharSequence newName, int columnType) {
        try {
            this.ff.iterateDir(this.path.$(), (file, type) -> {
                this.nativeLPSZ.of(file);
                if (type == 4 && IGNORED_FILES.excludes(this.nativeLPSZ)) {
                    this.path.trimTo(this.rootLen);
                    this.path.concat(this.nativeLPSZ);
                    this.other.trimTo(this.rootLen);
                    this.other.concat(this.nativeLPSZ);
                    int plen = this.path.length();
                    TableWriter.renameFileOrLog(this.ff, TableUtils.dFile(this.path.trimTo(plen), columnName), TableUtils.dFile(this.other.trimTo(plen), newName));
                    TableWriter.renameFileOrLog(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName), TableUtils.iFile(this.other.trimTo(plen), newName));
                    TableWriter.renameFileOrLog(this.ff, TableUtils.topFile(this.path.trimTo(plen), columnName), TableUtils.topFile(this.other.trimTo(plen), newName));
                    TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName), BitmapIndexUtils.keyFileName(this.other.trimTo(plen), newName));
                    TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName), BitmapIndexUtils.valueFileName(this.other.trimTo(plen), newName));
                }
            });
            if (columnType == 11) {
                TableWriter.renameFileOrLog(this.ff, SymbolMapWriter.offsetFileName(this.path.trimTo(this.rootLen), columnName), SymbolMapWriter.offsetFileName(this.other.trimTo(this.rootLen), newName));
                TableWriter.renameFileOrLog(this.ff, SymbolMapWriter.charFileName(this.path.trimTo(this.rootLen), columnName), SymbolMapWriter.charFileName(this.other.trimTo(this.rootLen), newName));
                TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), columnName), BitmapIndexUtils.keyFileName(this.other.trimTo(this.rootLen), newName));
                TableWriter.renameFileOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), columnName), BitmapIndexUtils.valueFileName(this.other.trimTo(this.rootLen), newName));
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int renameColumnFromMeta(int index, CharSequence newName) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount);
            this.ddlMem.putInt(this.partitionBy);
            this.ddlMem.putInt(timestampIndex);
            this.copyVersionAndHysteresis();
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < this.columnCount; ++i) {
                this.writeColumnEntry(i);
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                nameOffset += (long)VmUtils.getStorageLength(columnName);
                if (i == index) {
                    columnName = newName;
                }
                this.ddlMem.putStr(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void renameMetaToMetaPrev(CharSequence columnName) {
        try {
            this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void renameSwapMetaToMeta(CharSequence columnName) {
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_SWAP_RENAME_FAILURE, columnName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long repairDataGaps(long timestamp) {
        if (this.txFile.getMaxTimestamp() != Long.MIN_VALUE && this.partitionBy != 3) {
            long expectedSize;
            long actualSize = 0L;
            long lastTimestamp = -1L;
            long transientRowCount = this.txFile.getTransientRowCount();
            long maxTimestamp = this.txFile.getMaxTimestamp();
            try {
                long tsLimit = this.timestampFloorMethod.floor(this.txFile.getMaxTimestamp());
                long ts = this.getPartitionLo(this.txFile.getMinTimestamp());
                while (ts < tsLimit) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, ts, false);
                    int p = this.path.length();
                    long partitionSize = this.txFile.getPartitionSizeByPartitionTimestamp(ts);
                    if (partitionSize >= 0L && this.ff.exists(this.path.$())) {
                        actualSize += partitionSize;
                        lastTimestamp = ts;
                    } else {
                        Path other = Path.getThreadLocal2(this.path.trimTo(p).$());
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (!this.ff.rename(other, this.path)) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).$(']').$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$(this.path).$(']').$();
                        } else {
                            LOG.info().$("missing partition [name=").$(this.path.trimTo(p).$()).$(']').$();
                        }
                    }
                    ts = this.timestampAddMethod.calculate(ts, 1);
                }
                if (lastTimestamp > -1L) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(this.path, tsLimit, false);
                    if (!this.ff.exists(this.path.$())) {
                        Path other = Path.getThreadLocal2(this.path);
                        TableUtils.oldPartitionName(other, this.getTxn());
                        if (this.ff.exists(other.$())) {
                            if (!this.ff.rename(other, this.path)) {
                                LOG.error().$("could not rename [from=").$(other).$(", to=").$(this.path).$(']').$();
                                throw new CairoError("could not restore directory, see log for details");
                            }
                            LOG.info().$("restored [path=").$(this.path).$(']').$();
                        } else {
                            LOG.error().$("last partition does not exist [name=").$(this.path).$(']').$();
                            this.path.trimTo(this.rootLen);
                            this.setStateForTimestamp(this.path, lastTimestamp, false);
                            int p = this.path.length();
                            transientRowCount = this.txFile.getPartitionSizeByPartitionTimestamp(lastTimestamp);
                            TableUtils.dFile(this.path.trimTo(p), this.metadata.getColumnName(this.metadata.getTimestampIndex()));
                            maxTimestamp = TableUtils.readLongAtOffset(this.ff, this.path, this.tempMem16b, (transientRowCount - 1L) * 8L);
                            actualSize -= transientRowCount;
                            LOG.info().$("updated active partition [name=").$(this.path.trimTo(p).$()).$(", maxTimestamp=").$ts(maxTimestamp).$(", transientRowCount=").$(transientRowCount).$(", fixedRowCount=").$(this.txFile.getFixedRowCount()).$(']').$();
                        }
                    }
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
            if ((expectedSize = this.txFile.readFixedRowCount()) != actualSize || maxTimestamp != this.txFile.getMaxTimestamp()) {
                LOG.info().$("actual table size has been adjusted [name=`").utf8(this.tableName).$('`').$(", expectedFixedSize=").$(expectedSize).$(", actualFixedSize=").$(actualSize).$(']').$();
                this.txFile.reset(actualSize, transientRowCount, maxTimestamp);
                return maxTimestamp;
            }
        }
        return timestamp;
    }

    private void repairMetaRename(int index) {
        try {
            this.path.concat("_meta.prev");
            if (index > 0) {
                this.path.put('.').put(index);
            }
            this.path.$();
            if (this.ff.exists(this.path)) {
                LOG.info().$("Repairing metadata from: ").$(this.path).$();
                if (this.ff.exists(this.other.concat("_meta").$()) && !this.ff.remove(this.other)) {
                    throw CairoException.instance(this.ff.errno()).put("Repair failed. Cannot replace ").put(this.other);
                }
                if (!this.ff.rename(this.path, this.other)) {
                    throw CairoException.instance(this.ff.errno()).put("Repair failed. Cannot rename ").put(this.path).put(" -> ").put(this.other);
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
        this.clearTodoLog();
    }

    private void repairTruncate() {
        LOG.info().$("repairing abnormally terminated truncate on ").$(this.path).$();
        if (this.partitionBy != 3) {
            this.removePartitionDirectories();
        }
        this.txFile.reset();
        this.clearTodoLog();
    }

    private void restoreMetaFrom(CharSequence fromBase, int fromIndex) {
        try {
            this.path.concat(fromBase);
            if (fromIndex > 0) {
                this.path.put('.').put(fromIndex);
            }
            this.path.$();
            TableUtils.renameOrFail(this.ff, this.path, this.other.concat("_meta").$());
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void rollbackIndexes() {
        long maxRow = this.txFile.getTransientRowCount() - 1L;
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long fd = indexer.getFd();
            LOG.info().$("recovering index [fd=").$(fd).$(']').$();
            if (fd <= -1L) continue;
            indexer.rollback(maxRow);
        }
    }

    private void rollbackSymbolTables() {
        int expectedMapWriters = this.txFile.readWriterCount();
        for (int i = 0; i < expectedMapWriters; ++i) {
            this.denseSymbolMapWriters.getQuick(i).rollback(this.txFile.readSymbolWriterIndexOffset(i));
        }
    }

    private void runFragile(FragileCode fragile, CharSequence columnName, CairoException e) {
        try {
            fragile.run(columnName);
        }
        catch (CairoException err) {
            LOG.error().$("DOUBLE ERROR: 1st: {").$(e).$('}').$();
            this.throwDistressException(err);
        }
        throw e;
    }

    private void setAppendPosition(long position, boolean ensureFileSize) {
        for (int i = 0; i < this.columnCount; ++i) {
            TableWriter.setColumnSize(this.ff, this.getPrimaryColumn(i), this.getSecondaryColumn(i), TableUtils.getColumnType(this.metaMem, i), position - this.columnTops.getQuick(i), this.tempMem16b, ensureFileSize);
        }
    }

    private void setStateForTimestamp(Path path, long timestamp, boolean updatePartitionInterval) {
        long partitionTimestampHi = TableUtils.setPathForPartition(path, this.partitionBy, timestamp, true);
        TableUtils.txnPartitionConditionally(path, this.txFile.getPartitionNameTxnByPartitionTimestamp(partitionTimestampHi));
        if (updatePartitionInterval) {
            this.partitionTimestampHi = partitionTimestampHi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startAppendedBlock(long timestampLo, long timestampHi, long nRowsAdded, LongList blockColumnTops) {
        int columnIndex;
        if (timestampLo < this.txFile.getMaxTimestamp()) {
            throw CairoException.instance(this.ff.errno()).put("Cannot insert rows out of order. Table=").put(this.path);
        }
        if (this.txFile.getAppendedPartitionCount() == 0) {
            this.openFirstPartition(timestampLo);
        }
        if (this.partitionBy != 3 && timestampLo > this.partitionTimestampHi) {
            for (columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                AppendOnlyVirtualMemory mem1 = this.getPrimaryColumn(columnIndex);
                mem1.close(false);
                AppendOnlyVirtualMemory mem2 = this.getSecondaryColumn(columnIndex);
                if (null == mem2) continue;
                mem2.close(false);
            }
            this.switchPartition(timestampLo);
        }
        this.txFile.appendBlock(timestampLo, timestampHi, nRowsAdded);
        for (columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            long columnTop;
            long blockColumnTop = blockColumnTops.getQuick(columnIndex);
            if (blockColumnTop == -1L || blockColumnTop == (columnTop = this.columnTops.getQuick(columnIndex))) continue;
            try {
                assert (columnTop == 0L);
                assert (blockColumnTop > 0L);
                TableUtils.setPathForPartition(this.path, this.partitionBy, timestampLo, false);
                this.columnTops.setQuick(columnIndex, blockColumnTop);
                this.writeColumnTop(this.getMetadata().getColumnName(columnIndex), blockColumnTop);
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void switchPartition(long timestamp) {
        this.updateIndexes();
        this.txFile.switchPartitions(timestamp);
        this.openPartition(timestamp);
        this.setAppendPosition(0L, false);
    }

    private void syncColumns(int commitMode) {
        boolean async = commitMode == 0;
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns.getQuick(i * 2).sync(async);
            AppendOnlyVirtualMemory m2 = this.columns.getQuick(i * 2 + 1);
            if (m2 == null) continue;
            m2.sync(false);
        }
    }

    private void throwDistressException(Throwable cause) {
        this.distressed = true;
        throw new CairoError(cause);
    }

    private void updateIndexes() {
        if (this.indexCount == 0 || this.avoidIndexOnCommit) {
            this.avoidIndexOnCommit = false;
            return;
        }
        this.updateIndexesSlow();
    }

    private void updateIndexesParallel(long lo, long hi) {
        int i;
        this.indexSequences.clear();
        this.indexLatch.setCount(this.indexCount);
        int nParallelIndexes = this.indexCount - 1;
        Sequence indexPubSequence = this.messageBus.getIndexerPubSequence();
        RingQueue<ColumnIndexerTask> indexerQueue = this.messageBus.getIndexerQueue();
        LOG.info().$("parallel indexing [indexCount=").$(this.indexCount).$(']').$();
        int serialIndexCount = 0;
        block0: for (i = 0; i < nParallelIndexes; ++i) {
            long cursor = indexPubSequence.next();
            if (cursor == -1L) {
                TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                ++serialIndexCount;
                continue;
            }
            if (cursor == -2L) {
                do {
                    if ((cursor = indexPubSequence.next()) != -1L) continue;
                    TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                    ++serialIndexCount;
                    continue block0;
                } while (cursor < 0L);
            }
            ColumnIndexerTask queueItem = indexerQueue.get(cursor);
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long sequence = indexer.getSequence();
            queueItem.indexer = indexer;
            queueItem.lo = lo;
            queueItem.hi = hi;
            queueItem.countDownLatch = this.indexLatch;
            queueItem.sequence = sequence;
            this.indexSequences.add(sequence);
            indexPubSequence.done(cursor);
        }
        TableWriter.indexAndCountDown(this.denseIndexers.getQuick(this.indexCount - 1), lo, hi, this.indexLatch);
        ++serialIndexCount;
        if (!this.indexLatch.await(this.configuration.getWorkStealTimeoutNanos())) {
            for (i = 0; i < nParallelIndexes; ++i) {
                ColumnIndexer indexer = this.denseIndexers.getQuick(i);
                if (!indexer.tryLock(this.indexSequences.getQuick(i))) continue;
                TableWriter.indexAndCountDown(indexer, lo, hi, this.indexLatch);
                ++serialIndexCount;
            }
            this.indexLatch.await();
        }
        boolean distressed = false;
        for (int i2 = 0; i2 < this.indexCount; ++i2) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i2);
            distressed |= indexer.isDistressed();
        }
        if (distressed) {
            this.throwDistressException(null);
        }
        LOG.info().$("parallel indexing done [serialCount=").$(serialIndexCount).$(']').$();
    }

    private void updateIndexesSerially(long lo, long hi) {
        LOG.info().$("serial indexing [indexCount=").$(this.indexCount).$(']').$();
        int n = this.indexCount;
        for (int i = 0; i < n; ++i) {
            try {
                this.denseIndexers.getQuick(i).refreshSourceAndIndex(lo, hi);
                continue;
            }
            catch (CairoException e) {
                LOG.error().$("index error {").$(e).$('}').$();
                this.throwDistressException(e);
            }
        }
        LOG.info().$("serial indexing done [indexCount=").$(this.indexCount).$(']').$();
    }

    private void updateIndexesSlow() {
        long lo;
        long hi = this.txFile.getTransientRowCount();
        long l = lo = this.txFile.getAppendedPartitionCount() == 1 ? hi - this.txFile.getLastTxSize() : 0L;
        if (this.indexCount > 1 && this.parallelIndexerEnabled && hi - lo > (long)this.configuration.getParallelIndexThreshold()) {
            this.updateIndexesParallel(lo, hi);
        } else {
            this.updateIndexesSerially(lo, hi);
        }
    }

    private void updateMaxTimestamp(long timestamp) {
        this.txFile.updateMaxTimestamp(timestamp);
        this.timestampSetter.accept(timestamp);
    }

    private void validateSwapMeta(CharSequence columnName) {
        try {
            try {
                this.path.concat("_meta.swp");
                if (this.metaSwapIndex > 0) {
                    this.path.put('.').put(this.metaSwapIndex);
                }
                this.metaMem.of(this.ff, this.path.$(), this.ff.getPageSize(), this.ff.length(this.path));
                this.validationMap.clear();
                TableUtils.validate(this.ff, this.metaMem, this.validationMap);
            }
            finally {
                this.metaMem.close();
                this.path.trimTo(this.rootLen);
            }
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void writeColumnEntry(int i) {
        this.ddlMem.putByte((byte)TableUtils.getColumnType(this.metaMem, i));
        long flags = 0L;
        if (TableUtils.isColumnIndexed(this.metaMem, i)) {
            flags |= 1L;
        }
        if (TableUtils.isSequential(this.metaMem, i)) {
            flags |= 2L;
        }
        this.ddlMem.putLong(flags);
        this.ddlMem.putInt(TableUtils.getIndexBlockCapacity(this.metaMem, i));
        this.ddlMem.skip(3L);
    }

    private void writeColumnTop(CharSequence name) {
        this.writeColumnTop(name, this.txFile.getTransientRowCount());
    }

    private void writeColumnTop(CharSequence name, long columnTop) {
        TableUtils.writeColumnTop(this.ff, this.path, name, columnTop, this.tempMem16b);
    }

    private void writeRestoreMetaTodo(CharSequence columnName) {
        try {
            this.writeRestoreMetaTodo();
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_TODO_WRITE_FAILURE, columnName, e);
        }
    }

    private void writeRestoreMetaTodo() {
        this.todoMem.putLong(0L, ++this.todoTxn);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(8L, this.configuration.getDatabaseIdLo());
        this.todoMem.putLong(16L, this.configuration.getDatabaseIdHi());
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(32L, 1L);
        this.todoMem.putLong(40L, 2L);
        this.todoMem.putLong(48L, this.metaPrevIndex);
        Unsafe.getUnsafe().storeFence();
        this.todoMem.putLong(24L, this.todoTxn);
        this.todoMem.setSize(56L);
    }

    static {
        IGNORED_FILES.add("..");
        IGNORED_FILES.add(".");
        IGNORED_FILES.add("_meta");
        IGNORED_FILES.add("_txn");
        IGNORED_FILES.add("_todo_");
    }

    private class WriterTransientSymbolCountChangeHandler
    implements SymbolMapWriter.TransientSymbolCountChangeHandler {
        private int symColIndex;

        private WriterTransientSymbolCountChangeHandler(int symColIndex) {
            this.symColIndex = symColIndex;
        }

        @Override
        public void handleTransientSymbolCountChange(int symbolCount) {
            Unsafe.getUnsafe().storeFence();
            TableWriter.this.txFile.writeTransientSymbolCount(this.symColIndex, symbolCount);
        }
    }

    public class Row {
        private ObjList<? extends WriteOnlyVirtualMemory> activeColumns;
        private ObjList<Runnable> activeNullSetters;

        public void append() {
            if ((TableWriter.this.masterRef & 1L) != 0L) {
                for (int i = 0; i < TableWriter.this.columnCount; ++i) {
                    if (TableWriter.this.refs.getQuick(i) >= TableWriter.this.masterRef) continue;
                    this.activeNullSetters.getQuick(i).run();
                }
                TableWriter.this.masterRef++;
            }
        }

        public void cancel() {
            TableWriter.this.cancelRow();
        }

        public void putBin(int index, long address, long len) {
            this.getSecondaryColumn(index).putLong(this.getPrimaryColumn(index).putBin(address, len));
            this.notNull(index);
        }

        public void putBin(int index, BinarySequence sequence) {
            this.getSecondaryColumn(index).putLong(this.getPrimaryColumn(index).putBin(sequence));
            this.notNull(index);
        }

        public void putBool(int index, boolean value) {
            this.getPrimaryColumn(index).putBool(value);
            this.notNull(index);
        }

        public void putByte(int index, byte value) {
            this.getPrimaryColumn(index).putByte(value);
            this.notNull(index);
        }

        public void putChar(int index, char value) {
            this.getPrimaryColumn(index).putChar(value);
            this.notNull(index);
        }

        public void putDate(int index, long value) {
            this.putLong(index, value);
        }

        public void putDouble(int index, double value) {
            this.getPrimaryColumn(index).putDouble(value);
            this.notNull(index);
        }

        public void putFloat(int index, float value) {
            this.getPrimaryColumn(index).putFloat(value);
            this.notNull(index);
        }

        public void putInt(int index, int value) {
            this.getPrimaryColumn(index).putInt(value);
            this.notNull(index);
        }

        public void putLong(int index, long value) {
            this.getPrimaryColumn(index).putLong(value);
            this.notNull(index);
        }

        public void putLong256(int index, long l0, long l1, long l2, long l3) {
            this.getPrimaryColumn(index).putLong256(l0, l1, l2, l3);
            this.notNull(index);
        }

        public void putLong256(int index, Long256 value) {
            this.getPrimaryColumn(index).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            this.notNull(index);
        }

        public void putLong256(int index, CharSequence hexString) {
            this.getPrimaryColumn(index).putLong256(hexString);
            this.notNull(index);
        }

        public void putLong256(int index, @NotNull CharSequence hexString, int start, int end) {
            this.getPrimaryColumn(index).putLong256(hexString, start, end);
            this.notNull(index);
        }

        public void putShort(int index, short value) {
            this.getPrimaryColumn(index).putShort(value);
            this.notNull(index);
        }

        public void putStr(int index, CharSequence value) {
            this.getSecondaryColumn(index).putLong(this.getPrimaryColumn(index).putStr(value));
            this.notNull(index);
        }

        public void putStr(int index, char value) {
            this.getSecondaryColumn(index).putLong(this.getPrimaryColumn(index).putStr(value));
            this.notNull(index);
        }

        public void putStr(int index, CharSequence value, int pos, int len) {
            this.getSecondaryColumn(index).putLong(this.getPrimaryColumn(index).putStr(value, pos, len));
            this.notNull(index);
        }

        public void putSym(int index, CharSequence value) {
            this.getPrimaryColumn(index).putInt(((SymbolMapWriter)TableWriter.this.symbolMapWriters.getQuick(index)).put(value));
            this.notNull(index);
        }

        public void putSym(int index, char value) {
            this.getPrimaryColumn(index).putInt(((SymbolMapWriter)TableWriter.this.symbolMapWriters.getQuick(index)).put(value));
            this.notNull(index);
        }

        public void putSymIndex(int index, int symIndex) {
            this.getPrimaryColumn(index).putInt(symIndex);
            this.notNull(index);
        }

        public void putTimestamp(int index, long value) {
            this.putLong(index, value);
        }

        public void putTimestamp(int index, CharSequence value) {
            long l;
            try {
                l = value != null ? IntervalUtils.parseFloorPartialDate(value) : Long.MIN_VALUE;
            }
            catch (NumericException e) {
                throw CairoException.instance(0).put("Invalid timestamp: ").put(value);
            }
            this.putTimestamp(index, l);
        }

        private WriteOnlyVirtualMemory getPrimaryColumn(int columnIndex) {
            return this.activeColumns.getQuick(TableWriter.getPrimaryColumnIndex(columnIndex));
        }

        private WriteOnlyVirtualMemory getSecondaryColumn(int columnIndex) {
            return this.activeColumns.getQuick(TableWriter.getSecondaryColumnIndex(columnIndex));
        }

        private void notNull(int index) {
            TableWriter.this.refs.setQuick(index, TableWriter.this.masterRef);
        }
    }

    private class SwitchPartitionRowFunction
    implements RowFunction {
        private SwitchPartitionRowFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            if (timestamp > TableWriter.this.partitionTimestampHi || timestamp < TableWriter.this.txFile.getMaxTimestamp()) {
                return this.newRow0(timestamp);
            }
            TableWriter.this.updateMaxTimestamp(timestamp);
            TableWriter.this.txFile.append();
            return TableWriter.this.row;
        }

        @NotNull
        private Row newRow0(long timestamp) {
            if (timestamp < TableWriter.this.txFile.getMaxTimestamp()) {
                return this.newRowO3(timestamp);
            }
            if (timestamp > TableWriter.this.partitionTimestampHi && TableWriter.this.partitionBy != 3) {
                TableWriter.this.switchPartition(timestamp);
            }
            TableWriter.this.updateMaxTimestamp(timestamp);
            TableWriter.this.txFile.append();
            return TableWriter.this.row;
        }

        private Row newRowO3(long timestamp) {
            LOG.info().$("switched to o3 [table=").utf8(TableWriter.this.tableName).$(']').$();
            TableWriter.this.txFile.beginPartitionSizeUpdate();
            TableWriter.this.o3OpenColumns();
            TableWriter.this.o3InError = false;
            TableWriter.this.o3MasterRef = TableWriter.this.masterRef;
            TableWriter.this.o3TimestampSetter(timestamp);
            TableWriter.this.rowFunction = TableWriter.this.o3RowFunction;
            return TableWriter.this.row;
        }
    }

    private class O3PartitionFunction
    implements RowFunction {
        private O3PartitionFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            TableWriter.this.o3TimestampSetter(timestamp);
            return TableWriter.this.row;
        }
    }

    private class NoTimestampFunction
    implements RowFunction {
        private NoTimestampFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            TableWriter.this.txFile.append();
            return TableWriter.this.row;
        }
    }

    private class NoPartitionFunction
    implements RowFunction {
        private NoPartitionFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            TableWriter.this.txFile.append();
            if (timestamp >= TableWriter.this.txFile.getMaxTimestamp()) {
                TableWriter.this.updateMaxTimestamp(timestamp);
                return TableWriter.this.row;
            }
            throw CairoException.instance(TableWriter.this.ff.errno()).put("Cannot insert rows out of order. Table=").put(TableWriter.this.path);
        }
    }

    private class OpenPartitionRowFunction
    implements RowFunction {
        private OpenPartitionRowFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            if (TableWriter.this.txFile.getMaxTimestamp() != Long.MIN_VALUE) {
                return (TableWriter.this.rowFunction = TableWriter.this.switchPartitionFunction).newRow(timestamp);
            }
            return this.getRowSlow(timestamp);
        }

        private Row getRowSlow(long timestamp) {
            if (timestamp >= -62135596800000000L) {
                TableWriter.this.txFile.setMinTimestamp(timestamp);
                TableWriter.this.openFirstPartition(timestamp);
                return (TableWriter.this.rowFunction = TableWriter.this.switchPartitionFunction).newRow(timestamp);
            }
            throw CairoException.instance(0).put("timestamp before 0001-01-01 is not allowed");
        }
    }

    static class TimestampValueRecord
    implements Record {
        private long value;

        TimestampValueRecord() {
        }

        @Override
        public long getTimestamp(int col) {
            return this.value;
        }

        public void setTimestamp(long value) {
            this.value = value;
        }
    }

    @FunctionalInterface
    public static interface O3ColumnUpdateMethod {
        public void run(int var1, int var2, long var3, long var5);
    }

    @FunctionalInterface
    private static interface FragileCode {
        public void run(CharSequence var1);
    }

    @FunctionalInterface
    private static interface RemoveFileLambda {
        public void remove(FilesFacade var1, LPSZ var2);
    }
}

