/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Mappable;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TxReader
implements Closeable {
    protected static final int PARTITION_TS_OFFSET = 0;
    protected static final int PARTITION_SIZE_OFFSET = 1;
    protected static final int PARTITION_NAME_TX_OFFSET = 2;
    protected static final int PARTITION_DATA_TX_OFFSET = 3;
    protected final FilesFacade ff;
    protected final int rootLen;
    protected final LongList attachedPartitions = new LongList();
    private final Timestamps.TimestampFloorMethod timestampFloorMethod;
    protected Path path;
    protected long minTimestamp;
    protected long maxTimestamp;
    protected long txn;
    protected int symbolsCount;
    protected long dataVersion;
    protected long structureVersion;
    protected long fixedRowCount;
    protected long transientRowCount;
    protected int partitionBy;
    protected long partitionTableVersion;
    protected int attachedPartitionsSize = 0;
    private MappedReadOnlyMemory roTxMem;

    public TxReader(FilesFacade ff, Path path, int partitionBy) {
        this.ff = ff;
        this.path = new Path(path.length() + 10);
        this.path.put(path);
        this.rootLen = path.length();
        try {
            this.roTxMem = (MappedReadOnlyMemory)this.openTxnFile(this.ff, this.path, this.rootLen);
            this.timestampFloorMethod = partitionBy != 3 ? TableUtils.getPartitionFloor(partitionBy) : null;
            this.partitionBy = partitionBy;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public boolean attachedPartitionsContains(long ts) {
        return this.findAttachedPartitionIndex(ts) > -1;
    }

    @Override
    public void close() {
        this.roTxMem = Misc.free(this.roTxMem);
        this.path = Misc.free(this.path);
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public long getFixedRowCount() {
        return this.fixedRowCount;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public int getPartitionCount() {
        return this.attachedPartitions.size() / 4;
    }

    public long getPartitionDataTxn(int i) {
        return this.getPartitionDataTxnByIndex(i * 4);
    }

    public long getPartitionDataTxnByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 3);
    }

    public long getPartitionNameTxn(int i) {
        return this.getPartitionNameTxnByIndex(i * 4);
    }

    public long getPartitionNameTxnByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 2);
    }

    public long getPartitionNameTxnByPartitionTimestamp(long ts) {
        int index = this.findAttachedPartitionIndex(ts);
        if (index > -1) {
            return this.attachedPartitions.getQuick(index + 2);
        }
        return -1L;
    }

    public long getPartitionSize(int i) {
        return this.getPartitionSizeByIndex(i * 4);
    }

    public long getPartitionSizeByIndex(int index) {
        return this.attachedPartitions.getQuick(index + 1);
    }

    public long getPartitionSizeByPartitionTimestamp(long ts) {
        int index = this.findAttachedPartitionIndex(ts);
        if (index > -1) {
            return this.attachedPartitions.getQuick(index + 1);
        }
        return -1L;
    }

    public long getPartitionTableVersion() {
        return this.partitionTableVersion;
    }

    public long getPartitionTimestamp(int i) {
        return this.attachedPartitions.getQuick(i * 4 + 0);
    }

    public long getRowCount() {
        return this.transientRowCount + this.fixedRowCount;
    }

    public long getStructureVersion() {
        return this.structureVersion;
    }

    public long getTransientRowCount() {
        return this.transientRowCount;
    }

    public long getTxEofOffset() {
        return TableUtils.getTxMemSize(this.symbolsCount, this.attachedPartitions.size());
    }

    public long getTxn() {
        return this.txn;
    }

    public long readFixedRowCount() {
        return this.roTxMem.getLong(16L);
    }

    public int readSymbolCount(int symbolIndex) {
        return this.roTxMem.getInt(TableUtils.getSymbolWriterIndexOffset(symbolIndex));
    }

    public void readSymbolCounts(IntList symbolCountSnapshot) {
        int symbolMapCount = this.roTxMem.getInt(72L);
        if (symbolMapCount > 0) {
            for (int i = 0; i < symbolMapCount; ++i) {
                symbolCountSnapshot.add(this.roTxMem.getInt(TableUtils.getSymbolWriterIndexOffset(i)));
            }
        }
    }

    public int readSymbolWriterIndexOffset(int i) {
        return this.roTxMem.getInt(TableUtils.getSymbolWriterIndexOffset(i));
    }

    public long readTxn() {
        return this.roTxMem.getLong(0L);
    }

    public long readTxnCheck() {
        return this.roTxMem.getLong(64L);
    }

    public void readUnchecked() {
        this.txn = this.roTxMem.getLong(0L);
        this.transientRowCount = this.roTxMem.getLong(8L);
        this.fixedRowCount = this.roTxMem.getLong(16L);
        this.minTimestamp = this.roTxMem.getLong(24L);
        this.maxTimestamp = this.roTxMem.getLong(32L);
        this.dataVersion = this.roTxMem.getLong(48L);
        this.structureVersion = this.roTxMem.getLong(40L);
        long prevSymbolCount = this.symbolsCount;
        this.symbolsCount = this.roTxMem.getInt(72L);
        if (prevSymbolCount != (long)this.symbolsCount) {
            this.roTxMem.growToFileSize();
        }
        long prevPartitionTableVersion = this.partitionTableVersion;
        this.partitionTableVersion = this.roTxMem.getLong(56L);
        this.loadAttachedPartitions(prevPartitionTableVersion);
    }

    public int readWriterCount() {
        return this.roTxMem.getInt(72L);
    }

    private void copyAttachedPartitionsFromTx(int txAttachedPartitionsSize, int max) {
        this.roTxMem.grow(TableUtils.getPartitionTableIndexOffset(this.symbolsCount, txAttachedPartitionsSize));
        this.attachedPartitions.setPos(txAttachedPartitionsSize);
        for (int i = max; i < txAttachedPartitionsSize; ++i) {
            this.attachedPartitions.setQuick(i, this.roTxMem.getLong(TableUtils.getPartitionTableIndexOffset(this.symbolsCount, i)));
        }
        this.attachedPartitionsSize = txAttachedPartitionsSize;
    }

    protected int findAttachedPartitionIndex(long ts) {
        return this.findAttachedPartitionIndexByLoTimestamp(this.getPartitionTimestampLo(ts));
    }

    int findAttachedPartitionIndexByLoTimestamp(long ts) {
        int hi = this.attachedPartitions.size() - 4;
        if (hi > -1) {
            long last = this.attachedPartitions.getQuick(hi);
            if (last < ts) {
                return -(hi + 4 + 1);
            }
            if (last == ts) {
                return hi;
            }
        }
        return this.attachedPartitions.binarySearchBlock(0, this.attachedPartitions.size(), TableUtils.LONGS_PER_TX_ATTACHED_PARTITION_MSB, ts);
    }

    int getLastPartitionIndex() {
        return this.attachedPartitions.size() - 4;
    }

    long getPartitionTimestampLo(long timestamp) {
        return this.timestampFloorMethod != null && timestamp != Long.MIN_VALUE ? this.timestampFloorMethod.floor(timestamp) : Long.MIN_VALUE;
    }

    protected void initPartitionAt(int index, long partitionTimestampLo, long partitionSize) {
        this.attachedPartitions.setQuick(index + 0, partitionTimestampLo);
        this.attachedPartitions.setQuick(index + 1, partitionSize);
        this.attachedPartitions.setQuick(index + 2, -1L);
        this.attachedPartitions.setQuick(index + 3, this.txn);
    }

    private void loadAttachedPartitions(long prevPartitionTableVersion) {
        if (this.partitionBy != 3) {
            int txAttachedPartitionsSize = this.roTxMem.getInt(TableUtils.getPartitionTableSizeOffset(this.symbolsCount)) / 8;
            if (txAttachedPartitionsSize > 0) {
                if (prevPartitionTableVersion != this.partitionTableVersion) {
                    this.attachedPartitions.clear();
                    this.copyAttachedPartitionsFromTx(txAttachedPartitionsSize, 0);
                } else if (this.attachedPartitionsSize < txAttachedPartitionsSize) {
                    this.copyAttachedPartitionsFromTx(txAttachedPartitionsSize, Math.max(this.attachedPartitionsSize - 4, 0));
                }
                this.attachedPartitions.setQuick(txAttachedPartitionsSize - 4 + 1, this.transientRowCount);
            } else {
                this.attachedPartitionsSize = 0;
                this.attachedPartitions.clear();
            }
        } else {
            this.attachedPartitions.setPos(4);
            this.initPartitionAt(0, Long.MIN_VALUE, this.transientRowCount);
        }
    }

    protected Mappable openTxnFile(FilesFacade ff, Path path, int rootLen) {
        try {
            if (this.ff.exists(this.path.concat("_txn").$())) {
                SinglePageMappedReadOnlyPageMemory singlePageMappedReadOnlyPageMemory = new SinglePageMappedReadOnlyPageMemory(ff, path, ff.length(path));
                return singlePageMappedReadOnlyPageMemory;
            }
            throw CairoException.instance(ff.errno()).put("Cannot append. File does not exist: ").put(this.path);
        }
        finally {
            this.path.trimTo(rootLen);
        }
    }

    void readRowCounts() {
        this.transientRowCount = this.roTxMem.getLong(8L);
        this.fixedRowCount = this.roTxMem.getLong(16L);
    }
}

