/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.vm.Mappable;
import io.questdb.cairo.vm.PagedMappedReadWriteMemory;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.io.Closeable;

public final class TxWriter
extends TxReader
implements Closeable {
    private int attachedPositionDirtyIndex;
    private int txPartitionCount;
    private long prevMaxTimestamp;
    private long prevMinTimestamp;
    protected long prevTransientRowCount;
    private PagedMappedReadWriteMemory txMem;

    public TxWriter(FilesFacade ff, Path path, int partitionBy) {
        super(ff, path, partitionBy);
        try {
            this.readUnchecked();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public void append() {
        ++this.transientRowCount;
    }

    public void appendBlock(long timestampLo, long timestampHi, long nRowsAdded) {
        if (timestampLo < this.maxTimestamp) {
            throw CairoException.instance(this.ff.errno()).put("Cannot insert rows out of order. Table=").put(this.path);
        }
        if (this.txPartitionCount == 0) {
            this.txPartitionCount = 1;
        }
        this.maxTimestamp = timestampHi;
        this.transientRowCount += nRowsAdded;
    }

    public void beginPartitionSizeUpdate() {
        if (this.maxTimestamp != Long.MIN_VALUE) {
            this.updatePartitionSizeByTimestamp(this.maxTimestamp, this.transientRowCount);
        }
    }

    public void bumpStructureVersion(ObjList<SymbolMapWriter> denseSymbolMapWriters) {
        this.txMem.putLong(0L, ++this.txn);
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(40L, ++this.structureVersion);
        int count = denseSymbolMapWriters.size();
        int oldCount = this.txMem.getInt(72L);
        this.txMem.putInt(72L, count);
        this.storeSymbolCounts(denseSymbolMapWriters);
        if (oldCount != count) {
            this.attachedPositionDirtyIndex = 0;
            this.saveAttachedPartitionsToTx(count);
            this.symbolsCount = count;
        }
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(64L, this.txn);
    }

    public void cancelRow() {
        if (this.transientRowCount == 0L && this.txPartitionCount > 1) {
            --this.txPartitionCount;
            this.fixedRowCount -= this.prevTransientRowCount;
            this.transientRowCount = this.prevTransientRowCount;
            this.attachedPartitions.setPos(this.attachedPartitions.size() - 4);
        }
        this.maxTimestamp = this.prevMaxTimestamp;
        this.minTimestamp = this.prevMinTimestamp;
    }

    public long cancelToMaxTimestamp() {
        return this.prevMaxTimestamp;
    }

    public long cancelToTransientRowCount() {
        return this.prevTransientRowCount;
    }

    @Override
    public void close() {
        try {
            if (this.txMem != null) {
                this.txMem.jumpTo(this.getTxEofOffset());
            }
        }
        finally {
            super.close();
        }
    }

    @Override
    public void readUnchecked() {
        super.readUnchecked();
        this.prevTransientRowCount = this.transientRowCount;
        this.prevMaxTimestamp = this.maxTimestamp;
        this.prevMinTimestamp = this.minTimestamp;
    }

    @Override
    protected Mappable openTxnFile(FilesFacade ff, Path path, int rootLen) {
        try {
            if (ff.exists(path.concat("_txn").$())) {
                PagedMappedReadWriteMemory pagedMappedReadWriteMemory = this.txMem = new PagedMappedReadWriteMemory(ff, path, ff.getPageSize());
                return pagedMappedReadWriteMemory;
            }
            throw CairoException.instance(ff.errno()).put("Cannot append. File does not exist: ").put(path);
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    public void commit(int commitMode, ObjList<SymbolMapWriter> denseSymbolMapWriters) {
        this.txMem.putLong(0L, ++this.txn);
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(8L, this.transientRowCount);
        this.txMem.putLong(16L, this.fixedRowCount);
        this.txMem.putLong(24L, this.minTimestamp);
        this.txMem.putLong(32L, this.maxTimestamp);
        this.txMem.putLong(56L, this.partitionTableVersion);
        this.storeSymbolCounts(denseSymbolMapWriters);
        this.symbolsCount = denseSymbolMapWriters.size();
        this.txPartitionCount = 1;
        this.saveAttachedPartitionsToTx(this.symbolsCount);
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(64L, this.txn);
        if (commitMode != 2) {
            this.txMem.sync(0, commitMode == 0);
        }
        this.prevTransientRowCount = this.transientRowCount;
    }

    public void finishPartitionSizeUpdate(long minTimestamp, long maxTimestamp) {
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        assert (this.getPartitionCount() > 0);
        this.transientRowCount = this.getPartitionSize(this.getPartitionCount() - 1);
        this.fixedRowCount = 0L;
        int hi = this.getPartitionCount() - 1;
        for (int i = 0; i < hi; ++i) {
            this.fixedRowCount += this.getPartitionSize(i);
        }
        ++this.txPartitionCount;
    }

    public int getAppendedPartitionCount() {
        return this.txPartitionCount;
    }

    public long getLastTxSize() {
        return this.txPartitionCount == 1 ? this.transientRowCount - this.prevTransientRowCount : this.transientRowCount;
    }

    public boolean inTransaction() {
        return this.txPartitionCount > 1 || this.transientRowCount != this.prevTransientRowCount;
    }

    public boolean isActivePartition(long timestamp) {
        return this.getPartitionTimestampLo(this.maxTimestamp) == timestamp;
    }

    public void newBlock() {
        this.prevMaxTimestamp = this.maxTimestamp;
    }

    public void openFirstPartition(long timestamp) {
        this.txPartitionCount = 1;
        this.updateAttachedPartitionSizeByTimestamp(timestamp, 0L);
    }

    public void removeAttachedPartitions(long timestamp) {
        long partitionTimestampLo = this.getPartitionTimestampLo(timestamp);
        int index = this.findAttachedPartitionIndexByLoTimestamp(partitionTimestampLo);
        if (index > -1) {
            int size = this.attachedPartitions.size();
            if (index + 4 < size) {
                this.attachedPartitions.arrayCopy(index + 4, index, size - index - 4);
                this.attachedPositionDirtyIndex = Math.min(this.attachedPositionDirtyIndex, index);
            }
            this.attachedPartitions.setPos(size - 4);
            ++this.partitionTableVersion;
        }
    }

    public void reset(long fixedRowCount, long transientRowCount, long maxTimestamp) {
        long txn = this.txMem.getLong(0L) + 1L;
        this.txMem.putLong(0L, txn);
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(16L, fixedRowCount);
        if (this.maxTimestamp != maxTimestamp) {
            this.txMem.putLong(32L, maxTimestamp);
            this.txMem.putLong(8L, transientRowCount);
        }
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(64L, txn);
        this.fixedRowCount = fixedRowCount;
        this.maxTimestamp = maxTimestamp;
        this.transientRowCount = transientRowCount;
        this.txn = txn;
    }

    public void reset() {
        TableUtils.resetTxn(this.txMem, this.symbolsCount, this.txMem.getLong(0L) + 1L, this.txMem.getLong(48L) + 1L, this.txMem.getLong(56L) + 1L);
    }

    public void resetTimestamp() {
        this.prevMaxTimestamp = Long.MIN_VALUE;
        this.prevMinTimestamp = Long.MAX_VALUE;
        this.maxTimestamp = this.prevMaxTimestamp;
        this.minTimestamp = this.prevMinTimestamp;
    }

    public void setMinTimestamp(long timestamp) {
        this.minTimestamp = timestamp;
        if (this.prevMinTimestamp == Long.MAX_VALUE) {
            this.prevMinTimestamp = this.minTimestamp;
        }
    }

    public void switchPartitions(long timestamp) {
        this.fixedRowCount += this.transientRowCount;
        this.prevTransientRowCount = this.transientRowCount;
        long partitionTimestampLo = this.getPartitionTimestampLo(this.maxTimestamp);
        int index = this.findAttachedPartitionIndexByLoTimestamp(partitionTimestampLo);
        this.updatePartitionSizeByIndex(index, this.transientRowCount);
        this.attachedPositionDirtyIndex = Math.min(this.attachedPositionDirtyIndex, index);
        this.attachedPartitions.setPos((index += 4) + 4);
        long newTimestampLo = this.getPartitionTimestampLo(timestamp);
        this.initPartitionAt(index, newTimestampLo, 0L);
        this.transientRowCount = 0L;
        ++this.txPartitionCount;
    }

    public void truncate() {
        this.maxTimestamp = Long.MIN_VALUE;
        this.minTimestamp = Long.MAX_VALUE;
        this.prevTransientRowCount = 0L;
        this.transientRowCount = 0L;
        this.fixedRowCount = 0L;
        ++this.txn;
        this.txPartitionCount = 1;
        this.attachedPositionDirtyIndex = 0;
        this.attachedPartitions.clear();
        TableUtils.resetTxn(this.txMem, this.symbolsCount, this.txn, ++this.dataVersion, ++this.partitionTableVersion);
    }

    public void updateMaxTimestamp(long timestamp) {
        this.prevMaxTimestamp = this.maxTimestamp;
        assert (timestamp >= this.maxTimestamp);
        this.maxTimestamp = timestamp;
    }

    public void updatePartitionSizeByIndex(int partitionIndex, long partitionTimestampLo, long rowCount) {
        this.attachedPositionDirtyIndex = Math.min(this.attachedPositionDirtyIndex, this.updateAttachedPartitionSizeByIndex(partitionIndex, partitionTimestampLo, rowCount));
    }

    public void updatePartitionSizeByTimestamp(long timestamp, long rowCount) {
        this.attachedPositionDirtyIndex = Math.min(this.attachedPositionDirtyIndex, this.updateAttachedPartitionSizeByTimestamp(timestamp, rowCount));
    }

    public void writeTransientSymbolCount(int symbolIndex, int symCount) {
        this.txMem.putInt(TableUtils.getSymbolWriterTransientIndexOffset(symbolIndex), symCount);
    }

    void bumpPartitionTableVersion() {
        ++this.partitionTableVersion;
    }

    long getCommittedFixedRowCount() {
        return this.txMem.getLong(16L);
    }

    long getCommittedTransientRowCount() {
        return this.txMem.getLong(8L);
    }

    private int insertPartitionSizeByTimestamp(int index, long partitionTimestamp, long partitionSize) {
        int size = this.attachedPartitions.size();
        this.attachedPartitions.setPos(size + 4);
        if (index < size) {
            this.attachedPartitions.arrayCopy(index, index + 4, size - index);
            ++this.partitionTableVersion;
        }
        this.initPartitionAt(index, partitionTimestamp, partitionSize);
        return index;
    }

    void resetToLastPartition(long committedTransientRowCount) {
        this.resetToLastPartition(committedTransientRowCount, this.txMem.getLong(32L));
    }

    void resetToLastPartition(long committedTransientRowCount, long newMaxTimestamp) {
        this.updatePartitionSizeByTimestamp(this.maxTimestamp, committedTransientRowCount);
        this.maxTimestamp = this.prevMaxTimestamp = newMaxTimestamp;
        this.transientRowCount = committedTransientRowCount;
    }

    private void saveAttachedPartitionsToTx(int symCount) {
        int size = this.attachedPartitions.size();
        long partitionTableOffset = TableUtils.getPartitionTableSizeOffset(symCount);
        this.txMem.putInt(partitionTableOffset, size * 8);
        if (this.maxTimestamp != Long.MIN_VALUE) {
            for (int i = this.attachedPositionDirtyIndex; i < size; ++i) {
                this.txMem.putLong(TableUtils.getPartitionTableIndexOffset(partitionTableOffset, i), this.attachedPartitions.getQuick(i));
            }
            this.attachedPositionDirtyIndex = size;
        }
    }

    private void storeSymbolCounts(ObjList<SymbolMapWriter> denseSymbolMapWriters) {
        int n = denseSymbolMapWriters.size();
        for (int i = 0; i < n; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            int symCount = denseSymbolMapWriters.getQuick(i).getSymbolCount();
            this.txMem.putInt(offset, symCount);
            this.txMem.putInt(offset += 4L, symCount);
        }
    }

    private int updateAttachedPartitionSizeByIndex(int partitionIndex, long partitionTimestampLo, long partitionSize) {
        if (partitionIndex > -1) {
            this.updatePartitionSizeByIndex(partitionIndex, partitionSize);
            return partitionIndex;
        }
        return this.insertPartitionSizeByTimestamp(-(partitionIndex + 1), partitionTimestampLo, partitionSize);
    }

    private int updateAttachedPartitionSizeByTimestamp(long timestamp, long partitionSize) {
        long partitionTimestampLo = this.getPartitionTimestampLo(timestamp);
        return this.updateAttachedPartitionSizeByIndex(this.findAttachedPartitionIndexByLoTimestamp(partitionTimestampLo), partitionTimestampLo, partitionSize);
    }

    private void updatePartitionSizeByIndex(int index, long partitionSize) {
        if (this.attachedPartitions.getQuick(index + 1) != partitionSize) {
            this.attachedPartitions.set(index + 1, partitionSize);
            this.attachedPartitions.set(index + 3, this.txn);
        }
    }

    void updatePartitionSizeByIndexAndTxn(int index, long partitionSize) {
        this.attachedPartitions.set(index + 1, partitionSize);
        this.attachedPartitions.set(index + 2, this.txn);
        this.attachedPositionDirtyIndex = Math.min(this.attachedPositionDirtyIndex, index);
    }
}

