/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TxnScoreboard
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TxnScoreboard.class);
    private final long fd;
    private final long mem;
    private final long size;
    private final FilesFacade ff;

    public TxnScoreboard(FilesFacade ff, Path root, int entryCount) {
        this.ff = ff;
        root.concat("_txn_scoreboard").$();
        this.fd = TableUtils.openRW(ff, root, LOG);
        int pow2EntryCount = Numbers.ceilPow2(entryCount);
        this.size = TxnScoreboard.getScoreboardSize(pow2EntryCount);
        if (!ff.allocate(this.fd, this.size)) {
            ff.close(this.fd);
            throw CairoException.instance(ff.errno()).put("not enough space on disk? [name=").put(root).put(", size=").put(this.size).put(']');
        }
        ff.truncate(this.fd, this.size);
        this.mem = ff.mmap(this.fd, this.size, 0L, 2);
        if (this.mem == -1L) {
            ff.close(this.fd);
            throw CairoException.instance(ff.errno()).put("could not mmap column [fd=").put(this.fd).put(", size=").put(this.size).put(']');
        }
        TxnScoreboard.init(this.mem, pow2EntryCount);
    }

    @Override
    public void close() {
        this.ff.munmap(this.mem, this.size);
        this.ff.close(this.fd);
    }

    public void releaseTxn(long txn) {
        TxnScoreboard.releaseTxn(this.mem, txn);
    }

    public void acquireTxn(long txn) {
        if (TxnScoreboard.acquireTxn(this.mem, txn)) {
            return;
        }
        throw CairoException.instance(0).put("max txn-txn-inflight limit reached [txn=").put(txn).put(", min=").put(this.getMin()).put(']');
    }

    public long getMin() {
        return TxnScoreboard.getMin(this.mem);
    }

    public boolean isTxnAvailable(long nameTxn) {
        return TxnScoreboard.isTxnAvailable(this.mem, nameTxn);
    }

    public long getActiveReaderCount(long txn) {
        return TxnScoreboard.getCount(this.mem, txn);
    }

    private static boolean acquireTxn(long pTxnScoreboard, long txn) {
        assert (pTxnScoreboard > 0L);
        LOG.debug().$("acquire [p=").$(pTxnScoreboard).$(", txn=").$(txn).$(']').$();
        return TxnScoreboard.acquireTxn0(pTxnScoreboard, txn);
    }

    public static void releaseTxn(long pTxnScoreboard, long txn) {
        assert (pTxnScoreboard > 0L);
        LOG.debug().$("release  [p=").$(pTxnScoreboard).$(", txn=").$(txn).$(']').$();
        TxnScoreboard.releaseTxn0(pTxnScoreboard, txn);
    }

    private static native boolean acquireTxn0(long var0, long var2);

    private static native long releaseTxn0(long var0, long var2);

    private static native long getCount(long var0, long var2);

    private static native long getMin(long var0);

    public static native long getScoreboardSize(int var0);

    private static native boolean isTxnAvailable(long var0, long var2);

    private static native void init(long var0, int var2);
}

