/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.pool.AbstractPool;
import io.questdb.cairo.pool.PoolConstants;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.ResourcePool;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.pool.ex.PoolClosedException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Unsafe;
import java.util.Arrays;
import java.util.Map;

public class ReaderPool
extends AbstractPool
implements ResourcePool<TableReader> {
    private static final Log LOG = LogFactory.getLog(ReaderPool.class);
    private static final long UNLOCKED = -1L;
    private static final long NEXT_STATUS = Unsafe.getFieldOffset(Entry.class, "nextStatus");
    private static final int ENTRY_SIZE = 32;
    private static final long LOCK_OWNER = Unsafe.getFieldOffset(Entry.class, "lockOwner");
    private static final int NEXT_OPEN = 0;
    private static final int NEXT_ALLOCATED = 1;
    private static final int NEXT_LOCKED = 2;
    private final ConcurrentHashMap<Entry> entries = new ConcurrentHashMap();
    private final int maxSegments;
    private final int maxEntries;

    public ReaderPool(CairoConfiguration configuration) {
        super(configuration, configuration.getInactiveReaderTTL());
        this.maxSegments = configuration.getReaderPoolMaxSegments();
        this.maxEntries = this.maxSegments * 32;
    }

    @Override
    public TableReader get(CharSequence name) {
        Entry e = this.getEntry(name);
        long lockOwner = e.lockOwner;
        long thread = Thread.currentThread().getId();
        if (lockOwner != -1L) {
            LOG.info().$('\'').utf8(name).$("' is locked [owner=").$(lockOwner).$(']').$();
            throw EntryLockedException.INSTANCE;
        }
        do {
            for (int i = 0; i < 32; ++i) {
                if (!Unsafe.cas(e.allocations, i, -1L, thread)) continue;
                R r = e.readers[i];
                if (r == null) {
                    try {
                        LOG.info().$("open '").utf8(name).$("' [at=").$(e.index).$(':').$(i).$(']').$();
                        r = new R(this, e, i, name);
                    }
                    catch (CairoException ex) {
                        Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                        throw ex;
                    }
                    e.readers[i] = r;
                    this.notifyListener(thread, name, (short)10, e.index, i);
                } else {
                    r.goActive();
                    this.notifyListener(thread, name, (short)11, e.index, i);
                }
                if (this.isClosed()) {
                    e.readers[i] = null;
                    r.goodby();
                    LOG.info().$('\'').utf8(name).$("' born free").$();
                    return r;
                }
                LOG.debug().$('\'').utf8(name).$("' is assigned [at=").$(e.index).$(':').$(i).$(", thread=").$(thread).$(']').$();
                return r;
            }
            LOG.debug().$("Thread ").$(thread).$(" is moving to entry ").$(e.index + 1).$();
            if (!Unsafe.getUnsafe().compareAndSwapInt(e, NEXT_STATUS, 0, 1)) continue;
            LOG.debug().$("Thread ").$(thread).$(" allocated entry ").$(e.index + 1).$();
            e.next = new Entry(e.index + 1, this.clock.getTicks());
        } while ((e = e.next) != null && e.index < this.maxSegments);
        this.notifyListener(thread, name, (short)25, -1, -1);
        LOG.info().$("could not get, busy [table=`").utf8(name).$("`, thread=").$(thread).$(", retries=").$(this.maxSegments).$(']').$();
        throw EntryUnavailableException.INSTANCE;
    }

    public int getBusyCount() {
        int count = 0;
        for (Map.Entry<CharSequence, Entry> me : this.entries.entrySet()) {
            Entry e = me.getValue();
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.arrayGetVolatile(e.allocations, i) == -1L || e.readers[i] == null) continue;
                    ++count;
                }
            } while ((e = e.next) != null);
        }
        return count;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean lock(CharSequence name) {
        long thread;
        Entry e = this.getEntry(name);
        if (Unsafe.cas((Object)e, LOCK_OWNER, -1L, thread = Thread.currentThread().getId()) || Unsafe.cas((Object)e, LOCK_OWNER, thread, thread)) {
            do {
                for (int i = 0; i < 32; ++i) {
                    if (Unsafe.cas(e.allocations, i, -1L, thread)) {
                        this.closeReader(thread, e, i, (short)19, 2);
                        continue;
                    }
                    if (Unsafe.cas(e.allocations, i, thread, thread)) {
                        if (e.readers[i] == null) continue;
                        e.lockOwner = -1L;
                        return false;
                    }
                    LOG.info().$("could not lock, busy [table=`").utf8(name).$("`, at=").$(e.index).$(':').$(i).$(", owner=").$(e.allocations[i]).$(", thread=").$(thread).$(']').$();
                    e.lockOwner = -1L;
                    return false;
                }
            } while ((e.next != null || !Unsafe.getUnsafe().compareAndSwapInt(e, NEXT_STATUS, 0, 2)) && (e = e.next) != null);
        } else {
            LOG.error().$("' already locked [table=`").utf8(name).$("`, owner=").$(e.lockOwner).$(']').$();
            this.notifyListener(thread, name, (short)7, -1, -1);
            return false;
        }
        this.notifyListener(thread, name, (short)6, -1, -1);
        LOG.debug().$("locked [table=`").utf8(name).$("`, thread=").$(thread).$(']').$();
        return true;
    }

    public void unlock(CharSequence name) {
        Entry e = this.entries.get(name);
        long thread = Thread.currentThread().getId();
        if (e == null) {
            LOG.info().$("not found, cannot unlock [table=`").$(name).$("`]").$();
            this.notifyListener(thread, name, (short)9, -1, -1);
            return;
        }
        if (e.lockOwner == thread) {
            this.entries.remove(name);
            while (e != null) {
                e = e.next;
            }
        } else {
            this.notifyListener(thread, name, (short)12);
            throw CairoException.instance(0).put("Not the lock owner of ").put(name);
        }
        this.notifyListener(thread, name, (short)8, -1, -1);
        LOG.debug().$("unlocked [table=`").utf8(name).$("`]").$();
    }

    private void checkClosed() {
        if (this.isClosed()) {
            LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    @Override
    protected void closePool() {
        super.closePool();
        LOG.info().$("closed").$();
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int casFailures = 0;
        int closeReason = deadline < Long.MAX_VALUE ? 3 : 1;
        for (Map.Entry<CharSequence, Entry> me : this.entries.entrySet()) {
            Entry e = me.getValue();
            do {
                for (int i = 0; i < 32; ++i) {
                    R r;
                    if (deadline <= Unsafe.arrayGetVolatile(e.releaseTimes, i) || (r = e.readers[i]) == null) continue;
                    if (Unsafe.cas(e.allocations, i, -1L, thread)) {
                        if (deadline > e.releaseTimes[i]) {
                            removed = true;
                            this.closeReader(thread, e, i, (short)17, closeReason);
                        }
                        Unsafe.arrayPutOrdered(e.allocations, i, -1L);
                        continue;
                    }
                    ++casFailures;
                    if (deadline != Long.MAX_VALUE) continue;
                    r.goodby();
                    LOG.info().$("shutting down. '").$(r.getTableName()).$("' is left behind").$();
                }
            } while ((e = e.next) != null);
        }
        if (closeReason == 3) {
            return removed;
        }
        return casFailures == 0;
    }

    private void closeReader(long thread, Entry entry, int index, short ev, int reason) {
        R r = entry.readers[index];
        if (r != null) {
            r.goodby();
            r.close();
            LOG.info().$("closed '").$(r.getTableName()).$("' [at=").$(entry.index).$(':').$(index).$(", reason=").$(PoolConstants.closeReasonText(reason)).$(']').$();
            this.notifyListener(thread, r.getTableName(), ev, entry.index, index);
            entry.readers[index] = null;
        }
    }

    private Entry getEntry(CharSequence name) {
        Entry other;
        this.checkClosed();
        Entry e = this.entries.get(name);
        if (e == null && (other = this.entries.putIfAbsent(name, e = new Entry(0, this.clock.getTicks()))) != null) {
            e = other;
        }
        return e;
    }

    private void notifyListener(long thread, CharSequence name, short event, int segment, int position) {
        PoolListener listener = this.getPoolListener();
        if (listener != null) {
            listener.onEvent((byte)2, thread, name, event, (short)segment, (short)position);
        }
    }

    private boolean returnToPool(R reader) {
        String name = reader.getTableName();
        long thread = Thread.currentThread().getId();
        int index = reader.index;
        Entry e = reader.entry;
        if (e == null) {
            return false;
        }
        if (Unsafe.arrayGetVolatile(e.allocations, index) != -1L) {
            LOG.debug().$('\'').$(name).$("' is back [at=").$(e.index).$(':').$(index).$(", thread=").$(thread).$(']').$();
            this.notifyListener(thread, name, (short)1, ((R)reader).entry.index, index);
            e.releaseTimes[index] = this.clock.getTicks();
            Unsafe.arrayPutOrdered(e.allocations, index, -1L);
            return true;
        }
        LOG.error().$('\'').$(name).$("' is available [at=").$(e.index).$(':').$(index).$(']').$();
        return true;
    }

    public static class R
    extends TableReader {
        private final int index;
        private ReaderPool pool;
        private Entry entry;

        public R(ReaderPool pool, Entry entry, int index, CharSequence name) {
            super(pool.getConfiguration(), name);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                this.goPassive();
                if (this.pool != null && this.entry != null && this.pool.returnToPool(this)) {
                    return;
                }
                super.close();
            }
        }

        private void goodby() {
            this.entry = null;
            this.pool = null;
        }
    }

    public static class Entry {
        final long[] allocations = new long[32];
        final long[] releaseTimes = new long[32];
        final R[] readers = new R[32];
        final int index;
        volatile long lockOwner = -1L;
        int nextStatus = 0;
        volatile Entry next;

        public Entry(int index, long currentMicros) {
            this.index = index;
            Arrays.fill(this.allocations, -1L);
            Arrays.fill(this.releaseTimes, currentMicros);
        }
    }
}

