/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.sql.InvalidColumnException;
import io.questdb.std.str.CharSink;

public interface RecordMetadata
extends ColumnTypes {
    public static final int COLUMN_NOT_FOUND = -1;

    @Override
    public int getColumnCount();

    @Override
    public int getColumnType(int var1);

    default public int getColumnIndex(CharSequence columnName) {
        int columnIndex = this.getColumnIndexQuiet(columnName);
        if (columnIndex > -1) {
            return columnIndex;
        }
        throw InvalidColumnException.INSTANCE;
    }

    default public int getColumnIndexQuiet(CharSequence columnName) {
        return this.getColumnIndexQuiet(columnName, 0, columnName.length());
    }

    public int getColumnIndexQuiet(CharSequence var1, int var2, int var3);

    public String getColumnName(int var1);

    default public int getColumnType(CharSequence columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    public int getIndexValueBlockCapacity(int var1);

    default public int getIndexValueBlockCapacity(CharSequence columnName) {
        return this.getIndexValueBlockCapacity(this.getColumnIndex(columnName));
    }

    public int getTimestampIndex();

    default public boolean isSymbolTableStatic(CharSequence columnName) {
        return this.isSymbolTableStatic(this.getColumnIndex(columnName));
    }

    default public RecordMetadata getMetadata(int columnIndex) {
        return null;
    }

    public boolean isColumnIndexed(int var1);

    public boolean isSymbolTableStatic(int var1);

    default public void toJson(CharSink sink) {
        sink.put('{');
        sink.putQuoted("columnCount").put(':').put(this.getColumnCount());
        sink.put(',');
        sink.putQuoted("columns").put(':');
        sink.put('[');
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int type = this.getColumnType(i);
            if (i > 0) {
                sink.put(',');
            }
            sink.put('{');
            sink.putQuoted("index").put(':').put(i).put(',');
            sink.putQuoted("name").put(':').putQuoted(this.getColumnName(i)).put(',');
            sink.putQuoted("type").put(':').putQuoted(ColumnType.nameOf(type));
            if (this.isColumnIndexed(i)) {
                sink.put(',').putQuoted("indexed").put(":true");
                sink.put(',').putQuoted("indexValueBlockCapacity").put(':').put(this.getIndexValueBlockCapacity(i));
            }
            sink.put('}');
        }
        sink.put(']');
        sink.put(',').putQuoted("timestampIndex").put(':').put(this.getTimestampIndex());
        sink.put('}');
    }
}

