/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MappedReadWriteMemory;
import io.questdb.cairo.vm.PagedVirtualMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class AppendOnlyVirtualMemory
extends PagedVirtualMemory
implements MappedReadWriteMemory {
    private static final Log LOG = LogFactory.getLog(AppendOnlyVirtualMemory.class);
    private FilesFacade ff;
    private long fd = -1L;
    private long pageAddress = 0L;
    private int mappedPage;

    public AppendOnlyVirtualMemory(FilesFacade ff, LPSZ name, long pageSize) {
        this.of(ff, name, pageSize);
    }

    public AppendOnlyVirtualMemory() {
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public long getPageAddress(int page) {
        if (page == this.mappedPage) {
            return this.pageAddress;
        }
        return 0L;
    }

    @Override
    protected long mapWritePage(int page) {
        this.releaseCurrentPage();
        this.pageAddress = this.mapPage(page);
        return this.pageAddress;
    }

    @Override
    protected void release(int page, long address) {
        this.ff.munmap(address, this.getPageSize(page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean truncate) {
        long sz = this.getAppendOffset();
        this.releaseCurrentPage();
        super.close();
        if (this.fd != -1L) {
            try {
                VmUtils.bestEffortClose(this.ff, LOG, this.fd, truncate, sz, this.getMapPageSize());
            }
            finally {
                this.fd = -1L;
            }
        }
    }

    public void ensureFileSize(int page) {
        long target = this.pageOffset(page + 1);
        if (this.ff.length(this.fd) < target && !this.ff.allocate(this.fd, target)) {
            throw CairoException.instance(this.ff.errno()).put("Appender resize failed fd=").put(this.fd).put(", size=").put(target);
        }
    }

    @Override
    public void growToFileSize() {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() {
        return this.fd == -1L;
    }

    public long mapPage(int page) {
        this.ensureFileSize(page);
        long offset = this.pageOffset(page);
        long address = this.ff.mmap(this.fd, this.getMapPageSize(), offset, 2);
        if (address != -1L) {
            this.mappedPage = page;
            return address;
        }
        this.mappedPage = -1;
        throw CairoException.instance(this.ff.errno()).put("could not mmap for append fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.getMapPageSize());
    }

    public long getAppendAddress() {
        long appendOffset = this.getAppendOffset();
        return this.getPageAddress(this.pageIndex(appendOffset)) + this.offsetInPage(appendOffset);
    }

    public long getAppendAddressSize() {
        long appendOffset = this.getAppendOffset();
        long sz = this.getPageSize(this.pageIndex(appendOffset));
        return sz - this.offsetInPage(appendOffset);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.of(ff, name, pageSize);
    }

    @Override
    public final void of(FilesFacade ff, LPSZ name, long pageSize) {
        this.close();
        this.ff = ff;
        this.mappedPage = -1;
        this.setPageSize(pageSize);
        this.fd = TableUtils.openFileRWOrFail(ff, name);
        LOG.debug().$("open ").$(name).$(" [fd=").$(this.fd).$(", pageSize=").$(pageSize).$(']').$();
    }

    @Override
    public boolean isDeleted() {
        return !this.ff.exists(this.fd);
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    public final void of(FilesFacade ff, long fd, long pageSize) {
        this.close();
        this.ff = ff;
        this.setPageSize(pageSize);
        this.fd = fd;
    }

    @Override
    public final void setSize(long size) {
        this.jumpTo(size);
    }

    public void sync(boolean async) {
        if (this.pageAddress != 0L) {
            if (this.ff.msync(this.pageAddress, this.getMapPageSize(), async) == 0) {
                return;
            }
            LOG.error().$("could not msync [fd=").$(this.fd).$(", errno=").$(this.ff.errno()).$(']').$();
        }
    }

    public void truncate() {
        if (this.fd == -1L) {
            return;
        }
        this.releaseCurrentPage();
        if (!this.ff.truncate(Math.abs(this.fd), this.getMapPageSize())) {
            throw CairoException.instance(this.ff.errno()).put("Cannot truncate fd=").put(this.fd).put(" to ").put(this.getMapPageSize()).put(" bytes");
        }
        this.pageAddress = this.mapPage(0);
        this.updateLimits(0, this.pageAddress);
        LOG.debug().$("truncated [fd=").$(this.fd).$(']').$();
    }

    static void bestEffortTruncate(FilesFacade ff, Log log, long fd, long size, long mapPageSize) {
        if (ff.truncate(Math.abs(fd), size)) {
            log.debug().$("truncated and closed [fd=").$(fd).$(", size=").$(size).$(']').$();
        } else {
            if (ff.isRestrictedFileSystem()) {
                long n = (size - 1L) / mapPageSize;
                if (ff.truncate(Math.abs(fd), (n + 1L) * mapPageSize)) {
                    log.debug().$("truncated and closed, second attempt [fd=").$(fd).$(", size=").$((n + 1L) * mapPageSize).$(']').$();
                    return;
                }
            }
            log.debug().$("closed without truncate [fd=").$(fd).$(", errno=").$(ff.errno()).$(']').$();
        }
    }

    FilesFacade getFilesFacade() {
        return this.ff;
    }

    void releaseCurrentPage() {
        if (this.pageAddress != 0L) {
            this.release(0, this.pageAddress);
            this.pageAddress = 0L;
        }
    }
}

