/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.vm.ReadWriteVirtualMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Sink;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.CharSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class ContiguousVirtualMemory
implements ReadWriteVirtualMemory,
Mutable,
Closeable {
    private static final Log LOG = LogFactory.getLog(ContiguousVirtualMemory.class);
    private final ByteSequenceView bsview = new ByteSequenceView();
    private final CharSequenceView csview = new CharSequenceView();
    private final CharSequenceView csview2 = new CharSequenceView();
    private final Long256Impl long256 = new Long256Impl();
    private final Long256Impl long256B = new Long256Impl();
    private final int maxPages;
    private final InPageLong256FromCharSequenceDecoder inPageLong256Decoder = new InPageLong256FromCharSequenceDecoder();
    private long pageSize;
    private long pageSizeMsb;
    private long baseAddress = 0L;
    private long baseAddressHi = 0L;
    private long appendAddress = 0L;

    public ContiguousVirtualMemory(long pageSize, int maxPages) {
        this.maxPages = maxPages;
        this.setPageSize(pageSize);
    }

    public long addressOf(long offset) {
        return this.baseAddress + offset;
    }

    @Override
    public void clear() {
        this.releaseMemory();
    }

    @Override
    public void close() {
        this.releaseMemory();
        this.baseAddress = 0L;
        this.baseAddressHi = 0L;
        this.appendAddress = 0L;
    }

    public final long getAppendOffset() {
        return this.appendAddress - this.baseAddress;
    }

    @Override
    public final BinarySequence getBin(long offset) {
        long len = this.getLong(offset);
        if (len > -1L) {
            return this.bsview.of(offset + 8L, len);
        }
        return null;
    }

    @Override
    public final long getBinLen(long offset) {
        return this.getLong(offset);
    }

    @Override
    public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    @Override
    public final byte getByte(long offset) {
        return Unsafe.getUnsafe().getByte(this.addressOf(offset));
    }

    @Override
    public final double getDouble(long offset) {
        return Unsafe.getUnsafe().getDouble(this.addressOf(offset));
    }

    @Override
    public final float getFloat(long offset) {
        return Unsafe.getUnsafe().getFloat(this.addressOf(offset));
    }

    @Override
    public final int getInt(long offset) {
        return Unsafe.getUnsafe().getInt(this.addressOf(offset));
    }

    @Override
    public long getLong(long offset) {
        return Unsafe.getUnsafe().getLong(this.addressOf(offset));
    }

    @Override
    public long getPageAddress(int pageIndex) {
        return this.baseAddress;
    }

    @Override
    public int getPageCount() {
        return 1;
    }

    @Override
    public long getPageSize(int pageIndex) {
        return this.pageSize;
    }

    @Override
    public final short getShort(long offset) {
        return Unsafe.getUnsafe().getShort(this.addressOf(offset));
    }

    @Override
    public final CharSequence getStr(long offset) {
        return this.getStr0(offset, this.csview);
    }

    @Override
    public final CharSequence getStr2(long offset) {
        return this.getStr0(offset, this.csview2);
    }

    @Override
    public Long256 getLong256A(long offset) {
        this.getLong256(offset, this.long256);
        return this.long256;
    }

    @Override
    public void getLong256(long offset, CharSink sink) {
        long a = this.getLong(offset);
        long b = this.getLong(offset + 8L);
        long c = this.getLong(offset + 16L);
        long d = this.getLong(offset + 24L);
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    public Long256 getLong256B(long offset) {
        this.getLong256(offset, this.long256B);
        return this.long256B;
    }

    @Override
    public final char getChar(long offset) {
        return Unsafe.getUnsafe().getChar(this.addressOf(offset));
    }

    @Override
    public final int getStrLen(long offset) {
        return this.getInt(offset);
    }

    @Override
    public void grow(long size) {
        long nPages = (size >>> (int)this.pageSizeMsb) + 1L;
        size = nPages << (int)this.pageSizeMsb;
        long oldSize = this.getMemorySize();
        if (nPages > (long)this.maxPages) {
            throw LimitOverflowException.instance().put("Maximum number of pages (").put(this.maxPages).put(") breached in VirtualMemory");
        }
        long newBaseAddress = this.reallocateMemory(this.baseAddress, this.getMemorySize(), size);
        if (oldSize > 0L) {
            LOG.debug().$("extended [oldBase=").$(this.baseAddress).$(", newBase=").$(newBaseAddress).$(", oldSize=").$(oldSize).$(", newSize=").$(size).$(']').$();
        }
        this.handleMemoryReallocation(newBaseAddress, size);
    }

    @Override
    public long size() {
        return this.baseAddressHi - this.baseAddress;
    }

    public void getLong256(long offset, Long256Sink sink) {
        sink.setLong0(this.getLong(offset));
        sink.setLong1(this.getLong(offset + 8L));
        sink.setLong2(this.getLong(offset + 16L));
        sink.setLong3(this.getLong(offset + 24L));
    }

    public final CharSequence getStr0(long offset, CharSequenceView view) {
        int len = this.getInt(offset);
        if (len != -1) {
            return view.of(offset + 4L, len);
        }
        return null;
    }

    public long hash(long offset, long size) {
        long n = size - (size & 7L);
        long h = 179426491L;
        for (long i = 0L; i < n; i += 8L) {
            h = (h << 5) - h + this.getLong(offset + i);
        }
        while (n < size) {
            h = (h << 5) - h + (long)this.getByte(offset + n);
            ++n;
        }
        return h;
    }

    @Override
    public void jumpTo(long offset) {
        this.checkLimits(offset, 0L);
        this.appendAddress = this.baseAddress + offset;
    }

    @Override
    public void putBlockOfBytes(long from, long len) {
        this.checkLimits(len);
        Vect.memcpy(from, this.appendAddress, len);
        this.appendAddress += len;
    }

    @Override
    public final long putBin(BinarySequence value) {
        long offset = this.getAppendOffset();
        if (value != null) {
            long len = value.length();
            this.checkLimits(len + 8L);
            this.putLong(len);
            value.copyTo(this.appendAddress, 0L, len);
            this.appendAddress += len;
        } else {
            this.putLong(-1L);
        }
        return offset;
    }

    @Override
    public final long putBin(long from, long len) {
        this.checkLimits(len + 8L);
        long offset = this.getAppendOffset();
        this.putLong(len > 0L ? len : -1L);
        if (len < 1L) {
            return offset;
        }
        Vect.memcpy(from, this.appendAddress, len);
        this.appendAddress += len;
        return offset;
    }

    @Override
    public void putBool(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
    }

    @Override
    public void putBool(long offset, boolean value) {
        this.putByte(offset, (byte)(value ? 1 : 0));
    }

    @Override
    public final void putByte(long offset, byte value) {
        this.checkLimits(offset, 1L);
        Unsafe.getUnsafe().putByte(this.baseAddress + offset, value);
    }

    @Override
    public void putByte(byte b) {
        this.checkLimits(1L);
        Unsafe.getUnsafe().putByte(this.appendAddress, b);
        ++this.appendAddress;
    }

    @Override
    public void putChar(long offset, char value) {
        this.checkLimits(offset, 2L);
        Unsafe.getUnsafe().putChar(this.baseAddress + offset, value);
    }

    @Override
    public final void putChar(char value) {
        this.checkLimits(2L);
        Unsafe.getUnsafe().putChar(this.appendAddress, value);
        this.appendAddress += 2L;
    }

    @Override
    public void putDouble(long offset, double value) {
        this.checkLimits(offset, 8L);
        Unsafe.getUnsafe().putDouble(this.baseAddress + offset, value);
    }

    @Override
    public final void putDouble(double value) {
        this.checkLimits(8L);
        Unsafe.getUnsafe().putDouble(this.appendAddress, value);
        this.appendAddress += 8L;
    }

    @Override
    public void putFloat(long offset, float value) {
        this.checkLimits(offset, 4L);
        Unsafe.getUnsafe().putFloat(this.baseAddress + offset, value);
    }

    @Override
    public final void putFloat(float value) {
        this.checkLimits(4L);
        Unsafe.getUnsafe().putFloat(this.appendAddress, value);
        this.appendAddress += 4L;
    }

    @Override
    public void putInt(long offset, int value) {
        this.checkLimits(offset, 4L);
        Unsafe.getUnsafe().putInt(this.baseAddress + offset, value);
    }

    @Override
    public final void putInt(int value) {
        this.checkLimits(4L);
        Unsafe.getUnsafe().putInt(this.appendAddress, value);
        this.appendAddress += 4L;
    }

    @Override
    public void putLong(long offset, long value) {
        this.checkLimits(offset, 8L);
        this.putLongUnsafe(offset, value);
    }

    @Override
    public final void putLong(long value) {
        this.checkLimits(8L);
        Unsafe.getUnsafe().putLong(this.appendAddress, value);
        this.appendAddress += 8L;
    }

    @Override
    public final void putLong128(long l1, long l2) {
        this.checkLimits(16L);
        Unsafe.getUnsafe().putLong(this.appendAddress, l1);
        Unsafe.getUnsafe().putLong(this.appendAddress + 8L, l2);
        this.appendAddress += 16L;
    }

    @Override
    public void putLong256(long offset, Long256 value) {
        this.putLong256(offset, value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    @Override
    public void putLong256(long offset, long l0, long l1, long l2, long l3) {
        this.putLong(offset, l0);
        this.putLong(offset + 8L, l1);
        this.putLong(offset + 16L, l2);
        this.putLong(offset + 24L, l3);
    }

    @Override
    public final void putLong256(long l0, long l1, long l2, long l3) {
        this.putLong(l0);
        this.putLong(l1);
        this.putLong(l2);
        this.putLong(l3);
    }

    @Override
    public final void putLong256(Long256 value) {
        this.putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    @Override
    public final void putLong256(CharSequence hexString) {
        this.inPageLong256Decoder.putLong256(hexString);
    }

    @Override
    public final void putLong256(@NotNull CharSequence hexString, int start, int end) {
        this.inPageLong256Decoder.putLong256(hexString, start, end);
    }

    @Override
    public final long putNullBin() {
        long offset = this.getAppendOffset();
        this.putLong(-1L);
        return offset;
    }

    @Override
    public final long putNullStr() {
        long offset = this.getAppendOffset();
        this.putInt(-1);
        return offset;
    }

    @Override
    public final void putNullStr(long offset) {
        this.putInt(offset, -1);
    }

    @Override
    public void putShort(long offset, short value) {
        this.checkLimits(offset, 2L);
        Unsafe.getUnsafe().putShort(this.baseAddress + offset, value);
    }

    @Override
    public final void putShort(short value) {
        this.checkLimits(2L);
        Unsafe.getUnsafe().putShort(this.appendAddress, value);
        this.appendAddress += 2L;
    }

    @Override
    public final long putStr(CharSequence value) {
        return value != null ? this.putStr0(value, 0, value.length()) : this.putNullStr();
    }

    @Override
    public final long putStr(char value) {
        if (value != '\u0000') {
            this.checkLimits(6L);
            long offset = this.getAppendOffset();
            this.putInt(1);
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
            return offset;
        }
        return this.putNullStr();
    }

    @Override
    public final long putStr(CharSequence value, int pos, int len) {
        if (value != null) {
            return this.putStr0(value, pos, len);
        }
        return this.putNullStr();
    }

    @Override
    public void putStr(long offset, CharSequence value) {
        if (value != null) {
            this.putStr(offset, value, 0, value.length());
        } else {
            this.putNullStr(offset);
        }
    }

    @Override
    public void putStr(long offset, CharSequence value, int pos, int len) {
        this.checkLimits(offset, VmUtils.getStorageLength(len));
        this.putInt(offset, len);
        ContiguousVirtualMemory.copyStrChars(value, pos, len, this.baseAddress + offset + 4L);
    }

    public void putLongUnsafe(long offset, long value) {
        Unsafe.getUnsafe().putLong(this.baseAddress + offset, value);
    }

    public void replacePage(long address, long size) {
        long appendOffset = this.getAppendOffset();
        this.baseAddress = this.appendAddress = address;
        this.baseAddressHi = this.baseAddress + size;
        this.jumpTo(appendOffset);
    }

    public long resize(long size) {
        this.checkAndExtend(this.baseAddress + size);
        return this.baseAddress;
    }

    public void skip(long bytes) {
        this.checkLimits(bytes);
        this.appendAddress += bytes;
    }

    public void zero() {
        long baseLength = this.baseAddressHi - this.baseAddress;
        Vect.memset(this.baseAddress, baseLength, 0);
    }

    private static void copyStrChars(CharSequence value, int pos, int len, long address) {
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i + pos);
            Unsafe.getUnsafe().putChar(address + 2L * (long)i, c);
        }
    }

    private void checkAndExtend(long addressHi) {
        assert (this.appendAddress <= this.baseAddressHi);
        assert (addressHi >= this.baseAddress);
        if (addressHi <= this.baseAddressHi) {
            return;
        }
        this.grow(addressHi - this.baseAddress);
    }

    protected final void checkLimits(long size) {
        this.checkAndExtend(this.appendAddress + size);
    }

    protected final void checkLimits(long offset, long size) {
        this.checkAndExtend(this.baseAddress + offset + size);
    }

    protected long getMapPageSize() {
        return this.pageSize;
    }

    protected final long getMemorySize() {
        return this.baseAddressHi - this.baseAddress;
    }

    protected final void handleMemoryReallocation(long newBaseAddress, long newSize) {
        assert (newBaseAddress != 0L);
        long appendOffset = this.appendAddress - this.baseAddress;
        this.baseAddress = newBaseAddress;
        this.baseAddressHi = this.baseAddress + newSize;
        this.appendAddress = this.baseAddress + appendOffset;
        if (this.appendAddress > this.baseAddressHi) {
            this.appendAddress = this.baseAddressHi;
        }
    }

    protected final void handleMemoryReleased() {
        this.baseAddress = 0L;
        this.baseAddressHi = 0L;
        this.appendAddress = 0L;
    }

    private void putLong256Null() {
        this.checkLimits(32L);
        Long256Impl.putNull(this.appendAddress);
    }

    private long putStr0(CharSequence value, int pos, int len) {
        long storageLen = VmUtils.getStorageLength(len);
        this.checkLimits(storageLen);
        long offset = this.getAppendOffset();
        Unsafe.getUnsafe().putInt(this.appendAddress, len);
        ContiguousVirtualMemory.copyStrChars(value, pos, len, this.appendAddress + 4L);
        this.appendAddress += storageLen;
        return offset;
    }

    protected long reallocateMemory(long currentBaseAddress, long currentSize, long newSize) {
        if (currentBaseAddress != 0L) {
            return Unsafe.realloc(currentBaseAddress, currentSize, newSize);
        }
        return Unsafe.malloc(newSize);
    }

    protected void releaseMemory() {
        if (this.baseAddress != 0L) {
            long baseLength = this.baseAddressHi - this.baseAddress;
            Unsafe.free(this.baseAddress, baseLength);
            this.handleMemoryReleased();
        }
    }

    protected final void setPageSize(long pageSize) {
        this.pageSize = Numbers.ceilPow2(pageSize);
        this.pageSizeMsb = Numbers.msb(this.pageSize);
    }

    private class InPageLong256FromCharSequenceDecoder
    extends Long256FromCharSequenceDecoder {
        private InPageLong256FromCharSequenceDecoder() {
        }

        @Override
        public void onDecoded(long l0, long l1, long l2, long l3) {
            ContiguousVirtualMemory.this.checkLimits(32L);
            Unsafe.getUnsafe().putLong(ContiguousVirtualMemory.this.appendAddress, l0);
            Unsafe.getUnsafe().putLong(ContiguousVirtualMemory.this.appendAddress + 8L, l1);
            Unsafe.getUnsafe().putLong(ContiguousVirtualMemory.this.appendAddress + 16L, l2);
            Unsafe.getUnsafe().putLong(ContiguousVirtualMemory.this.appendAddress + 24L, l3);
        }

        private void putLong256(CharSequence hexString, int start, int end) {
            try {
                InPageLong256FromCharSequenceDecoder.decode(hexString, start, end, ContiguousVirtualMemory.this.inPageLong256Decoder);
            }
            catch (NumericException e) {
                throw CairoException.instance(0).put("invalid long256 [hex=").put(hexString).put(']');
            }
            ContiguousVirtualMemory.this.appendAddress = ContiguousVirtualMemory.this.appendAddress + 32L;
        }

        private void putLong256(CharSequence hexString) {
            int len;
            if (hexString == null || (len = hexString.length()) == 0) {
                ContiguousVirtualMemory.this.putLong256Null();
                ContiguousVirtualMemory.this.appendAddress = ContiguousVirtualMemory.this.appendAddress + 32L;
            } else {
                this.putLong256(hexString, 2, len);
            }
        }
    }

    private class ByteSequenceView
    implements BinarySequence {
        private long offset;
        private long len = -1L;

        private ByteSequenceView() {
        }

        @Override
        public byte byteAt(long index) {
            return ContiguousVirtualMemory.this.getByte(this.offset + index);
        }

        @Override
        public void copyTo(long address, long start, long length) {
            long bytesRemaining = Math.min(length, this.len - start);
            long offset = this.offset + start;
            Vect.memcpy(ContiguousVirtualMemory.this.baseAddress + offset, address, bytesRemaining);
        }

        @Override
        public long length() {
            return this.len;
        }

        ByteSequenceView of(long offset, long len) {
            this.offset = offset;
            this.len = len;
            return this;
        }
    }

    public class CharSequenceView
    extends AbstractCharSequence {
        private int len;
        private long offset;

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            return ContiguousVirtualMemory.this.getChar(this.offset + (long)index * 2L);
        }

        CharSequenceView of(long offset, int len) {
            this.offset = offset;
            this.len = len;
            return this;
        }
    }
}

