/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MappedReadWriteMemory;
import io.questdb.cairo.vm.PagedVirtualMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Vect;
import io.questdb.std.str.LPSZ;

public class PagedMappedReadWriteMemory
extends PagedVirtualMemory
implements MappedReadWriteMemory {
    private static final Log LOG = LogFactory.getLog(PagedMappedReadWriteMemory.class);
    private FilesFacade ff;
    private long fd = -1L;

    public PagedMappedReadWriteMemory(FilesFacade ff, LPSZ name, long maxPageSize) {
        this.of(ff, name, maxPageSize);
    }

    public PagedMappedReadWriteMemory() {
    }

    @Override
    public void close() {
        long size = this.getAppendOffset();
        super.close();
        if (this.isOpen()) {
            try {
                VmUtils.bestEffortClose(this.ff, LOG, this.fd, true, size, this.getMapPageSize());
            }
            finally {
                this.fd = -1L;
            }
        }
    }

    @Override
    protected long allocateNextPage(int page) {
        long offset = this.pageOffset(page);
        long pageSize = this.getMapPageSize();
        if (this.ff.length(this.fd) < offset + pageSize && !this.ff.allocate(this.fd, offset + pageSize)) {
            throw CairoException.instance(this.ff.errno()).put("No space left on device [need=").put(offset + pageSize).put(']');
        }
        long address = this.ff.mmap(this.fd, pageSize, offset, 2);
        if (address != -1L) {
            return address;
        }
        throw CairoException.instance(this.ff.errno()).put("Cannot mmap read-write fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(pageSize);
    }

    @Override
    public void growToFileSize() {
        this.grow(this.ff.length(this.fd));
    }

    @Override
    public long getPageAddress(int page) {
        return this.mapWritePage(page);
    }

    @Override
    protected void release(int page, long address) {
        this.ff.munmap(address, this.getPageSize(page));
    }

    public boolean isOpen() {
        return this.fd != -1L;
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.close();
        this.ff = ff;
        this.fd = TableUtils.openFileRWOrFail(ff, name);
        this.of0(ff, name, pageSize, size);
    }

    @Override
    public final void of(FilesFacade ff, LPSZ name, long pageSize) {
        this.close();
        this.ff = ff;
        this.fd = TableUtils.openFileRWOrFail(ff, name);
        this.of0(ff, name, pageSize, ff.length(this.fd));
    }

    private void of0(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.setPageSize(pageSize);
        this.ensurePagesListCapacity(size);
        LOG.debug().$("open ").$(name).$(" [fd=").$(this.fd).$(']').$();
        try {
            this.jumpTo(size);
        }
        catch (Throwable e) {
            ff.close(this.fd);
            this.fd = -1L;
            throw e;
        }
    }

    @Override
    public boolean isDeleted() {
        return !this.ff.exists(this.fd);
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    public final void of(FilesFacade ff, long fd, long pageSize) {
        this.close();
        this.ff = ff;
        this.fd = fd;
        long size = ff.length(fd);
        this.setPageSize(pageSize);
        this.ensurePagesListCapacity(size);
        try {
            this.jumpTo(size);
        }
        catch (Throwable e) {
            ff.close(fd);
            this.fd = -1L;
            throw e;
        }
    }

    @Override
    public void setSize(long size) {
        this.jumpTo(size);
    }

    public void sync(int pageIndex, boolean async) {
        if (this.ff.msync(this.pages.getQuick(pageIndex), this.getMapPageSize(), async) == 0) {
            return;
        }
        LOG.error().$("could not msync [fd=").$(this.fd).$(']').$();
    }

    public void sync(boolean async) {
        int n = this.pages.size();
        for (int i = 0; i < n; ++i) {
            this.sync(i, async);
        }
    }

    public void truncate() {
        long firstPage = this.getPageAddress(0);
        long pageSize = this.getMapPageSize();
        Vect.memset(firstPage, pageSize, 0);
        int n = this.pages.size();
        for (int i = 1; i < n; ++i) {
            this.release(i, this.pages.getQuick(i));
            this.pages.setQuick(i, 0L);
        }
        this.jumpTo(0L);
        long fileSize = this.ff.length(this.fd);
        if (fileSize > pageSize) {
            if (this.ff.truncate(this.fd, pageSize)) {
                return;
            }
            long mem = this.ff.mmap(this.fd, fileSize, 0L, 2);
            Vect.memset(mem + pageSize, fileSize - pageSize, 0);
            this.ff.munmap(mem, fileSize);
            LOG.debug().$("could not truncate, zeroed [fd=").$(this.fd).$(']').$();
        }
    }
}

