/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.vm.AppendOnlyVirtualMemory;
import io.questdb.cairo.vm.PagedVirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;

public class PagedSlidingReadOnlyMemory
extends PagedVirtualMemory {
    private static final Log LOG = LogFactory.getLog(PagedSlidingReadOnlyMemory.class);
    private FilesFacade ff;
    private long fd = -1L;
    private long size = 0L;
    private long pageAddress;
    private int pageIndex;
    private AppendOnlyVirtualMemory parent;

    @Override
    public void close() {
        super.close();
        this.closeFile();
        this.releasePage();
    }

    @Override
    public long getPageAddress(int page) {
        return page == this.pageIndex ? this.pageAddress : this.mapPage(page);
    }

    @Override
    public long getPageSize(int page) {
        return this.getMapPageSize();
    }

    @Override
    protected long mapWritePage(int page) {
        throw new UnsupportedOperationException("Cannot jump() read-only memory. Use grow() instead.");
    }

    public long getFd() {
        return this.fd;
    }

    public void of(AppendOnlyVirtualMemory parent) {
        this.close();
        this.ff = parent.getFilesFacade();
        this.fd = parent.getFd();
        this.parent = parent;
        this.setPageSize(parent.getMapPageSize());
        this.updateSize();
        this.pageIndex = -1;
        LOG.debug().$("open [fd=").$(this.fd).$(", size=").$(this.size).$(']').$();
    }

    public void updateSize() {
        if (this.parent != null) {
            this.size = this.pageOffset(this.pageIndex(this.parent.getAppendOffset())) + this.getMapPageSize();
        }
    }

    private void closeFile() {
        if (this.fd != -1L) {
            LOG.debug().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1L;
            this.size = 0L;
            this.parent = null;
        }
    }

    private void invalidateCurrentPage() {
        this.pageAddress = 0L;
        this.pageIndex = -1;
        this.clearHotPage();
    }

    private long mapPage(int page) {
        this.releaseCurrentPage();
        long offset = this.pageOffset(page);
        long sz = this.size - offset;
        if (sz > 0L) {
            sz = this.getMapPageSize();
            long address = this.ff.mmap(this.fd, sz, offset, 1);
            if (address == -1L) {
                this.invalidateCurrentPage();
                throw CairoException.instance(this.ff.errno()).put("Cannot map read-only page. fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.size).put(", page=").put(sz);
            }
            this.pageIndex = page;
            this.pageAddress = address;
            return address;
        }
        this.invalidateCurrentPage();
        throw CairoException.instance(this.ff.errno()).put("Trying to map read-only page outside of file boundary. fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.size).put(", page=").put(sz);
    }

    private void releaseCurrentPage() {
        if (this.pageAddress != 0L) {
            this.ff.munmap(this.pageAddress, this.getMapPageSize());
        }
    }

    private void releasePage() {
        this.releaseCurrentPage();
        this.invalidateCurrentPage();
    }
}

