/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.VmUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Sink;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;

public class SinglePageMappedReadOnlyPageMemory
implements MappedReadOnlyMemory {
    private static final Log LOG = LogFactory.getLog(SinglePageMappedReadOnlyPageMemory.class);
    private final ByteSequenceView bsview = new ByteSequenceView();
    private final CharSequenceView csview = new CharSequenceView();
    private final CharSequenceView csview2 = new CharSequenceView();
    private final Long256Impl long256 = new Long256Impl();
    private final Long256Impl long256B = new Long256Impl();
    protected long page = -1L;
    protected FilesFacade ff;
    protected long fd = -1L;
    protected long size = 0L;
    protected long absolutePointer;
    private long grownLength;

    public SinglePageMappedReadOnlyPageMemory(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.of(ff, name, pageSize, size);
    }

    public SinglePageMappedReadOnlyPageMemory(FilesFacade ff, LPSZ name, long size) {
        this.of(ff, name, 0L, size);
    }

    public SinglePageMappedReadOnlyPageMemory() {
    }

    public long addressOf(long offset) {
        assert (offset < this.size) : "offset=" + offset + ", size=" + this.size + ", fd=" + this.fd;
        return this.absolutePointer + offset;
    }

    @Override
    public void close() {
        if (this.page != -1L) {
            this.ff.munmap(this.page, this.size);
            this.size = 0L;
            this.page = -1L;
        }
        if (this.fd != -1L) {
            this.ff.close(this.fd);
            LOG.debug().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1L;
        }
        this.grownLength = 0L;
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.openFile(ff, name);
        this.map(ff, name, size);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long pageSize) {
        this.openFile(ff, name);
        this.map(ff, name, ff.length(this.fd));
    }

    @Override
    public boolean isDeleted() {
        return !this.ff.exists(this.fd);
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public final BinarySequence getBin(long offset) {
        long len = this.getLong(offset);
        if (len == -1L) {
            return null;
        }
        return this.bsview.of(offset + 8L, len);
    }

    @Override
    public final long getBinLen(long offset) {
        return this.getLong(offset);
    }

    @Override
    public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    @Override
    public final byte getByte(long offset) {
        return Unsafe.getUnsafe().getByte(this.addressOf(offset));
    }

    @Override
    public final double getDouble(long offset) {
        return Unsafe.getUnsafe().getDouble(this.addressOf(offset));
    }

    @Override
    public final float getFloat(long offset) {
        return Unsafe.getUnsafe().getFloat(this.addressOf(offset));
    }

    @Override
    public final int getInt(long offset) {
        return Unsafe.getUnsafe().getInt(this.addressOf(offset));
    }

    @Override
    public long getLong(long offset) {
        return Unsafe.getUnsafe().getLong(this.addressOf(offset));
    }

    @Override
    public long getPageAddress(int pageIndex) {
        return this.absolutePointer;
    }

    @Override
    public int getPageCount() {
        return 1;
    }

    @Override
    public long getPageSize(int pageIndex) {
        return this.size;
    }

    @Override
    public final short getShort(long offset) {
        return Unsafe.getUnsafe().getShort(this.absolutePointer + offset);
    }

    @Override
    public final CharSequence getStr(long offset) {
        return this.getStr0(offset, this.csview);
    }

    @Override
    public final CharSequence getStr2(long offset) {
        return this.getStr0(offset, this.csview2);
    }

    @Override
    public Long256 getLong256A(long offset) {
        this.getLong256(offset, this.long256);
        return this.long256;
    }

    @Override
    public void getLong256(long offset, CharSink sink) {
        long a = Unsafe.getUnsafe().getLong(this.addressOf(offset));
        long b = Unsafe.getUnsafe().getLong(this.addressOf(offset + 8L));
        long c = Unsafe.getUnsafe().getLong(this.addressOf(offset + 16L));
        long d = Unsafe.getUnsafe().getLong(this.addressOf(offset + 24L));
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    public Long256 getLong256B(long offset) {
        this.getLong256(offset, this.long256B);
        return this.long256B;
    }

    @Override
    public final char getChar(long offset) {
        return Unsafe.getUnsafe().getChar(this.addressOf(offset));
    }

    @Override
    public final int getStrLen(long offset) {
        return this.getInt(offset);
    }

    @Override
    public void grow(long newSize) {
        if (newSize > this.grownLength) {
            this.grownLength = newSize;
        }
        if (newSize <= this.size) {
            return;
        }
        long fileSize = this.ff.length(this.fd);
        newSize = Math.max(newSize, fileSize);
        long offset = this.absolutePointer - this.page;
        long previousSize = this.size;
        if (previousSize > 0L) {
            this.page = this.ff.mremap(this.fd, this.page, previousSize, newSize, 0L, 1);
        } else {
            assert (this.page == -1L);
            this.page = this.ff.mmap(this.fd, newSize, 0L, 1);
        }
        if (this.page == -1L) {
            long fd = this.fd;
            this.close();
            throw CairoException.instance(this.ff.errno()).put("Could not remap file [previousSize=").put(previousSize).put(", newSize=").put(newSize).put(", fd=").put(fd).put(']');
        }
        this.size = newSize;
        this.absolutePointer = this.page + offset;
    }

    @Override
    public long size() {
        return this.size;
    }

    public long getGrownLength() {
        return this.grownLength;
    }

    public void getLong256(long offset, Long256Sink sink) {
        sink.setLong0(Unsafe.getUnsafe().getLong(this.addressOf(offset)));
        sink.setLong1(Unsafe.getUnsafe().getLong(this.addressOf(offset + 8L)));
        sink.setLong2(Unsafe.getUnsafe().getLong(this.addressOf(offset + 16L)));
        sink.setLong3(Unsafe.getUnsafe().getLong(this.addressOf(offset + 24L)));
    }

    public final CharSequence getStr0(long offset, CharSequenceView view) {
        int len = this.getInt(offset);
        if (len > -1 && offset + VmUtils.getStorageLength(len) <= this.size) {
            return view.of(offset + 4L, len);
        }
        if (len == -1) {
            return null;
        }
        throw CairoException.instance(0).put("String is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(", size=").put(this.size).put(", fd=").put(this.fd).put(']');
    }

    @Override
    public void growToFileSize() {
        this.grow(this.ff.length(this.fd));
    }

    public void of(FilesFacade ff, long fd, LPSZ name, long size) {
        this.close();
        this.ff = ff;
        this.fd = fd;
        if (fd != -1L) {
            this.map(ff, name, size);
        }
    }

    protected void map(FilesFacade ff, LPSZ name, long size) {
        this.size = size = Math.min(ff.length(this.fd), size);
        if (size > 0L) {
            this.page = ff.mmap(this.fd, size, 0L, 1);
            if (this.page == -1L) {
                long fd = this.fd;
                long fileLen = ff.length(fd);
                this.close();
                throw CairoException.instance(ff.errno()).put("Could not mmap ").put(name).put(" [size=").put(size).put(", fd=").put(fd).put(", memUsed=").put(Unsafe.getMemUsed()).put(", fileLen=").put(fileLen).put(']');
            }
            this.absolutePointer = this.page;
        } else {
            this.page = -1L;
            this.absolutePointer = -1L;
        }
        LOG.debug().$("open ").$(name).$(" [fd=").$(this.fd).$(", pageSize=").$(size).$(", size=").$(this.size).$(']').$();
    }

    private void openFile(FilesFacade ff, LPSZ name) {
        this.close();
        this.ff = ff;
        boolean exists = ff.exists(name);
        if (!exists) {
            throw CairoException.instance(0).put("File not found: ").put(name);
        }
        this.fd = TableUtils.openRO(ff, name, LOG);
    }

    private class ByteSequenceView
    implements BinarySequence {
        private long offset;
        private long len = -1L;
        private long readAddress;

        private ByteSequenceView() {
        }

        @Override
        public byte byteAt(long index) {
            assert (index < this.len);
            return Unsafe.getUnsafe().getByte(this.readAddress + index);
        }

        @Override
        public void copyTo(long address, long start, long length) {
            long bytesRemaining = Math.min(length, this.len - start);
            long offset = this.offset + start;
            Vect.memcpy(SinglePageMappedReadOnlyPageMemory.this.page + offset, address, bytesRemaining);
        }

        @Override
        public long length() {
            return this.len;
        }

        ByteSequenceView of(long offset, long len) {
            this.offset = offset;
            this.len = len;
            this.readAddress = SinglePageMappedReadOnlyPageMemory.this.page + offset;
            return this;
        }
    }

    public class CharSequenceView
    extends AbstractCharSequence {
        private int len;
        private long offset;

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            return SinglePageMappedReadOnlyPageMemory.this.getChar(this.offset + (long)index * 2L);
        }

        CharSequenceView of(long offset, int len) {
            this.offset = offset;
            this.len = len;
            return this;
        }
    }
}

