/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseAsciiCharSequenceObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

public class HttpHeaderParser
implements Mutable,
Closeable,
HttpRequestHeader {
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final ObjectPool<DirectByteCharSequence> pool;
    private final LowerCaseAsciiCharSequenceObjHashMap<DirectByteCharSequence> headers = new LowerCaseAsciiCharSequenceObjHashMap();
    private final CharSequenceObjHashMap<DirectByteCharSequence> urlParams = new CharSequenceObjHashMap();
    private final long hi;
    private final DirectByteCharSequence temp = new DirectByteCharSequence();
    private final BoundaryAugmenter boundaryAugmenter = new BoundaryAugmenter();
    private long _wptr;
    private long headerPtr;
    private DirectByteCharSequence method;
    private DirectByteCharSequence url;
    private DirectByteCharSequence methodLine;
    private boolean needMethod;
    private long _lo;
    private DirectByteCharSequence headerName;
    private boolean incomplete;
    private DirectByteCharSequence contentType;
    private DirectByteCharSequence boundary;
    private CharSequence contentDispositionName;
    private CharSequence contentDisposition;
    private CharSequence contentDispositionFilename;
    private boolean m = true;
    private boolean u = true;
    private boolean q = false;
    private DirectByteCharSequence charset;

    public HttpHeaderParser(int bufferLen, ObjectPool<DirectByteCharSequence> pool) {
        int sz = Numbers.ceilPow2(bufferLen);
        this._wptr = this.headerPtr = Unsafe.malloc(sz);
        this.hi = this.headerPtr + (long)sz;
        this.pool = pool;
        this.clear();
    }

    private static DirectByteCharSequence unquote(CharSequence key, DirectByteCharSequence that) {
        int len = that.length();
        if (len == 0) {
            throw HttpException.instance("missing value [key=").put(key).put(']');
        }
        if (that.charAt(0) == '\"') {
            if (that.charAt(len - 1) == '\"') {
                return that.of(that.getLo() + 1L, that.getHi() - 1L);
            }
            throw HttpException.instance("unclosed quote [key=").put(key).put(']');
        }
        return that;
    }

    @Override
    public final void clear() {
        this.needMethod = true;
        this._wptr = this._lo = this.headerPtr;
        this.incomplete = true;
        this.headers.clear();
        this.method = null;
        this.url = null;
        this.headerName = null;
        this.contentType = null;
        this.boundary = null;
        this.contentDisposition = null;
        this.contentDispositionName = null;
        this.contentDispositionFilename = null;
        this.urlParams.clear();
        this.m = true;
        this.u = true;
        this.q = false;
    }

    @Override
    public void close() {
        if (this.headerPtr != 0L) {
            Unsafe.free(this.headerPtr, this.hi - this.headerPtr);
            this.headerPtr = 0L;
            this.boundaryAugmenter.close();
        }
    }

    @Override
    public DirectByteCharSequence getBoundary() {
        return this.boundaryAugmenter.of(this.boundary);
    }

    @Override
    public DirectByteCharSequence getCharset() {
        return this.charset;
    }

    @Override
    public CharSequence getContentDisposition() {
        return this.contentDisposition;
    }

    @Override
    public CharSequence getContentDispositionFilename() {
        return this.contentDispositionFilename;
    }

    @Override
    public CharSequence getContentDispositionName() {
        return this.contentDispositionName;
    }

    @Override
    public CharSequence getContentType() {
        return this.contentType;
    }

    @Override
    public DirectByteCharSequence getHeader(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public ObjList<CharSequence> getHeaderNames() {
        return this.headers.keys();
    }

    @Override
    public CharSequence getMethod() {
        return this.method;
    }

    @Override
    public CharSequence getMethodLine() {
        return this.methodLine;
    }

    @Override
    public CharSequence getUrl() {
        return this.url;
    }

    @Override
    public DirectByteCharSequence getUrlParam(CharSequence name) {
        return this.urlParams.get(name);
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public long parse(long ptr, long hi, boolean _method) {
        long p;
        if (_method && this.needMethod) {
            int l = this.parseMethod(ptr, hi);
            p = ptr + (long)l;
        } else {
            p = ptr;
        }
        while (p < hi) {
            if (this._wptr == this.hi) {
                throw HttpException.instance("header is too large");
            }
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == '\r') continue;
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)b);
            switch (b) {
                case ':': {
                    if (this.headerName != null) break;
                    this.headerName = this.pool.next().of(this._lo, this._wptr - 1L);
                    this._lo = this._wptr + 1L;
                    break;
                }
                case '\n': {
                    if (this.headerName == null) {
                        this.incomplete = false;
                        this.parseKnownHeaders();
                        return p;
                    }
                    DirectByteCharSequence v = this.pool.next().of(this._lo, this._wptr - 1L);
                    this._lo = this._wptr;
                    this.headers.put(this.headerName, v);
                    this.headerName = null;
                    break;
                }
            }
        }
        return p;
    }

    public int size() {
        return this.headers.size();
    }

    private void parseContentDisposition() {
        long p;
        DirectByteCharSequence contentDisposition = this.getHeader(CONTENT_DISPOSITION_HEADER);
        if (contentDisposition == null) {
            return;
        }
        long _lo = p = contentDisposition.getLo();
        long hi = contentDisposition.getHi();
        boolean expectFormData = true;
        boolean swallowSpace = true;
        DirectByteCharSequence name = null;
        while (p <= hi) {
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == ' ' && swallowSpace) {
                _lo = p;
                continue;
            }
            if (p > hi || b == ';') {
                if (expectFormData) {
                    this.contentDisposition = this.pool.next().of(_lo, p - 1L);
                    _lo = p;
                    expectFormData = false;
                    continue;
                }
                if (name == null) {
                    throw HttpException.instance("Malformed ").put(CONTENT_DISPOSITION_HEADER).put(" header");
                }
                if (Chars.equals((CharSequence)"name", name)) {
                    this.contentDispositionName = HttpHeaderParser.unquote("name", this.pool.next().of(_lo, p - 1L));
                    swallowSpace = true;
                    _lo = p;
                    name = null;
                    continue;
                }
                if (Chars.equals((CharSequence)"filename", name)) {
                    this.contentDispositionFilename = HttpHeaderParser.unquote("filename", this.pool.next().of(_lo, p - 1L));
                    _lo = p;
                    name = null;
                    continue;
                }
                if (p <= hi) continue;
                break;
            }
            if (b != '=') continue;
            name = name == null ? this.pool.next().of(_lo, p - 1L) : name.of(_lo, p - 1L);
            _lo = p;
            swallowSpace = false;
        }
    }

    private void parseContentType() {
        long p;
        DirectByteCharSequence seq = this.getHeader(CONTENT_TYPE_HEADER);
        if (seq == null) {
            return;
        }
        long _lo = p = seq.getLo();
        long hi = seq.getHi();
        DirectByteCharSequence name = null;
        boolean contentType = true;
        boolean swallowSpace = true;
        while (p <= hi) {
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == ' ' && swallowSpace) {
                _lo = p;
                continue;
            }
            if (p > hi || b == ';') {
                if (contentType) {
                    this.contentType = this.pool.next().of(_lo, p - 1L);
                    _lo = p;
                    contentType = false;
                    continue;
                }
                if (name == null) {
                    throw HttpException.instance("Malformed ").put(CONTENT_TYPE_HEADER).put(" header");
                }
                if (Chars.equals((CharSequence)"charset", name)) {
                    this.charset = this.pool.next().of(_lo, p - 1L);
                    name = null;
                    _lo = p;
                    continue;
                }
                if (Chars.equals((CharSequence)"boundary", name)) {
                    this.boundary = this.pool.next().of(_lo, p - 1L);
                    _lo = p;
                    name = null;
                    continue;
                }
                if (p <= hi) continue;
                break;
            }
            if (b != '=') continue;
            name = name == null ? this.pool.next().of(_lo, p - 1L) : name.of(_lo, p - 1L);
            _lo = p;
            swallowSpace = false;
        }
    }

    private void parseKnownHeaders() {
        this.parseContentType();
        this.parseContentDisposition();
    }

    private int parseMethod(long lo, long hi) {
        long p = lo;
        while (p < hi) {
            if (this._wptr == this.hi) {
                throw HttpException.instance("url is too long");
            }
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == '\r') continue;
            switch (b) {
                case ' ': {
                    if (this.m) {
                        this.method = this.pool.next().of(this._lo, this._wptr);
                        this._lo = this._wptr + 1L;
                        this.m = false;
                        break;
                    }
                    if (this.u) {
                        this.url = this.pool.next().of(this._lo, this._wptr);
                        this.u = false;
                        this._lo = this._wptr + 1L;
                        break;
                    }
                    if (!this.q) break;
                    int o = this.urlDecode(this._lo, this._wptr, this.urlParams);
                    this.q = false;
                    this._lo = this._wptr;
                    this._wptr -= (long)o;
                    break;
                }
                case '?': {
                    this.url = this.pool.next().of(this._lo, this._wptr);
                    this.u = false;
                    this.q = true;
                    this._lo = this._wptr + 1L;
                    break;
                }
                case '\n': {
                    if (this.method == null) {
                        throw HttpException.instance("bad method");
                    }
                    this.methodLine = this.pool.next().of(this.method.getLo(), this._wptr);
                    this.needMethod = false;
                    this._lo = this._wptr;
                    return (int)(p - lo);
                }
            }
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)b);
        }
        return (int)(p - lo);
    }

    private int urlDecode(long lo, long hi, CharSequenceObjHashMap<DirectByteCharSequence> map) {
        long _lo = lo;
        long rp = lo;
        long wp = lo;
        int offset = 0;
        DirectByteCharSequence name = null;
        block8: while (rp < hi) {
            char b = (char)Unsafe.getUnsafe().getByte(rp++);
            switch (b) {
                case '=': {
                    if (_lo < wp) {
                        name = this.pool.next().of(_lo, wp);
                    }
                    _lo = rp - (long)offset;
                    break;
                }
                case '&': {
                    if (name != null) {
                        map.put(name, this.pool.next().of(_lo, wp));
                        name = null;
                    } else if (_lo < wp) {
                        map.put(this.pool.next().of(_lo, wp), null);
                    }
                    _lo = rp - (long)offset;
                    break;
                }
                case '+': {
                    Unsafe.getUnsafe().putByte(wp++, (byte)32);
                    continue block8;
                }
                case '%': {
                    try {
                        if (rp + 1L < hi) {
                            byte bb = (byte)Numbers.parseHexInt(this.temp.of(rp, rp += 2L));
                            Unsafe.getUnsafe().putByte(wp++, bb);
                            offset += 2;
                            continue block8;
                        }
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                    throw HttpException.instance("invalid query encoding");
                }
            }
            Unsafe.getUnsafe().putByte(wp++, (byte)b);
        }
        if (_lo < wp) {
            if (name != null) {
                map.put(name, this.pool.next().of(_lo, wp));
            } else {
                map.put(this.pool.next().of(_lo, wp), null);
            }
        }
        return offset;
    }

    public static class BoundaryAugmenter
    implements Closeable {
        private static final String BOUNDARY_PREFIX = "\r\n--";
        private final DirectByteCharSequence export = new DirectByteCharSequence();
        private long lo = this._wptr = Unsafe.malloc(this.lim);
        private long lim = 64L;
        private long _wptr;

        public BoundaryAugmenter() {
            this.of0(BOUNDARY_PREFIX);
        }

        @Override
        public void close() {
            if (this.lo > 0L) {
                Unsafe.free(this.lo, this.lim);
                this.lo = 0L;
            }
        }

        public DirectByteCharSequence of(CharSequence value) {
            int len = value.length() + BOUNDARY_PREFIX.length();
            if ((long)len > this.lim) {
                this.resize(len);
            }
            this._wptr = this.lo + (long)BOUNDARY_PREFIX.length();
            this.of0(value);
            return this.export.of(this.lo, this._wptr);
        }

        private void of0(CharSequence value) {
            int len = value.length();
            Chars.asciiStrCpy(value, len, this._wptr);
            this._wptr += (long)len;
        }

        private void resize(int lim) {
            Unsafe.free(this.lo, this.lim);
            this.lim = Numbers.ceilPow2(lim);
            this.lo = this._wptr = Unsafe.malloc(this.lim);
            this.of0(BOUNDARY_PREFIX);
        }
    }
}

