/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.MessageBus;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnIndexerJob;
import io.questdb.cairo.TableBlockWriter;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpMinServerConfiguration;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorFactory;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.WaitProcessor;
import io.questdb.cutlass.http.processors.HealthCheckProcessor;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.http.processors.StaticContentProcessor;
import io.questdb.cutlass.http.processors.TableStatusCheckProcessor;
import io.questdb.cutlass.http.processors.TextImportProcessor;
import io.questdb.cutlass.http.processors.TextQueryProcessor;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.engine.groupby.vect.GroupByJob;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.Job;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import io.questdb.std.WeakObjectPool;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class HttpServer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(HttpServer.class);
    private static final WorkerPoolAwareConfiguration.ServerFactory<HttpServer, HttpServerConfiguration> CREATE0 = HttpServer::create0;
    private static final WorkerPoolAwareConfiguration.ServerFactory<HttpServer, HttpMinServerConfiguration> CREATE_MIN = HttpServer::createMin;
    private final ObjList<HttpRequestProcessorSelectorImpl> selectors;
    private final IODispatcher<HttpConnectionContext> dispatcher;
    private final int workerCount;
    private final HttpContextFactory httpContextFactory;
    private final WorkerPool workerPool;
    private final WaitProcessor rescheduleContext;

    public HttpServer(HttpMinServerConfiguration configuration, WorkerPool pool, boolean localPool) {
        int i;
        this.workerCount = pool.getWorkerCount();
        this.selectors = new ObjList(this.workerCount);
        this.workerPool = localPool ? pool : null;
        for (i = 0; i < this.workerCount; ++i) {
            this.selectors.add(new HttpRequestProcessorSelectorImpl());
        }
        this.httpContextFactory = new HttpContextFactory(configuration.getHttpContextConfiguration());
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), this.httpContextFactory);
        pool.assign(this.dispatcher);
        this.rescheduleContext = new WaitProcessor(configuration.getWaitProcessorConfiguration());
        pool.assign(this.rescheduleContext);
        for (i = 0; i < this.workerCount; ++i) {
            final int index = i;
            pool.assign(i, new Job(){
                private final HttpRequestProcessorSelector selector;
                private final IORequestProcessor<HttpConnectionContext> processor;
                {
                    this.selector = (HttpRequestProcessorSelector)HttpServer.this.selectors.getQuick(index);
                    this.processor = (operation, context) -> context.handleClientOperation(operation, this.selector, HttpServer.this.rescheduleContext);
                }

                @Override
                public boolean run(int workerId) {
                    boolean useful = HttpServer.this.dispatcher.processIOQueue(this.processor);
                    return useful |= HttpServer.this.rescheduleContext.runReruns(this.selector);
                }
            });
            pool.assign(i, () -> {
                Misc.free(this.selectors.getQuick(index));
                this.httpContextFactory.closeContextPool();
                Misc.free(QueryCache.getInstance());
            });
        }
    }

    public static void addDefaultEndpoints(HttpServer server, final HttpServerConfiguration configuration, final CairoEngine cairoEngine, final WorkerPool workerPool, final MessageBus messageBus, final HttpRequestProcessorBuilder jsonQueryProcessorBuilder, final FunctionFactoryCache functionFactoryCache) {
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return jsonQueryProcessorBuilder.newInstance();
            }

            @Override
            public String getUrl() {
                return "/exec";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextImportProcessor(cairoEngine);
            }

            @Override
            public String getUrl() {
                return "/imp";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, messageBus, workerPool.getWorkerCount(), functionFactoryCache);
            }

            @Override
            public String getUrl() {
                return "/exp";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TableStatusCheckProcessor(cairoEngine, configuration.getJsonQueryProcessorConfiguration());
            }

            @Override
            public String getUrl() {
                return "/chk";
            }
        });
        server.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new StaticContentProcessor(configuration);
            }

            @Override
            public String getUrl() {
                return "*";
            }
        });
        workerPool.assign(new ColumnIndexerJob(messageBus));
        workerPool.assign(new GroupByJob(messageBus));
        workerPool.assign(new TableBlockWriter.TableBlockWriterJob(messageBus));
    }

    @Nullable
    public static HttpServer create(HttpServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine) {
        return HttpServer.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, (FunctionFactoryCache)null);
    }

    @Nullable
    public static HttpServer create(HttpServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine, WorkerPoolAwareConfiguration.ServerFactory<HttpServer, HttpServerConfiguration> factory) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, factory, null);
    }

    @Nullable
    public static HttpServer create(HttpServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine, @Nullable FunctionFactoryCache functionFactoryCache) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, CREATE0, functionFactoryCache);
    }

    @Nullable
    public static HttpServer createMin(HttpMinServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine, @Nullable FunctionFactoryCache functionFactoryCache) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, CREATE_MIN, functionFactoryCache);
    }

    public void bind(HttpRequestProcessorFactory factory) {
        String url = factory.getUrl();
        assert (url != null);
        for (int i = 0; i < this.workerCount; ++i) {
            HttpRequestProcessorSelectorImpl selector = this.selectors.getQuick(i);
            if ("*".equals(url)) {
                selector.defaultRequestProcessor = factory.newInstance();
                continue;
            }
            selector.processorMap.put(url, factory.newInstance());
        }
    }

    @Override
    public void close() {
        if (this.workerPool != null) {
            this.workerPool.halt();
        }
        Misc.free(this.httpContextFactory);
        Misc.free(this.dispatcher);
    }

    private static HttpServer create0(HttpServerConfiguration configuration, CairoEngine cairoEngine, WorkerPool workerPool, boolean localPool, MessageBus messageBus, FunctionFactoryCache functionFactoryCache) {
        HttpServer s = new HttpServer(configuration, workerPool, localPool);
        QueryCache.configure(configuration);
        HttpRequestProcessorBuilder jsonQueryProcessorBuilder = () -> new JsonQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, messageBus, workerPool.getWorkerCount(), functionFactoryCache);
        HttpServer.addDefaultEndpoints(s, configuration, cairoEngine, workerPool, messageBus, jsonQueryProcessorBuilder, functionFactoryCache);
        return s;
    }

    private static HttpServer createMin(HttpMinServerConfiguration configuration, CairoEngine cairoEngine, WorkerPool workerPool, boolean localPool, MessageBus messageBus, FunctionFactoryCache functionFactoryCache) {
        HttpServer s = new HttpServer(configuration, workerPool, localPool);
        s.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new HealthCheckProcessor();
            }

            @Override
            public String getUrl() {
                return "*";
            }
        });
        return s;
    }

    private static class HttpContextFactory
    implements IOContextFactory<HttpConnectionContext>,
    Closeable,
    EagerThreadSetup {
        private final ThreadLocal<WeakObjectPool<HttpConnectionContext>> contextPool = new ThreadLocal<WeakObjectPool>(() -> new WeakObjectPool<HttpConnectionContext>(() -> new HttpConnectionContext(configuration), configuration.getConnectionPoolInitialCapacity()));
        private boolean closed = false;

        public HttpContextFactory(HttpContextConfiguration configuration) {
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public HttpConnectionContext newInstance(long fd, IODispatcher<HttpConnectionContext> dispatcher) {
            return ((HttpConnectionContext)((WeakObjectPool)this.contextPool.get()).pop()).of(fd, dispatcher);
        }

        @Override
        public void done(HttpConnectionContext context) {
            if (this.closed) {
                Misc.free(context);
            } else {
                context.of(-1L, null);
                ((WeakObjectPool)this.contextPool.get()).push(context);
                LOG.debug().$("pushed").$();
            }
        }

        @Override
        public void setup() {
            this.contextPool.get();
        }

        private void closeContextPool() {
            Misc.free(this.contextPool.get());
            LOG.info().$("closed").$();
        }
    }

    private static class HttpRequestProcessorSelectorImpl
    implements HttpRequestProcessorSelector {
        private final CharSequenceObjHashMap<HttpRequestProcessor> processorMap = new CharSequenceObjHashMap();
        private HttpRequestProcessor defaultRequestProcessor = null;

        private HttpRequestProcessorSelectorImpl() {
        }

        @Override
        public HttpRequestProcessor select(CharSequence url) {
            return this.processorMap.get(url);
        }

        @Override
        public HttpRequestProcessor getDefaultProcessor() {
            return this.defaultRequestProcessor;
        }

        @Override
        public void close() {
            Misc.free(this.defaultRequestProcessor);
            ObjList<CharSequence> processorKeys = this.processorMap.keys();
            int n = processorKeys.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.processorMap.get(processorKeys.getQuick(i)));
            }
        }
    }

    public static interface HttpRequestProcessorBuilder {
        public HttpRequestProcessor newInstance();
    }
}

