/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.http.processors.ValueWriter;
import io.questdb.cutlass.text.TextUtil;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.NanosecondClock;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class JsonQueryProcessorState
implements Mutable,
Closeable {
    static final int QUERY_RECORD_PREFIX = 9;
    static final int QUERY_SETUP_FIRST_RECORD = 8;
    static final int QUERY_SUFFIX = 7;
    static final int QUERY_RECORD_SUFFIX = 6;
    static final int QUERY_RECORD = 5;
    static final int QUERY_RECORD_START = 4;
    static final int QUERY_METADATA_SUFFIX = 3;
    static final int QUERY_METADATA = 2;
    static final int QUERY_PREFIX = 1;
    private static final Log LOG = LogFactory.getLog(JsonQueryProcessorState.class);
    private final ObjList<ValueWriter> allValueWriters = new ObjList();
    private final StringSink query = new StringSink();
    private final StringSink columnsQueryParameter = new StringSink();
    private final ObjList<StateResumeAction> resumeActions = new ObjList();
    private final ObjList<ValueWriter> valueWriters = new ObjList();
    private final ArrayColumnTypes columnTypes = new ArrayColumnTypes();
    private final ObjList<String> columnNames = new ObjList();
    private final HttpConnectionContext httpConnectionContext;
    private final IntList columnSkewList = new IntList();
    private final ObjList<ValueWriter> skewedValueWriters = new ObjList();
    private final NanosecondClock nanosecondClock;
    private final int floatScale;
    private final int doubleScale;
    private Rnd rnd;
    private RecordCursorFactory recordCursorFactory;
    private RecordCursor cursor;
    private boolean noMeta = false;
    private Record record;
    private int queryState = 1;
    private int columnIndex;
    private boolean countRows = false;
    private long count;
    private long skip;
    private long stop;
    private int columnCount;
    private long executeStartNanos;
    private long recordCountNanos;
    private long compilerNanos;
    private boolean timings;
    private boolean queryCacheable = false;

    public JsonQueryProcessorState(HttpConnectionContext httpConnectionContext, NanosecondClock nanosecondClock, int floatScale, int doubleScale) {
        this.httpConnectionContext = httpConnectionContext;
        this.resumeActions.extendAndSet(1, this::onQueryPrefix);
        this.resumeActions.extendAndSet(2, this::onQueryMetadata);
        this.resumeActions.extendAndSet(3, this::onQueryMetadataSuffix);
        this.resumeActions.extendAndSet(8, this::doFirstRecordLoop);
        this.resumeActions.extendAndSet(9, this::onQueryRecordPrefix);
        this.resumeActions.extendAndSet(5, this::onQueryRecord);
        this.resumeActions.extendAndSet(6, this::onQueryRecordSuffix);
        this.resumeActions.extendAndSet(7, this::doQuerySuffix);
        this.skewedValueWriters.extendAndSet(0, this::putSkewedBooleanValue);
        this.skewedValueWriters.extendAndSet(1, this::putSkewedByteValue);
        this.skewedValueWriters.extendAndSet(9, this::putSkewedDoubleValue);
        this.skewedValueWriters.extendAndSet(8, this::putSkewedFloatValue);
        this.skewedValueWriters.extendAndSet(4, this::putSkewedIntValue);
        this.skewedValueWriters.extendAndSet(5, this::putSkewedLongValue);
        this.skewedValueWriters.extendAndSet(6, this::putSkewedDateValue);
        this.skewedValueWriters.extendAndSet(7, this::putSkewedTimestampValue);
        this.skewedValueWriters.extendAndSet(2, this::putSkewedShortValue);
        this.skewedValueWriters.extendAndSet(3, this::putSkewedCharValue);
        this.skewedValueWriters.extendAndSet(10, this::putSkewedStrValue);
        this.skewedValueWriters.extendAndSet(11, this::putSkewedSymValue);
        this.skewedValueWriters.extendAndSet(13, this::putSkewedBinValue);
        this.skewedValueWriters.extendAndSet(12, this::putSkewedLong256Value);
        this.skewedValueWriters.extendAndSet(15, JsonQueryProcessorState::putCursorValue);
        this.allValueWriters.extendAndSet(0, JsonQueryProcessorState::putBooleanValue);
        this.allValueWriters.extendAndSet(1, JsonQueryProcessorState::putByteValue);
        this.allValueWriters.extendAndSet(9, this::putDoubleValue);
        this.allValueWriters.extendAndSet(8, this::putFloatValue);
        this.allValueWriters.extendAndSet(4, JsonQueryProcessorState::putIntValue);
        this.allValueWriters.extendAndSet(5, JsonQueryProcessorState::putLongValue);
        this.allValueWriters.extendAndSet(6, JsonQueryProcessorState::putDateValue);
        this.allValueWriters.extendAndSet(7, JsonQueryProcessorState::putTimestampValue);
        this.allValueWriters.extendAndSet(2, JsonQueryProcessorState::putShortValue);
        this.allValueWriters.extendAndSet(3, JsonQueryProcessorState::putCharValue);
        this.allValueWriters.extendAndSet(10, JsonQueryProcessorState::putStrValue);
        this.allValueWriters.extendAndSet(11, JsonQueryProcessorState::putSymValue);
        this.allValueWriters.extendAndSet(13, JsonQueryProcessorState::putBinValue);
        this.allValueWriters.extendAndSet(12, JsonQueryProcessorState::putLong256Value);
        this.allValueWriters.extendAndSet(17, JsonQueryProcessorState::putCursorValue);
        this.nanosecondClock = nanosecondClock;
        this.floatScale = floatScale;
        this.doubleScale = doubleScale;
    }

    @Override
    public void clear() {
        this.columnCount = 0;
        this.columnTypes.clear();
        this.columnNames.clear();
        this.cursor = Misc.free(this.cursor);
        this.record = null;
        if (null != this.recordCursorFactory) {
            if (this.queryCacheable) {
                QueryCache.getInstance().push(this.query, this.recordCursorFactory);
            } else {
                this.recordCursorFactory.close();
            }
            this.recordCursorFactory = null;
        }
        this.query.clear();
        this.columnsQueryParameter.clear();
        this.queryState = 1;
        this.columnIndex = 0;
        this.countRows = false;
    }

    @Override
    public void close() {
        this.cursor = Misc.free(this.cursor);
        this.recordCursorFactory = Misc.free(this.recordCursorFactory);
    }

    public void configure(HttpRequestHeader request, DirectByteCharSequence query, long skip, long stop) throws Utf8Exception {
        this.query.clear();
        TextUtil.utf8Decode(query.getLo(), query.getHi(), this.query);
        this.skip = skip;
        this.count = 0L;
        this.stop = stop;
        this.noMeta = Chars.equalsNc((CharSequence)"true", request.getUrlParam("nm"));
        this.countRows = Chars.equalsNc((CharSequence)"true", request.getUrlParam("count"));
        this.timings = Chars.equalsNc((CharSequence)"true", request.getUrlParam("timings"));
    }

    public LogRecord error() {
        return LOG.error().$('[').$(this.getFd()).$("] ");
    }

    public HttpConnectionContext getHttpConnectionContext() {
        return this.httpConnectionContext;
    }

    public CharSequence getQuery() {
        return this.query;
    }

    public Rnd getRnd() {
        return this.rnd;
    }

    public void setRnd(Rnd rnd) {
        this.rnd = rnd;
    }

    public LogRecord info() {
        return LOG.info().$('[').$(this.getFd()).$("] ");
    }

    public void logBufferTooSmall() {
        this.info().$("Response buffer is too small, state=").$(this.queryState).$();
    }

    public void logExecuteCached() {
        this.info().$("execute-cached ").$("[skip: ").$(this.skip).$(", stop: ").$(this.stop).$(']').$();
    }

    public void logExecuteNew() {
        this.info().$("execute-new ").$("[skip: ").$(this.skip).$(", stop: ").$(this.stop).$(']').$();
    }

    public void logSyntaxError(SqlException e) {
        this.info().$("syntax-error [q=`").utf8(this.query).$("`, at=").$(e.getPosition()).$(", message=`").utf8(e.getFlyweightMessage()).$('`').$(']').$();
    }

    public void logTimings() {
        this.info().$("timings ").$("[compiler: ").$(this.compilerNanos).$(", count: ").$(this.recordCountNanos).$(", execute: ").$(this.nanosecondClock.getTicks() - this.executeStartNanos).$(", q=`").$(this.query).$("`]").$();
    }

    public void setCompilerNanos(long compilerNanos) {
        this.compilerNanos = compilerNanos;
    }

    public void startExecutionTimer() {
        this.executeStartNanos = this.nanosecondClock.getTicks();
    }

    static void prepareExceptionJson(HttpChunkedResponseSocket socket, int position, CharSequence message, CharSequence query) throws PeerDisconnectedException, PeerIsSlowToReadException {
        socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(query == null ? "" : query).put(',').putQuoted("error").put(':').encodeUtf8AndQuote(message).put(',').putQuoted("position").put(':').put(position);
        socket.put('}');
        socket.sendChunk(true);
    }

    private static void putStringOrNull(CharSink r, CharSequence str) {
        if (str == null) {
            r.put("null");
        } else {
            r.encodeUtf8AndQuote(str);
        }
    }

    private static void putBinValue(HttpChunkedResponseSocket socket, Record record, int col) {
        socket.put('[');
        socket.put(']');
    }

    private static void putBooleanValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getBool(col));
    }

    private static void putByteValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getByte(col));
    }

    private static void putCharValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        char c = rec.getChar(col);
        if (c == '\u0000') {
            socket.put("\"\"");
        } else {
            socket.put('\"').putUtf8(c).put('\"');
        }
    }

    private static void putDateValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        long d = rec.getDate(col);
        if (d == Long.MIN_VALUE) {
            socket.put("null");
            return;
        }
        socket.put('\"').putISODateMillis(d).put('\"');
    }

    private static void putIntValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        int i = rec.getInt(col);
        if (i == Integer.MIN_VALUE) {
            socket.put("null");
        } else {
            Numbers.append((CharSink)socket, i);
        }
    }

    private static void putLong256Value(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put('\"');
        rec.getLong256(col, socket);
        socket.put('\"');
    }

    private static void putLongValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        long l = rec.getLong(col);
        if (l == Long.MIN_VALUE) {
            socket.put("null");
        } else {
            socket.put(l);
        }
    }

    private static void putShortValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getShort(col));
    }

    private static void putStrValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putStringOrNull(socket, rec.getStr(col));
    }

    private static void putSymValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putStringOrNull(socket, rec.getSym(col));
    }

    private static void putTimestampValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        long t = rec.getTimestamp(col);
        if (t == Long.MIN_VALUE) {
            socket.put("null");
            return;
        }
        socket.put('\"').putISODate(t).put('\"');
    }

    private static void putCursorValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putStringOrNull(socket, null);
    }

    private boolean addColumnToOutput(RecordMetadata metadata, CharSequence columnNames, int start, int hi) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (start == hi) {
            this.info().$("empty column in list '").$(columnNames).$('\'').$();
            HttpChunkedResponseSocket socket = this.getHttpConnectionContext().getChunkedResponseSocket();
            JsonQueryProcessor.header(socket, "");
            socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(this.query).put(',').putQuoted("error").put(':').putQuoted("empty column in list");
            socket.put('}');
            socket.sendChunk(true);
            return true;
        }
        int columnIndex = metadata.getColumnIndexQuiet(columnNames, start, hi);
        if (columnIndex == -1) {
            this.info().$("invalid column in list: '").$(columnNames, start, hi).$('\'').$();
            HttpChunkedResponseSocket socket = this.getHttpConnectionContext().getChunkedResponseSocket();
            JsonQueryProcessor.header(socket, "");
            socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(this.query).put(',').putQuoted("error").put(':').put('\'').put("invalid column in list: ").put(columnNames, start, hi).put('\'');
            socket.put('}');
            socket.sendChunk(true);
            return true;
        }
        int columnType = metadata.getColumnType(columnIndex);
        this.columnTypes.add(columnType);
        this.columnSkewList.add(columnIndex);
        this.valueWriters.add(this.skewedValueWriters.getQuick(columnType));
        this.columnNames.add(metadata.getColumnName(columnIndex));
        return false;
    }

    private void doFirstRecordLoop(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.onQuerySetupFirstRecord()) {
            this.doRecordFetchLoop(socket, columnCount);
        } else {
            this.doQuerySuffix(socket, columnCount);
        }
    }

    private void doNextRecordLoop(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.doQueryNextRecord()) {
            this.doRecordFetchLoop(socket, columnCount);
        } else {
            this.doQuerySuffix(socket, columnCount);
        }
    }

    private void doQueryMetadata(HttpChunkedResponseSocket socket, int columnCount) {
        this.queryState = 2;
        while (this.columnIndex < columnCount) {
            socket.bookmark();
            if (this.columnIndex > 0) {
                socket.put(',');
            }
            socket.put('{').putQuoted("name").put(':').encodeUtf8AndQuote(this.columnNames.getQuick(this.columnIndex)).put(',').putQuoted("type").put(':').putQuoted(ColumnType.nameOf(this.columnTypes.getColumnType(this.columnIndex)));
            socket.put('}');
            ++this.columnIndex;
        }
    }

    private void doQueryMetadataSuffix(HttpChunkedResponseSocket socket) {
        this.queryState = 3;
        socket.bookmark();
        socket.put("],\"dataset\":[");
    }

    private boolean doQueryNextRecord() {
        if (this.cursor.hasNext()) {
            if (this.count < this.stop) {
                return true;
            }
            this.onNoMoreData();
        }
        return false;
    }

    private boolean doQueryPrefix(HttpChunkedResponseSocket socket) {
        if (this.noMeta) {
            socket.bookmark();
            socket.put('{').putQuoted("dataset").put(":[");
            return false;
        }
        socket.bookmark();
        socket.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(this.query);
        socket.put(',').putQuoted("columns").put(':').put('[');
        this.columnIndex = 0;
        return true;
    }

    private void doQueryRecord(HttpChunkedResponseSocket socket, int columnCount) {
        this.queryState = 5;
        while (this.columnIndex < columnCount) {
            socket.bookmark();
            if (this.columnIndex > 0) {
                socket.put(',');
            }
            this.valueWriters.getQuick(this.columnIndex).write(socket, this.record, this.columnIndex);
            ++this.columnIndex;
        }
    }

    private void doQueryRecordPrefix(HttpChunkedResponseSocket socket) {
        this.queryState = 9;
        socket.bookmark();
        if (this.count > this.skip) {
            socket.put(',');
        }
        socket.put('[');
        this.columnIndex = 0;
    }

    private void doQueryRecordSuffix(HttpChunkedResponseSocket socket) {
        this.queryState = 6;
        ++this.count;
        socket.bookmark();
        socket.put(']');
    }

    private void doQuerySuffix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.queryState = 7;
        if (this.count > -1L) {
            this.logTimings();
            socket.bookmark();
            socket.put(']');
            socket.put(',').putQuoted("count").put(':').put(this.count);
            if (this.timings) {
                socket.put(',').putQuoted("timings").put(':').put('{');
                socket.putQuoted("compiler").put(':').put(this.compilerNanos).put(',');
                socket.putQuoted("execute").put(':').put(this.nanosecondClock.getTicks() - this.executeStartNanos).put(',');
                socket.putQuoted("count").put(':').put(this.recordCountNanos);
                socket.put('}');
            }
            socket.put('}');
            this.count = -1L;
            socket.sendChunk(true);
            return;
        }
        socket.done();
    }

    private void doRecordFetchLoop(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        do {
            this.doQueryRecordPrefix(socket);
            this.doQueryRecord(socket, columnCount);
            this.doQueryRecordSuffix(socket);
        } while (this.doQueryNextRecord());
        this.doQuerySuffix(socket, columnCount);
    }

    private long getFd() {
        return this.httpConnectionContext.getFd();
    }

    boolean noCursor() {
        return this.cursor == null;
    }

    boolean of(RecordCursorFactory factory, SqlExecutionContextImpl sqlExecutionContext) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int columnCount;
        this.recordCursorFactory = factory;
        this.queryCacheable = true;
        this.cursor = factory.getCursor(sqlExecutionContext);
        RecordMetadata metadata = factory.getMetadata();
        HttpRequestHeader header = this.httpConnectionContext.getRequestHeader();
        DirectByteCharSequence columnNames = header.getUrlParam("cols");
        this.valueWriters.clear();
        if (columnNames != null) {
            this.columnsQueryParameter.clear();
            try {
                TextUtil.utf8Decode(columnNames.getLo(), columnNames.getHi(), this.columnsQueryParameter);
            }
            catch (Utf8Exception e) {
                this.info().$("utf8 error when decoding column list '").$(columnNames).$('\'').$();
                HttpChunkedResponseSocket socket = this.getHttpConnectionContext().getChunkedResponseSocket();
                JsonQueryProcessor.header(socket, "");
                socket.put('{').putQuoted("error").put(':').putQuoted("utf8 error in column list");
                socket.put('}');
                socket.sendChunk(true);
                return false;
            }
            this.columnSkewList.clear();
            columnCount = 1;
            int start = 0;
            int comma = 0;
            while (comma > -1) {
                comma = Chars.indexOf(this.columnsQueryParameter, start, ',');
                if (comma > -1) {
                    if (this.addColumnToOutput(metadata, this.columnsQueryParameter, start, comma)) {
                        return false;
                    }
                    start = comma + 1;
                    ++columnCount;
                    continue;
                }
                int hi = this.columnsQueryParameter.length();
                if (!this.addColumnToOutput(metadata, this.columnsQueryParameter, start, hi)) continue;
                return false;
            }
        } else {
            columnCount = metadata.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                int columnType = metadata.getColumnType(i);
                this.columnTypes.add(columnType);
                this.valueWriters.add(this.allValueWriters.getQuick(columnType));
                this.columnNames.add(metadata.getColumnName(i));
            }
        }
        this.columnCount = columnCount;
        return true;
    }

    private void onNoMoreData() {
        long nanos = this.nanosecondClock.getTicks();
        if (this.countRows) {
            RecordCursor cursor = this.cursor;
            long size = cursor.size();
            if (size < 0L) {
                LOG.info().$("counting").$();
                long count = 1L;
                while (cursor.hasNext()) {
                    ++count;
                }
                this.count += count;
            } else {
                this.count = size;
            }
        }
        this.recordCountNanos = this.nanosecondClock.getTicks() - nanos;
    }

    private void onQueryMetadata(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryMetadata(socket, columnCount);
        this.onQueryMetadataSuffix(socket, columnCount);
    }

    private void onQueryMetadataSuffix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryMetadataSuffix(socket);
        this.doFirstRecordLoop(socket, columnCount);
    }

    private void onQueryPrefix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.doQueryPrefix(socket)) {
            this.doQueryMetadata(socket, columnCount);
            this.doQueryMetadataSuffix(socket);
        }
        this.doFirstRecordLoop(socket, columnCount);
    }

    private void onQueryRecord(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecord(socket, columnCount);
        this.onQueryRecordSuffix(socket, columnCount);
    }

    private void onQueryRecordPrefix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecordPrefix(socket);
        this.onQueryRecord(socket, columnCount);
    }

    private void onQueryRecordSuffix(HttpChunkedResponseSocket socket, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doQueryRecordSuffix(socket);
        this.doNextRecordLoop(socket, columnCount);
    }

    private boolean onQuerySetupFirstRecord() {
        if (this.skip > 0L) {
            long target;
            RecordCursor cursor = this.cursor;
            for (target = this.skip + 1L; target > 0L && cursor.hasNext(); --target) {
            }
            if (target > 0L) {
                return false;
            }
            this.count = this.skip;
        } else if (!this.cursor.hasNext()) {
            return false;
        }
        this.columnIndex = 0;
        this.record = this.cursor.getRecord();
        return true;
    }

    private void putDoubleValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getDouble(col), this.doubleScale);
    }

    private void putFloatValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        socket.put(rec.getFloat(col), this.floatScale);
    }

    private void putSkewedBinValue(HttpChunkedResponseSocket socket, Record record, int col) {
        JsonQueryProcessorState.putBinValue(socket, record, this.columnSkewList.getQuick(col));
    }

    private void putSkewedBooleanValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putBooleanValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedByteValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putByteValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedCharValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putCharValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedDateValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putDateValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedDoubleValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        this.putDoubleValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedFloatValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        this.putFloatValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedIntValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putIntValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedLong256Value(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putLong256Value(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedLongValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putLongValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedShortValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putShortValue(socket, rec, col);
    }

    private void putSkewedStrValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putStrValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedSymValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putSymValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    private void putSkewedTimestampValue(HttpChunkedResponseSocket socket, Record rec, int col) {
        JsonQueryProcessorState.putTimestampValue(socket, rec, this.columnSkewList.getQuick(col));
    }

    void resume(HttpChunkedResponseSocket socket) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.resumeActions.getQuick(this.queryState).onResume(socket, this.columnCount);
    }

    void setQueryCacheable(boolean queryCacheable) {
        this.queryCacheable = queryCacheable;
    }

    @FunctionalInterface
    static interface StateResumeAction {
        public void onResume(HttpChunkedResponseSocket var1, int var2) throws PeerDisconnectedException, PeerIsSlowToReadException;
    }
}

