/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TableStatusCheckProcessor
implements HttpRequestProcessor,
Closeable {
    private final CairoEngine cairoEngine;
    private final Path path = new Path();
    private final String keepAliveHeader;

    public TableStatusCheckProcessor(CairoEngine cairoEngine, JsonQueryProcessorConfiguration configuration) {
        this.cairoEngine = cairoEngine;
        this.keepAliveHeader = Chars.toString(configuration.getKeepAliveHeader());
    }

    private static String toResponse(int existenceCheckResult) {
        switch (existenceCheckResult) {
            case 0: {
                return "Exists";
            }
            case 1: {
                return "Does not exist";
            }
        }
        return "Reserved name";
    }

    @Override
    public void close() {
        Misc.free(this.path);
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        DirectByteCharSequence tableName = context.getRequestHeader().getUrlParam("j");
        if (tableName == null) {
            context.simpleResponse().sendStatus(200, "table name missing");
        } else {
            int check = this.cairoEngine.getStatus(context.getCairoSecurityContext(), this.path, tableName);
            if (Chars.equalsNc((CharSequence)"json", context.getRequestHeader().getUrlParam("f"))) {
                HttpChunkedResponseSocket r = context.getChunkedResponseSocket();
                r.status(200, "application/json");
                r.headers().put(this.keepAliveHeader);
                r.sendHeader();
                r.put('{').putQuoted("status").put(':').putQuoted(TableStatusCheckProcessor.toResponse(check)).put('}');
                r.sendChunk(true);
            } else {
                context.simpleResponse().sendStatus(200, TableStatusCheckProcessor.toResponse(check));
            }
        }
    }
}

