/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.json;

import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class JsonException
extends Exception
implements Sinkable,
FlyweightMessageContainer {
    private static final ThreadLocal<JsonException> tlException = new ThreadLocal<JsonException>(JsonException::new);
    private final StringSink message = new StringSink();
    private int position;

    public static JsonException $(int position, CharSequence message) {
        return JsonException.position(position).put(message);
    }

    public static JsonException position(int position) {
        JsonException ex = (JsonException)tlException.get();
        ex.message.clear();
        ex.position = position;
        return ex;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return "[" + this.position + "] " + this.message;
    }

    public int getPosition() {
        return this.position;
    }

    public JsonException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public JsonException put(char c) {
        this.message.put(c);
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[').put(this.position).put("]: ").put(this.message);
    }
}

