/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableWriter;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;

public class CairoLineProtoParserSupport {
    private static final Log LOG = LogFactory.getLog(CairoLineProtoParserSupport.class);

    public static void putValue(TableWriter.Row row, int columnType, int columnIndex, CharSequence value) throws BadCastException {
        try {
            switch (columnType) {
                case 5: {
                    row.putLong(columnIndex, Numbers.parseLong(value, 0, value.length() - 1));
                    break;
                }
                case 0: {
                    row.putBool(columnIndex, CairoLineProtoParserSupport.isTrue(value));
                    break;
                }
                case 10: {
                    row.putStr(columnIndex, value, 1, value.length() - 2);
                    break;
                }
                case 11: {
                    row.putSym(columnIndex, value);
                    break;
                }
                case 9: {
                    row.putDouble(columnIndex, Numbers.parseDouble(value));
                    break;
                }
                case 8: {
                    row.putFloat(columnIndex, Numbers.parseFloat(value));
                    break;
                }
                case 4: {
                    row.putInt(columnIndex, Numbers.parseInt(value, 0, value.length() - 1));
                    break;
                }
                case 2: {
                    row.putShort(columnIndex, Numbers.parseShort(value, 0, value.length() - 1));
                    break;
                }
                case 1: {
                    long v = Numbers.parseLong(value, 0, value.length() - 1);
                    if (v < -128L || v > 127L) {
                        throw CairoException.instance(0).put("line protocol integer is out of byte bounds [columnIndex=").put(columnIndex).put(", v=").put(v).put(']');
                    }
                    row.putByte(columnIndex, (byte)v);
                    break;
                }
                case 6: {
                    row.putDate(columnIndex, Numbers.parseLong(value, 0, value.length() - 1));
                    break;
                }
                case 12: {
                    if (value.charAt(0) == '0' && value.charAt(1) == 'x') {
                        row.putLong256(columnIndex, value, 2, value.length() - 1);
                        break;
                    }
                    throw BadCastException.INSTANCE;
                }
                case 7: {
                    row.putTimestamp(columnIndex, Numbers.parseLong(value, 0, value.length() - 1));
                    break;
                }
            }
        }
        catch (NumericException e) {
            LOG.info().$("cast error [value=").$(value).$(", toType=").$(ColumnType.nameOf(columnType)).$(']').$();
            throw BadCastException.INSTANCE;
        }
    }

    public static int getValueType(CharSequence token) {
        int len = token.length();
        switch (token.charAt(len - 1)) {
            case 'i': {
                if (token.charAt(1) == 'x') {
                    return 12;
                }
                return 5;
            }
            case 'F': 
            case 'T': 
            case 'e': 
            case 'f': 
            case 't': {
                return 0;
            }
            case '\"': {
                if (len < 2 || token.charAt(0) != '\"') {
                    LOG.error().$("incorrectly quoted string: ").$(token).$();
                    return -1;
                }
                return 10;
            }
        }
        return 9;
    }

    public static boolean isTrue(CharSequence value) {
        return (value.charAt(0) | 0x20) == 116;
    }

    public static class BadCastException
    extends Exception {
        public static final BadCastException INSTANCE = new BadCastException();
    }
}

