/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.cutlass.line.CachedCharSequence;
import io.questdb.cutlass.line.CharSequenceCache;
import io.questdb.cutlass.line.LineProtoException;
import io.questdb.cutlass.line.LineProtoParser;
import io.questdb.cutlass.line.Utf8RepairContinue;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public class LineProtoLexer
implements Mutable,
Closeable {
    protected final CharSequenceCache charSequenceCache;
    private final ArrayBackedCharSink sink = new ArrayBackedCharSink();
    private final ArrayBackedCharSequence cs = new ArrayBackedCharSequence();
    private final FloatingCharSequence floatingCharSequence = new FloatingCharSequence();
    private int state = 1;
    private boolean escape = false;
    private long buffer;
    private long bufferHi;
    private long dstPos = 0L;
    private long dstTop = 0L;
    private boolean skipLine = false;
    private LineProtoParser parser;
    private long utf8ErrorTop;
    private long utf8ErrorPos;
    private int errorCode = 0;
    private boolean unquoted = true;

    public LineProtoLexer(int bufferSize) {
        this.buffer = Unsafe.malloc(bufferSize);
        this.bufferHi = this.buffer + (long)bufferSize;
        this.charSequenceCache = address -> {
            this.floatingCharSequence.lo = this.buffer + (long)Numbers.decodeHighInt(address);
            this.floatingCharSequence.hi = this.buffer + (long)Numbers.decodeLowInt(address) - 2L;
            assert (this.floatingCharSequence.hi < this.bufferHi);
            assert (this.floatingCharSequence.lo >= this.buffer);
            return this.floatingCharSequence;
        };
        this.clear();
    }

    @Override
    public final void clear() {
        this.escape = false;
        this.dstTop = this.dstPos = this.buffer;
        this.state = 1;
        this.utf8ErrorPos = -1L;
        this.utf8ErrorTop = -1L;
        this.skipLine = false;
        this.unquoted = true;
        this.errorCode = 0;
    }

    @Override
    public void close() {
        Unsafe.free(this.buffer, this.bufferHi - this.buffer);
    }

    public void parse(long bytesPtr, long hi) {
        this.parsePartial(bytesPtr, hi);
    }

    public void parseLast() {
        if (!this.skipLine) {
            this.dstPos += 2L;
            try {
                this.onEol();
            }
            catch (LineProtoException e) {
                this.parser.onError((int)(this.dstPos - 2L - this.buffer) / 2, this.state, this.errorCode);
            }
        }
        this.clear();
    }

    public void withParser(LineProtoParser parser) {
        this.parser = parser;
    }

    private void chop() {
        this.dstTop = this.dstPos;
    }

    private void doSkipLine(byte b) {
        if (b == 10 || b == 13) {
            this.clear();
            this.doSkipLineComplete();
        }
    }

    protected void doSkipLineComplete() {
    }

    private void fireEvent() throws LineProtoException {
        if (this.dstTop > this.dstPos - 3L) {
            this.errorCode = 3;
            throw LineProtoException.INSTANCE;
        }
        this.parser.onEvent(this.cs, this.state, this.charSequenceCache);
        this.chop();
    }

    private void fireEventTransition(int evtTagName, int evtFieldName) {
        switch (this.state) {
            case 1: 
            case 2: {
                this.fireEvent();
                this.state = evtTagName;
                break;
            }
            case 3: {
                this.fireEvent();
                this.state = evtFieldName;
                break;
            }
            default: {
                this.errorCode = 1;
                throw LineProtoException.INSTANCE;
            }
        }
    }

    private void fireEventTransition2() {
        switch (this.state) {
            case 4: {
                this.fireEvent();
                this.state = 2;
                break;
            }
            case 5: {
                this.fireEvent();
                this.state = 3;
                break;
            }
            default: {
                this.errorCode = 1;
                throw LineProtoException.INSTANCE;
            }
        }
    }

    private void onComma() {
        if (this.unquoted) {
            this.fireEventTransition(4, 5);
        }
    }

    protected void onEol() throws LineProtoException {
        switch (this.state) {
            case 1: {
                this.chop();
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                this.fireEvent();
                this.parser.onLineEnd(this.charSequenceCache);
                this.clear();
                break;
            }
            default: {
                this.errorCode = 1;
                throw LineProtoException.INSTANCE;
            }
        }
    }

    private void onEquals() {
        if (this.unquoted) {
            this.fireEventTransition2();
        }
    }

    private void onEsc() {
        this.escape = true;
    }

    private void onQuote() {
        this.unquoted = !this.unquoted;
    }

    private void onSpace() {
        if (this.unquoted) {
            this.fireEventTransition(5, 6);
        }
    }

    protected long parsePartial(long bytesPtr, long hi) {
        long p = bytesPtr;
        while (p < hi && !this.partialComplete()) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (this.skipLine) {
                this.doSkipLine(b);
                ++p;
                continue;
            }
            if (this.escape) {
                this.dstPos -= 2L;
            }
            try {
                if (b > -1) {
                    this.sink.put((char)b);
                    ++p;
                } else {
                    try {
                        p = this.utf8Decode(p, hi, b);
                    }
                    catch (Utf8RepairContinue e) {
                        break;
                    }
                }
                this.dstPos += 2L;
                if (this.escape) {
                    this.escape = false;
                    continue;
                }
                switch (b) {
                    case 34: {
                        this.onQuote();
                        break;
                    }
                    case 10: 
                    case 13: {
                        this.onEol();
                        break;
                    }
                    case 32: {
                        this.onSpace();
                        break;
                    }
                    case 92: {
                        this.onEsc();
                        break;
                    }
                    case 44: {
                        this.onComma();
                        break;
                    }
                    case 61: {
                        this.onEquals();
                        break;
                    }
                }
            }
            catch (LineProtoException ex) {
                this.skipLine = true;
                this.parser.onError((int)(this.dstPos - 2L - this.buffer) / 2, this.state, this.errorCode);
            }
        }
        return p;
    }

    protected boolean partialComplete() {
        return false;
    }

    private long repairMultiByteChar(long lo, long hi, byte b) throws LineProtoException {
        int n = -1;
        while (true) {
            if (this.utf8ErrorTop == -1L) {
                this.utf8ErrorTop = this.utf8ErrorPos = this.dstPos + 1L;
            }
            this.dstPos = this.utf8ErrorPos++;
            this.sink.put((char)b);
            long errorLen = this.utf8ErrorPos - this.utf8ErrorTop;
            if (errorLen > 1L) {
                this.dstPos = this.utf8ErrorTop - 1L;
                n = Chars.utf8DecodeMultiByte(this.utf8ErrorTop, this.utf8ErrorPos, Unsafe.getUnsafe().getByte(this.utf8ErrorTop), this.sink);
            }
            if (n == -1 && errorLen > 3L) {
                this.errorCode = 2;
                throw LineProtoException.INSTANCE;
            }
            if (n != -1 || ++lo >= hi) break;
            b = Unsafe.getUnsafe().getByte(lo);
        }
        this.dstPos = this.utf8ErrorTop - 1L;
        if (n > 0) {
            this.utf8ErrorPos = -1L;
            this.utf8ErrorTop = -1L;
            return lo + 1L;
        }
        throw Utf8RepairContinue.INSTANCE;
    }

    private long utf8Decode(long lo, long hi, byte b) throws LineProtoException {
        if (this.utf8ErrorPos > -1L) {
            return this.repairMultiByteChar(lo, hi, b);
        }
        int n = Chars.utf8DecodeMultiByte(lo, hi, b, this.sink);
        if (n == -1) {
            return this.repairMultiByteChar(lo, hi, b);
        }
        return lo + (long)n;
    }

    private class ArrayBackedCharSequence
    extends AbstractCharSequence
    implements CachedCharSequence {
        private ArrayBackedCharSequence() {
        }

        @Override
        public long getCacheAddress() {
            return Numbers.encodeLowHighInts((int)(LineProtoLexer.this.dstPos - LineProtoLexer.this.buffer), (int)(LineProtoLexer.this.dstTop - LineProtoLexer.this.buffer));
        }

        @Override
        public int length() {
            return (int)((LineProtoLexer.this.dstPos - LineProtoLexer.this.dstTop) / 2L - 1L);
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(LineProtoLexer.this.dstTop + (long)index * 2L);
        }
    }

    private class ArrayBackedCharSink
    extends AbstractCharSink {
        private ArrayBackedCharSink() {
        }

        @Override
        public CharSink put(char c) {
            if (LineProtoLexer.this.dstPos == LineProtoLexer.this.bufferHi) {
                this.extend();
            }
            Unsafe.getUnsafe().putChar(LineProtoLexer.this.dstPos, c);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            throw new UnsupportedOperationException();
        }

        private void extend() {
            int capacity = (int)(LineProtoLexer.this.bufferHi - LineProtoLexer.this.buffer) * 2;
            if (capacity < 0) {
                throw LineProtoException.INSTANCE;
            }
            long buf = Unsafe.realloc(LineProtoLexer.this.buffer, LineProtoLexer.this.bufferHi - LineProtoLexer.this.buffer, capacity);
            long offset = LineProtoLexer.this.dstTop - LineProtoLexer.this.buffer;
            LineProtoLexer.this.bufferHi = buf + (long)capacity;
            LineProtoLexer.this.buffer = buf;
            LineProtoLexer.this.dstPos = buf + offset + (LineProtoLexer.this.dstPos - LineProtoLexer.this.dstTop);
            LineProtoLexer.this.dstTop = buf + offset;
        }
    }

    private static class FloatingCharSequence
    extends AbstractCharSequence {
        long lo;
        long hi;

        private FloatingCharSequence() {
        }

        @Override
        public int length() {
            return (int)(this.hi - this.lo) / 2;
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(this.lo + (long)index * 2L);
        }
    }
}

