/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.line.LineProtoSender;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkError;

public class LineTCPProtoSender
extends LineProtoSender {
    private static final Log LOG = LogFactory.getLog(LineProtoSender.class);

    public LineTCPProtoSender(int sendToIPv4Address, int sendToPort, int bufferCapacity) {
        super(0, sendToIPv4Address, sendToPort, bufferCapacity, 0);
    }

    @Override
    protected long createSocket(int interfaceIPv4Address, int ttl, long sockaddr) throws NetworkError {
        long fd = this.nf.socketTcp(true);
        if (this.nf.connect(fd, sockaddr) != 0L) {
            throw NetworkError.instance(this.nf.errno(), "could not connect to ").ip(interfaceIPv4Address);
        }
        int orgSndBufSz = this.nf.getSndBuf(fd);
        this.nf.setSndBuf(fd, 2 * this.capacity);
        int newSndBufSz = this.nf.getSndBuf(fd);
        LOG.info().$("Send buffer size change from ").$(orgSndBufSz).$(" to ").$(newSndBufSz).$();
        return fd;
    }

    @Override
    protected void sendToSocket(long fd, long lo, long sockaddr, int len) throws NetworkError {
        if (this.nf.send(fd, lo, len) != len) {
            throw NetworkError.instance(this.nf.errno()).put("send error");
        }
    }
}

