/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

public class NewLineProtoParser
implements Closeable {
    public static final long NULL_TIMESTAMP = Long.MIN_VALUE;
    private static final byte ENTITY_TYPE_NONE = -1;
    public static final byte ENTITY_TYPE_TAG = 0;
    public static final byte ENTITY_TYPE_FLOAT = 1;
    public static final byte ENTITY_TYPE_INTEGER = 2;
    public static final byte ENTITY_TYPE_STRING = 3;
    public static final byte ENTITY_TYPE_BOOLEAN = 4;
    public static final byte ENTITY_TYPE_LONG256 = 5;
    public static final byte ENTITY_TYPE_CACHED_TAG = 6;
    public static final int N_ENTITY_TYPES = 7;
    private final DirectByteCharSequence measurementName = new DirectByteCharSequence();
    private final DirectByteCharSequence charSeq = new DirectByteCharSequence();
    private final ObjList<ProtoEntity> entityCache = new ObjList();
    private long bufAt;
    private long entityLo;
    private boolean tagsComplete;
    private int nEscapedChars;
    private int nEntities;
    private ProtoEntity currentEntity;
    private ErrorCode errorCode;
    private EntityHandler entityHandler;
    private long timestamp;
    private final EntityHandler entityTableHandler = this::expectTableName;
    private final EntityHandler entityNameHandler = this::expectEntityName;
    private final EntityHandler entityValueHandler = this::expectEntityValue;
    private final EntityHandler entityTimestampHandler = this::expectTimestamp;
    private final EntityHandler entityEndOfLineHandler = this::expectEndoOfLine;

    public NewLineProtoParser of(long bufLo) {
        this.bufAt = bufLo - 1L;
        this.startNextMeasurement();
        return this;
    }

    public ParseResult parseMeasurement(long bufHi) {
        assert (this.bufAt != 0L && bufHi >= this.bufAt);
        block5: while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            boolean endOfLine = false;
            switch (b) {
                case 10: 
                case 13: {
                    endOfLine = true;
                    b = 10;
                }
                case 32: 
                case 44: 
                case 61: {
                    if (!this.entityHandler.completeEntity(b)) {
                        if (this.errorCode == ErrorCode.EMPTY_LINE) {
                            this.entityLo = ++this.bufAt;
                            continue block5;
                        }
                        return ParseResult.ERROR;
                    }
                    if (endOfLine) {
                        if (this.nEntities > 0) {
                            this.entityHandler = this.entityEndOfLineHandler;
                            return ParseResult.MEASUREMENT_COMPLETE;
                        }
                        this.errorCode = ErrorCode.NO_FIELDS;
                        return ParseResult.ERROR;
                    }
                    this.nEscapedChars = 0;
                    this.entityLo = ++this.bufAt;
                    continue block5;
                }
                case 92: {
                    if (this.bufAt + 1L >= bufHi) {
                        return ParseResult.BUFFER_UNDERFLOW;
                    }
                    ++this.nEscapedChars;
                    ++this.bufAt;
                    b = Unsafe.getUnsafe().getByte(this.bufAt);
                }
            }
            if (this.nEscapedChars > 0) {
                Unsafe.getUnsafe().putByte(this.bufAt - (long)this.nEscapedChars, b);
            }
            ++this.bufAt;
        }
        return ParseResult.BUFFER_UNDERFLOW;
    }

    public void startNextMeasurement() {
        ++this.bufAt;
        this.nEscapedChars = 0;
        this.entityLo = this.bufAt;
        this.errorCode = null;
        this.tagsComplete = false;
        this.nEntities = 0;
        this.currentEntity = null;
        this.entityHandler = this.entityTableHandler;
        this.timestamp = Long.MIN_VALUE;
    }

    public ParseResult skipMeasurement(long bufHi) {
        assert (this.bufAt != 0L && bufHi >= this.bufAt);
        while (this.bufAt < bufHi) {
            byte b = Unsafe.getUnsafe().getByte(this.bufAt);
            if (b == 10 || b == 13) {
                return ParseResult.MEASUREMENT_COMPLETE;
            }
            ++this.bufAt;
        }
        return ParseResult.BUFFER_UNDERFLOW;
    }

    public long getBufferAddress() {
        return this.bufAt;
    }

    public DirectByteCharSequence getMeasurementName() {
        return this.measurementName;
    }

    public int getnEntities() {
        return this.nEntities;
    }

    public ProtoEntity getEntity(int n) {
        assert (n < this.nEntities);
        return this.entityCache.get(n);
    }

    public boolean hasTimestamp() {
        return this.timestamp != Long.MIN_VALUE;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void clear() {
        this.bufAt = 0L;
    }

    @Override
    public void close() {
    }

    private boolean expectTableName(byte endOfEntityByte) {
        boolean bl = this.tagsComplete = endOfEntityByte == 32;
        if (endOfEntityByte == 44 || this.tagsComplete) {
            this.measurementName.of(this.entityLo, this.bufAt);
            this.entityHandler = this.entityNameHandler;
            return true;
        }
        this.errorCode = this.entityLo == this.bufAt ? ErrorCode.EMPTY_LINE : ErrorCode.NO_FIELDS;
        return false;
    }

    private boolean expectEntityName(byte endOfEntityByte) {
        boolean emptyEntity;
        if (endOfEntityByte == 61) {
            if (this.entityCache.size() <= this.nEntities) {
                this.currentEntity = new ProtoEntity();
                this.entityCache.add(this.currentEntity);
            } else {
                this.currentEntity = this.entityCache.get(this.nEntities);
                this.currentEntity.clear();
            }
            ++this.nEntities;
            this.currentEntity.setName();
            this.entityHandler = this.entityValueHandler;
            return true;
        }
        boolean bl = emptyEntity = this.bufAt == this.entityLo;
        if (emptyEntity) {
            if (endOfEntityByte == 32) {
                if (this.tagsComplete) {
                    this.entityHandler = this.entityTimestampHandler;
                } else {
                    this.tagsComplete = true;
                }
                return true;
            }
            if (endOfEntityByte == 10) {
                return true;
            }
        }
        this.errorCode = this.tagsComplete ? ErrorCode.INCOMPLETE_FIELD : ErrorCode.INCOMPLETE_TAG;
        return false;
    }

    private boolean expectEntityValue(byte endOfEntityByte) {
        boolean endOfSet;
        boolean bl = endOfSet = endOfEntityByte == 32;
        if (endOfSet || endOfEntityByte == 44 || endOfEntityByte == 10) {
            if (this.currentEntity.setValue()) {
                if (endOfSet) {
                    if (this.tagsComplete) {
                        this.entityHandler = this.entityTimestampHandler;
                    } else {
                        this.entityHandler = this.entityNameHandler;
                        this.tagsComplete = true;
                    }
                } else {
                    this.entityHandler = this.entityNameHandler;
                }
                return true;
            }
            this.errorCode = ErrorCode.INVALID_FIELD_VALUE;
            return false;
        }
        this.errorCode = ErrorCode.INVALID_FIELD_SEPERATOR;
        return false;
    }

    private boolean expectTimestamp(byte endOfEntityByte) {
        try {
            if (endOfEntityByte == 10) {
                this.timestamp = Numbers.parseLong(this.charSeq.of(this.entityLo, this.bufAt - (long)this.nEscapedChars));
                this.entityHandler = null;
                return true;
            }
            this.errorCode = ErrorCode.INVALID_FIELD_SEPERATOR;
            return false;
        }
        catch (NumericException ex) {
            this.errorCode = ErrorCode.INVALID_TIMESTAMP;
            return false;
        }
    }

    private boolean expectEndoOfLine(byte endOfEntityByte) {
        assert (endOfEntityByte == 10);
        return true;
    }

    public class ProtoEntity {
        private final DirectByteCharSequence name = new DirectByteCharSequence();
        private final DirectByteCharSequence value = new DirectByteCharSequence();
        private byte type = (byte)-1;
        private long integerValue;
        private boolean booleanValue;
        private double floatValue;

        private void setName() {
            this.name.of(NewLineProtoParser.this.entityLo, NewLineProtoParser.this.bufAt - (long)NewLineProtoParser.this.nEscapedChars);
        }

        private boolean setValue() {
            assert (this.type == -1);
            long bufHi = NewLineProtoParser.this.bufAt - (long)NewLineProtoParser.this.nEscapedChars;
            int valueLen = (int)(bufHi - NewLineProtoParser.this.entityLo);
            if (valueLen <= 0) {
                return false;
            }
            this.value.of(NewLineProtoParser.this.entityLo, bufHi);
            if (NewLineProtoParser.this.tagsComplete) {
                byte lastByte = this.value.byteAt(valueLen - 1);
                return this.parse(lastByte, valueLen);
            }
            this.type = 0;
            return true;
        }

        private boolean parse(byte lastByte, int valueLen) {
            try {
                switch (lastByte) {
                    case 105: {
                        if (valueLen > 1 && this.value.charAt(1) != 'x') {
                            NewLineProtoParser.this.charSeq.of(this.value.getLo(), this.value.getHi() - 1L);
                            this.integerValue = Numbers.parseLong(NewLineProtoParser.this.charSeq);
                            this.type = (byte)2;
                        } else {
                            if (valueLen < 4 || this.value.charAt(0) != '0') {
                                return false;
                            }
                            this.value.of(this.value.getLo(), this.value.getHi() - 1L);
                            this.type = (byte)5;
                        }
                        return true;
                    }
                    case 101: {
                        byte b = this.value.byteAt(0);
                        this.booleanValue = b == 116 || b == 84;
                        this.type = (byte)4;
                        return true;
                    }
                    case 84: 
                    case 116: {
                        this.booleanValue = true;
                        this.type = (byte)4;
                        return true;
                    }
                    case 70: 
                    case 102: {
                        this.booleanValue = false;
                        this.type = (byte)4;
                        return true;
                    }
                    case 34: {
                        byte b = this.value.byteAt(0);
                        if (valueLen > 1 && b == 34) {
                            this.value.of(this.value.getLo() + 1L, this.value.getHi() - 1L);
                            this.type = (byte)3;
                            return true;
                        }
                        return false;
                    }
                }
                this.floatValue = Numbers.parseDouble(this.value);
                this.type = 1;
                return true;
            }
            catch (NumericException ex) {
                return false;
            }
        }

        private void clear() {
            this.type = (byte)-1;
        }

        public byte getType() {
            return this.type;
        }

        public DirectByteCharSequence getName() {
            return this.name;
        }

        public DirectByteCharSequence getValue() {
            return this.value;
        }

        public long getIntegerValue() {
            return this.integerValue;
        }

        public double getFloatValue() {
            return this.floatValue;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }
    }

    private static interface EntityHandler {
        public boolean completeEntity(byte var1);
    }

    public static enum ErrorCode {
        EMPTY_LINE,
        NO_FIELDS,
        INCOMPLETE_TAG,
        INCOMPLETE_FIELD,
        INVALID_FIELD_SEPERATOR,
        INVALID_TIMESTAMP,
        INVALID_FIELD_VALUE;

    }

    public static enum ParseResult {
        MEASUREMENT_COMPLETE,
        BUFFER_UNDERFLOW,
        ERROR;

    }
}

