/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MappedReadOnlyMemory;
import io.questdb.cairo.vm.SinglePageMappedReadOnlyPageMemory;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjIntHashMap;
import io.questdb.std.str.Path;
import java.io.Closeable;

class SymbolCache
implements Closeable {
    private final ObjIntHashMap<CharSequence> indexBySym = new ObjIntHashMap(256, 0.5, -2);
    private final MappedReadOnlyMemory txMem = new SinglePageMappedReadOnlyPageMemory();
    private final SymbolMapReaderImpl symMapReader = new SymbolMapReaderImpl();
    private long transientSymCountOffset;

    SymbolCache() {
    }

    void of(CairoConfiguration configuration, Path path, CharSequence name, int symIndex) {
        FilesFacade ff = configuration.getFilesFacade();
        this.transientSymCountOffset = TableUtils.getSymbolWriterTransientIndexOffset(symIndex);
        int plen = path.length();
        this.txMem.of(ff, path.concat("_txn").$(), ff.getPageSize(), this.transientSymCountOffset + 4L);
        int symCount = this.txMem.getInt(this.transientSymCountOffset);
        path.trimTo(plen);
        this.symMapReader.of(configuration, path, name, symCount);
        this.indexBySym.clear(symCount);
    }

    int getSymIndex(CharSequence symValue) {
        int symIndex = this.indexBySym.get(symValue);
        if (-2 != symIndex) {
            return symIndex;
        }
        int symCount = this.txMem.getInt(this.transientSymCountOffset);
        this.symMapReader.updateSymbolCount(symCount);
        symIndex = this.symMapReader.keyOf(symValue);
        if (-2 != symIndex) {
            this.indexBySym.put(symValue.toString(), symIndex);
        }
        return symIndex;
    }

    int getNCached() {
        return this.indexBySym.size();
    }

    @Override
    public void close() {
        this.symMapReader.close();
        this.indexBySym.clear();
        this.txMem.close();
    }
}

