/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.sql.BindVariableService;
import io.questdb.griffin.SqlException;
import io.questdb.std.CleanClosable;
import io.questdb.std.IntList;
import io.questdb.std.WeakAutoClosableObjectPool;

public abstract class AbstractTypeContainer<T extends CleanClosable>
implements CleanClosable {
    protected final IntList types = new IntList();
    protected final WeakAutoClosableObjectPool<T> parentPool;

    public AbstractTypeContainer(WeakAutoClosableObjectPool<T> parentPool) {
        this.parentPool = parentPool;
    }

    @Override
    public void close() {
        this.getTypes().clear();
        this.parentPool.push(this);
    }

    public void defineBindVariables(BindVariableService bindVariableService) throws SqlException {
        int n = this.types.size();
        for (int i = 0; i < n; ++i) {
            bindVariableService.define(i, this.types.getQuick(i), 0);
        }
    }

    public IntList getTypes() {
        return this.types;
    }

    protected void copyTypesFrom(BindVariableService bindVariableService) {
        int n = bindVariableService.getIndexedVariableCount();
        for (int i = 0; i < n; ++i) {
            this.getTypes().add(bindVariableService.getFunction(i).getType());
        }
    }
}

