/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.network.DefaultIODispatcherConfiguration;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.millitime.DateFormatUtils;

public class DefaultPGWireConfiguration
implements PGWireConfiguration {
    private final IODispatcherConfiguration ioDispatcherConfiguration = new DefaultIODispatcherConfiguration(){

        @Override
        public int getBindPort() {
            return 8812;
        }

        @Override
        public String getDispatcherLogName() {
            return "pg-server";
        }
    };
    private final int[] workerAffinity = new int[]{-1};

    @Override
    public int getCharacterStoreCapacity() {
        return 4096;
    }

    @Override
    public int getCharacterStorePoolCapacity() {
        return 64;
    }

    @Override
    public int getConnectionPoolInitialCapacity() {
        return 64;
    }

    @Override
    public IODispatcherConfiguration getDispatcherConfiguration() {
        return this.ioDispatcherConfiguration;
    }

    @Override
    public String getServerVersion() {
        return "11.3";
    }

    @Override
    public int getFactoryCacheColumnCount() {
        return 16;
    }

    @Override
    public int getFactoryCacheRowCount() {
        return 16;
    }

    @Override
    public int getIdleRecvCountBeforeGivingUp() {
        return 10000;
    }

    @Override
    public NetworkFacade getNetworkFacade() {
        return NetworkFacadeImpl.INSTANCE;
    }

    @Override
    public int getRecvBufferSize() {
        return 0x100000;
    }

    @Override
    public int getSendBufferSize() {
        return 0x100000;
    }

    @Override
    public int getIdleSendCountBeforeGivingUp() {
        return 10000;
    }

    @Override
    public int getMaxBlobSizeOnQuery() {
        return 524288;
    }

    @Override
    public int[] getWorkerAffinity() {
        return this.workerAffinity;
    }

    @Override
    public int getWorkerCount() {
        return 1;
    }

    @Override
    public boolean haltOnError() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getDefaultPassword() {
        return "quest";
    }

    @Override
    public String getDefaultUsername() {
        return "admin";
    }

    @Override
    public DateLocale getDefaultDateLocale() {
        return DateFormatUtils.enLocale;
    }

    @Override
    public int getInsertCacheBlockCount() {
        return 8;
    }

    @Override
    public int getInsertCacheRowCount() {
        return 8;
    }

    @Override
    public int getInsertPoolCapacity() {
        return 32;
    }

    @Override
    public int getNamedStatementCacheCapacity() {
        return 32;
    }

    @Override
    public int getNamesStatementPoolCapacity() {
        return 32;
    }

    @Override
    public int getPendingWritersCacheSize() {
        return 16;
    }
}

