/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.pgwire.BadProtocolException;
import io.questdb.cutlass.pgwire.PGAuthenticator;
import io.questdb.cutlass.pgwire.PGBasicAuthenticator;
import io.questdb.cutlass.pgwire.PGOids;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.pgwire.TypesAndInsert;
import io.questdb.cutlass.pgwire.TypesAndSelect;
import io.questdb.cutlass.text.TextLoader;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.bind.BindVariableServiceImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.IOContext;
import io.questdb.network.IODispatcher;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.BinarySequence;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Rnd;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.WeakAutoClosableObjectPool;
import io.questdb.std.WeakObjectPool;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StdoutSink;
import org.jetbrains.annotations.Nullable;

public class PGConnectionContext
implements IOContext,
Mutable,
WriterSource {
    public static final String TAG_SET = "SET";
    public static final String TAG_BEGIN = "BEGIN";
    public static final String TAG_COMMIT = "COMMIT";
    public static final String TAG_ROLLBACK = "ROLLBACK";
    public static final String TAG_SELECT = "SELECT";
    public static final String TAG_OK = "OK";
    public static final String TAG_COPY = "COPY";
    public static final String TAG_INSERT = "INSERT";
    public static final char STATUS_IN_TRANSACTION = 'T';
    public static final char STATUS_IN_ERROR = 'E';
    public static final char STATUS_IDLE = 'I';
    private static final int INT_BYTES_X = Numbers.bswap(4);
    private static final int INT_NULL_X = Numbers.bswap(-1);
    private static final int SYNC_PARSE = 1;
    private static final int SYNC_DESCRIBE = 2;
    private static final int SYNC_BIND = 3;
    private static final int SYNC_DESCRIBE_PORTAL = 4;
    private static final byte MESSAGE_TYPE_ERROR_RESPONSE = 69;
    private static final int INIT_SSL_REQUEST = 80877103;
    private static final int INIT_STARTUP_MESSAGE = 196608;
    private static final int INIT_CANCEL_REQUEST = 80877102;
    private static final byte MESSAGE_TYPE_COMMAND_COMPLETE = 67;
    private static final byte MESSAGE_TYPE_EMPTY_QUERY = 73;
    private static final byte MESSAGE_TYPE_DATA_ROW = 68;
    private static final byte MESSAGE_TYPE_READY_FOR_QUERY = 90;
    private static final Log LOG = LogFactory.getLog(PGConnectionContext.class);
    private static final int PREFIXED_MESSAGE_HEADER_LEN = 5;
    private static final byte MESSAGE_TYPE_LOGIN_RESPONSE = 82;
    private static final byte MESSAGE_TYPE_PARAMETER_STATUS = 83;
    private static final byte MESSAGE_TYPE_ROW_DESCRIPTION = 84;
    private static final byte MESSAGE_TYPE_PARAMETER_DESCRIPTION = 116;
    private static final byte MESSAGE_TYPE_PARSE_COMPLETE = 49;
    private static final byte MESSAGE_TYPE_BIND_COMPLETE = 50;
    private static final byte MESSAGE_TYPE_CLOSE_COMPLETE = 51;
    private static final byte MESSAGE_TYPE_NO_DATA = 110;
    private static final byte MESSAGE_TYPE_COPY_IN_RESPONSE = 71;
    private static final byte MESSAGE_TYPE_PORTAL_SUSPENDED = 115;
    private static final int NO_TRANSACTION = 0;
    private static final int IN_TRANSACTION = 1;
    private static final int COMMIT_TRANSACTION = 2;
    private static final int ERROR_TRANSACTION = 3;
    private static final int ROLLING_BACK_TRANSACTION = 4;
    private final long recvBuffer;
    private final long sendBuffer;
    private final int recvBufferSize;
    private final CharacterStore characterStore;
    private final BindVariableService bindVariableService;
    private final long sendBufferLimit;
    private final int sendBufferSize;
    private final ResponseAsciiSink responseAsciiSink = new ResponseAsciiSink();
    private final DirectByteCharSequence dbcs = new DirectByteCharSequence();
    private final int maxBlobSizeOnQuery;
    private final NetworkFacade nf;
    private final boolean dumpNetworkTraffic;
    private final int idleSendCountBeforeGivingUp;
    private final int idleRecvCountBeforeGivingUp;
    private final String serverVersion;
    private final PGAuthenticator authenticator;
    private final SqlExecutionContextImpl sqlExecutionContext;
    private final Path path = new Path();
    private final IntList bindVariableTypes = new IntList();
    private final IntList selectColumnTypes = new IntList();
    private final WeakObjectPool<NamedStatementWrapper> namedStatementWrapperPool;
    private final WeakObjectPool<Portal> namedPortalPool;
    private final WeakAutoClosableObjectPool<TypesAndInsert> typesAndInsertPool;
    private final DateLocale locale;
    private final CharSequenceObjHashMap<TableWriter> pendingWriters;
    private final DirectCharSink utf8Sink;
    private final TypeManager typeManager;
    private final AssociativeCache<TypesAndInsert> typesAndInsertCache;
    private final CharSequenceObjHashMap<NamedStatementWrapper> namedStatementMap;
    private final CharSequenceObjHashMap<Portal> namedPortalMap;
    private final IntList syncActions = new IntList(4);
    private final CairoEngine engine;
    private IntList activeSelectColumnTypes;
    private int parsePhaseBindVariableCount;
    private long sendBufferPtr;
    private boolean requireInitialMessage = false;
    private long recvBufferWriteOffset = 0L;
    private long recvBufferReadOffset = 0L;
    private int bufferRemainingOffset = 0;
    private int bufferRemainingSize = 0;
    private RecordCursor currentCursor = null;
    private RecordCursorFactory currentFactory = null;
    private TypesAndSelect typesAndSelect = null;
    private TypesAndInsert typesAndInsert = null;
    private long fd;
    private CharSequence queryText;
    private CharSequence queryTag;
    private CharSequence username;
    private boolean authenticationRequired = true;
    private IODispatcher<PGConnectionContext> dispatcher;
    private Rnd rnd;
    private long rowCount;
    private boolean completed = true;
    private boolean isEmptyQuery;
    private int transactionState = 0;
    private NamedStatementWrapper wrapper;
    private AssociativeCache<TypesAndSelect> typesAndSelectCache;
    private WeakAutoClosableObjectPool<TypesAndSelect> typesAndSelectPool;
    private IntList activeBindVariableTypes;
    private boolean sendParameterDescription;
    private PGResumeProcessor resumeProcessor;
    private final PGResumeProcessor resumeCursorRef = this::resumeCursor;
    private long maxRows;

    public PGConnectionContext(CairoEngine engine, PGWireConfiguration configuration, @Nullable MessageBus messageBus, int workerCount) {
        this.engine = engine;
        this.utf8Sink = new DirectCharSink(engine.getConfiguration().getTextConfiguration().getUtf8SinkSize());
        this.typeManager = new TypeManager(engine.getConfiguration().getTextConfiguration(), this.utf8Sink);
        this.nf = configuration.getNetworkFacade();
        this.bindVariableService = new BindVariableServiceImpl(engine.getConfiguration());
        this.recvBufferSize = Numbers.ceilPow2(configuration.getRecvBufferSize());
        this.recvBuffer = Unsafe.malloc(this.recvBufferSize);
        this.sendBufferSize = Numbers.ceilPow2(configuration.getSendBufferSize());
        this.sendBufferPtr = this.sendBuffer = Unsafe.malloc(this.sendBufferSize);
        this.sendBufferLimit = this.sendBuffer + (long)this.sendBufferSize;
        this.characterStore = new CharacterStore(configuration.getCharacterStoreCapacity(), configuration.getCharacterStorePoolCapacity());
        this.maxBlobSizeOnQuery = configuration.getMaxBlobSizeOnQuery();
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
        this.idleSendCountBeforeGivingUp = configuration.getIdleSendCountBeforeGivingUp();
        this.idleRecvCountBeforeGivingUp = configuration.getIdleRecvCountBeforeGivingUp();
        this.serverVersion = configuration.getServerVersion();
        this.authenticator = new PGBasicAuthenticator(configuration.getDefaultUsername(), configuration.getDefaultPassword());
        this.locale = configuration.getDefaultDateLocale();
        this.sqlExecutionContext = new SqlExecutionContextImpl(engine, workerCount, messageBus);
        this.rnd = configuration.getRandom();
        this.sqlExecutionContext.setRandom(this.rnd);
        this.namedStatementWrapperPool = new WeakObjectPool<NamedStatementWrapper>(NamedStatementWrapper::new, configuration.getNamesStatementPoolCapacity());
        this.namedPortalPool = new WeakObjectPool<Portal>(Portal::new, configuration.getNamesStatementPoolCapacity());
        this.typesAndInsertPool = new WeakAutoClosableObjectPool<TypesAndInsert>(TypesAndInsert::new, configuration.getInsertPoolCapacity());
        this.typesAndInsertCache = new AssociativeCache(configuration.getInsertCacheBlockCount(), configuration.getInsertCacheRowCount());
        this.namedStatementMap = new CharSequenceObjHashMap(configuration.getNamedStatementCacheCapacity());
        this.pendingWriters = new CharSequenceObjHashMap(configuration.getPendingWritersCacheSize());
        this.namedPortalMap = new CharSequenceObjHashMap(configuration.getNamedStatementCacheCapacity());
    }

    public static int getInt(long address, long msgLimit, CharSequence errorMessage) throws BadProtocolException {
        if (address + 4L <= msgLimit) {
            return PGConnectionContext.getIntUnsafe(address);
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    public static long getLongUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getLong(address));
    }

    public static short getShort(long address, long msgLimit, CharSequence errorMessage) throws BadProtocolException {
        if (address + 2L <= msgLimit) {
            return PGConnectionContext.getShortUnsafe(address);
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    public static long getStringLength(long x, long limit, CharSequence errorMessage) throws BadProtocolException {
        long len;
        long l = len = Unsafe.getUnsafe().getByte(x) == 0 ? x : PGConnectionContext.getStringLengthTedious(x, limit);
        if (len > -1L) {
            return len;
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    public static long getStringLengthTedious(long x, long limit) {
        for (long i = x; i < limit; ++i) {
            if (Unsafe.getUnsafe().getByte(i) != 0) continue;
            return i;
        }
        return -1L;
    }

    public static void putInt(long address, int value) {
        Unsafe.getUnsafe().putInt(address, Numbers.bswap(value));
    }

    public static void putLong(long address, long value) {
        Unsafe.getUnsafe().putLong(address, Numbers.bswap(value));
    }

    public static void putShort(long address, short value) {
        Unsafe.getUnsafe().putShort(address, Numbers.bswap(value));
    }

    @Override
    public void clear() {
        this.sendBufferPtr = this.sendBuffer;
        this.requireInitialMessage = true;
        this.bufferRemainingOffset = 0;
        this.bufferRemainingSize = 0;
        this.responseAsciiSink.reset();
        this.prepareForNewQuery();
        this.authenticationRequired = true;
        this.username = null;
        this.typeManager.clear();
        this.clearWriters();
        this.clearRecvBuffer();
        this.typesAndInsertCache.clear();
        this.namedStatementMap.clear();
        this.namedPortalMap.clear();
        this.bindVariableService.clear();
        this.bindVariableTypes.clear();
    }

    public void clearWriters() {
        int n = this.pendingWriters.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.pendingWriters.valueQuick(i));
        }
        this.pendingWriters.clear();
    }

    @Override
    public void close() {
        this.clear();
        this.fd = -1L;
        this.sqlExecutionContext.with(AllowAllCairoSecurityContext.INSTANCE, null, null, -1L, null);
        Unsafe.free(this.sendBuffer, this.sendBufferSize);
        Unsafe.free(this.recvBuffer, this.recvBufferSize);
        Misc.free(this.typesAndSelectCache);
        Misc.free(this.path);
        Misc.free(this.utf8Sink);
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public boolean invalid() {
        return this.fd == -1L;
    }

    public IODispatcher<PGConnectionContext> getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public TableWriter getWriter(CairoSecurityContext context, CharSequence name) {
        int index = this.pendingWriters.keyIndex(name);
        if (index < 0) {
            return this.pendingWriters.valueAt(index);
        }
        return this.engine.getWriter(context, name);
    }

    public void handleClientOperation(SqlCompiler compiler, AssociativeCache<TypesAndSelect> selectAndTypesCache, WeakAutoClosableObjectPool<TypesAndSelect> selectAndTypesPool, int operation) throws PeerDisconnectedException, PeerIsSlowToReadException, PeerIsSlowToWriteException, BadProtocolException {
        this.typesAndSelectCache = selectAndTypesCache;
        this.typesAndSelectPool = selectAndTypesPool;
        try {
            if (this.bufferRemainingSize > 0) {
                this.doSend(this.bufferRemainingOffset, this.bufferRemainingSize);
                if (this.resumeProcessor != null) {
                    this.resumeProcessor.resume();
                }
            }
            boolean keepReceiving = true;
            block3: do {
                if (operation == 1 && this.recv() == 0) {
                    keepReceiving = false;
                }
                if (!keepReceiving) continue;
                do {
                    long readOffsetBeforeParse = this.recvBufferReadOffset;
                    this.parse(this.recvBuffer + this.recvBufferReadOffset, (int)(this.recvBufferWriteOffset - this.recvBufferReadOffset), compiler);
                    if (readOffsetBeforeParse != this.recvBufferReadOffset) continue;
                    if (readOffsetBeforeParse <= 0L) continue block3;
                    this.shiftReceiveBuffer(readOffsetBeforeParse);
                    continue block3;
                } while (this.recvBufferReadOffset < this.recvBufferWriteOffset);
                this.clearRecvBuffer();
            } while (keepReceiving && operation == 1);
        }
        catch (SqlException e) {
            this.reportError(e.getPosition(), e.getFlyweightMessage());
        }
        catch (CairoException e) {
            this.reportError(-1, e.getFlyweightMessage());
        }
    }

    public PGConnectionContext of(long clientFd, IODispatcher<PGConnectionContext> dispatcher) {
        this.fd = clientFd;
        this.sqlExecutionContext.with(clientFd);
        this.dispatcher = dispatcher;
        this.clear();
        return this;
    }

    public void setBooleanBindVariable(int index, int valueLen) throws SqlException {
        if (valueLen != 4 && valueLen != 5) {
            throw SqlException.$(0, "bad value for BOOLEAN parameter [index=").put(index).put(", valueLen=").put(valueLen).put(']');
        }
        this.bindVariableService.setBoolean(index, valueLen == 4);
    }

    public void setCharBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (!Chars.utf8Decode(address, address + (long)valueLen, e)) {
            LOG.error().$("invalid char UTF8 bytes [index=").$(index).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.bindVariableService.setChar(index, this.characterStore.toImmutable().charAt(0));
    }

    public void setDateBindVariable(int index, long address, int valueLen) throws SqlException {
        this.dbcs.of(address, address + (long)valueLen);
        try {
            this.bindVariableService.setDate(index, DateFormatUtils.PG_DATE_Z_FORMAT.parse(this.dbcs, this.locale));
        }
        catch (NumericException ex) {
            throw SqlException.$(0, "bad parameter value [index=").put(index).put(", value=").put(this.dbcs).put(']');
        }
    }

    public void setDoubleBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 8, valueLen);
        this.bindVariableService.setDouble(index, Double.longBitsToDouble(PGConnectionContext.getLongUnsafe(address)));
    }

    public void setFloatBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 4, valueLen);
        this.bindVariableService.setFloat(index, Float.intBitsToFloat(PGConnectionContext.getIntUnsafe(address)));
    }

    public void setIntBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 4, valueLen);
        this.bindVariableService.setInt(index, PGConnectionContext.getIntUnsafe(address));
    }

    public void setLongBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 8, valueLen);
        this.bindVariableService.setLong(index, PGConnectionContext.getLongUnsafe(address));
    }

    public void setShortBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 2, valueLen);
        this.bindVariableService.setShort(index, PGConnectionContext.getShortUnsafe(address));
    }

    public void setStrBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (!Chars.utf8Decode(address, address + (long)valueLen, e)) {
            LOG.error().$("invalid str UTF8 bytes [index=").$(index).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.bindVariableService.setStr(index, this.characterStore.toImmutable());
    }

    public void setTimestampBindVariable(int index, long address, int valueLen) throws BadProtocolException, SqlException {
        PGConnectionContext.ensureValueLength(index, 8, valueLen);
        this.bindVariableService.setTimestamp(index, PGConnectionContext.getLongUnsafe(address) + 946684800000000L);
    }

    private static int getIntUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getInt(address));
    }

    private static short getShortUnsafe(long address) {
        return Numbers.bswap(Unsafe.getUnsafe().getShort(address));
    }

    private static void ensureValueLength(int index, int required, int actual) throws BadProtocolException {
        if (required == actual) {
            return;
        }
        LOG.error().$("bad parameter value length [required=").$(required).$(", actual=").$(actual).$(", index=").$(index).I$();
        throw BadProtocolException.INSTANCE;
    }

    private static void prepareParams(ResponseAsciiSink sink, String name, String value) {
        sink.put((byte)83);
        long addr = sink.skip();
        sink.encodeUtf8Z(name);
        sink.encodeUtf8Z(value);
        sink.putLen(addr);
    }

    private static void bindParameterFormats(long lo, long msgLimit, short parameterFormatCount, IntList bindVariableTypes) throws BadProtocolException {
        if (lo + (long)(2 * parameterFormatCount) <= msgLimit) {
            LOG.debug().$("processing bind formats [count=").$(parameterFormatCount).$(']').$();
            for (int i = 0; i < parameterFormatCount; ++i) {
                short code = PGConnectionContext.getShortUnsafe(lo + (long)(i * 2));
                bindVariableTypes.setQuick(i, PGOids.toParamBinaryType(code, bindVariableTypes.getQuick(i)));
            }
        } else {
            LOG.error().$("invalid format code count [value=").$(parameterFormatCount).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
    }

    private static void setupBindVariables(long lo, IntList bindVariableTypes, int count) {
        bindVariableTypes.setPos(count);
        for (int i = 0; i < count; ++i) {
            bindVariableTypes.setQuick(i, Unsafe.getUnsafe().getInt(lo + (long)i * 4L));
        }
    }

    private static void bindSingleFormatForAll(long lo, long msgLimit, IntList activeBindVariableTypes) throws BadProtocolException {
        short code = PGConnectionContext.getShort(lo, msgLimit, "could not read parameter formats");
        int n = activeBindVariableTypes.size();
        for (int i = 0; i < n; ++i) {
            activeBindVariableTypes.setQuick(i, PGOids.toParamBinaryType(code, activeBindVariableTypes.getQuick(i)));
        }
    }

    private void appendBinColumn(Record record, int i) throws SqlException {
        BinarySequence sequence = record.getBin(i);
        if (sequence == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long blobSize = sequence.length();
            if (blobSize < (long)this.maxBlobSizeOnQuery) {
                this.responseAsciiSink.put(sequence);
            } else {
                throw SqlException.position(0).put("blob is too large [blobSize=").put(blobSize).put(", max=").put(this.maxBlobSizeOnQuery).put(", columnIndex=").put(i).put(']');
            }
        }
    }

    private void appendBooleanColumn(Record record, int columnIndex) {
        this.responseAsciiSink.putNetworkInt(1);
        this.responseAsciiSink.put(record.getBool(columnIndex) ? (char)'t' : 'f');
    }

    private void appendByteColumn(Record record, int columnIndex) {
        long a = this.responseAsciiSink.skip();
        this.responseAsciiSink.put((int)record.getByte(columnIndex));
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendByteColumnBin(Record record, int columnIndex) {
        byte value = record.getByte(columnIndex);
        this.responseAsciiSink.putNetworkInt(2);
        this.responseAsciiSink.putNetworkShort(value);
    }

    private void appendCharColumn(Record record, int columnIndex) {
        long a = this.responseAsciiSink.skip();
        this.responseAsciiSink.putUtf8(record.getChar(columnIndex));
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendDateColumn(Record record, int columnIndex) {
        long longValue = record.getDate(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            long a = this.responseAsciiSink.skip();
            DateFormatUtils.PG_DATE_MILLI_TIME_Z_FORMAT.format(longValue, null, null, this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendDateColumnBin(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkLong(longValue * 1000L - 946684800000000L);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendDoubleColumn(Record record, int columnIndex) {
        double doubleValue = record.getDouble(columnIndex);
        if (doubleValue == doubleValue) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(doubleValue);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendDoubleColumnBin(Record record, int columnIndex) {
        double value = record.getDouble(columnIndex);
        if (value == value) {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkDouble(value);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendFloatColumn(Record record, int columnIndex) {
        float floatValue = record.getFloat(columnIndex);
        if (floatValue == floatValue) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(floatValue, 3);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendFloatColumnBin(Record record, int columnIndex) {
        float value = record.getFloat(columnIndex);
        if (value == value) {
            this.responseAsciiSink.putNetworkInt(4);
            this.responseAsciiSink.putNetworkFloat(value);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendIntCol(Record record, int i) {
        int intValue = record.getInt(i);
        if (intValue != Integer.MIN_VALUE) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(intValue);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendIntColumnBin(Record record, int columnIndex) {
        int value = record.getInt(columnIndex);
        if (value != Integer.MIN_VALUE) {
            this.responseAsciiSink.ensureCapacity(8);
            this.responseAsciiSink.putIntUnsafe(0L, INT_BYTES_X);
            this.responseAsciiSink.putIntUnsafe(4L, Numbers.bswap(value));
            this.responseAsciiSink.bump(8);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendLong256Column(Record record, int columnIndex) {
        Long256 long256Value = record.getLong256A(columnIndex);
        long a = this.responseAsciiSink.skip();
        Numbers.appendLong256(long256Value.getLong0(), long256Value.getLong1(), long256Value.getLong2(), long256Value.getLong3(), this.responseAsciiSink);
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendLongColumn(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.put(longValue);
            this.responseAsciiSink.putLenEx(a);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendLongColumnBin(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue != Long.MIN_VALUE) {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkLong(longValue);
        } else {
            this.responseAsciiSink.setNullValue();
        }
    }

    private void appendRecord(Record record, int columnCount) throws SqlException {
        this.responseAsciiSink.put((byte)68);
        long offset = this.responseAsciiSink.skip();
        this.responseAsciiSink.putNetworkShort((short)columnCount);
        block24: for (int i = 0; i < columnCount; ++i) {
            switch (this.activeSelectColumnTypes.getQuick(i)) {
                case -2147483644: {
                    this.appendIntColumnBin(record, i);
                    continue block24;
                }
                case 4: {
                    this.appendIntCol(record, i);
                    continue block24;
                }
                case -2147483638: 
                case 10: {
                    this.appendStrColumn(record, i);
                    continue block24;
                }
                case -2147483637: 
                case 11: {
                    this.appendSymbolColumn(record, i);
                    continue block24;
                }
                case -2147483643: {
                    this.appendLongColumnBin(record, i);
                    continue block24;
                }
                case 5: {
                    this.appendLongColumn(record, i);
                    continue block24;
                }
                case 2: {
                    this.appendShortColumn(record, i);
                    continue block24;
                }
                case -2147483639: {
                    this.appendDoubleColumnBin(record, i);
                    continue block24;
                }
                case 9: {
                    this.appendDoubleColumn(record, i);
                    continue block24;
                }
                case -2147483640: {
                    this.appendFloatColumnBin(record, i);
                    continue block24;
                }
                case -2147483646: {
                    this.appendShortColumnBin(record, i);
                    continue block24;
                }
                case -2147483642: {
                    this.appendDateColumnBin(record, i);
                    continue block24;
                }
                case -2147483641: {
                    this.appendTimestampColumnBin(record, i);
                    continue block24;
                }
                case -2147483647: {
                    this.appendByteColumnBin(record, i);
                    continue block24;
                }
                case 8: {
                    this.appendFloatColumn(record, i);
                    continue block24;
                }
                case 7: {
                    this.appendTimestampColumn(record, i);
                    continue block24;
                }
                case 6: {
                    this.appendDateColumn(record, i);
                    continue block24;
                }
                case -2147483648: 
                case 0: {
                    this.appendBooleanColumn(record, i);
                    continue block24;
                }
                case 1: {
                    this.appendByteColumn(record, i);
                    continue block24;
                }
                case -2147483635: 
                case 13: {
                    this.appendBinColumn(record, i);
                    continue block24;
                }
                case -2147483645: 
                case 3: {
                    this.appendCharColumn(record, i);
                    continue block24;
                }
                case -2147483636: 
                case 12: {
                    this.appendLong256Column(record, i);
                    continue block24;
                }
                default: {
                    assert (false);
                    continue block24;
                }
            }
        }
        this.responseAsciiSink.putLen(offset);
    }

    private void appendShortColumn(Record record, int columnIndex) {
        long a = this.responseAsciiSink.skip();
        this.responseAsciiSink.put(record.getShort(columnIndex));
        this.responseAsciiSink.putLenEx(a);
    }

    private void appendShortColumnBin(Record record, int columnIndex) {
        short value = record.getShort(columnIndex);
        this.responseAsciiSink.putNetworkInt(2);
        this.responseAsciiSink.putNetworkShort(value);
    }

    private void appendStrColumn(Record record, int columnIndex) {
        CharSequence strValue = record.getStr(columnIndex);
        if (strValue == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.encodeUtf8(strValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendSymbolColumn(Record record, int columnIndex) {
        CharSequence strValue = record.getSym(columnIndex);
        if (strValue == null) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            this.responseAsciiSink.encodeUtf8(strValue);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendTimestampColumn(Record record, int i) {
        long longValue = record.getTimestamp(i);
        if (longValue == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            long a = this.responseAsciiSink.skip();
            TimestampFormatUtils.PG_TIMESTAMP_FORMAT.format(longValue, null, null, this.responseAsciiSink);
            this.responseAsciiSink.putLenEx(a);
        }
    }

    private void appendTimestampColumnBin(Record record, int columnIndex) {
        long longValue = record.getLong(columnIndex);
        if (longValue == Long.MIN_VALUE) {
            this.responseAsciiSink.setNullValue();
        } else {
            this.responseAsciiSink.putNetworkInt(8);
            this.responseAsciiSink.putNetworkLong(longValue - 946684800000000L);
        }
    }

    private void assertTrue(boolean check, String message) throws BadProtocolException {
        if (check) {
            return;
        }
        LOG.error().$(message).$();
        throw BadProtocolException.INSTANCE;
    }

    private long bindValuesAsStrings(long lo, long msgLimit, short parameterValueCount) throws BadProtocolException, SqlException {
        for (int j = 0; j < parameterValueCount; ++j) {
            int valueLen = PGConnectionContext.getInt(lo, msgLimit, "malformed bind variable");
            if (valueLen != -1 && (lo += 4L) + (long)valueLen <= msgLimit) {
                this.setStrBindVariable(j, lo, valueLen);
                lo += (long)valueLen;
                continue;
            }
            if (valueLen == -1) continue;
            LOG.error().$("value length is outside of buffer [parameterIndex=").$(j).$(", valueLen=").$(valueLen).$(", messageRemaining=").$(msgLimit - lo).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        return lo;
    }

    private long bindValuesUsingSetters(long lo, long msgLimit, short parameterValueCount) throws BadProtocolException, SqlException {
        for (int j = 0; j < parameterValueCount; ++j) {
            int valueLen = PGConnectionContext.getInt(lo, msgLimit, "malformed bind variable");
            lo += 4L;
            if (valueLen == -1) continue;
            if (lo + (long)valueLen <= msgLimit) {
                switch (this.activeBindVariableTypes.getQuick(j)) {
                    case 0x17000001: {
                        this.setIntBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x14000001: {
                        this.setLongBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 1510211585: {
                        this.setTimestampBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x15000001: {
                        this.setShortBindVariable(j, lo, valueLen);
                        break;
                    }
                    case -1123942399: {
                        this.setDoubleBindVariable(j, lo, valueLen);
                        break;
                    }
                    case -1140719615: {
                        this.setFloatBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x12000001: {
                        this.setCharBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 973340673: {
                        this.setDateBindVariable(j, lo, valueLen);
                        break;
                    }
                    case 0x10000001: {
                        this.setBooleanBindVariable(j, valueLen);
                        break;
                    }
                    default: {
                        this.setStrBindVariable(j, lo, valueLen);
                    }
                }
                lo += (long)valueLen;
                continue;
            }
            LOG.error().$("value length is outside of buffer [parameterIndex=").$(j).$(", valueLen=").$(valueLen).$(", messageRemaining=").$(msgLimit - lo).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        return lo;
    }

    private void buildSelectColumnTypes() {
        RecordMetadata m = this.typesAndSelect.getFactory().getMetadata();
        int columnCount = m.getColumnCount();
        this.activeSelectColumnTypes.setPos(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.activeSelectColumnTypes.setQuick(i, m.getColumnType(i));
        }
    }

    void clearRecvBuffer() {
        this.recvBufferWriteOffset = 0L;
        this.recvBufferReadOffset = 0L;
    }

    private boolean compileQuery(SqlCompiler compiler) throws SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        block10: {
            block9: {
                if (this.queryText == null || this.queryText.length() <= 0) break block9;
                this.typesAndInsert = this.typesAndInsertCache.peek(this.queryText);
                if (this.typesAndInsert != null) {
                    this.typesAndInsert.defineBindVariables(this.bindVariableService);
                    this.queryTag = TAG_INSERT;
                    return false;
                }
                this.typesAndSelect = this.typesAndSelectCache.poll(this.queryText);
                if (this.typesAndSelect != null) {
                    this.bindVariableService.clear();
                    this.typesAndSelect.defineBindVariables(this.bindVariableService);
                    this.queryTag = TAG_SELECT;
                    return false;
                }
                CompiledQuery cc = compiler.compile(this.queryText, this.sqlExecutionContext);
                this.sqlExecutionContext.storeTelemetry(cc.getType(), (short)3);
                switch (cc.getType()) {
                    case 1: {
                        this.typesAndSelect = this.typesAndSelectPool.pop();
                        this.typesAndSelect.of(cc.getRecordCursorFactory(), this.bindVariableService);
                        this.queryTag = TAG_SELECT;
                        LOG.debug().$("cache select [sql=").$(this.queryText).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
                        break;
                    }
                    case 2: {
                        this.queryTag = TAG_INSERT;
                        this.typesAndInsert = this.typesAndInsertPool.pop();
                        this.typesAndInsert.of(cc.getInsertStatement(), this.bindVariableService);
                        if (this.bindVariableService.getIndexedVariableCount() > 0) {
                            LOG.debug().$("cache insert [sql=").$(this.queryText).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
                            this.typesAndInsertCache.put(this.queryText, this.typesAndInsert);
                            break;
                        }
                        break block10;
                    }
                    case 8: {
                        this.queryTag = TAG_COPY;
                        this.sendCopyInResponse(compiler.getEngine(), cc.getTextLoader());
                        break;
                    }
                    case 6: {
                        this.configureContextForSet();
                        break;
                    }
                    default: {
                        this.queryTag = TAG_OK;
                        break;
                    }
                }
                break block10;
            }
            this.isEmptyQuery = true;
        }
        return true;
    }

    private void configureContextForSet() {
        if (SqlKeywords.isBegin(this.queryText)) {
            this.queryTag = TAG_BEGIN;
            this.transactionState = 1;
        } else if (SqlKeywords.isCommit(this.queryText)) {
            this.queryTag = TAG_COMMIT;
            if (this.transactionState != 3) {
                this.transactionState = 2;
            }
        } else if (SqlKeywords.isRollback(this.queryText)) {
            this.queryTag = TAG_ROLLBACK;
            this.transactionState = 4;
        } else {
            this.queryTag = TAG_SET;
        }
    }

    private void configureContextFromNamedStatement(CharSequence statementName, @Nullable SqlCompiler compiler) throws BadProtocolException, SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        boolean bl = this.sendParameterDescription = statementName != null;
        if (this.wrapper != null) {
            LOG.debug().$("reusing existing wrapper").$();
            return;
        }
        if (statementName != null) {
            LOG.debug().$("named statement [name=").$(statementName).$(']').$();
            this.wrapper = this.namedStatementMap.get(statementName);
            if (this.wrapper != null) {
                this.setupVariableSettersFromWrapper(this.wrapper, compiler);
            } else {
                LOG.error().$("statement does not exist [name=").$(statementName).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    private void configurePortal(CharSequence portalName, CharSequence statementName) throws BadProtocolException {
        int index = this.namedPortalMap.keyIndex(portalName);
        if (index <= -1) {
            LOG.error().$("duplicate portal [name=").$(portalName).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        Portal portal = this.namedPortalPool.pop();
        portal.statementName = statementName;
        this.namedPortalMap.putAt(index, Chars.toString(portalName), portal);
    }

    private void configurePreparedStatement(CharSequence statementName) throws BadProtocolException {
        int index = this.namedStatementMap.keyIndex(statementName);
        if (index <= -1) {
            LOG.error().$("duplicate statement [name=").$(statementName).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        this.wrapper = this.namedStatementWrapperPool.pop();
        this.wrapper.queryText = Chars.toString(this.queryText);
        this.wrapper.tag = this.queryTag;
        this.namedStatementMap.putAt(index, Chars.toString(statementName), this.wrapper);
        this.activeBindVariableTypes = this.wrapper.bindVariableTypes;
        this.activeSelectColumnTypes = this.wrapper.selectColumnTypes;
    }

    private void doAuthentication(long msgLo, long msgLimit) throws BadProtocolException, PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        CairoSecurityContext cairoSecurityContext = this.authenticator.authenticate(this.username, msgLo, msgLimit);
        if (cairoSecurityContext != null) {
            this.sqlExecutionContext.with(cairoSecurityContext, this.bindVariableService, this.rnd, this.fd, null);
            this.authenticationRequired = false;
            this.prepareLoginOk();
            this.sendAndReset();
        }
    }

    int doReceive(int remaining) {
        long data = this.recvBuffer + this.recvBufferWriteOffset;
        int n = this.nf.recv(this.getFd(), data, remaining);
        this.dumpBuffer('>', data, n);
        return n;
    }

    void doSend(int offset, int size) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int n = this.nf.send(this.getFd(), this.sendBuffer + (long)offset, size);
        this.dumpBuffer('<', this.sendBuffer + (long)offset, n);
        if (n < 0) {
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n < size) {
            this.doSendWithRetries(offset + n, size - n);
        }
        this.sendBufferPtr = this.sendBuffer;
        this.bufferRemainingSize = 0;
        this.bufferRemainingOffset = 0;
    }

    private void doSendWithRetries(int bufferOffset, int bufferSize) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int offset = bufferOffset;
        int remaining = bufferSize;
        int idleSendCount = 0;
        while (remaining > 0 && idleSendCount < this.idleSendCountBeforeGivingUp) {
            int m = this.nf.send(this.getFd(), this.sendBuffer + (long)offset, remaining);
            if (m < 0) {
                throw PeerDisconnectedException.INSTANCE;
            }
            this.dumpBuffer('<', this.sendBuffer + (long)offset, m);
            if (m > 0) {
                remaining -= m;
                offset += m;
                continue;
            }
            ++idleSendCount;
        }
        if (remaining > 0) {
            this.bufferRemainingOffset = offset;
            this.bufferRemainingSize = remaining;
            throw PeerIsSlowToReadException.INSTANCE;
        }
    }

    private void dumpBuffer(char direction, long buffer, int len) {
        if (this.dumpNetworkTraffic && len > 0) {
            StdoutSink.INSTANCE.put(direction);
            Net.dump(buffer, len);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void executeInsert() {
        try {
            switch (this.transactionState) {
                case 1: {
                    m = this.typesAndInsert.getInsert().createMethod(this.sqlExecutionContext, this);
                    try {
                        this.rowCount = m.execute();
                        w = m.popWriter();
                        this.pendingWriters.put(w.getTableName(), w);
                        break;
                    }
                    catch (Throwable e) {
                        Misc.free(m);
                        throw e;
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    m2 = this.typesAndInsert.getInsert().createMethod(this.sqlExecutionContext, this);
                    var4_6 = null;
                    this.rowCount = m2.execute();
                    m2.commit();
                    if (m2 == null) break;
                    if (var4_6 == null) ** GOTO lbl31
                    try {
                        m2.close();
                    }
                    catch (Throwable var5_7) {
                        var4_6.addSuppressed(var5_7);
                    }
                    break;
lbl31:
                    // 1 sources

                    m2.close();
                    break;
                    catch (Throwable var5_8) {
                        try {
                            var4_6 = var5_8;
                            throw var5_8;
                        }
                        catch (Throwable var6_9) {
                            if (m2 != null) {
                                if (var4_6 != null) {
                                    try {
                                        m2.close();
                                    }
                                    catch (Throwable var7_10) {
                                        var4_6.addSuppressed(var7_10);
                                    }
                                } else {
                                    m2.close();
                                }
                            }
                            throw var6_9;
                        }
                    }
                }
            }
            this.prepareCommandComplete(true);
        }
        catch (Throwable e) {
            if (this.transactionState == 1) {
                this.transactionState = 3;
            }
            throw e;
        }
    }

    private void executeTag() {
        LOG.debug().$("executing [tag=").$(this.queryTag).$(']').$();
        if (this.queryTag != null && TAG_OK != this.queryTag) {
            this.executeTag0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTag0() {
        switch (this.transactionState) {
            case 2: {
                try {
                    int n = this.pendingWriters.size();
                    for (int i = 0; i < n; ++i) {
                        TableWriter m = this.pendingWriters.valueQuick(i);
                        m.commit();
                        Misc.free(m);
                    }
                    break;
                }
                finally {
                    this.pendingWriters.clear();
                    this.transactionState = 0;
                }
            }
            case 4: {
                try {
                    int n = this.pendingWriters.size();
                    for (int i = 0; i < n; ++i) {
                        TableWriter m = this.pendingWriters.valueQuick(i);
                        m.rollback();
                        Misc.free(m);
                    }
                    break;
                }
                finally {
                    this.pendingWriters.clear();
                    this.transactionState = 0;
                }
            }
        }
    }

    private CharSequence getString(long lo, long hi, CharSequence errorMessage) throws BadProtocolException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (Chars.utf8Decode(lo, hi, e)) {
            return this.characterStore.toImmutable();
        }
        LOG.error().$(errorMessage).$();
        throw BadProtocolException.INSTANCE;
    }

    @Nullable
    private CharSequence getStatementName(long lo, long hi) throws BadProtocolException {
        if (hi - lo > 0L) {
            return this.getString(lo, hi, "invalid UTF8 bytes in statement name");
        }
        return null;
    }

    @Nullable
    private CharSequence getPortalName(long lo, long hi) throws BadProtocolException {
        if (hi - lo > 0L) {
            return this.getString(lo, hi, "invalid UTF8 bytes in portal name");
        }
        return null;
    }

    private void parse(long address, int len, SqlCompiler compiler) throws PeerDisconnectedException, PeerIsSlowToReadException, BadProtocolException, SqlException {
        if (this.requireInitialMessage) {
            this.processInitialMessage(address, len);
            return;
        }
        if (len < 5) {
            return;
        }
        byte type = Unsafe.getUnsafe().getByte(address);
        int msgLen = PGConnectionContext.getIntUnsafe(address + 1L);
        LOG.debug().$("received msg [type=").$((char)type).$(", len=").$(msgLen).$(']').$();
        if (msgLen < 1) {
            LOG.error().$("invalid message length [type=").$(type).$(", msgLen=").$(msgLen).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        if (msgLen > len - 1) {
            LOG.debug().$("not enough data in buffer [expected=").$(msgLen).$(", have=").$(len).$(", recvBufferWriteOffset=").$(this.recvBufferWriteOffset).$(", recvBufferReadOffset=").$(this.recvBufferReadOffset).$(']').$();
            return;
        }
        this.recvBufferReadOffset += (long)(msgLen + 1);
        long msgLimit = address + (long)msgLen + 1L;
        long msgLo = address + 5L;
        if (this.authenticationRequired) {
            this.doAuthentication(msgLo, msgLimit);
            return;
        }
        switch (type) {
            case 80: {
                this.processParse(address, msgLo, msgLimit, compiler);
                break;
            }
            case 88: {
                throw PeerDisconnectedException.INSTANCE;
            }
            case 67: {
                this.processClose(msgLo, msgLimit);
                break;
            }
            case 66: {
                this.processBind(msgLo, msgLimit, compiler);
                break;
            }
            case 69: {
                this.processExec(msgLo, msgLimit);
                break;
            }
            case 83: {
                this.processSyncActions();
                this.prepareReadyForQuery();
                this.prepareForNewQuery();
            }
            case 72: {
                this.sendAndReset();
                break;
            }
            case 68: {
                this.processDescribe(msgLo, msgLimit, compiler);
                break;
            }
            case 81: {
                this.processQuery(msgLo, msgLimit, compiler);
                break;
            }
            case 100: {
                System.out.println("data " + msgLen);
                break;
            }
            default: {
                LOG.error().$("unknown message [type=").$(type).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    private void parseQueryText(long lo, long hi, SqlCompiler compiler) throws BadProtocolException, PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        CharacterStoreEntry e = this.characterStore.newEntry();
        if (Chars.utf8Decode(lo, hi, e)) {
            this.queryText = this.characterStore.toImmutable();
            LOG.info().$("parse [q=").utf8(this.queryText).$(']').$();
            this.compileQuery(compiler);
            return;
        }
        LOG.error().$("invalid UTF8 bytes in parse query").$();
        throw BadProtocolException.INSTANCE;
    }

    private void prepareBindComplete() {
        this.responseAsciiSink.put((byte)50);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    private void prepareCloseComplete() {
        this.responseAsciiSink.put((byte)51);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    void prepareCommandComplete(boolean addRowCount) {
        if (this.isEmptyQuery) {
            LOG.debug().$("empty").$();
            this.responseAsciiSink.put((byte)73);
            this.responseAsciiSink.putIntDirect(INT_BYTES_X);
        } else {
            this.responseAsciiSink.put((byte)67);
            long addr = this.responseAsciiSink.skip();
            if (addRowCount) {
                if (this.queryTag == TAG_INSERT) {
                    LOG.debug().$("insert [rowCount=").$(this.rowCount).$(']').$();
                    this.responseAsciiSink.encodeUtf8(this.queryTag).put(" 0 ").put(this.rowCount).put('\u0000');
                } else {
                    LOG.debug().$("other [rowCount=").$(this.rowCount).$(']').$();
                    this.responseAsciiSink.encodeUtf8(this.queryTag).put(' ').put(this.rowCount).put('\u0000');
                }
            } else {
                LOG.debug().$("now row count").$();
                this.responseAsciiSink.encodeUtf8(this.queryTag).put('\u0000');
            }
            this.responseAsciiSink.putLen(addr);
        }
    }

    void prepareSuspended() {
        LOG.debug().$("suspended").$();
        this.responseAsciiSink.put((byte)115);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    private void prepareDescribePortalResponse() {
        if (this.typesAndSelect != null) {
            try {
                this.prepareRowDescription();
            }
            catch (NoSpaceLeftInResponseBufferException ignored) {
                LOG.error().$("not enough space in buffer for row description [buffer=").$(this.sendBufferSize).I$();
                this.responseAsciiSink.reset();
                throw CairoException.instance(0).put("server configuration error: not enough space in send buffer for row description");
            }
        } else {
            this.prepareNoDataMessage();
        }
    }

    private void prepareDescribeResponse() {
        if (this.sendParameterDescription) {
            this.prepareParameterDescription();
        }
        this.prepareDescribePortalResponse();
    }

    private void prepareError(int position, CharSequence message) {
        this.responseAsciiSink.put((byte)69);
        long addr = this.responseAsciiSink.skip();
        this.responseAsciiSink.put('C');
        this.responseAsciiSink.encodeUtf8Z("00000");
        this.responseAsciiSink.put('M');
        this.responseAsciiSink.encodeUtf8Z(message);
        this.responseAsciiSink.put('S');
        this.responseAsciiSink.encodeUtf8Z("ERROR");
        if (position > -1) {
            this.responseAsciiSink.put('P').put(position + 1).put('\u0000');
        }
        this.responseAsciiSink.put('\u0000');
        this.responseAsciiSink.putLen(addr);
        LOG.error().$("error [pos=").$(position).$(", msg=`").$(message).$("`]").$();
    }

    private void prepareForNewQuery() {
        LOG.debug().$("prepare for new query").$();
        if (this.completed) {
            this.isEmptyQuery = false;
            this.characterStore.clear();
            this.bindVariableService.clear();
            this.currentCursor = Misc.free(this.currentCursor);
            this.typesAndInsert = null;
            this.typesAndSelect = null;
            this.rowCount = 0L;
            this.queryTag = TAG_OK;
            this.queryText = null;
            this.wrapper = null;
            this.syncActions.clear();
            this.sendParameterDescription = false;
        }
    }

    private void prepareLoginOk() {
        this.responseAsciiSink.put((byte)82);
        this.responseAsciiSink.putNetworkInt(8);
        this.responseAsciiSink.putIntDirect(0);
        PGConnectionContext.prepareParams(this.responseAsciiSink, "TimeZone", "GMT");
        PGConnectionContext.prepareParams(this.responseAsciiSink, "application_name", "QuestDB");
        PGConnectionContext.prepareParams(this.responseAsciiSink, "server_version", this.serverVersion);
        PGConnectionContext.prepareParams(this.responseAsciiSink, "integer_datetimes", "on");
        PGConnectionContext.prepareParams(this.responseAsciiSink, "client_encoding", "UTF8");
        this.prepareReadyForQuery();
    }

    private void prepareLoginResponse() {
        this.responseAsciiSink.put((byte)82);
        this.responseAsciiSink.putNetworkInt(8);
        this.responseAsciiSink.putNetworkInt(3);
    }

    private void prepareNoDataMessage() {
        this.responseAsciiSink.put((byte)110);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    private void prepareParameterDescription() {
        this.responseAsciiSink.put((byte)116);
        long l = this.responseAsciiSink.skip();
        int n = this.bindVariableService.getIndexedVariableCount();
        this.responseAsciiSink.putNetworkShort((short)n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.responseAsciiSink.putIntDirect(PGOids.toParamType(this.activeBindVariableTypes.getQuick(i)));
            }
        }
        this.responseAsciiSink.putLen(l);
    }

    private void prepareParseComplete() {
        this.responseAsciiSink.put((byte)49);
        this.responseAsciiSink.putIntDirect(INT_BYTES_X);
    }

    void prepareReadyForQuery() {
        this.responseAsciiSink.put((byte)90);
        this.responseAsciiSink.putNetworkInt(5);
        switch (this.transactionState) {
            case 1: {
                this.responseAsciiSink.put('T');
                break;
            }
            case 3: {
                this.responseAsciiSink.put('E');
                break;
            }
            default: {
                this.responseAsciiSink.put('I');
            }
        }
    }

    private void prepareRowDescription() {
        RecordMetadata metadata = this.typesAndSelect.getFactory().getMetadata();
        ResponseAsciiSink sink = this.responseAsciiSink;
        sink.put((byte)84);
        long addr = sink.skip();
        int n = this.activeSelectColumnTypes.size();
        sink.putNetworkShort((short)n);
        for (int i = 0; i < n; ++i) {
            int typeFlag = this.activeSelectColumnTypes.getQuick(i);
            int columnType = PGOids.toColumnType(typeFlag);
            sink.encodeUtf8Z(metadata.getColumnName(i));
            sink.putIntDirect(0);
            sink.putNetworkShort((short)(i + 1));
            sink.putNetworkInt(PGOids.TYPE_OIDS.get(columnType));
            if (columnType < 10) {
                sink.putNetworkShort((short)ColumnType.sizeOf(columnType));
            } else {
                sink.putNetworkShort((short)-1);
            }
            sink.putIntDirect(INT_NULL_X);
            sink.putNetworkShort(typeFlag == 13 ? (short)1 : PGOids.getColumnBinaryFlag(typeFlag));
        }
        sink.putLen(addr);
    }

    private void prepareSslResponse() {
        this.responseAsciiSink.put('N');
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processBind(long lo, long msgLimit, SqlCompiler compiler) throws BadProtocolException, SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        short columnFormatCodeCount;
        LOG.debug().$("bind").$();
        long hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad portal name length [msgType='B']");
        CharSequence portalName = this.getPortalName(lo, hi);
        lo = hi + 1L;
        hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad prepared statement name length [msgType='B']");
        CharSequence statementName = this.getStatementName(lo, hi);
        this.configureContextFromNamedStatement(statementName, compiler);
        if (portalName != null) {
            this.configurePortal(portalName, statementName);
        }
        lo = hi + 1L;
        short parameterFormatCount = PGConnectionContext.getShort(lo, msgLimit, "could not read parameter format code count");
        lo += 2L;
        if (parameterFormatCount > 0) {
            if (parameterFormatCount == 1) {
                PGConnectionContext.bindSingleFormatForAll(lo, msgLimit, this.activeBindVariableTypes);
            } else if (parameterFormatCount == this.parsePhaseBindVariableCount) {
                PGConnectionContext.bindParameterFormats(lo, msgLimit, parameterFormatCount, this.activeBindVariableTypes);
            }
        }
        short parameterValueCount = PGConnectionContext.getShort(lo += (long)(parameterFormatCount * 2), msgLimit, "could not read parameter value count");
        LOG.debug().$("binding [parameterValueCount=").$(parameterValueCount).$(", thread=").$(Thread.currentThread().getId()).$(']').$();
        this.validateParameterCounts(parameterFormatCount, parameterValueCount, this.parsePhaseBindVariableCount);
        lo += 2L;
        if (parameterValueCount > 0) {
            lo = this.parsePhaseBindVariableCount == parameterValueCount ? this.bindValuesUsingSetters(lo, msgLimit, parameterValueCount) : this.bindValuesAsStrings(lo, msgLimit, parameterValueCount);
        }
        if (this.typesAndSelect != null && (columnFormatCodeCount = PGConnectionContext.getShort(lo, msgLimit, "could not read result set column format codes")) > 0) {
            RecordMetadata m = this.typesAndSelect.getFactory().getMetadata();
            int columnCount = m.getColumnCount();
            long spaceNeeded = lo + (long)((columnFormatCodeCount + 1) * 2);
            if (spaceNeeded > msgLimit) {
                LOG.error().$("could not process column format codes [bufSpaceNeeded=").$(spaceNeeded).$(", bufSpaceAvail=").$(msgLimit).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            if (columnFormatCodeCount == columnCount) {
                for (int i = 0; i < columnCount; ++i) {
                    this.activeSelectColumnTypes.setQuick(i, PGOids.toColumnBinaryType(PGConnectionContext.getShortUnsafe(lo += 2L), m.getColumnType(i)));
                }
            } else {
                if (columnFormatCodeCount != 1) {
                    LOG.error().$("could not process column format codes [fmtCount=").$(columnFormatCodeCount).$(", columnCount=").$(columnCount).$(']').$();
                    throw BadProtocolException.INSTANCE;
                }
                short code = PGConnectionContext.getShortUnsafe(lo);
                for (int i = 0; i < columnCount; ++i) {
                    this.activeSelectColumnTypes.setQuick(i, PGOids.toColumnBinaryType(code, m.getColumnType(i)));
                }
            }
        }
        this.syncActions.add(3);
    }

    private void processClose(long lo, long msgLimit) throws BadProtocolException {
        byte type = Unsafe.getUnsafe().getByte(lo);
        switch (type) {
            case 83: {
                long hi = PGConnectionContext.getStringLength(++lo, msgLimit, "bad prepared statement name length");
                CharSequence statementName = this.getStatementName(lo, hi);
                if (statementName == null) break;
                int index = this.namedStatementMap.keyIndex(statementName);
                if (index < 0) {
                    this.namedStatementWrapperPool.push((NamedStatementWrapper)((Mutable)this.namedStatementMap.valueAt(index)));
                    this.namedStatementMap.removeAt(index);
                    break;
                }
                LOG.error().$("invalid statement name [value=").$(statementName).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            case 80: {
                long high = PGConnectionContext.getStringLength(++lo, msgLimit, "bad prepared statement name length");
                CharSequence portalName = this.getPortalName(lo, high);
                if (portalName == null) break;
                int index = this.namedPortalMap.keyIndex(portalName);
                if (index < 0) {
                    this.namedPortalPool.push((Portal)((Mutable)this.namedPortalMap.valueAt(index)));
                    this.namedPortalMap.removeAt(index);
                    break;
                }
                LOG.error().$("invalid portal name [value=").$(portalName).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            default: {
                LOG.error().$("invalid type for close message [type=").$(type).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
        this.prepareCloseComplete();
    }

    private void processDescribe(long lo, long msgLimit, SqlCompiler compiler) throws SqlException, BadProtocolException, PeerDisconnectedException, PeerIsSlowToReadException {
        boolean isPortal = Unsafe.getUnsafe().getByte(lo) == 80;
        long hi = PGConnectionContext.getStringLength(lo + 1L, msgLimit, "bad prepared statement name length");
        CharSequence target = this.getPortalName(lo + 1L, hi);
        LOG.debug().$("describe [name=").$(target).$(']').$();
        if (isPortal && target != null) {
            Portal p = this.namedPortalMap.get(target);
            if (p != null) {
                target = p.statementName;
            } else {
                LOG.error().$("invalid portal [name=").$(target).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
        this.configureContextFromNamedStatement(target, compiler);
        int n = this.bindVariableService.getIndexedVariableCount();
        if (this.sendParameterDescription && n > 0 && this.activeBindVariableTypes.size() == 0) {
            this.activeBindVariableTypes.setPos(n);
            for (int i = 0; i < n; ++i) {
                this.activeBindVariableTypes.setQuick(i, Numbers.bswap(PGOids.TYPE_OIDS.getQuick(this.bindVariableService.getFunction(i).getType())));
            }
        }
        if (isPortal) {
            this.syncActions.add(4);
        } else {
            this.syncActions.add(2);
        }
    }

    private void processExec(long lo, long msgLimit) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException, BadProtocolException {
        long hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad portal name length");
        CharSequence portalName = this.getPortalName(lo, hi);
        if (portalName != null) {
            LOG.info().$("execute portal [name=").$(portalName).$(']').$();
        }
        lo = hi + 1L;
        int maxRows = PGConnectionContext.getInt(lo, msgLimit, "could not read max rows value");
        this.processSyncActions();
        this.processExecute(maxRows);
        this.wrapper = null;
    }

    private void processExecute(int maxRows) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        if (this.typesAndSelect != null) {
            LOG.debug().$("executing query").$();
            this.setupFactoryAndCursor();
            this.sendCursor(maxRows);
        } else if (this.typesAndInsert != null) {
            LOG.debug().$("executing insert").$();
            this.executeInsert();
        } else {
            this.executeTag();
            this.prepareCommandComplete(false);
        }
    }

    private void processInitialMessage(long address, int len) throws PeerDisconnectedException, PeerIsSlowToReadException, BadProtocolException {
        if (len < 8) {
            return;
        }
        int msgLen = PGConnectionContext.getIntUnsafe(address);
        if (msgLen > len) {
            return;
        }
        this.recvBufferReadOffset += (long)msgLen;
        int protocol = PGConnectionContext.getIntUnsafe(address + 4L);
        switch (protocol) {
            case 80877103: {
                this.prepareSslResponse();
                this.sendAndReset();
                return;
            }
            case 196608: {
                this.requireInitialMessage = false;
                long msgLimit = address + (long)msgLen;
                long lo = address + 8L;
                LOG.info().$("protocol [major=").$(protocol >> 16).$(", minor=").$((short)protocol).$(']').$();
                while (lo < msgLimit - 1L) {
                    long nameLo = lo;
                    long nameHi = PGConnectionContext.getStringLength(lo, msgLimit, "malformed property name");
                    long valueLo = lo = nameHi + 1L;
                    long valueHi = PGConnectionContext.getStringLength(valueLo, msgLimit, "malformed property value");
                    this.dbcs.of(nameLo, nameHi);
                    if (Chars.equals((CharSequence)this.dbcs, "user")) {
                        CharacterStoreEntry e = this.characterStore.newEntry();
                        e.put(this.dbcs.of(valueLo, valueHi));
                        this.username = e.toImmutable();
                    }
                    LOG.info().$("property [name=").$(this.dbcs.of(nameLo, nameHi)).$(", value=").$(this.dbcs.of(valueLo, valueHi)).$(']').$();
                }
                this.characterStore.clear();
                this.assertTrue(this.username != null, "user is not specified");
                this.prepareLoginResponse();
                this.sendAndReset();
                break;
            }
            case 80877102: {
                LOG.info().$("cancel request").$();
                throw PeerDisconnectedException.INSTANCE;
            }
            default: {
                LOG.error().$("unknown init message [protocol=").$(protocol).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    private void processParse(long address, long lo, long msgLimit, SqlCompiler compiler) throws BadProtocolException, SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        long hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad prepared statement name length");
        CharSequence statementName = this.getStatementName(lo, hi);
        lo = hi + 1L;
        hi = PGConnectionContext.getStringLength(lo, msgLimit, "bad query text length");
        this.parseQueryText(lo, hi, compiler);
        lo = hi + 1L;
        this.parsePhaseBindVariableCount = PGConnectionContext.getShort(lo, msgLimit, "could not read parameter type count");
        if (statementName != null) {
            LOG.info().$("prepare [name=").$(statementName).$(']').$();
            this.configurePreparedStatement(statementName);
        } else {
            this.activeBindVariableTypes = this.bindVariableTypes;
            this.activeSelectColumnTypes = this.selectColumnTypes;
        }
        if (this.parsePhaseBindVariableCount > 0) {
            if (lo + 2L + (long)this.parsePhaseBindVariableCount * 4L > msgLimit) {
                LOG.error().$("could not read parameters [parameterCount=").$(this.parsePhaseBindVariableCount).$(", offset=").$(lo - address).$(", remaining=").$(msgLimit - lo).$(']').$();
                throw BadProtocolException.INSTANCE;
            }
            LOG.debug().$("params [count=").$(this.parsePhaseBindVariableCount).$(']').$();
            PGConnectionContext.setupBindVariables(lo + 2L, this.activeBindVariableTypes, this.parsePhaseBindVariableCount);
        } else if (this.parsePhaseBindVariableCount < 0) {
            LOG.error().$("invalid parameter count [parameterCount=").$(this.parsePhaseBindVariableCount).$(", offset=").$(lo - address).$(']').$();
            throw BadProtocolException.INSTANCE;
        }
        if (this.typesAndSelect != null) {
            this.buildSelectColumnTypes();
        }
        this.syncActions.add(1);
    }

    private void processQuery(long lo, long limit, SqlCompiler compiler) throws BadProtocolException, SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareForNewQuery();
        this.parseQueryText(lo, limit - 1L, compiler);
        if (this.typesAndSelect != null) {
            this.activeSelectColumnTypes = this.selectColumnTypes;
            this.buildSelectColumnTypes();
            assert (this.queryText != null);
            this.queryTag = TAG_SELECT;
            this.setupFactoryAndCursor();
            this.prepareRowDescription();
            this.sendCursor(0);
        } else if (this.typesAndInsert != null) {
            this.executeInsert();
        } else {
            this.executeTag();
            this.prepareCommandComplete(false);
        }
        this.prepareReadyForQuery();
        this.sendAndReset();
    }

    private void processSyncActions() {
        try {
            int n = this.syncActions.size();
            block9: for (int i = 0; i < n; ++i) {
                switch (this.syncActions.getQuick(i)) {
                    case 1: {
                        this.prepareParseComplete();
                        continue block9;
                    }
                    case 2: {
                        this.prepareDescribeResponse();
                        continue block9;
                    }
                    case 3: {
                        this.prepareBindComplete();
                        continue block9;
                    }
                    case 4: {
                        this.prepareDescribePortalResponse();
                    }
                }
            }
        }
        finally {
            this.syncActions.clear();
        }
    }

    int recv() throws PeerDisconnectedException, PeerIsSlowToWriteException, BadProtocolException {
        int remaining = (int)((long)this.recvBufferSize - this.recvBufferWriteOffset);
        this.assertTrue(remaining > 0, "undersized receive buffer or someone is abusing protocol");
        int n = this.doReceive(remaining);
        LOG.debug().$("recv [n=").$(n).$(']').$();
        if (n < 0) {
            throw PeerDisconnectedException.INSTANCE;
        }
        if (n == 0) {
            int retriesRemaining;
            for (retriesRemaining = this.idleRecvCountBeforeGivingUp; retriesRemaining > 0; --retriesRemaining) {
                n = this.doReceive(remaining);
                if (n == 0) {
                    continue;
                }
                if (n >= 0) break;
                LOG.info().$("disconnect [code=").$(n).$(']').$();
                throw PeerDisconnectedException.INSTANCE;
            }
            if (retriesRemaining == 0) {
                throw PeerIsSlowToWriteException.INSTANCE;
            }
        }
        this.recvBufferWriteOffset += (long)n;
        return n;
    }

    private void reportError(int position, CharSequence flyweightMessage) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.prepareError(position, flyweightMessage);
        this.prepareReadyForQuery();
        this.sendAndReset();
        this.clearRecvBuffer();
    }

    private void resumeCursor() throws SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        Record record = this.currentCursor.getRecord();
        int columnCount = this.currentFactory.getMetadata().getColumnCount();
        this.responseAsciiSink.bookmark();
        this.appendSingleRecord(record, columnCount);
        this.sendCursor0(record, columnCount);
    }

    private void sendAndReset() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.doSend(0, (int)(this.sendBufferPtr - this.sendBuffer));
        this.responseAsciiSink.reset();
    }

    private void sendCopyInResponse(CairoEngine engine, TextLoader textLoader) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (0 == engine.getStatus(this.sqlExecutionContext.getCairoSecurityContext(), this.path, textLoader.getTableName())) {
            this.responseAsciiSink.put((byte)71);
            long addr = this.responseAsciiSink.skip();
            this.responseAsciiSink.put((byte)0);
            try (TableWriter writer = engine.getWriter(this.sqlExecutionContext.getCairoSecurityContext(), textLoader.getTableName());){
                TableWriterMetadata metadata = writer.getMetadata();
                this.responseAsciiSink.putNetworkShort((short)metadata.getColumnCount());
                int n = metadata.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    this.responseAsciiSink.putNetworkShort((short)PGOids.TYPE_OIDS.get(metadata.getColumnType(i)));
                }
            }
            this.responseAsciiSink.putLen(addr);
        } else {
            SqlException e = SqlException.$(0, "table '").put(textLoader.getTableName()).put("' does not exist");
            this.prepareError(e.getPosition(), e.getFlyweightMessage());
            this.prepareReadyForQuery();
        }
        this.sendAndReset();
    }

    private void sendCursor(int maxRows) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        this.rowCount = 0L;
        Record record = this.currentCursor.getRecord();
        RecordMetadata metadata = this.currentFactory.getMetadata();
        int columnCount = metadata.getColumnCount();
        long cursorRowCount = this.currentCursor.size();
        this.maxRows = maxRows > 0 ? Long.min(maxRows, cursorRowCount) : Long.MAX_VALUE;
        this.resumeProcessor = this.resumeCursorRef;
        this.sendCursor0(record, columnCount);
    }

    private void sendCursor0(Record record, int columnCount) throws PeerDisconnectedException, PeerIsSlowToReadException, SqlException {
        while (this.currentCursor.hasNext()) {
            this.responseAsciiSink.bookmark();
            try {
                try {
                    this.appendRecord(record, columnCount);
                    if (this.rowCount++ <= this.maxRows) continue;
                    break;
                }
                catch (NoSpaceLeftInResponseBufferException e) {
                    this.responseAsciiSink.resetToBookmark();
                    this.sendAndReset();
                    this.appendSingleRecord(record, columnCount);
                }
            }
            catch (SqlException e) {
                this.responseAsciiSink.resetToBookmark();
                throw e;
            }
        }
        boolean bl = this.completed = this.maxRows <= 0L || this.rowCount < this.maxRows;
        if (this.completed) {
            this.resumeProcessor = null;
            this.currentCursor = Misc.free(this.currentCursor);
            this.currentFactory = null;
            if (this.typesAndSelect != null) {
                this.typesAndSelectCache.put(this.queryText, this.typesAndSelect);
                this.typesAndSelect = null;
            }
            this.prepareCommandComplete(true);
        } else {
            this.prepareSuspended();
        }
    }

    private void appendSingleRecord(Record record, int columnCount) throws SqlException {
        try {
            this.appendRecord(record, columnCount);
        }
        catch (NoSpaceLeftInResponseBufferException e1) {
            LOG.error().$("not enough space in buffer for row data [buffer=").$(this.sendBufferSize).I$();
            this.responseAsciiSink.reset();
            throw CairoException.instance(0).put("server configuration error: not enough space in send buffer for row data");
        }
    }

    private void setupFactoryAndCursor() {
        if (this.currentCursor == null) {
            this.currentFactory = this.typesAndSelect.getFactory();
            try {
                this.currentCursor = this.currentFactory.getCursor(this.sqlExecutionContext);
                this.rnd = this.sqlExecutionContext.getRandom();
            }
            catch (Throwable e) {
                this.currentFactory = Misc.free(this.currentFactory);
                throw e;
            }
        }
    }

    private void setupVariableSettersFromWrapper(NamedStatementWrapper wrapper, @Nullable SqlCompiler compiler) throws SqlException, PeerDisconnectedException, PeerIsSlowToReadException {
        this.queryText = wrapper.queryText;
        LOG.debug().$("wrapper query [q=`").$(wrapper.queryText).$("`]").$();
        this.activeBindVariableTypes = wrapper.bindVariableTypes;
        this.parsePhaseBindVariableCount = wrapper.bindVariableTypes.size();
        this.activeSelectColumnTypes = wrapper.selectColumnTypes;
        if (this.compileQuery(compiler) && this.typesAndSelect != null) {
            this.buildSelectColumnTypes();
        }
    }

    private void shiftReceiveBuffer(long readOffsetBeforeParse) {
        long len = this.recvBufferWriteOffset - readOffsetBeforeParse;
        LOG.debug().$("shift [offset=").$(readOffsetBeforeParse).$(", len=").$(len).$(']').$();
        Vect.memcpy(this.recvBuffer + readOffsetBeforeParse, this.recvBuffer, len);
        this.recvBufferWriteOffset = len;
        this.recvBufferReadOffset = 0L;
    }

    private void validateParameterCounts(short parameterFormatCount, short parameterValueCount, int parameterTypeCount) throws BadProtocolException {
        if (parameterValueCount > 0) {
            if (parameterValueCount < parameterTypeCount) {
                LOG.error().$("parameter type count must be less or equals to number of parameters values").$();
                throw BadProtocolException.INSTANCE;
            }
            if (parameterFormatCount > 1 && parameterFormatCount != parameterValueCount) {
                LOG.error().$("parameter format count and parameter value count must match").$();
                throw BadProtocolException.INSTANCE;
            }
        }
    }

    class ResponseAsciiSink
    extends AbstractCharSink {
        private long bookmarkPtr = -1L;

        ResponseAsciiSink() {
        }

        public void bookmark() {
            this.bookmarkPtr = PGConnectionContext.this.sendBufferPtr;
        }

        public void bump(int size) {
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)size;
        }

        @Override
        public CharSink put(CharSequence cs) {
            int len;
            if (cs != null && (len = cs.length()) > 0) {
                this.ensureCapacity(len);
                for (int i = 0; i < len; ++i) {
                    Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr + (long)i, (byte)cs.charAt(i));
                }
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)len;
            }
            return this;
        }

        @Override
        public CharSink put(char c) {
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, (byte)c);
            return this;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            this.ensureCapacity(len);
            Chars.asciiCopyTo(chars, start, len, PGConnectionContext.this.sendBufferPtr);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + (long)len;
            return this;
        }

        public CharSink put(byte b) {
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, b);
            return this;
        }

        public void put(BinarySequence sequence) {
            long len = sequence.length();
            if (len > (long)PGConnectionContext.this.maxBlobSizeOnQuery) {
                this.setNullValue();
            } else {
                this.ensureCapacity((int)(len + 4L));
                PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, (int)len);
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
                for (long x = 0L; x < len; ++x) {
                    Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr + x, sequence.byteAt(x));
                }
                PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + len;
            }
        }

        public void putIntDirect(int value) {
            this.ensureCapacity(4);
            this.putIntUnsafe(0L, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
        }

        public void putIntUnsafe(long offset, int value) {
            Unsafe.getUnsafe().putInt(PGConnectionContext.this.sendBufferPtr + offset, value);
        }

        public void putLen(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start));
        }

        public void putLenEx(long start) {
            PGConnectionContext.putInt(start, (int)(PGConnectionContext.this.sendBufferPtr - start - 4L));
        }

        public void putNetworkDouble(double value) {
            this.ensureCapacity(8);
            Unsafe.getUnsafe().putDouble(PGConnectionContext.this.sendBufferPtr, Double.longBitsToDouble(Numbers.bswap(Double.doubleToLongBits(value))));
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 8L;
        }

        public void putNetworkFloat(float value) {
            this.ensureCapacity(4);
            Unsafe.getUnsafe().putFloat(PGConnectionContext.this.sendBufferPtr, Float.intBitsToFloat(Numbers.bswap(Float.floatToIntBits(value))));
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
        }

        public void putNetworkInt(int value) {
            this.ensureCapacity(4);
            PGConnectionContext.putInt(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
        }

        public void putNetworkLong(long value) {
            this.ensureCapacity(8);
            PGConnectionContext.putLong(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 8L;
        }

        public void putNetworkShort(short value) {
            this.ensureCapacity(2);
            PGConnectionContext.putShort(PGConnectionContext.this.sendBufferPtr, value);
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 2L;
        }

        public void resetToBookmark() {
            assert (this.bookmarkPtr != -1L);
            PGConnectionContext.this.sendBufferPtr = this.bookmarkPtr;
            this.bookmarkPtr = -1L;
        }

        void encodeUtf8Z(CharSequence value) {
            this.encodeUtf8(value);
            this.ensureCapacity(1);
            Unsafe.getUnsafe().putByte(PGConnectionContext.this.sendBufferPtr++, (byte)0);
        }

        private void ensureCapacity(int size) {
            if (PGConnectionContext.this.sendBufferPtr + (long)size < PGConnectionContext.this.sendBufferLimit) {
                return;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        void reset() {
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBuffer;
        }

        void setNullValue() {
            this.putIntDirect(INT_NULL_X);
        }

        long skip() {
            this.ensureCapacity(4);
            long checkpoint = PGConnectionContext.this.sendBufferPtr;
            PGConnectionContext.this.sendBufferPtr = PGConnectionContext.this.sendBufferPtr + 4L;
            return checkpoint;
        }
    }

    public static class NamedStatementWrapper
    implements Mutable {
        public final IntList bindVariableTypes = new IntList();
        public final IntList selectColumnTypes = new IntList();
        public CharSequence queryText = null;
        public CharSequence tag;

        @Override
        public void clear() {
            this.tag = null;
            this.queryText = null;
            this.bindVariableTypes.clear();
            this.selectColumnTypes.clear();
        }
    }

    public static class Portal
    implements Mutable {
        public CharSequence statementName = null;

        @Override
        public void clear() {
            this.statementName = null;
        }
    }

    @FunctionalInterface
    private static interface PGResumeProcessor {
        public void resume() throws PeerIsSlowToReadException, SqlException, PeerDisconnectedException;
    }
}

